/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.soap.server;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.servlet.ServletContext;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.Constants;
import org.apache.soap.SOAPException;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.server.http.ServerHTTPUtils;
import org.apache.soap.util.ConfigManager;
import org.apache.soap.util.xml.DOM2Writer;
import org.apache.soap.util.xml.DOMUtils;
import org.apache.soap.util.xml.XMLParserUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLDrivenConfigManager
implements ConfigManager {
    protected String ddsFileName = "dds.xml";
    protected Hashtable dds = null;
    protected Hashtable undeployedDDS = null;
    protected ServletContext context = null;
    private static TraceComponent tc = Tr.register(XMLDrivenConfigManager.class.getName(), null, "com.ibm.soap.resources.SOAP");

    public void setContext(ServletContext servletContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setContext(ServletContext)");
        }
        this.context = servletContext;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setContext(ServletContext)");
        }
    }

    public void setOptions(Hashtable hashtable) throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setOptions(Hashtable)");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setOptions(Hashtable)");
        }
    }

    public void init() throws SOAPException {
        Object object;
        Enumeration enumeration;
        Object object2;
        Object object3;
        File file;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "init()");
            }
            file = ServerHTTPUtils.getFileFromNameAndContext(this.ddsFileName, this.context);
            try {
                object3 = XMLParserUtils.getXMLDocBuilder();
                object2 = ((DocumentBuilder)object3).parse(new InputSource("file:///" + file));
                this.encodePasswords((Document)object2);
                if (object2 != null) {
                    enumeration = object2.getDocumentElement();
                    object = DOMUtils.getFirstChildElement((Element)((Object)enumeration));
                    this.dds = new Hashtable();
                    this.undeployedDDS = new Hashtable();
                    while (object != null) {
                        DeploymentDescriptor deploymentDescriptor = DeploymentDescriptor.fromXML((Element)object);
                        this.dds.put(deploymentDescriptor.getID(), deploymentDescriptor);
                        object = DOMUtils.getNextSiblingElement((Element)object);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Deployed: " + deploymentDescriptor.getID());
                    }
                    break block11;
                }
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error: Problem parsing file '" + file + "'.");
            }
            catch (Exception exception) {
                throw new SOAPException(Constants.FAULT_CODE_SERVER, "Error: File '" + file + "' does not exist or an error occurred closing it.");
            }
        }
        object3 = ServerHTTPUtils.getFileFromNameAndContext("serviceState.dat", this.context);
        if (file.exists()) {
            object2 = null;
            try {
                enumeration = new FileInputStream((File)object3);
                object = new ObjectInputStream((InputStream)((Object)enumeration));
                object2 = (Hashtable)((ObjectInputStream)object).readObject();
                ((ObjectInputStream)object).close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (object2 != null) {
                enumeration = ((Hashtable)object2).keys();
                while (enumeration.hasMoreElements()) {
                    this.undeploy((String)enumeration.nextElement());
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init()");
        }
    }

    public void deploy(DeploymentDescriptor deploymentDescriptor) throws SOAPException {
        DeploymentDescriptor deploymentDescriptor2 = null;
        deploymentDescriptor2 = (DeploymentDescriptor)this.undeployedDDS.remove(deploymentDescriptor.getID());
        if (deploymentDescriptor2 != null) {
            this.dds.put(deploymentDescriptor2.getID(), deploymentDescriptor2);
        }
        this.storeState();
    }

    public String[] list() throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "list()");
        }
        String[] stringArray = this.undeployedDDS.size() > 0 ? new String[this.dds.size() + this.undeployedDDS.size() + 1] : new String[this.dds.size()];
        Enumeration enumeration = this.dds.keys();
        Enumeration enumeration2 = this.undeployedDDS.keys();
        int n = 0;
        while (enumeration.hasMoreElements()) {
            stringArray[n++] = (String)enumeration.nextElement();
        }
        if (this.undeployedDDS.size() > 0) {
            stringArray[n++] = "SOAP_UNDEPLOYED_BUT_REGISTERED";
            while (enumeration2.hasMoreElements()) {
                stringArray[n++] = (String)enumeration2.nextElement();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "list()");
        }
        return stringArray;
    }

    public DeploymentDescriptor undeploy(String string) throws SOAPException {
        DeploymentDescriptor deploymentDescriptor = null;
        deploymentDescriptor = (DeploymentDescriptor)this.dds.remove(string);
        if (deploymentDescriptor != null) {
            this.undeployedDDS.put(deploymentDescriptor.getID(), deploymentDescriptor);
        } else {
            deploymentDescriptor = (DeploymentDescriptor)this.undeployedDDS.get(string);
        }
        this.storeState();
        return deploymentDescriptor;
    }

    public DeploymentDescriptor query(String string) throws SOAPException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "query(String))");
        }
        DeploymentDescriptor deploymentDescriptor = (DeploymentDescriptor)this.dds.get(string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "query(String))");
        }
        return deploymentDescriptor;
    }

    private void encodePasswords(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "encodePasswords(Document))");
        }
        File file = ServerHTTPUtils.getFileFromNameAndContext(this.ddsFileName, this.context);
        Vector vector = this.getPasswordNodes(document);
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            this.testAndEncode((Element)vector.elementAt(i));
        }
        if (n > 0) {
            try {
                FileWriter fileWriter = new FileWriter(file);
                DOM2Writer.serializeAsXML(document, fileWriter);
                fileWriter.close();
            }
            catch (Exception exception) {
                Tr.warning(tc, "couldNotEncodeSOAPPasswords");
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "encodePasswords(Document))");
        }
    }

    private void testAndEncode(Element element) {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testAndEncode(Element))");
        }
        if ((string = PasswordUtil.passwordDecode(element.getAttribute("value"))).equals(element.getAttribute("value")) && !(string = PasswordUtil.passwordEncode(element.getAttribute("value"))).equals(element.getAttribute("value"))) {
            element.setAttribute("value", string);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "testAndEncode(Element))");
        }
    }

    private Vector getPasswordNodes(Document document) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getPasswordNodes(Document))");
        }
        Vector<Element> vector = new Vector<Element>();
        NodeList nodeList = document.getElementsByTagName("isd:option");
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Element element = (Element)nodeList.item(i);
            String string = DOMUtils.getAttribute(element, "key");
            if (!string.equals("password")) continue;
            vector.addElement(element);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getPasswordNodes(Document))");
        }
        return vector;
    }

    private synchronized void storeState() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "storeState())");
        }
        File file = ServerHTTPUtils.getFileFromNameAndContext("serviceState.dat", this.context);
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this.undeployedDDS);
            objectOutputStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "storeState())");
        }
    }
}

