/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.soap.soapenabler;

import com.ibm.ejs.sm.client.ui.NLS;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.soap.soapenabler.ServiceDescriptor;
import com.ibm.soap.soapenabler.SoapModuleDescriptor;
import com.ibm.soap.soapenabler.Utils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import org.apache.soap.server.DeploymentDescriptor;
import org.apache.soap.util.xml.XMLParserUtils;
import org.eclipse.jst.j2ee.application.Application;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ArchiveException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.ReopenException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.strategy.LoadStrategy;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class SoapEnabler {
    private String earTemplateFileName = null;
    private String earTargetFileName = null;
    private List soapModules = new Vector();
    private static NLS myNLS = new NLS("com.ibm.soap.soapenabler.properties.SoapEnabler");

    public void setVerbose(boolean bl) {
        Utils.verbose = bl;
    }

    public void setEARTemplateFileName(String string) {
        this.earTemplateFileName = string;
    }

    public String getEARTemplateFileName() {
        return this.earTemplateFileName;
    }

    public void setEARTargetFileName(String string) {
        this.earTargetFileName = string;
    }

    public String getEARTargetFileName() {
        return this.earTargetFileName;
    }

    public void addSoapModule(SoapModuleDescriptor soapModuleDescriptor) {
        this.soapModules.add(soapModuleDescriptor);
    }

    public List getSoapModules() {
        return this.soapModules;
    }

    public void writeTargetEarFile() throws IOException, ArchiveException, OpenFailureException, SaveFailureException, ReopenException {
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        LoadStrategy loadStrategy = commonarchiveFactory.createLoadStrategy(this.earTemplateFileName);
        EARFile eARFile = commonarchiveFactory.openEARFile(loadStrategy, this.earTargetFileName);
        Application application = eARFile.getDeploymentDescriptor();
        Iterator iterator = this.soapModules.iterator();
        while (iterator.hasNext()) {
            SoapModuleDescriptor soapModuleDescriptor = (SoapModuleDescriptor)iterator.next();
            Utils.addModule(soapModuleDescriptor, commonarchiveFactory, application, eARFile);
        }
        eARFile.save();
        eARFile.close();
    }

    public static void writeTargetEarFile(String[] stringArray) throws IllegalArgumentException, IOException, ArchiveException, OpenFailureException, SaveFailureException, ReopenException {
        try {
            int n = 0;
            SoapEnabler soapEnabler = new SoapEnabler();
            String string = stringArray[n++];
            Utils.backupEar(string);
            soapEnabler.setEARTemplateFileName(string);
            soapEnabler.setEARTargetFileName(string);
            Vector<ServiceDescriptor> vector = new Vector<ServiceDescriptor>();
            Vector<ServiceDescriptor> vector2 = new Vector<ServiceDescriptor>();
            int n2 = Integer.parseInt(stringArray[n++]);
            for (int i = 0; i < n2; ++i) {
                int n3;
                ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
                File file = new File(stringArray[n++]);
                DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
                Document document = null;
                Element element = null;
                try {
                    document = documentBuilder.parse(new InputSource("file:///" + file.getAbsolutePath()));
                    element = document.getDocumentElement();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                DeploymentDescriptor deploymentDescriptor = DeploymentDescriptor.fromXML(element);
                serviceDescriptor.setDeploymentDescriptor(deploymentDescriptor);
                boolean bl = stringArray[n++].equalsIgnoreCase("y");
                if (bl) {
                    serviceDescriptor.addClassPathEntry(stringArray[n++]);
                }
                int n4 = Integer.parseInt(stringArray[n++]);
                for (n3 = 0; n3 < n4; ++n3) {
                    serviceDescriptor.addClassPathEntry(stringArray[n++]);
                }
                if ((n3 = (int)(stringArray[n++].equalsIgnoreCase("y") ? 1 : 0)) != 0) {
                    vector2.add(serviceDescriptor);
                    continue;
                }
                vector.add(serviceDescriptor);
            }
            if (vector.size() > 0) {
                SoapModuleDescriptor soapModuleDescriptor = new SoapModuleDescriptor();
                soapModuleDescriptor.setTemplateWARUri("soap.war");
                soapModuleDescriptor.setTargetWARUri("soap.war");
                soapModuleDescriptor.setServices(vector);
                soapModuleDescriptor.setContextRoot(stringArray[n++]);
                soapEnabler.addSoapModule(soapModuleDescriptor);
            }
            if (vector2.size() > 0) {
                SoapModuleDescriptor soapModuleDescriptor = new SoapModuleDescriptor();
                soapModuleDescriptor.setTemplateWARUri("soap-sec.war");
                soapModuleDescriptor.setTargetWARUri("soap-sec.war");
                soapModuleDescriptor.setServices(vector2);
                soapModuleDescriptor.setContextRoot(stringArray[n++]);
                soapEnabler.addSoapModule(soapModuleDescriptor);
            }
            soapEnabler.writeTargetEarFile();
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw new IllegalArgumentException(myNLS.getString("com.ibm.soap.soapenabler.malformedcmdline1", "ERROR: Malformed command-line string."));
        }
        catch (NumberFormatException numberFormatException) {
            Object[] objectArray = new String[]{"" + numberFormatException.getMessage()};
            throw new IllegalArgumentException(myNLS.getFormattedMessage("com.ibm.soap.soapenabler.malformedcmdline2", objectArray, "ERROR: Malformed command-line string: {0}"));
        }
    }

    public static void main(String[] stringArray) throws Exception {
        System.out.print("\n");
        System.out.println(myNLS.getString("com.ibm.soap.soapenabler.soapenabler.ibmbanner", "IBM WebSphere Application Server"));
        System.out.println(myNLS.getString("com.ibm.soap.soapenabler.soapenabler.soapbanner", "SOAP Enterprise Archive enabler tool."));
        System.out.println(myNLS.getString("com.ibm.soap.soapenabler.soapenabler.copyright", "Copyright IBM Corp., 1997-2002"));
        System.out.print("\n");
        if (stringArray.length > 0) {
            Utils.askInstallAdmin = false;
            SoapEnabler.writeTargetEarFile(stringArray);
        } else {
            Archive archive;
            Object object;
            Object object2;
            SoapEnabler soapEnabler = new SoapEnabler();
            InputStreamReader inputStreamReader = new InputStreamReader(System.in);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            String string = Utils.getReadFileInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.earfilename", "Please enter the name of your ear file: ")).getPath();
            Utils.backupEar(string);
            soapEnabler.setEARTemplateFileName(string);
            soapEnabler.setEARTargetFileName(string);
            CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
            LoadStrategy loadStrategy = commonarchiveFactory.createLoadStrategy(string);
            EARFile eARFile = commonarchiveFactory.openEARFile(loadStrategy, string);
            Application application = eARFile.getDeploymentDescriptor();
            boolean bl = application.isVersion1_2Descriptor();
            List list = eARFile.getArchiveFiles();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                object2 = (Archive)iterator.next();
                object = object2.getURI();
                if (!((String)object).toLowerCase().endsWith(".war")) continue;
                iterator.remove();
            }
            object2 = new Vector();
            object = list.iterator();
            List list2 = eARFile.getEJBJarFiles();
            Vector<String> vector = new Vector<String>();
            Iterator iterator2 = list2.iterator();
            while (object.hasNext()) {
                archive = (Archive)object.next();
                object2.add(archive.getURI());
            }
            while (iterator2.hasNext()) {
                archive = (EJBJarFile)iterator2.next();
                vector.add(archive.getURI());
            }
            int n = Utils.getIntegerInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.howmany", "How many services would you like your application to contain (1...n)?"));
            Vector<ServiceDescriptor> vector2 = new Vector<ServiceDescriptor>();
            Vector<ServiceDescriptor> vector3 = new Vector<ServiceDescriptor>();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray;
                int n2;
                Object[] objectArray2 = new String[]{"" + (i + 1)};
                System.out.print("\n");
                System.out.println(myNLS.getFormattedMessage("com.ibm.soap.soapenabler.nowpromptingforservicenumber", objectArray2, "Now prompting for info for service {0}:"));
                ServiceDescriptor serviceDescriptor = new ServiceDescriptor();
                System.out.print("\t");
                File file = Utils.getReadFileInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.enterfilename", "Please enter the file name of the SOAP deployment descriptor xml file: "));
                DocumentBuilder documentBuilder = XMLParserUtils.getXMLDocBuilder();
                Document document = documentBuilder.parse(new InputSource("file:///" + file.getAbsolutePath()));
                Element element = document.getDocumentElement();
                DeploymentDescriptor deploymentDescriptor = DeploymentDescriptor.fromXML(element);
                serviceDescriptor.setDeploymentDescriptor(deploymentDescriptor);
                Object[] objectArray3 = new String[]{"y", "n"};
                System.out.print("\t");
                boolean bl2 = Utils.getBooleanInput(bufferedReader, myNLS.getFormattedMessage("com.ibm.soap.soapenabler.isthisejb", objectArray3, "Is this service an EJB; ({0} = yes / {1} = no)?"));
                if (bl2) {
                    System.out.print("\t");
                    n2 = Utils.getListChoiceInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.chooseejbfile", "Please choose an EJB Jar file"), vector);
                    objectArray = (Object[])list2.get(n2);
                    serviceDescriptor.addClassPathEntry(objectArray.getURI());
                }
                System.out.print("\t");
                n2 = Utils.getIntegerInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.howmanyaddlcps", "If there are any additional jarfiles that need to be added to the Classpath specify the number to add (answer 0 for none) (0...n)?") + " ");
                for (int j = 0; j < n2; ++j) {
                    Object[] objectArray4 = new String[]{"" + (j + 1)};
                    System.out.print("\t");
                    int n3 = Utils.getListChoiceInput(bufferedReader, myNLS.getFormattedMessage("com.ibm.soap.soapenabler.classpathreq", objectArray4, "Classpath addition {0}: Here are all the archive files found, please choose one to add to the Classpath:"), (List)object2);
                    Archive archive2 = (Archive)list.get(n3);
                    serviceDescriptor.addClassPathEntry(archive2.getURI());
                }
                objectArray = new String[]{"y", "n"};
                System.out.print("\t");
                boolean bl3 = Utils.getBooleanInput(bufferedReader, myNLS.getFormattedMessage("com.ibm.soap.soapenabler.shouldsecure", objectArray, "Should this service be secured; ({0} = yes / {1} = no)?"));
                if (bl3) {
                    vector3.add(serviceDescriptor);
                    continue;
                }
                vector2.add(serviceDescriptor);
            }
            if (vector2.size() > 0) {
                SoapModuleDescriptor soapModuleDescriptor = new SoapModuleDescriptor();
                if (bl) {
                    soapModuleDescriptor.setTemplateWARUri("soap_app22.war");
                } else {
                    soapModuleDescriptor.setTemplateWARUri("soap.war");
                }
                soapModuleDescriptor.setTargetWARUri("soap.war");
                soapModuleDescriptor.setServices(vector2);
                System.out.print("\n");
                soapModuleDescriptor.setContextRoot(Utils.getStringInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.nonseccontext", "Please enter a context root for your non-secured services (e.g. /soap): ")));
                soapEnabler.addSoapModule(soapModuleDescriptor);
            }
            if (vector3.size() > 0) {
                SoapModuleDescriptor soapModuleDescriptor = new SoapModuleDescriptor();
                if (bl) {
                    soapModuleDescriptor.setTemplateWARUri("soap-sec_app22.war");
                } else {
                    soapModuleDescriptor.setTemplateWARUri("soap-sec.war");
                }
                soapModuleDescriptor.setTargetWARUri("soap-sec.war");
                soapModuleDescriptor.setServices(vector3);
                System.out.print("\n");
                soapModuleDescriptor.setContextRoot(Utils.getStringInput(bufferedReader, myNLS.getString("com.ibm.soap.soapenabler.seccontext", "Please enter a context root for your secured services (e.g. /soap-sec): ")));
                soapEnabler.addSoapModule(soapModuleDescriptor);
            }
            eARFile.close();
            soapEnabler.writeTargetEarFile();
        }
    }
}

