/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.attributes.ConstantValueAttrInfo;
import com.ibm.toad.cfparse.attributes.DeprecatedAttrInfo;
import com.ibm.toad.cfparse.attributes.ExceptionAttrInfo;
import com.ibm.toad.cfparse.attributes.InnerClassesAttrInfo;
import com.ibm.toad.cfparse.attributes.LineNumberAttrInfo;
import com.ibm.toad.cfparse.attributes.LocalVariableAttrInfo;
import com.ibm.toad.cfparse.attributes.SourceDirAttrInfo;
import com.ibm.toad.cfparse.attributes.SourceFileAttrInfo;
import com.ibm.toad.cfparse.attributes.SyntheticAttrInfo;
import com.ibm.toad.cfparse.attributes.UnknownAttrInfo;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.BitSet;

public final class AttrInfoList {
    private ConstantPool d_cp;
    private int d_numAttrs;
    private AttrInfo[] d_attrs;
    private int d_depth;
    static /* synthetic */ Class class$com$ibm$toad$cfparse$ConstantPool;

    public AttrInfoList(ConstantPool constantPool, int n) {
        this.d_cp = constantPool;
        this.d_numAttrs = 0;
        this.d_attrs = null;
        this.d_depth = n;
    }

    int depth() {
        return this.d_depth;
    }

    private void resize() {
        AttrInfo[] attrInfoArray = new AttrInfo[this.d_numAttrs + 10];
        if (this.d_attrs != null) {
            System.arraycopy(this.d_attrs, 0, attrInfoArray, 0, this.d_numAttrs);
        }
        this.d_attrs = attrInfoArray;
    }

    private String sindent() {
        String string = "";
        for (int i = 0; i < this.d_depth; ++i) {
            string = string + "  ";
        }
        return string;
    }

    public int length() {
        return this.d_numAttrs;
    }

    public int size() {
        int n = 2;
        for (int i = 0; i < this.d_numAttrs; ++i) {
            n += this.d_attrs[i].size();
        }
        return n;
    }

    public AttrInfo get(int n) {
        if (n < 0 || n > this.d_attrs.length - 1) {
            return null;
        }
        return this.d_attrs[n];
    }

    public String getName(int n) {
        if (n < 0 || n > this.d_attrs.length - 1) {
            return null;
        }
        return this.d_attrs[n].getName();
    }

    public AttrInfo get(String string) {
        for (int i = 0; i < this.d_numAttrs; ++i) {
            if (!this.d_attrs[i].getName().equals(string)) continue;
            return this.d_attrs[i];
        }
        return null;
    }

    public void remove(String string) {
        for (int i = 0; i < this.d_numAttrs; ++i) {
            if (!this.d_attrs[i].getName().equals(string)) continue;
            this.remove(i);
        }
    }

    public void remove(int n) {
        if (n < 0 || n > this.d_numAttrs - 1) {
            return;
        }
        for (int i = n; i < this.d_numAttrs - 1; ++i) {
            this.d_attrs[i] = this.d_attrs[i + 1];
        }
        --this.d_numAttrs;
    }

    public AttrInfo add(String string) {
        int n = 0;
        if (this.d_attrs == null || this.d_numAttrs == this.d_attrs.length) {
            this.resize();
        }
        if ((n = this.d_cp.find(1, string)) == -1) {
            n = this.d_cp.addUtf8(string);
        }
        if (string.equals("SourceFile")) {
            this.d_attrs[this.d_numAttrs] = new SourceFileAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("SourceDir")) {
            this.d_attrs[this.d_numAttrs] = new SourceDirAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("ConstantValue")) {
            this.d_attrs[this.d_numAttrs] = new ConstantValueAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Code")) {
            this.d_attrs[this.d_numAttrs] = new CodeAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Exceptions")) {
            this.d_attrs[this.d_numAttrs] = new ExceptionAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("LineNumberTable")) {
            this.d_attrs[this.d_numAttrs] = new LineNumberAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("LocalVariableTable")) {
            this.d_attrs[this.d_numAttrs] = new LocalVariableAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("InnerClasses")) {
            this.d_attrs[this.d_numAttrs] = new InnerClassesAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Synthetic")) {
            this.d_attrs[this.d_numAttrs] = new SyntheticAttrInfo(this.d_cp, n, this.d_depth);
        } else if (string.equals("Deprecated")) {
            this.d_attrs[this.d_numAttrs] = new DeprecatedAttrInfo(this.d_cp, n, this.d_depth);
        } else {
            try {
                Class<?> clazz = Class.forName(string + "AttrInfo");
                Constructor<?> constructor = clazz.getConstructor(class$com$ibm$toad$cfparse$ConstantPool == null ? (class$com$ibm$toad$cfparse$ConstantPool = AttrInfoList.class$("com.ibm.toad.cfparse.ConstantPool")) : class$com$ibm$toad$cfparse$ConstantPool, Integer.TYPE, Integer.TYPE);
                this.d_attrs[this.d_numAttrs] = (AttrInfo)constructor.newInstance(this.d_cp, new Integer(n), new Integer(this.d_depth));
            }
            catch (Exception exception) {
                this.d_attrs[this.d_numAttrs] = new UnknownAttrInfo(this.d_cp, n, this.d_depth);
            }
        }
        ++this.d_numAttrs;
        return this.d_attrs[this.d_numAttrs - 1];
    }

    public void sort(int[] nArray) {
        for (int i = 0; i < this.d_numAttrs; ++i) {
            this.d_attrs[i].sort(nArray);
        }
    }

    public BitSet uses() {
        BitSet bitSet = new BitSet(this.d_cp.length());
        for (int i = 0; i < this.d_numAttrs; ++i) {
            bitSet.or(this.d_attrs[i].uses());
        }
        return bitSet;
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_numAttrs);
        for (int i = 0; i < this.d_numAttrs; ++i) {
            this.d_attrs[i].write(dataOutputStream);
        }
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_numAttrs = dataInputStream.readUnsignedShort();
        this.d_attrs = new AttrInfo[this.d_numAttrs];
        for (int i = 0; i < this.d_numAttrs; ++i) {
            int n = dataInputStream.readUnsignedShort();
            String string = this.d_cp.getAsString(n);
            if (string.equals("SourceFile")) {
                this.d_attrs[i] = new SourceFileAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("ConstantValue")) {
                this.d_attrs[i] = new ConstantValueAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("Code")) {
                this.d_attrs[i] = new CodeAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("Exceptions")) {
                this.d_attrs[i] = new ExceptionAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("LineNumberTable")) {
                this.d_attrs[i] = new LineNumberAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("LocalVariableTable")) {
                this.d_attrs[i] = new LocalVariableAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("InnerClasses")) {
                this.d_attrs[i] = new InnerClassesAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("SourceDir")) {
                this.d_attrs[i] = new SourceDirAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("Synthetic")) {
                this.d_attrs[i] = new SyntheticAttrInfo(this.d_cp, n, this.d_depth);
            } else if (string.equals("Deprecated")) {
                this.d_attrs[i] = new DeprecatedAttrInfo(this.d_cp, n, this.d_depth);
            } else {
                try {
                    Class<?> clazz = Class.forName(string + "AttrInfo");
                    Constructor<?> constructor = clazz.getConstructor(class$com$ibm$toad$cfparse$ConstantPool == null ? AttrInfoList.class$("com.ibm.toad.cfparse.ConstantPool") : class$com$ibm$toad$cfparse$ConstantPool, Integer.TYPE, Integer.TYPE);
                    this.d_attrs[i] = (AttrInfo)constructor.newInstance(this.d_cp, new Integer(n), new Integer(this.d_depth));
                }
                catch (Exception exception) {
                    this.d_attrs[i] = new UnknownAttrInfo(this.d_cp, n, this.d_depth);
                }
            }
            this.d_attrs[i].read(dataInputStream);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.d_numAttrs > 0) {
            --this.d_depth;
            stringBuffer.append(this.sindent());
            ++this.d_depth;
            stringBuffer.append("ATTRIBUTES:\n");
            for (int i = 0; i < this.d_numAttrs; ++i) {
                stringBuffer.append(this.d_attrs[i] + "\n");
            }
        }
        return stringBuffer.toString();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

