/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class ExceptionAttrInfo
extends AttrInfo {
    private int d_numExceptions;
    private int[] d_exceptions;

    ExceptionAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
        this.d_len = 0;
        this.d_numExceptions = 0;
        this.d_exceptions = null;
    }

    private void resize() {
        int[] nArray = new int[this.d_numExceptions + 10];
        if (this.d_exceptions != null) {
            System.arraycopy(this.d_exceptions, 0, nArray, 0, this.d_numExceptions);
        }
        this.d_exceptions = nArray;
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        for (int i = 0; i < this.d_numExceptions; ++i) {
            bitSet.set(this.d_exceptions[i]);
        }
        return bitSet;
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        for (int i = 0; i < this.d_numExceptions; ++i) {
            this.d_exceptions[i] = nArray[this.d_exceptions[i]];
        }
    }

    public void add(String string) {
        if (this.d_exceptions == null || this.d_numExceptions == this.d_exceptions.length) {
            this.resize();
        }
        this.d_exceptions[this.d_numExceptions] = this.d_cp.addClass(string);
        ++this.d_numExceptions;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_numExceptions = dataInputStream.readUnsignedShort();
        D.azzert(this.d_len == 2 + this.d_numExceptions * 2, "d_len != 2 + (d_numExceptions * 2)\n" + this.d_len + " != 2 + (" + this.d_numExceptions + "* 2)\n");
        this.d_exceptions = new int[this.d_numExceptions];
        for (int i = 0; i < this.d_numExceptions; ++i) {
            this.d_exceptions[i] = dataInputStream.readUnsignedShort();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        dataOutputStream.writeInt(2 + this.d_numExceptions * 2);
        dataOutputStream.writeShort(this.d_numExceptions);
        for (int i = 0; i < this.d_numExceptions; ++i) {
            dataOutputStream.writeShort(this.d_exceptions[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": ");
        for (int i = 0; i < this.d_numExceptions; ++i) {
            if (this.d_exceptions[i] == 0) continue;
            stringBuffer.append(", " + this.d_cp.getAsJava(this.d_exceptions[i]));
        }
        return stringBuffer.append("\n").toString();
    }

    public int length() {
        return this.d_numExceptions;
    }

    public String get(int n) {
        if (n < 0 || n >= this.d_numExceptions || this.d_exceptions[n] == 0) {
            return "";
        }
        return this.d_cp.getAsJava(this.d_exceptions[n]);
    }

    public void set(int n, String string) {
        if (n < 0 || n >= this.d_numExceptions || this.d_exceptions[n] == 0) {
            return;
        }
        this.d_cp.editClass(this.d_exceptions[n], string);
    }

    public void remove(int n) {
        if (n < 0 || n >= this.d_numExceptions) {
            return;
        }
        for (int i = n; i < this.d_numExceptions - 1; ++i) {
            this.d_exceptions[i] = this.d_exceptions[i + 1];
        }
        --this.d_numExceptions;
    }
}

