/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.utils.Access;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import com.ibm.toad.utils.D;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.BitSet;

public final class InnerClassesAttrInfo
extends AttrInfo {
    private int d_numInnerClasses;
    private int[] d_innerClasses;

    InnerClassesAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
    }

    protected void sort(int[] nArray) {
        super.sort(nArray);
        for (int i = 0; i < this.d_innerClasses.length; ++i) {
            if (i % 4 == 3) continue;
            this.d_innerClasses[i] = nArray[this.d_innerClasses[i]];
        }
    }

    protected BitSet uses() {
        BitSet bitSet = super.uses();
        for (int i = 0; i < this.d_innerClasses.length; ++i) {
            if (i % 4 == 3) continue;
            bitSet.set(this.d_innerClasses[i]);
        }
        return bitSet;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_numInnerClasses = dataInputStream.readUnsignedShort();
        D.azzert(this.d_len == 2 + this.d_numInnerClasses * 8, "d_len != 2 + (d_numInnerClasses * 8)\n" + this.d_len + " != 2 + (" + this.d_numInnerClasses + "* 8)\n");
        this.d_innerClasses = new int[this.d_numInnerClasses * 4];
        for (int i = 0; i < this.d_innerClasses.length; ++i) {
            this.d_innerClasses[i] = dataInputStream.readUnsignedShort();
        }
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        DataIOUtils.writeUnsignedInt(dataOutputStream, this.d_len);
        dataOutputStream.writeShort(this.d_numInnerClasses);
        for (int i = 0; i < this.d_innerClasses.length; ++i) {
            dataOutputStream.writeShort(this.d_innerClasses[i]);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.sindent() + "Attribute: " + this.d_cp.getAsString(this.d_idxName) + ": \n");
        int n = 0;
        while (n < this.d_innerClasses.length) {
            int n2 = this.d_innerClasses[n++];
            int n3 = this.d_innerClasses[n++];
            int n4 = this.d_innerClasses[n++];
            int n5 = this.d_innerClasses[n++];
            String string = "";
            if (n4 == 0) {
                string = "(Anonymous) ";
            }
            stringBuffer.append(this.sindent() + string + Access.getAsString(n5) + this.d_cp.getAsJava(n2));
            if (n3 != 0) {
                stringBuffer.append(". Member of Class " + this.d_cp.getAsJava(n3));
            }
            if (n4 != 0) {
                stringBuffer.append(". Class name " + this.d_cp.getAsJava(n4));
            }
            stringBuffer.append("\n");
        }
        return stringBuffer.toString();
    }

    public int getNumInnerClasses() {
        return this.d_numInnerClasses;
    }

    public String getOuterClassName(int n) {
        if (n < 0 || n >= this.d_numInnerClasses) {
            return "";
        }
        int n2 = this.d_innerClasses[n * 4 + 1];
        if (n2 == 0) {
            return "";
        }
        return this.d_cp.getAsJava(n2);
    }

    public String getClassName(int n) {
        if (n < 0 || n >= this.d_numInnerClasses) {
            return "";
        }
        int n2 = this.d_innerClasses[n * 4 + 2];
        if (n2 == 0) {
            return "";
        }
        return this.d_cp.getAsJava(n2);
    }

    public boolean isAnonymous(int n) {
        if (n < 0 || n >= this.d_numInnerClasses) {
            return false;
        }
        int n2 = this.d_innerClasses[n * 4 + 2];
        return n2 == 0;
    }

    public String getFullClassName(int n) {
        if (n < 0 || n >= this.d_numInnerClasses) {
            return "";
        }
        int n2 = this.d_innerClasses[n * 4];
        int n3 = this.d_innerClasses[n * 4 + 2];
        int n4 = this.d_innerClasses[n * 4 + 3];
        String string = "";
        if (n3 == 0) {
            string = "(Anonymous) ";
        }
        return string + Access.getAsString(n4) + this.d_cp.getAsJava(n2);
    }
}

