/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.attributes;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.AttrInfo;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.cfparse.utils.DataIOUtils;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public final class UnknownAttrInfo
extends AttrInfo {
    private byte[] d_info;

    UnknownAttrInfo(ConstantPool constantPool, int n, int n2) {
        super(constantPool, n, n2);
        this.d_len = 0;
        this.d_info = null;
    }

    public void read(DataInputStream dataInputStream) throws IOException {
        this.d_len = DataIOUtils.readUnsignedIntAsInt(dataInputStream);
        this.d_info = new byte[this.d_len];
        dataInputStream.readFully(this.d_info);
    }

    public void write(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(this.d_idxName);
        DataIOUtils.writeUnsignedInt(dataOutputStream, this.d_len);
        if (this.d_info != null) {
            dataOutputStream.write(this.d_info, 0, this.d_len);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(super.toString() + "  bytes (" + this.d_len + "): ");
        for (int i = 0; i < this.d_len; ++i) {
            int n = ByteArray.getByteAtOffset(this.d_info, i);
            stringBuffer.append(Integer.toHexString(n) + " ");
        }
        stringBuffer.append("\n");
        return stringBuffer.toString();
    }

    public byte[] get() {
        return this.d_info;
    }

    public void set(byte[] byArray) {
        this.d_len = byArray.length;
        this.d_info = byArray;
    }
}

