/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.instruction;

import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.attributes.CodeAttrInfo;
import com.ibm.toad.cfparse.instruction.CodeViewer;
import com.ibm.toad.cfparse.instruction.InstructionFactory;
import com.ibm.toad.cfparse.instruction.JVMInstruction;
import com.ibm.toad.cfparse.utils.ByteArray;
import com.ibm.toad.utils.D;
import java.util.HashMap;

public class ImmutableCodeSegment {
    private int d_numInstructions;
    private int[] d_instructions;
    private HashMap d_offsets;
    private byte[] d_code;

    public ImmutableCodeSegment(byte[] byArray) {
        this.d_code = byArray;
        D.azzert(byArray != null, "Cannot create null ImmutableCodeSegment");
        this.readCode(this.d_code);
    }

    private void readCode(byte[] byArray) {
        this.d_offsets = new HashMap();
        int[] nArray = new int[byArray.length];
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            block7: {
                JVMInstruction jVMInstruction;
                block6: {
                    nArray[n2] = n;
                    this.d_offsets.put(new Integer(n), new Integer(n2));
                    int n3 = n;
                    int n4 = ByteArray.getByteAtOffset(byArray, n);
                    boolean bl = false;
                    ++n;
                    jVMInstruction = JVMInstruction.d_instrTable[n4];
                    int n5 = jVMInstruction.len();
                    if (n5 != 0) break block6;
                    switch (n4) {
                        case 170: 
                        case 171: {
                            n += this.specArgSkip(byArray, n4, n);
                            break block7;
                        }
                        case 196: {
                            n += this.specArgSkip(byArray, n4, n);
                            break block7;
                        }
                        default: {
                            throw new D.AssertionException("Unknown special op code");
                        }
                    }
                }
                String string = jVMInstruction.operandTypes();
                int n6 = string.length();
                for (int i = 0; i < n6; ++i) {
                    n += JVMInstruction.argSkip(string.charAt(i));
                }
            }
            ++n2;
        }
        this.d_numInstructions = n2;
        this.d_instructions = new int[this.d_numInstructions];
        System.arraycopy(nArray, 0, this.d_instructions, 0, this.d_numInstructions);
    }

    private int specArgSkip(byte[] byArray, int n, int n2) {
        int n3 = n2;
        int n4 = (4 - n2 % 4) % 4;
        switch (n) {
            case 170: {
                int n5 = ByteArray.getIntAtOffset(byArray, n2 += n4 + 4);
                int n6 = ByteArray.getIntAtOffset(byArray, n2 += 4);
                n2 += 4;
                for (int i = n5; i <= n6; ++i) {
                    n2 += 4;
                }
                break;
            }
            case 171: {
                int n7 = ByteArray.getIntAtOffset(byArray, n2 += n4 + 4);
                n2 += 4;
                for (int i = 0; i < n7; ++i) {
                    n2 += 8;
                }
                break;
            }
            case 196: {
                int n8 = ByteArray.getByteAtOffset(byArray, n2);
                n2 += 3;
                if (n8 != 132) break;
                n2 += 2;
            }
        }
        return n2 - n3;
    }

    public byte[] getInstruction(int n) {
        if (n < 0 || n >= this.d_numInstructions) {
            return null;
        }
        int n2 = n == this.d_numInstructions - 1 ? this.d_code.length : this.d_instructions[n + 1];
        byte[] byArray = new byte[n2 - this.d_instructions[n]];
        System.arraycopy(this.d_code, this.d_instructions[n], byArray, 0, n2 - this.d_instructions[n]);
        return byArray;
    }

    public int getOffset(int n) {
        D.azzert(n >= 0 && n < this.d_numInstructions, "Illegal instruction number");
        return this.d_instructions[n];
    }

    public int getInum(int n) {
        Integer n2 = (Integer)this.d_offsets.get(new Integer(n));
        D.azzert(n2 != null, "Illegal offset");
        return n2;
    }

    public int getNumInstructions() {
        return this.d_numInstructions;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.d_numInstructions; ++i) {
            int n = this.d_instructions[i];
            int n2 = i == this.d_numInstructions - 1 ? this.d_code.length : this.d_instructions[i + 1];
            stringBuffer.append(i + "(" + this.getOffset(i) + ") " + this.toBytes(this.d_code, n, n2) + "\t\t\t" + this.InstrPrint(this.d_code, n, n2) + "\n");
        }
        return stringBuffer.toString();
    }

    String toBytes(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = n; i < n2; ++i) {
            String string = Integer.toHexString(byArray[i] & 0xFF) + " ";
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0");
            }
            stringBuffer.append(string);
        }
        return stringBuffer.toString();
    }

    String InstrPrint(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer;
        block9: {
            JVMInstruction jVMInstruction;
            int n3;
            block8: {
                char[] cArray = new char[]{'i', 'l', 'f', 'd', 'a'};
                n3 = n;
                int n4 = byArray[n] & 0xFF;
                jVMInstruction = JVMInstruction.d_instrTable[n4];
                stringBuffer = new StringBuffer(jVMInstruction.name() + " ");
                if (jVMInstruction.len() != 0) break block8;
                switch (n4) {
                    case 170: {
                        n3 += (4 - n3 % 4) % 4;
                        this.sprintOperand(stringBuffer, n3, 'A');
                        stringBuffer.append(" ");
                        int n5 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        stringBuffer.append("-");
                        int n6 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        n3 += 4;
                        stringBuffer.append(" ");
                        for (int i = n5; i <= n6; ++i) {
                            this.sprintOperand(stringBuffer, n3, 'A');
                            n3 += 4;
                            stringBuffer.append(" ");
                        }
                        break block9;
                    }
                    case 171: {
                        n3 += (4 - n3 % 4) % 4;
                        this.sprintOperand(stringBuffer, n3, 'A');
                        stringBuffer.append(" ");
                        int n7 = ByteArray.getIntAtOffset(byArray, n3 += 4);
                        this.sprintOperand(stringBuffer, n3, 'l');
                        n3 += 4;
                        stringBuffer.append(" ");
                        for (int i = 0; i < n7; ++i) {
                            stringBuffer.append("(");
                            this.sprintOperand(stringBuffer, n3, 'l');
                            stringBuffer.append(", ");
                            this.sprintOperand(stringBuffer, n3 += 4, 'A');
                            n3 += 4;
                            stringBuffer.append(") ");
                        }
                        break block9;
                    }
                    case 196: {
                        int n8 = ByteArray.getByteAtOffset(byArray, n3 + 1);
                        JVMInstruction jVMInstruction2 = JVMInstruction.d_instrTable[n8];
                        stringBuffer.append(jVMInstruction2.name() + " ");
                        this.sprintOperand(stringBuffer, n3 + 2, 'V');
                        stringBuffer.append(" ");
                        if (n8 != 132) break block9;
                        this.sprintOperand(stringBuffer, n3 + 4, 'I');
                        break block9;
                    }
                    default: {
                        throw new D.AssertionException("unknown special op code");
                    }
                }
            }
            ++n3;
            int n9 = jVMInstruction.d_operandTypes.length();
            for (int i = 0; i < n9; ++i) {
                this.sprintOperand(stringBuffer, n3, jVMInstruction.d_operandTypes.charAt(i));
                n3 += JVMInstruction.argSkip(jVMInstruction.d_operandTypes.charAt(i));
                stringBuffer.append(" ");
            }
        }
        return stringBuffer.toString();
    }

    void sprintOperand(StringBuffer stringBuffer, int n, char c) {
        int n2 = 0;
        switch (c) {
            case 'c': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(n2);
                break;
            }
            case 'C': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append(n2);
                break;
            }
            case 'v': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case 'V': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                stringBuffer.append("v" + n2);
                break;
            }
            case '0': 
            case 'u': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'i': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                if (n2 > 127) {
                    n2 -= 256;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'I': {
                n2 = ByteArray.getShortAtOffset(this.d_code, n);
                if (n2 > Short.MAX_VALUE) {
                    n2 -= 65536;
                }
                stringBuffer.append("#" + n2);
                break;
            }
            case 'l': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append("#" + n2);
                break;
            }
            case 'a': {
                n2 = ByteArray.getSignedShortAtOffset(this.d_code, n);
                stringBuffer.append(n + n2 - 1);
                break;
            }
            case 'A': {
                n2 = ByteArray.getIntAtOffset(this.d_code, n);
                stringBuffer.append(n + n2 - 1);
                break;
            }
            case 't': {
                n2 = ByteArray.getByteAtOffset(this.d_code, n);
                stringBuffer.append(JVMInstruction.arrayTypeCode2String(n2));
                break;
            }
            default: {
                stringBuffer.append("<unknown operand type: " + c + ">");
            }
        }
    }

    public static CodeViewer getViewer() {
        return new CodeViewer(){
            InstructionFactory d_if;

            public void setInstructionType(InstructionFactory instructionFactory) {
                this.d_if = instructionFactory;
            }

            public String view(ConstantPool constantPool, byte[] byArray, CodeAttrInfo.ExceptionInfo[] exceptionInfoArray, int n, String string) {
                int n2;
                StringBuffer stringBuffer = new StringBuffer();
                ImmutableCodeSegment immutableCodeSegment = new ImmutableCodeSegment(byArray);
                int n3 = immutableCodeSegment.getNumInstructions();
                for (n2 = 0; n2 < n3; ++n2) {
                    int n4 = immutableCodeSegment.getOffset(n2);
                    int n5 = n2 == n3 - 1 ? byArray.length : immutableCodeSegment.getOffset(n2 + 1);
                    stringBuffer.append(n2 + "(" + immutableCodeSegment.getOffset(n2) + ")" + string + " " + immutableCodeSegment.toBytes(byArray, n4, n5) + "\t\t\t" + immutableCodeSegment.InstrPrint(byArray, n4, n5) + "\n");
                }
                stringBuffer.append(string + "Exception Table:\n");
                if (n == 0) {
                    stringBuffer.append(string + "  <none>\n");
                } else {
                    for (n2 = 0; n2 < n; ++n2) {
                        stringBuffer.append(string + exceptionInfoArray[n2] + "\n");
                    }
                }
                return stringBuffer.toString();
            }
        };
    }
}

