/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.utils;

import java.util.StringTokenizer;

public final class Access {
    public static final short ACC_PUBLIC = 1;
    public static final short ACC_PRIVATE = 2;
    public static final short ACC_PROTECTED = 4;
    public static final short ACC_STATIC = 8;
    public static final short ACC_FINAL = 16;
    public static final short ACC_SUPER = 32;
    public static final short ACC_SYNCHRONIZED = 32;
    public static final short ACC_VOLATILE = 64;
    public static final short ACC_BRIDGE = 64;
    public static final short ACC_TRANSIENT = 128;
    public static final short ACC_VARARGS = 128;
    public static final short ACC_NATIVE = 256;
    public static final short ACC_INTERFACE = 512;
    public static final short ACC_ABSTRACT = 1024;
    public static final short ACC_STRICT = 2048;
    public static final short ACC_ANNOTATION = 8192;
    public static final short ACC_ENUM = 16384;

    public static boolean isBridge(int n) {
        return (n & 0x40) != 0;
    }

    public static boolean isVarargs(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isEnum(int n) {
        return (n & 0x4000) != 0;
    }

    public static boolean isAnnotation(int n) {
        return (n & 0x2000) != 0;
    }

    public static boolean isStrict(int n) {
        return (n & 0x800) != 0;
    }

    public static boolean isPublic(int n) {
        return (n & 1) != 0;
    }

    public static boolean isPrivate(int n) {
        return (n & 2) != 0;
    }

    public static boolean isProtected(int n) {
        return (n & 4) != 0;
    }

    public static boolean isStatic(int n) {
        return (n & 8) != 0;
    }

    public static boolean isFinal(int n) {
        return (n & 0x10) != 0;
    }

    public static boolean isSuper(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isSynchronized(int n) {
        return (n & 0x20) != 0;
    }

    public static boolean isVolatile(int n) {
        return (n & 0x40) != 0;
    }

    public static boolean isTransient(int n) {
        return (n & 0x80) != 0;
    }

    public static boolean isInterface(int n) {
        return (n & 0x200) != 0;
    }

    public static boolean isClass(int n) {
        return !Access.isInterface(n);
    }

    public static boolean isNative(int n) {
        return (n & 0x100) != 0;
    }

    public static boolean isAbstract(int n) {
        return (n & 0x400) != 0;
    }

    public static boolean isFlag(String string) {
        return string.equals("public") || string.equals("final") || string.equals("/*super*/") || string.equals("abstract") || string.equals("interface") || string.equals("private") || string.equals("protected") || string.equals("static") || string.equals("native") || string.equals("volatile") || string.equals("transient") || string.equals("synchronized") || string.equals("class") || string.equals("annotation") || string.equals("enum") || string.equals("varargs") || string.equals("bridge");
    }

    public static String getAsString(int n) {
        String string = "";
        if (Access.isPublic(n)) {
            string = string + "public ";
        }
        if (Access.isFinal(n)) {
            string = string + "final ";
        }
        if (Access.isSuper(n)) {
            string = string + "/*super*/ ";
        }
        if (Access.isAbstract(n)) {
            string = string + "abstract ";
        }
        if (Access.isInterface(n)) {
            string = string + "interface ";
        }
        if (Access.isPrivate(n)) {
            string = string + "private ";
        }
        if (Access.isProtected(n)) {
            string = string + "protected ";
        }
        if (Access.isSynchronized(n)) {
            string = string + "synchronized ";
        }
        if (Access.isStatic(n)) {
            string = string + "static ";
        }
        if (Access.isNative(n)) {
            string = string + "native ";
        }
        if (Access.isVolatile(n)) {
            string = string + "volatile ";
        }
        if (Access.isTransient(n)) {
            string = string + "transient ";
        }
        if (Access.isClass(n)) {
            string = string + "class ";
        }
        if (Access.isAnnotation(n)) {
            string = string + "annotation ";
        }
        if (Access.isEnum(n)) {
            string = string + "enum ";
        }
        if (Access.isVarargs(n)) {
            string = string + "varargs ";
        }
        if (Access.isBridge(n)) {
            string = string + "bridge ";
        }
        return string;
    }

    public static String getClassAsString(int n) {
        String string = "";
        if (Access.isPublic(n)) {
            string = string + "public ";
        }
        if (Access.isFinal(n)) {
            string = string + "final ";
        }
        if (Access.isSuper(n)) {
            string = string + "/*super*/ ";
        }
        if (Access.isInterface(n)) {
            string = string + "interface ";
        }
        if (Access.isAbstract(n)) {
            string = string + "abstract ";
        }
        if (Access.isClass(n)) {
            string = string + "class ";
        }
        if (Access.isAnnotation(n)) {
            string = string + "annotation ";
        }
        if (Access.isEnum(n)) {
            string = string + "enum ";
        }
        return string;
    }

    public static String getMethodAsString(int n) {
        String string = "";
        if (Access.isPublic(n)) {
            string = string + "public ";
        }
        if (Access.isFinal(n)) {
            string = string + "final ";
        }
        if (Access.isPrivate(n)) {
            string = string + "private ";
        }
        if (Access.isProtected(n)) {
            string = string + "protected ";
        }
        if (Access.isStatic(n)) {
            string = string + "static ";
        }
        if (Access.isSynchronized(n)) {
            string = string + "synchronized ";
        }
        if (Access.isNative(n)) {
            string = string + "native ";
        }
        if (Access.isAbstract(n)) {
            string = string + "abstract ";
        }
        if (Access.isVarargs(n)) {
            string = string + "varargs ";
        }
        if (Access.isBridge(n)) {
            string = string + "bridge ";
        }
        return string;
    }

    public static String getFieldAsString(int n) {
        String string = "";
        if (Access.isPublic(n)) {
            string = string + "public ";
        }
        if (Access.isPrivate(n)) {
            string = string + "private ";
        }
        if (Access.isProtected(n)) {
            string = string + "protected ";
        }
        if (Access.isFinal(n)) {
            string = string + "final ";
        }
        if (Access.isStatic(n)) {
            string = string + "static ";
        }
        if (Access.isVolatile(n)) {
            string = string + "volatile ";
        }
        if (Access.isTransient(n)) {
            string = string + "transient ";
        }
        if (Access.isEnum(n)) {
            string = string + "enum ";
        }
        return string;
    }

    public static int getFromString(String string) {
        int n = 0;
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            if (string2.equals("public")) {
                n |= 1;
                continue;
            }
            if (string2.equals("final")) {
                n |= 0x10;
                continue;
            }
            if (string2.equals("/*super*/")) {
                n |= 0x20;
                continue;
            }
            if (string2.equals("abstract")) {
                n |= 0x400;
                continue;
            }
            if (string2.equals("interface")) {
                n |= 0x200;
                continue;
            }
            if (string2.equals("private")) {
                n |= 2;
                continue;
            }
            if (string2.equals("protected")) {
                n |= 4;
                continue;
            }
            if (string2.equals("final")) {
                n |= 0x10;
                continue;
            }
            if (string2.equals("static")) {
                n |= 8;
                continue;
            }
            if (string2.equals("volatile")) {
                n |= 0x40;
                continue;
            }
            if (string2.equals("transient")) {
                n |= 0x80;
                continue;
            }
            if (string2.equals("synchronized")) {
                n |= 0x20;
                continue;
            }
            if (string2.equals("native")) {
                n |= 0x100;
                continue;
            }
            if (string2.equals("annotation")) {
                n |= 0x2000;
                continue;
            }
            if (string2.equals("enum")) {
                n |= 0x4000;
                continue;
            }
            if (string2.equals("varargs")) {
                n |= 0x80;
                continue;
            }
            if (string2.equals("bridge")) {
                n |= 0x40;
                continue;
            }
            if (!string2.equals("class")) continue;
            n |= 0;
        }
        return n;
    }
}

