/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.cfparse.utils;

import com.ibm.toad.cfparse.ClassFile;
import com.ibm.toad.cfparse.ConstantPool;
import com.ibm.toad.cfparse.MethodInfoList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class CFUtils {
    public static final int BYTES = 1;
    public static final int FILE = 2;
    public static final int CLASSFILE = 3;
    public static final int STRING = 4;

    public static String canonicalize(String string) {
        String string2 = string.replace('\\', '/').replace('.', '/');
        string2 = string2.endsWith("/class") ? string2.substring(0, string2.length() - 6) + ".class" : string2 + ".class";
        return string2;
    }

    public static String[] getClassPath(boolean bl) {
        String[] stringArray;
        StringTokenizer stringTokenizer = new StringTokenizer(System.getProperty("java.class.path"), File.pathSeparator);
        String[] stringArray2 = new String[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            stringArray = stringTokenizer.nextToken();
            if (!bl && (stringArray.endsWith(".jar") || stringArray.endsWith(".zip"))) continue;
            stringArray2[n++] = stringArray;
        }
        stringArray = new String[n];
        System.arraycopy(stringArray2, 0, stringArray, 0, n);
        return stringArray;
    }

    public static Vector getFileDeps(String string, String string2, boolean bl) {
        ClassFile classFile;
        Hashtable<String, ClassFile> hashtable = new Hashtable<String, ClassFile>();
        Hashtable<String, String> hashtable2 = new Hashtable<String, String>();
        Vector<String> vector = new Vector<String>();
        Vector<String> vector2 = new Vector<String>();
        if (hashtable.contains(string2 = CFUtils.canonicalize(string2))) {
            classFile = (ClassFile)hashtable.get(string2);
        } else {
            try {
                classFile = new ClassFile(string + string2);
            }
            catch (Exception exception) {
                System.out.println("oops ");
                exception.printStackTrace();
                return null;
            }
            hashtable.put(string2, classFile);
            hashtable2.put(string2, classFile.getSourceFilename());
        }
        ConstantPool constantPool = classFile.getCP();
        for (int i = 0; i < constantPool.length(); ++i) {
            String string3;
            if (constantPool.getType(i) != 7 || (string3 = CFUtils.canonicalize(constantPool.getAsString(i))).equals(string2) || string3.startsWith("java/") || string3.startsWith("com/sun/")) continue;
            if (bl) {
                if (vector.contains(string3)) continue;
                vector.addElement(string3);
                vector2.addElement(string3);
                continue;
            }
            if (hashtable2.contains(string3)) {
                vector2.addElement((String)hashtable2.get(string3));
                continue;
            }
            try {
                classFile = new ClassFile(string + string3);
                hashtable.put(string3, classFile);
                hashtable2.put(string3, classFile.getSourceFilename());
                if (vector2.contains(classFile.getSourceFilename())) continue;
                vector2.addElement(classFile.getSourceFilename());
                continue;
            }
            catch (Exception exception) {
                System.out.println("Failed to read " + string3);
            }
        }
        return vector2;
    }

    public static String[] getClassNames(String string, boolean bl) {
        String string2 = string.replace('\\', '/').replace('.', '/');
        if (string2.endsWith("*")) {
            string2 = string2.substring(0, string2.length() - 1);
        }
        if (!string2.endsWith("/")) {
            string2 = string2 + "/";
        }
        String[] stringArray = CFUtils.getClassPath(bl);
        Vector<Object> vector = new Vector<Object>();
        for (int i = 0; i < stringArray.length; ++i) {
            String[] stringArray2;
            Object object;
            String string3 = "";
            if (stringArray[i].endsWith("/")) {
                string3 = stringArray[i] + string2;
            } else {
                if (stringArray[i].endsWith(".jar") || stringArray[i].endsWith(".zip")) {
                    object = CFUtils.getClassNamesFromZip(stringArray[i], string2);
                    if (object == null) continue;
                    for (int j = 0; j < ((Object)object).length; ++j) {
                        vector.addElement(object[j]);
                    }
                    continue;
                }
                string3 = stringArray[i] + "/" + string2;
            }
            object = new File(string3);
            if (!((File)object).isDirectory() || (stringArray2 = ((File)object).list(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.endsWith(".class");
                }
            })) == null) continue;
            for (int j = 0; j < stringArray2.length; ++j) {
                String string4 = (string2 + stringArray2[j].substring(0, stringArray2[j].length() - 6)).replace('/', '.');
                vector.addElement(string4);
            }
        }
        Object[] objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object forName(String string, int n, boolean bl) {
        return CFUtils.forName(null, string, n, bl);
    }

    public static Object forName(String[] stringArray, String string, int n, boolean bl) {
        String string2 = CFUtils.canonicalize(string);
        if (stringArray == null) {
            stringArray = CFUtils.getClassPath(bl);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Object object;
            String string3 = "";
            if (stringArray[i].endsWith("/")) {
                string3 = stringArray[i] + string2;
            } else {
                if (stringArray[i].endsWith(".jar") || stringArray[i].endsWith(".zip")) {
                    object = CFUtils.forName(stringArray[i], string, n);
                    if (object == null) continue;
                    return object;
                }
                string3 = stringArray[i] + "/" + string2;
            }
            object = new File(string3);
            if (!((File)object).isFile()) continue;
            switch (n) {
                case 1: {
                    try {
                        FileInputStream fileInputStream = new FileInputStream((File)object);
                        byte[] byArray = new byte[fileInputStream.available()];
                        int n2 = 0;
                        for (int j = 0; j < byArray.length && (n2 = fileInputStream.read(byArray, j, byArray.length - j)) != -1; j += n2) {
                        }
                        return byArray;
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
                case 2: {
                    return object;
                }
                case 4: {
                    return string3;
                }
                case 3: {
                    try {
                        ClassFile classFile = new ClassFile(string3);
                        return classFile;
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    public static String[] getClassNamesFromZip(String string, String string2) {
        Object[] objectArray;
        String string3 = string2.replace('\\', '/').replace('.', '/');
        if (string3.endsWith("*")) {
            string3 = string3.substring(0, string3.length() - 1);
        }
        if (!string3.endsWith("/")) {
            string3 = string3 + "/";
        }
        Vector<String> vector = new Vector<String>();
        try {
            objectArray = new ZipFile(string);
            Enumeration<? extends ZipEntry> enumeration = objectArray.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!zipEntry.getName().startsWith(string3) || !zipEntry.getName().endsWith(".class") || zipEntry.isDirectory()) continue;
                String string4 = zipEntry.getName().replace('/', '.').substring(0, zipEntry.getName().length() - 6);
                vector.addElement(string4);
            }
        }
        catch (Exception exception) {
            return null;
        }
        objectArray = new String[vector.size()];
        vector.copyInto(objectArray);
        return objectArray;
    }

    public static Object forName(String string, String string2, int n) {
        String string3 = CFUtils.canonicalize(string2);
        try {
            ZipFile zipFile = new ZipFile(string);
            ZipEntry zipEntry = zipFile.getEntry(string3);
            if (zipEntry != null) {
                InputStream inputStream = zipFile.getInputStream(zipEntry);
                if (n == 3) {
                    ClassFile classFile = new ClassFile(inputStream);
                    return classFile;
                }
                if (n == 1) {
                    byte[] byArray = new byte[(int)zipEntry.getSize()];
                    int n2 = 0;
                    for (int i = 0; i < byArray.length && (n2 = inputStream.read(byArray, i, byArray.length - i)) != -1; i += n2) {
                    }
                    return byArray;
                }
                if (n == 4) {
                    return string;
                }
                return null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static String[] getLocalMethodNames(ClassFile classFile) {
        MethodInfoList methodInfoList = classFile.getMethods();
        String[] stringArray = new String[methodInfoList.length()];
        for (int i = 0; i < methodInfoList.length(); ++i) {
            stringArray[i] = methodInfoList.getMethodName(i);
        }
        return stringArray;
    }

    public static String[] getUsedFieldNames(ClassFile classFile, String[] stringArray) {
        int n;
        int n2;
        ConstantPool constantPool = classFile.getCP();
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < constantPool.length(); ++n2) {
            if (constantPool.getType(n2) != 9) continue;
            vector.addElement(constantPool.getAsJava(n2));
        }
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = stringArray[n2].indexOf("*");
                String string = n == -1 ? stringArray[n2] : stringArray[n2].substring(0, n);
                Vector vector2 = (Vector)vector.clone();
                vector.setSize(0);
                for (int i = 0; i < vector2.size(); ++i) {
                    String string2 = (String)vector2.elementAt(i);
                    String string3 = string2.substring(string2.lastIndexOf(" ") + 1, string2.length());
                    if (string3.startsWith(string)) continue;
                    vector.addElement(string2);
                }
            }
        }
        String[] stringArray2 = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[n] = (String)vector.elementAt(n);
        }
        return stringArray2;
    }

    public static String[] getUsedMethodNames(ClassFile classFile, String[] stringArray) {
        int n;
        int n2;
        ConstantPool constantPool = classFile.getCP();
        Vector<String> vector = new Vector<String>();
        for (n2 = 0; n2 < constantPool.length(); ++n2) {
            if (constantPool.getType(n2) != 10) continue;
            vector.addElement(constantPool.getAsJava(n2));
        }
        if (stringArray != null) {
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                n = stringArray[n2].indexOf("*");
                String string = n == -1 ? stringArray[n2] : stringArray[n2].substring(0, n);
                Vector vector2 = (Vector)vector.clone();
                vector.setSize(0);
                for (int i = 0; i < vector2.size(); ++i) {
                    String string2 = (String)vector2.elementAt(i);
                    String string3 = string2.substring(string2.lastIndexOf(" ") + 1, string2.length());
                    if (string3.startsWith(string)) continue;
                    vector.addElement(string2);
                }
            }
        }
        String[] stringArray2 = new String[vector.size()];
        for (n = 0; n < vector.size(); ++n) {
            stringArray2[n] = (String)vector.elementAt(n);
        }
        return stringArray2;
    }

    public static int compress(ClassFile classFile, String string) {
        BitSet bitSet = classFile.uses();
        int[] nArray = new int[classFile.getCP().length()];
        int n = 0;
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (bitSet.get(i)) {
                nArray[i] = n++;
                continue;
            }
            ++n2;
            nArray[i] = -1;
        }
        classFile.sort(nArray);
        if (string != null) {
            try {
                classFile.write(string);
            }
            catch (Exception exception) {
                return -1;
            }
        }
        return n2;
    }
}

