/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.jan.jbc.cfgimpl;

import com.ibm.toad.jan.jbc.CFG;
import com.ibm.toad.jan.jbc.JBC;
import com.ibm.toad.jan.jbc.JBCVisitor;
import com.ibm.toad.jan.jbc.cfgimpl.myBasicBlock;
import com.ibm.toad.pc.goodies.IntVector;
import com.ibm.toad.pc.goodies.Worklist;
import com.ibm.toad.utils.D;

class CFGEdgeBuildingVisitor
extends JBCVisitor {
    private myBasicBlock[] bb;
    private myBasicBlock curBlock;
    private int curBlockIdx;
    private int curPos;
    private boolean withEHCF;
    private JBCVisitor.Iterator iter;
    private IntVector jsrTargs;
    private IntVector jsrs;
    private IntVector retBlocks;

    public static myBasicBlock findBlock(myBasicBlock[] myBasicBlockArray, int n) {
        int n2 = 0;
        while (n2 < myBasicBlockArray.length) {
            if (n >= myBasicBlockArray[n2].getFromPos() && n < myBasicBlockArray[n2].getToPos()) {
                return myBasicBlockArray[n2];
            }
            ++n2;
        }
        D.assert((boolean)false);
        return null;
    }

    private static void add_ehLinks(JBCVisitor.Iterator iterator, myBasicBlock[] myBasicBlockArray, myBasicBlock myBasicBlock2, int n) {
        int n2 = 0;
        while (n2 < iterator.numEH()) {
            int n3 = iterator.getEH_StartPos(n2);
            int n4 = iterator.getEH_EndPos(n2);
            int n5 = iterator.getEH_HandlerPos(n2);
            if (n >= n3 && n < n4) {
                myBasicBlock2.addEHSuccessor(CFGEdgeBuildingVisitor.findBlock(myBasicBlockArray, n5));
            }
            ++n2;
        }
        myBasicBlock2.addEHSuccessor(myBasicBlockArray[myBasicBlockArray.length - 1]);
    }

    CFGEdgeBuildingVisitor(myBasicBlock[] myBasicBlockArray, JBCVisitor.Iterator iterator, boolean bl) {
        this.withEHCF = bl;
        this.curBlockIdx = 0;
        this.bb = myBasicBlockArray;
        this.iter = iterator;
        this.jsrTargs = new IntVector(5, 5);
        this.jsrs = new IntVector(5, 5);
        this.retBlocks = new IntVector(5, 5);
    }

    public void postvisit(int n, int n2) {
        if (n == this.bb[this.curBlockIdx + 1].fromPos) {
            if (this.curBlock.type == -1) {
                switch (n2) {
                    case 172: 
                    case 173: 
                    case 174: 
                    case 175: 
                    case 176: 
                    case 177: {
                        this.curBlock.type = 3;
                        break;
                    }
                    case 191: {
                        this.curBlock.type = 0;
                        break;
                    }
                    default: {
                        this.curBlock.type = 4;
                        this.curBlock.addNormalSuccessor(this.bb[this.curBlockIdx + 1]);
                    }
                }
            }
            ++this.curBlockIdx;
        }
    }

    public void previsit(int n, int n2) {
        this.curBlock = this.bb[this.curBlockIdx];
        this.curPos = n;
        if (this.withEHCF) {
            JBC.InstructionDefinition instructionDefinition = JBC.getDef(n2);
            if (instructionDefinition.doesThrow) {
                CFGEdgeBuildingVisitor.add_ehLinks(this.iter, this.bb, this.curBlock, n);
            }
        }
    }

    public void visit_goto(boolean bl, int n) {
        this.curBlock.type = 0;
        this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, n));
    }

    public void visit_jsr(boolean bl, int n) {
        this.curBlock.type = 6;
        this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, n));
        this.jsrTargs.addElement(CFGEdgeBuildingVisitor.findBlock(this.bb, n).getID());
        this.jsrs.addElement(this.curBlockIdx);
    }

    public void visit_if(int n) {
        this.curBlock.type = 1;
        this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, n));
        D.assert((this.curBlockIdx + 1 < this.bb.length ? 1 : 0) != 0);
        this.curBlock.addNormalSuccessor(this.bb[this.curBlockIdx + 1]);
    }

    public void visit_lookupswitch(int n, int n2, int[] nArray, int[] nArray2) {
        this.curBlock.type = 2;
        this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, n));
        int n3 = 0;
        while (n3 < nArray2.length) {
            this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, nArray2[n3]));
            ++n3;
        }
    }

    public void visit_tableswitch(int n, int n2, int n3, int[] nArray) {
        this.curBlock.type = 2;
        this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, n));
        int n4 = 0;
        while (n4 < nArray.length) {
            this.curBlock.addNormalSuccessor(CFGEdgeBuildingVisitor.findBlock(this.bb, nArray[n4]));
            ++n4;
        }
    }

    public void visit_ret(boolean bl, int n) {
        this.curBlock.type = 7;
        this.retBlocks.addElement(this.curBlockIdx);
    }

    public void post() {
        IntVector[] intVectorArray = this.computeRetTargets();
        this.addRetEdges(intVectorArray);
    }

    private IntVector[] computeRetTargets() {
        int n;
        IntVector[] intVectorArray = new IntVector[this.bb.length];
        Worklist worklist = new Worklist(this.bb.length);
        intVectorArray[0] = new IntVector(0, 0);
        worklist.put(0);
        int n2 = 0;
        while (n2 < this.jsrTargs.size()) {
            n = this.jsrTargs.elementAt(n2);
            if (intVectorArray[n] == null) {
                intVectorArray[n] = new IntVector(5, 5);
            }
            intVectorArray[n].addElement(this.jsrs.elementAt(n2) + 1);
            worklist.put(n);
            ++n2;
        }
        block6: while (!worklist.isEmpty()) {
            n = worklist.get();
            myBasicBlock myBasicBlock2 = this.bb[n];
            switch (myBasicBlock2.getType()) {
                case 3: {
                    break;
                }
                case 6: {
                    if (intVectorArray[n + 1] != null) continue block6;
                    intVectorArray[n + 1] = intVectorArray[n];
                    worklist.put(n + 1);
                    break;
                }
                case 7: {
                    break;
                }
                default: {
                    int n3;
                    CFG.BasicBlock basicBlock;
                    CFG.Blocks blocks = myBasicBlock2.getNormalSucc();
                    while (blocks.hasMoreElements()) {
                        basicBlock = blocks.nextBlock();
                        n3 = basicBlock.getID();
                        if (intVectorArray[n3] != null) continue;
                        intVectorArray[n3] = intVectorArray[n];
                        worklist.put(n3);
                    }
                    blocks = myBasicBlock2.getEHSucc();
                    while (blocks.hasMoreElements()) {
                        basicBlock = blocks.nextBlock();
                        n3 = basicBlock.getID();
                        if (intVectorArray[n3] != null) continue;
                        intVectorArray[n3] = intVectorArray[n];
                        worklist.put(n3);
                    }
                    continue block6;
                }
            }
        }
        return intVectorArray;
    }

    private void addRetEdges(IntVector[] intVectorArray) {
        int n = 0;
        while (n < this.retBlocks.size()) {
            int n2 = this.retBlocks.elementAt(n);
            myBasicBlock myBasicBlock2 = this.bb[n2];
            IntVector intVector = intVectorArray[n2];
            if (intVector != null) {
                int n3 = 0;
                while (n3 < intVector.size()) {
                    myBasicBlock2.addNormalSuccessor(this.bb[intVector.elementAt(n3)]);
                    ++n3;
                }
            }
            ++n;
        }
    }
}

