/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.jan.jbc.cfgimpl;

import com.ibm.toad.jan.jbc.JBC;
import com.ibm.toad.jan.jbc.JBCVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;

class FindLeadersVisitor
extends JBCVisitor {
    private SortedSet leaders = new TreeSet();
    private boolean nextIsLeader = true;
    private boolean withEHCF;

    private FindLeadersVisitor(boolean bl) {
        this.withEHCF = bl;
    }

    private void addLeader(int n) {
        this.leaders.add(new Integer(n));
    }

    public void previsit(int n, int n2) {
        if (this.nextIsLeader) {
            this.addLeader(n);
            this.nextIsLeader = false;
        }
        if (this.withEHCF) {
            JBC.InstructionDefinition instructionDefinition = JBC.getDef(n2);
            if (instructionDefinition.doesThrow) {
                this.nextIsLeader = true;
            }
        }
    }

    public void visit_goto(boolean bl, int n) {
        this.nextIsLeader = true;
        this.addLeader(n);
    }

    public void visit_jsr(boolean bl, int n) {
        this.nextIsLeader = true;
        this.addLeader(n);
    }

    public void visit_if(int n) {
        this.nextIsLeader = true;
        this.addLeader(n);
    }

    public void visit_lookupswitch(int n, int n2, int[] nArray, int[] nArray2) {
        this.nextIsLeader = true;
        this.addLeader(n);
        int n3 = 0;
        while (n3 < nArray2.length) {
            this.addLeader(nArray2[n3]);
            ++n3;
        }
    }

    public void visit_tableswitch(int n, int n2, int n3, int[] nArray) {
        this.nextIsLeader = true;
        this.addLeader(n);
        int n4 = 0;
        while (n4 < nArray.length) {
            this.addLeader(nArray[n4]);
            ++n4;
        }
    }

    public void visit_ret(boolean bl, int n) {
        this.nextIsLeader = true;
    }

    public void visit_return() {
        this.nextIsLeader = true;
    }

    public void visit_areturn() {
        this.nextIsLeader = true;
    }

    public void visit_dreturn() {
        this.nextIsLeader = true;
    }

    public void visit_freturn() {
        this.nextIsLeader = true;
    }

    public void visit_ireturn() {
        this.nextIsLeader = true;
    }

    public void visit_lreturn() {
        this.nextIsLeader = true;
    }

    private static int[] toIntArray(Collection collection) {
        int n = collection.size();
        int[] nArray = new int[n];
        Iterator iterator = collection.iterator();
        int n2 = 0;
        while (iterator.hasNext()) {
            nArray[n2++] = (Integer)iterator.next();
        }
        return nArray;
    }

    public static int[] findLeaders(JBCVisitor.Iterator iterator, int n, int n2, boolean bl) {
        FindLeadersVisitor findLeadersVisitor = new FindLeadersVisitor(bl);
        iterator.traverse(findLeadersVisitor, n, n2);
        if (bl) {
            int n3 = 0;
            while (n3 < iterator.numEH()) {
                findLeadersVisitor.leaders.add(new Integer(iterator.getEH_HandlerPos(n3)));
                ++n3;
            }
        }
        return FindLeadersVisitor.toIntArray(findLeadersVisitor.leaders);
    }
}

