/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.pc.goodies;

import java.util.Enumeration;
import java.util.NoSuchElementException;

public class IntVector {
    private static final int DFLT_CAPACITY = 100;
    private static final int DFLT_INCREMENT = 100;
    protected int[] d_aiElements;
    protected int d_iNElements;
    protected final int d_iIncrement;

    public IntVector() {
        this(100, 100);
    }

    public IntVector(int n) {
        this(n, 100);
    }

    public IntVector(int n, int n2) {
        this.d_iIncrement = n2;
        this.d_iNElements = 0;
        this.d_aiElements = new int[n];
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = 0;
        while (n < this.d_iNElements - 1) {
            stringBuffer.append(this.d_aiElements[n]).append(", ");
            ++n;
        }
        if (this.d_iNElements > 0) {
            stringBuffer.append(this.d_aiElements[this.d_iNElements - 1]);
        }
        stringBuffer.append("]");
        return new String(stringBuffer);
    }

    public Object clone() {
        IntVector intVector = new IntVector(this.d_aiElements.length, this.d_iIncrement);
        intVector.d_iNElements = this.d_iNElements;
        System.arraycopy(this.d_aiElements, 0, intVector.d_aiElements, 0, this.d_iNElements);
        return intVector;
    }

    private boolean isInBounds(int n) {
        return n >= 0 && n < this.d_iNElements;
    }

    public final int elementAt(int n) throws IndexOutOfBoundsException {
        if (!this.isInBounds(n)) {
            throw new IndexOutOfBoundsException(Integer.toString(n) + "vs. " + this);
        }
        return this.d_aiElements[n];
    }

    public final void setElementAt(int n, int n2) throws IndexOutOfBoundsException {
        if (!this.isInBounds(n2)) {
            throw new IndexOutOfBoundsException(Integer.toString(n2));
        }
        this.d_aiElements[n2] = n;
    }

    public final int firstElement() throws NoSuchElementException {
        if (!this.isInBounds(0)) {
            throw new NoSuchElementException();
        }
        return this.d_aiElements[0];
    }

    public final int lastElement() throws NoSuchElementException {
        if (!this.isInBounds(this.d_iNElements - 1)) {
            throw new NoSuchElementException();
        }
        return this.d_aiElements[this.d_iNElements - 1];
    }

    public final void addElement(int n) {
        this.ensureCapacity(this.d_iNElements + 1);
        this.d_aiElements[this.d_iNElements] = n;
        ++this.d_iNElements;
    }

    public final void insertElementAt(int n, int n2) throws IndexOutOfBoundsException {
        if (!this.isInBounds(this.d_iNElements - 1)) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.d_iNElements + 1);
        System.arraycopy(this.d_aiElements, n2, this.d_aiElements, n2 + 1, this.d_iNElements - n2);
        this.d_aiElements[n2] = n;
        ++this.d_iNElements;
    }

    public final boolean removeElement(int n) {
        int n2 = this.indexOf(n);
        if (n2 == -1) {
            return false;
        }
        try {
            this.removeElementAt(n2);
            return true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return false;
        }
    }

    public final void removeElementAt(int n) throws IndexOutOfBoundsException {
        if (!this.isInBounds(this.d_iNElements - 1)) {
            throw new IndexOutOfBoundsException();
        }
        System.arraycopy(this.d_aiElements, n + 1, this.d_aiElements, n, this.d_iNElements - n - 1);
        --this.d_iNElements;
    }

    public final void removeAllElements() {
        this.d_iNElements = 0;
    }

    public final boolean isEmpty() {
        return this.d_iNElements == 0;
    }

    public final int size() {
        return this.d_iNElements;
    }

    public final void setSize(int n) {
        if (n <= this.d_iNElements) {
            this.d_iNElements = n;
            return;
        }
        this.ensureCapacity(n);
        int n2 = this.d_iNElements;
        while (n2 < n) {
            this.d_aiElements[n2] = 0;
            ++n2;
        }
        this.d_iNElements = n;
    }

    public final int capacity() {
        return this.d_aiElements.length;
    }

    public final void ensureCapacity(int n) {
        if (this.d_aiElements.length >= n) {
            return;
        }
        int n2 = this.d_iIncrement > 0 ? this.d_aiElements.length + this.d_iIncrement : this.d_aiElements.length + this.d_aiElements.length;
        if (n2 < n) {
            n2 = n;
        }
        int[] nArray = new int[n2];
        System.arraycopy(this.d_aiElements, 0, nArray, 0, this.d_iNElements);
        this.d_aiElements = nArray;
    }

    public final void trimToSize() {
        if (this.d_aiElements.length == this.d_iNElements) {
            return;
        }
        int[] nArray = new int[this.d_iNElements];
        System.arraycopy(this.d_aiElements, 0, nArray, 0, this.d_iNElements);
        this.d_aiElements = nArray;
    }

    public final void copyInto(int[] nArray) throws IndexOutOfBoundsException {
        System.arraycopy(this.d_aiElements, 0, nArray, 0, this.d_iNElements);
    }

    public final Enum elements() {
        return new MyEnum(this.d_aiElements, this.d_iNElements);
    }

    public final boolean contains(int n) {
        return this.indexOf(n) != -1;
    }

    public final int indexOf(int n) {
        if (this.isEmpty()) {
            return -1;
        }
        return this.indexOf(n, 0);
    }

    public final int indexOf(int n, int n2) throws IndexOutOfBoundsException {
        if (!this.isInBounds(this.d_iNElements - 1)) {
            throw new IndexOutOfBoundsException();
        }
        int n3 = n2;
        while (n3 < this.d_iNElements) {
            if (this.d_aiElements[n3] == n) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    private static final class MyEnum
    implements Enum {
        private int[] d_aiElements;
        private int d_iCounter;

        MyEnum(int[] nArray, int n) {
            this.d_aiElements = new int[n];
            System.arraycopy(nArray, 0, this.d_aiElements, 0, n);
            this.d_iCounter = -1;
        }

        public boolean hasMoreElements() {
            return this.d_iCounter + 1 < this.d_aiElements.length;
        }

        public Object nextElement() {
            ++this.d_iCounter;
            return new Integer(this.d_aiElements[this.d_iCounter]);
        }

        public int nextInt() {
            ++this.d_iCounter;
            return this.d_aiElements[this.d_iCounter];
        }
    }

    public static interface Enum
    extends Enumeration {
        public int nextInt();
    }
}

