/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.pc.vmsim.impl;

import com.ibm.toad.jan.jbc.JBCVisitor;
import com.ibm.toad.pc.vmsim.JVMSimulator;
import com.ibm.toad.pc.vmsim.impl.ParamsLocator;
import com.ibm.toad.utils.D;

public class JBCTour
extends JBCVisitor {
    private JVMSimulator.FrameBuilder[] d_aFrameBuilder;
    private int d_iNFrameBuilders;
    private boolean d_bCleanup = false;

    public JBCTour(JVMSimulator.FrameBuilder[] frameBuilderArray, int n) {
        this.d_aFrameBuilder = frameBuilderArray;
        this.d_iNFrameBuilders = n;
    }

    private static boolean isTwinType(String string) {
        if (string.equals("J") || string.equals("long")) {
            return true;
        }
        return string.equals("D") || string.equals("double");
    }

    private static String makeDotted(String string) {
        if (string.startsWith("[")) {
            return JBCTour.makeFromJVM(string);
        }
        return string.replace('/', '.');
    }

    private static void makeDotted(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].replace('/', '.');
            ++n;
        }
    }

    private static String makeFromJVM(String string) throws IllegalArgumentException {
        int n = string.length();
        if (n == 0) {
            throw new IllegalArgumentException("Empty string");
        }
        String string2 = "";
        int n2 = 0;
        if (string.startsWith("[")) {
            n2 = string.lastIndexOf(91) + 1;
            StringBuffer stringBuffer = new StringBuffer();
            int n3 = 0;
            while (n3 < n2) {
                stringBuffer.append("[]");
                ++n3;
            }
            string2 = new String(stringBuffer);
            string = string.substring(n2);
            n = string.length();
        }
        char c = string.charAt(0);
        switch (c) {
            case 'Z': {
                return "boolean" + string2;
            }
            case 'B': {
                return "byte" + string2;
            }
            case 'S': {
                return "short" + string2;
            }
            case 'C': {
                return "char" + string2;
            }
            case 'I': {
                return "int" + string2;
            }
            case 'J': {
                return "long" + string2;
            }
            case 'F': {
                return "float" + string2;
            }
            case 'D': {
                return "double" + string2;
            }
            case 'V': {
                return "void" + string2;
            }
            case 'L': {
                return JBCTour.makeDotted(string.substring(1, n - 1)) + string2;
            }
        }
        throw new IllegalArgumentException("Unrecognized string " + string);
    }

    private static void makeFromJVM(String[] stringArray) throws IllegalArgumentException {
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = JBCTour.makeFromJVM(stringArray[n]);
            ++n;
        }
    }

    public void previsit(int n, int n2) {
        int n3 = 0;
        while (n3 < this.d_iNFrameBuilders) {
            if (this.d_aFrameBuilder[n3].d_registration.isRegisteredFor(254)) {
                this.d_aFrameBuilder[n3].previsit(n, n2);
            }
            ++n3;
        }
    }

    public void postvisit(int n, int n2) {
        int n3 = 0;
        while (n3 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n3];
            if (frameBuilder.d_registration.isRegisteredFor(255)) {
                frameBuilder.postvisit(n, n2);
            }
            if (this.d_bCleanup) {
                frameBuilder.d_frame.stack.popAll();
                frameBuilder.d_frame.locals.discardAll();
            }
            ++n3;
        }
        this.d_bCleanup = false;
    }

    public void visit_aaload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(50)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_aaload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_aaload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_aaload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_aastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(83)) {
                JVMSimulator.Variable variable = ParamsLocator.get_aastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_aastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_aastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_aastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_aconst_null() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (!frameBuilder.d_registration.isRegisteredFor(1)) {
                frameBuilder.d_frame.stack.push(frameBuilder.d_factory.makeVariable());
            } else {
                JVMSimulator.Variable variable = frameBuilder.visit_aconst_null();
                frameBuilder.d_frame.stack.push(variable);
            }
            ++n;
        }
    }

    public void visit_aload(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(25)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_aload_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_aload(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_aload_0() {
        this.visit_aload(false, 0);
    }

    public void visit_aload_1() {
        this.visit_aload(false, 1);
    }

    public void visit_aload_2() {
        this.visit_aload(false, 2);
    }

    public void visit_aload_3() {
        this.visit_aload(false, 3);
    }

    public void visit_anewarray(String string) {
        string = JBCTour.makeDotted(string);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(189)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_anewarray_count(frameBuilder.d_frame);
                variable = frameBuilder.visit_anewarray(string, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_areturn() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(176)) {
                JVMSimulator.Variable variable = ParamsLocator.get_areturn_objectref(frameBuilder.d_frame);
                frameBuilder.visit_areturn(variable);
            }
            frameBuilder.d_frame.stack.popAllBut1();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_arraylength() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(190)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_arraylength_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_arraylength(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_astore(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(58)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_astore_objectref(frameBuilder.d_frame);
                variable = frameBuilder.visit_astore(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.locals.setElementAt(n, variable);
            ++n2;
        }
    }

    public void visit_astore_0() {
        this.visit_astore(false, 0);
    }

    public void visit_astore_1() {
        this.visit_astore(false, 1);
    }

    public void visit_astore_2() {
        this.visit_astore(false, 2);
    }

    public void visit_astore_3() {
        this.visit_astore(false, 3);
    }

    public void visit_athrow() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(191)) {
                JVMSimulator.Variable variable = ParamsLocator.get_athrow_objectref(frameBuilder.d_frame);
                frameBuilder.visit_athrow(variable);
            }
            frameBuilder.d_frame.stack.popAllBut1();
            ++n;
        }
    }

    public void visit_baload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(51)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_baload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_baload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_baload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_bastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(84)) {
                JVMSimulator.Variable variable = ParamsLocator.get_bastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_bastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_bastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_bastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_bipush(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(16) ? frameBuilder.visit_bipush(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_caload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(52)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_caload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_caload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_caload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_castore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(85)) {
                JVMSimulator.Variable variable = ParamsLocator.get_castore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_castore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_castore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_castore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_checkcast(String string) {
        string = JBCTour.makeDotted(string);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(192)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_checkcast_objectref(frameBuilder.d_frame);
                variable = frameBuilder.visit_checkcast(string, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_d2f() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(144)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_d2f_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_d2f(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_d2i() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(142)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_d2i_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_d2i(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_d2l() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(143)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_d2l_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_d2l(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dadd() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(99)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dadd_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dadd_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_dadd(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_daload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(49)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_daload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_daload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_daload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(82)) {
                JVMSimulator.Variable variable = ParamsLocator.get_dastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_dastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_dastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_dcmpg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(152)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dcmpg_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dcmpg_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_dcmpg(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_dcmpl() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(151)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dcmpl_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dcmpl_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_dcmpl(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_dconst(double d) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(14) ? frameBuilder.visit_dconst(d) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dconst_0() {
        this.visit_dconst(0.0);
    }

    public void visit_dconst_1() {
        this.visit_dconst(1.0);
    }

    public void visit_ddiv() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(111)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ddiv_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ddiv_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ddiv(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dload(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(24)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dload_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_dload(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.push2(variable);
            ++n2;
        }
    }

    public void visit_dload_0() {
        this.visit_dload(false, 0);
    }

    public void visit_dload_1() {
        this.visit_dload(false, 1);
    }

    public void visit_dload_2() {
        this.visit_dload(false, 2);
    }

    public void visit_dload_3() {
        this.visit_dload(false, 3);
    }

    public void visit_dmul() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(107)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dmul_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dmul_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_dmul(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dneg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(119)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dneg_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_dneg(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_drem() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(115)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_drem_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_drem_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_drem(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dreturn() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(175)) {
                JVMSimulator.Variable variable = ParamsLocator.get_dreturn_value(frameBuilder.d_frame);
                frameBuilder.visit_dreturn(variable);
            }
            frameBuilder.d_frame.stack.popAllBut2();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_dstore(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(57)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dstore_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_dstore(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.locals.setElementAt2(n, variable);
            ++n2;
        }
    }

    public void visit_dstore_0() {
        this.visit_dstore(false, 0);
    }

    public void visit_dstore_1() {
        this.visit_dstore(false, 1);
    }

    public void visit_dstore_2() {
        this.visit_dstore(false, 2);
    }

    public void visit_dstore_3() {
        this.visit_dstore(false, 3);
    }

    public void visit_dsub() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(103)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_dsub_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_dsub_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_dsub(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_dup() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup();
            ++n;
        }
    }

    public void visit_dup_x1() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup_x1();
            ++n;
        }
    }

    public void visit_dup_x2() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup_x2();
            ++n;
        }
    }

    public void visit_dup2() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup2();
            ++n;
        }
    }

    public void visit_dup2_x1() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup2_x1();
            ++n;
        }
    }

    public void visit_dup2_x2() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.dup2_x2();
            ++n;
        }
    }

    public void visit_f2d() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(141)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_f2d_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_f2d(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_f2i() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(139)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_f2i_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_f2i(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_f2l() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(140)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_f2l_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_f2l(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_fadd() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(98)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fadd_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fadd_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fadd(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_faload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(48)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_faload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_faload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_faload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(81)) {
                JVMSimulator.Variable variable = ParamsLocator.get_fastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_fastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_fastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_fcmpg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(150)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fcmpg_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fcmpg_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fcmpg(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fcmpl() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(149)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fcmpl_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fcmpl_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fcmpl(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fconst(float f) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(11) ? frameBuilder.visit_fconst(f) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fconst_0() {
        this.visit_fconst(0.0f);
    }

    public void visit_fconst_1() {
        this.visit_fconst(1.0f);
    }

    public void visit_fconst_2() {
        this.visit_fconst(2.0f);
    }

    public void visit_fdiv() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(110)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fdiv_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fdiv_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fdiv(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fload(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(23)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fload_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_fload(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_fload_0() {
        this.visit_fload(false, 0);
    }

    public void visit_fload_1() {
        this.visit_fload(false, 1);
    }

    public void visit_fload_2() {
        this.visit_fload(false, 2);
    }

    public void visit_fload_3() {
        this.visit_fload(false, 3);
    }

    public void visit_fmul() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(106)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fmul_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fmul_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fmul(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_fneg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(118)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fneg_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_fneg(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_frem() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(114)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_frem_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_frem_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_frem(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_freturn() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(174)) {
                JVMSimulator.Variable variable = ParamsLocator.get_freturn_value(frameBuilder.d_frame);
                frameBuilder.visit_freturn(variable);
            }
            frameBuilder.d_frame.stack.popAllBut1();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_fstore(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(56)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fstore_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_fstore(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.locals.setElementAt(n, variable);
            ++n2;
        }
    }

    public void visit_fstore_0() {
        this.visit_fstore(false, 0);
    }

    public void visit_fstore_1() {
        this.visit_fstore(false, 1);
    }

    public void visit_fstore_2() {
        this.visit_fstore(false, 2);
    }

    public void visit_fstore_3() {
        this.visit_fstore(false, 3);
    }

    public void visit_fsub() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(102)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_fsub_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_fsub_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_fsub(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_getfield(String string, String string2, String string3) {
        string = JBCTour.makeDotted(string);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(180)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_getfield_objectref(frameBuilder.d_frame);
                variable = frameBuilder.visit_getfield(string, string2, string3, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            if (bl) {
                frameBuilder.d_frame.stack.push2(variable);
            } else {
                frameBuilder.d_frame.stack.push(variable);
            }
            ++n;
        }
    }

    public void visit_getstatic(String string, String string2, String string3) {
        string = JBCTour.makeDotted(string);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(178) ? frameBuilder.visit_getstatic(string, string2, string3) : frameBuilder.d_factory.makeVariable();
            if (bl) {
                frameBuilder.d_frame.stack.push2(variable);
            } else {
                frameBuilder.d_frame.stack.push(variable);
            }
            ++n;
        }
    }

    public void visit_goto(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(167)) {
                frameBuilder.visit_goto(n);
            }
            ++n2;
        }
    }

    public void visit_i2b() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(145)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2b_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2b(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_i2c() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(146)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2c_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2c(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_i2d() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(135)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2d_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2d(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_i2f() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(134)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2f_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2f(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_i2l() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(133)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2l_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2l(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_i2s() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(147)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_i2s_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_i2s(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_iadd() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(96)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iadd_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_iadd_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_iadd(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_iaload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(46)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iaload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_iaload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_iaload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_iand() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(126)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iand_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_iand_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_iand(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_iastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(79)) {
                JVMSimulator.Variable variable = ParamsLocator.get_iastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_iastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_iastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_iastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_iconst(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(3) ? frameBuilder.visit_iconst(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_iconst_0() {
        this.visit_iconst(0);
    }

    public void visit_iconst_1() {
        this.visit_iconst(1);
    }

    public void visit_iconst_2() {
        this.visit_iconst(2);
    }

    public void visit_iconst_3() {
        this.visit_iconst(3);
    }

    public void visit_iconst_4() {
        this.visit_iconst(4);
    }

    public void visit_iconst_5() {
        this.visit_iconst(5);
    }

    public void visit_iconst_m1() {
        this.visit_iconst(-1);
    }

    public void visit_idiv() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(108)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_idiv_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_idiv_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_idiv(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_if_acmpeq(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(165)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_acmpeq_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_acmpeq_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_acmpeq(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_acmpne(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(166)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_acmpne_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_acmpne_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_acmpne(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmpeq(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(159)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmpeq_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmpeq_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmpeq(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmpge(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(162)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmpge_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmpge_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmpge(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmpgt(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(163)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmpgt_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmpgt_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmpgt(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmple(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(164)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmple_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmple_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmple(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmplt(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(161)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmplt_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmplt_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmplt(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_if_icmpne(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(160)) {
                JVMSimulator.Variable variable = ParamsLocator.get_if_icmpne_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_if_icmpne_value1(frameBuilder.d_frame);
                frameBuilder.visit_if_icmpne(n, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifeq(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(153)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifeq_value(frameBuilder.d_frame);
                frameBuilder.visit_ifeq(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifge(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(156)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifge_value(frameBuilder.d_frame);
                frameBuilder.visit_ifge(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifgt(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(157)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifgt_value(frameBuilder.d_frame);
                frameBuilder.visit_ifgt(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifle(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(158)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifle_value(frameBuilder.d_frame);
                frameBuilder.visit_ifle(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_iflt(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(155)) {
                JVMSimulator.Variable variable = ParamsLocator.get_iflt_value(frameBuilder.d_frame);
                frameBuilder.visit_iflt(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifne(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(154)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifne_value(frameBuilder.d_frame);
                frameBuilder.visit_ifne(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifnonnull(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(199)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifnonnull_value(frameBuilder.d_frame);
                frameBuilder.visit_ifnonnull(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_ifnull(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(198)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ifnull_value(frameBuilder.d_frame);
                frameBuilder.visit_ifnull(n, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n2;
        }
    }

    public void visit_iinc(boolean bl, int n, int n2) {
        int n3 = 0;
        while (n3 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n3];
            if (frameBuilder.d_registration.isRegisteredFor(132)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iinc_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_iinc(n, n2, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.locals.setElementAt(n, variable);
            ++n3;
        }
    }

    public void visit_iload(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(21)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iload_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_iload(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_iload_0() {
        this.visit_iload(false, 0);
    }

    public void visit_iload_1() {
        this.visit_iload(false, 1);
    }

    public void visit_iload_2() {
        this.visit_iload(false, 2);
    }

    public void visit_iload_3() {
        this.visit_iload(false, 3);
    }

    public void visit_imul() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(104)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_imul_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_imul_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_imul(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ineg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(116)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ineg_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_ineg(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_instanceof(String string) {
        string = JBCTour.makeDotted(string);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(193)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_instanceof_objectref(frameBuilder.d_frame);
                variable = frameBuilder.visit_instanceof(string, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_invokeinterface(String string, String string2, String[] stringArray, String string3) {
        string = JBCTour.makeDotted(string);
        JBCTour.makeFromJVM(stringArray);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = string3.equals("void");
        boolean bl2 = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            int n2;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(185)) {
                n2 = stringArray.length;
                JVMSimulator.Variable[] variableArray = ParamsLocator.get_invokeinterface_params(frameBuilder.d_frame, n2);
                JVMSimulator.Variable variable2 = ParamsLocator.get_invokeinterface_objectref(frameBuilder.d_frame, n2);
                variable = frameBuilder.visit_invokeinterface(string, string2, stringArray, string3, variableArray, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                frameBuilder.d_frame.stack.pop();
                ++n2;
            }
            frameBuilder.d_frame.stack.pop();
            if (!bl) {
                if (bl2) {
                    frameBuilder.d_frame.stack.push2(variable);
                } else {
                    frameBuilder.d_frame.stack.push(variable);
                }
            }
            ++n;
        }
    }

    public void visit_invokespecial(String string, String string2, String[] stringArray, String string3) {
        string = JBCTour.makeDotted(string);
        JBCTour.makeFromJVM(stringArray);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = string3.equals("void");
        boolean bl2 = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            int n2;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(183)) {
                n2 = stringArray.length;
                JVMSimulator.Variable[] variableArray = ParamsLocator.get_invokespecial_params(frameBuilder.d_frame, n2);
                JVMSimulator.Variable variable2 = ParamsLocator.get_invokespecial_objectref(frameBuilder.d_frame, n2);
                variable = frameBuilder.visit_invokespecial(string, string2, stringArray, string3, variableArray, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                frameBuilder.d_frame.stack.pop();
                ++n2;
            }
            frameBuilder.d_frame.stack.pop();
            if (!bl) {
                if (bl2) {
                    frameBuilder.d_frame.stack.push2(variable);
                } else {
                    frameBuilder.d_frame.stack.push(variable);
                }
            }
            ++n;
        }
    }

    public void visit_invokestatic(String string, String string2, String[] stringArray, String string3) {
        string = JBCTour.makeDotted(string);
        JBCTour.makeFromJVM(stringArray);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = string3.equals("void");
        boolean bl2 = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            int n2;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(184)) {
                n2 = stringArray.length;
                JVMSimulator.Variable[] variableArray = ParamsLocator.get_invokestatic_params(frameBuilder.d_frame, n2);
                variable = frameBuilder.visit_invokestatic(string, string2, stringArray, string3, variableArray);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                frameBuilder.d_frame.stack.pop();
                ++n2;
            }
            if (!bl) {
                if (bl2) {
                    frameBuilder.d_frame.stack.push2(variable);
                } else {
                    frameBuilder.d_frame.stack.push(variable);
                }
            }
            ++n;
        }
    }

    public void visit_invokevirtual(String string, String string2, String[] stringArray, String string3) {
        string = JBCTour.makeDotted(string);
        JBCTour.makeFromJVM(stringArray);
        string3 = JBCTour.makeFromJVM(string3);
        boolean bl = string3.equals("void");
        boolean bl2 = JBCTour.isTwinType(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            int n2;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(182)) {
                n2 = stringArray.length;
                JVMSimulator.Variable[] variableArray = ParamsLocator.get_invokevirtual_params(frameBuilder.d_frame, n2);
                JVMSimulator.Variable variable2 = ParamsLocator.get_invokevirtual_objectref(frameBuilder.d_frame, n2);
                variable = frameBuilder.visit_invokevirtual(string, string2, stringArray, string3, variableArray, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            n2 = 0;
            while (n2 < stringArray.length) {
                frameBuilder.d_frame.stack.pop();
                ++n2;
            }
            frameBuilder.d_frame.stack.pop();
            if (!bl) {
                if (bl2) {
                    frameBuilder.d_frame.stack.push2(variable);
                } else {
                    frameBuilder.d_frame.stack.push(variable);
                }
            }
            ++n;
        }
    }

    public void visit_ior() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(128)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ior_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ior_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ior(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_irem() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(112)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_irem_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_irem_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_irem(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ireturn() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(172)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ireturn_value(frameBuilder.d_frame);
                frameBuilder.visit_ireturn(variable);
            }
            frameBuilder.d_frame.stack.popAllBut1();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_ishl() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(120)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ishl_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ishl_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ishl(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ishr() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(122)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ishr_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ishr_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ishr(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_istore(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(54)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_istore_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_istore(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.locals.setElementAt(n, variable);
            ++n2;
        }
    }

    public void visit_istore_0() {
        this.visit_istore(false, 0);
    }

    public void visit_istore_1() {
        this.visit_istore(false, 1);
    }

    public void visit_istore_2() {
        this.visit_istore(false, 2);
    }

    public void visit_istore_3() {
        this.visit_istore(false, 3);
    }

    public void visit_isub() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(100)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_isub_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_isub_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_isub(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_iushr() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(124)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_iushr_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_iushr_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_iushr(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ixor() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(130)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ixor_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ixor_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ixor(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_jsr(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(168) ? frameBuilder.visit_jsr(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_l2d() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(138)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_l2d_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_l2d(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_l2f() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(137)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_l2f_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_l2f(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_l2i() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(136)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_l2i_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_l2i(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ladd() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(97)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ladd_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ladd_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ladd(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_laload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(47)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_laload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_laload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_laload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_land() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(127)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_land_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_land_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_land(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(80)) {
                JVMSimulator.Variable variable = ParamsLocator.get_lastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_lastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_aastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_lcmp() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(148)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lcmp_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lcmp_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lcmp(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_lconst(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(9) ? frameBuilder.visit_lconst(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push2(variable);
            ++n2;
        }
    }

    public void visit_lconst_0() {
        this.visit_lconst(0);
    }

    public void visit_lconst_1() {
        this.visit_lconst(1);
    }

    public void visit_ldc(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(18) ? frameBuilder.visit_ldc(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_ldc(boolean bl, String string) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(18) ? frameBuilder.visit_ldc(string) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ldc(boolean bl, float f) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(18) ? frameBuilder.visit_ldc(f) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_ldc2_w(long l) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(18) ? frameBuilder.visit_ldc2_w(l) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_ldc2_w(double d) {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(18) ? frameBuilder.visit_ldc2_w(d) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_ldiv() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(109)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_ldiv_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_ldiv_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_ldiv(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lload(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(22)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lload_var(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_lload(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.push2(variable);
            ++n2;
        }
    }

    public void visit_lload_0() {
        this.visit_lload(false, 0);
    }

    public void visit_lload_1() {
        this.visit_lload(false, 1);
    }

    public void visit_lload_2() {
        this.visit_lload(false, 2);
    }

    public void visit_lload_3() {
        this.visit_lload(false, 3);
    }

    public void visit_lmul() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(105)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lmul_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lmul_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lmul(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lneg() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(117)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lneg_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_lneg(variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lor() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(129)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lor_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lor_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lor(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lrem() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(113)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lrem_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lrem_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lrem(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lreturn() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(173)) {
                JVMSimulator.Variable variable = ParamsLocator.get_lreturn_value(frameBuilder.d_frame);
                frameBuilder.visit_lreturn(variable);
            }
            frameBuilder.d_frame.stack.popAllBut2();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_lshl() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(121)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lshl_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lshl_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lshl(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lshr() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(123)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lshr_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lshr_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lshr(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lstore(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(55)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lstore_value(frameBuilder.d_frame);
                variable = frameBuilder.visit_lstore(n, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.locals.setElementAt2(n, variable);
            ++n2;
        }
    }

    public void visit_lstore_0() {
        this.visit_lstore(false, 0);
    }

    public void visit_lstore_1() {
        this.visit_lstore(false, 1);
    }

    public void visit_lstore_2() {
        this.visit_lstore(false, 2);
    }

    public void visit_lstore_3() {
        this.visit_lstore(false, 3);
    }

    public void visit_lsub() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(101)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lsub_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lsub_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lsub(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lushr() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(125)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lushr_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lushr_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lushr(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lxor() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(131)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_lxor_value2(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_lxor_value1(frameBuilder.d_frame);
                variable = frameBuilder.visit_lxor(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.pop2();
            frameBuilder.d_frame.stack.push2(variable);
            ++n;
        }
    }

    public void visit_lookupswitch(int n, int n2, int[] nArray, int[] nArray2) {
        int n3 = 0;
        while (n3 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n3];
            if (frameBuilder.d_registration.isRegisteredFor(171)) {
                JVMSimulator.Variable variable = ParamsLocator.get_lookupswitch_key(frameBuilder.d_frame);
                frameBuilder.visit_lookupswitch(n, n2, nArray, nArray2, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n3;
        }
    }

    public void visit_monitorenter() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(194)) {
                JVMSimulator.Variable variable = ParamsLocator.get_monitorenter_objectref(frameBuilder.d_frame);
                frameBuilder.visit_monitorenter(variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_monitorexit() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(195)) {
                JVMSimulator.Variable variable = ParamsLocator.get_monitorexit_objectref(frameBuilder.d_frame);
                frameBuilder.visit_monitorexit(variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_multianewarray(String string, int n) {
        string = JBCTour.makeDotted(string);
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(197)) {
                JVMSimulator.Variable[] variableArray = ParamsLocator.get_multianewarray_dims(frameBuilder.d_frame, n);
                variable = frameBuilder.visit_multianewarray(string, n, variableArray);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            int n3 = 0;
            while (n3 < n) {
                frameBuilder.d_frame.stack.pop();
                ++n3;
            }
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_new(String string) {
        string = JBCTour.makeDotted(string);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(187) ? frameBuilder.visit_new(string) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_newarray(char c) {
        String string = null;
        switch (c) {
            case 'Z': {
                string = "boolean";
                break;
            }
            case 'C': {
                string = "char";
                break;
            }
            case 'F': {
                string = "float";
                break;
            }
            case 'D': {
                string = "double";
                break;
            }
            case 'B': {
                string = "byte";
                break;
            }
            case 'S': {
                string = "short";
                break;
            }
            case 'I': {
                string = "int";
                break;
            }
            case 'J': {
                string = "long";
                break;
            }
            default: {
                D.assert((boolean)false, (String)("Illegal argument: " + c));
            }
        }
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(188)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_newarray_count(frameBuilder.d_frame);
                variable = frameBuilder.visit_newarray(string, variable2);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_nop() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(0)) {
                frameBuilder.visit_nop();
            }
            ++n;
        }
    }

    public void visit_pop() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_pop2() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.pop2();
            ++n;
        }
    }

    public void visit_putfield(String string, String string2, String string3) {
        string = JBCTour.makeDotted(string);
        string3 = JBCTour.makeFromJVM(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(181)) {
                JVMSimulator.Variable variable = ParamsLocator.get_putfield_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_putfield_objectref(frameBuilder.d_frame);
                frameBuilder.visit_putfield(string, string2, string3, variable, variable2);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_putstatic(String string, String string2, String string3) {
        string = JBCTour.makeDotted(string);
        string3 = JBCTour.makeFromJVM(string3);
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(179)) {
                JVMSimulator.Variable variable = ParamsLocator.get_putstatic_value(frameBuilder.d_frame);
                frameBuilder.visit_putstatic(string, string2, string3, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_ret(boolean bl, int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            if (frameBuilder.d_registration.isRegisteredFor(169)) {
                JVMSimulator.Variable variable = ParamsLocator.get_ret_var(frameBuilder.d_frame, n);
                frameBuilder.visit_ret(n, variable);
            }
            ++n2;
        }
    }

    public void visit_return() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(177)) {
                frameBuilder.visit_return();
            }
            frameBuilder.d_frame.stack.popAll();
            this.d_bCleanup = true;
            ++n;
        }
    }

    public void visit_saload() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.Variable variable;
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(53)) {
                JVMSimulator.Variable variable2 = ParamsLocator.get_saload_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_saload_arrayref(frameBuilder.d_frame);
                variable = frameBuilder.visit_saload(variable2, variable3);
            } else {
                variable = frameBuilder.d_factory.makeVariable();
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.push(variable);
            ++n;
        }
    }

    public void visit_sastore() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n];
            if (frameBuilder.d_registration.isRegisteredFor(86)) {
                JVMSimulator.Variable variable = ParamsLocator.get_sastore_value(frameBuilder.d_frame);
                JVMSimulator.Variable variable2 = ParamsLocator.get_sastore_index(frameBuilder.d_frame);
                JVMSimulator.Variable variable3 = ParamsLocator.get_sastore_arrayref(frameBuilder.d_frame);
                frameBuilder.visit_sastore(variable, variable2, variable3);
            }
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            frameBuilder.d_frame.stack.pop();
            ++n;
        }
    }

    public void visit_sipush(int n) {
        int n2 = 0;
        while (n2 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n2];
            JVMSimulator.Variable variable = frameBuilder.d_registration.isRegisteredFor(17) ? frameBuilder.visit_sipush(n) : frameBuilder.d_factory.makeVariable();
            frameBuilder.d_frame.stack.push(variable);
            ++n2;
        }
    }

    public void visit_swap() {
        int n = 0;
        while (n < this.d_iNFrameBuilders) {
            this.d_aFrameBuilder[n].d_frame.stack.swap();
            ++n;
        }
    }

    public void visit_tableswitch(int n, int n2, int n3, int[] nArray) {
        int n4 = 0;
        while (n4 < this.d_iNFrameBuilders) {
            JVMSimulator.FrameBuilder frameBuilder = this.d_aFrameBuilder[n4];
            if (frameBuilder.d_registration.isRegisteredFor(170)) {
                JVMSimulator.Variable variable = ParamsLocator.get_tableswitch_index(frameBuilder.d_frame);
                frameBuilder.visit_tableswitch(n, n2, n3, nArray, variable);
            }
            frameBuilder.d_frame.stack.pop();
            ++n4;
        }
    }

    public void visit_wide() {
    }
}

