/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.D;
import com.ibm.toad.utils.Log;
import com.ibm.toad.utils.Strings;
import com.ibm.toad.utils.Various;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public final class ClassPath {
    private static final String cfileSuffix = ".class";

    private ClassPath() {
    }

    public static Element mkDefaultClassPathElement() {
        String string = System.getProperty("java.sys.class.path") + File.pathSeparator + System.getProperty("java.class.path");
        return ClassPath.mkElement(ClassPath.splitClassPath(string));
    }

    public static Strings.Enumeration splitClassPath(String string) {
        return Strings.makeEnumeration(Various.splitString(string, File.pathSeparatorChar));
    }

    public static Element mkElement(String string) {
        D.pre(string != null);
        return ClassPath.mkElement(new File(string));
    }

    public static Element mkElement(File file) {
        D.pre(file != null);
        if (file.isDirectory()) {
            return new DirElement(file);
        }
        if (file.isFile()) {
            return new JarElement(file);
        }
        if (file.getPath().toLowerCase().endsWith(".jar")) {
            return new JarElement(file);
        }
        if (file.getPath().endsWith(File.separator)) {
            return new DirElement(file);
        }
        Log.debugln("ClassPath.mkElement guessing type of element (directory) since it doesnt exist: " + file.getPath());
        return new DirElement(file);
    }

    public static Element mkElement(Strings.Enumeration enumeration) {
        D.pre(enumeration != null);
        if (!enumeration.hasMoreElements()) {
            return new NullElement();
        }
        enumeration = Strings.makeEnumeration(Strings.List.reverse(Strings.makeList(enumeration)));
        CompoundElement compoundElement = null;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextString();
            if (string == null) continue;
            compoundElement = new CompoundElement(ClassPath.mkElement(string), compoundElement);
        }
        return compoundElement;
    }

    public static Element mkElement(Element[] elementArray) {
        D.pre(elementArray != null);
        if (elementArray.length == 0) {
            return new NullElement();
        }
        CompoundElement compoundElement = null;
        for (int i = elementArray.length - 1; i >= 0; --i) {
            D.pre(elementArray[i] != null);
            compoundElement = new CompoundElement(elementArray[i], compoundElement);
        }
        return compoundElement;
    }

    public static Element mkNullElement() {
        return new NullElement();
    }

    public static Element mkPkgInclustionElement(Element element, Strings.Enumeration enumeration) {
        D.pre(element != null);
        D.pre(enumeration != null);
        return new PkgInclusionFilteringElement(element, enumeration);
    }

    public static Element mkPkgExclustionElement(Element element, Strings.Enumeration enumeration) {
        D.pre(element != null);
        D.pre(enumeration != null);
        return new PkgExclusionFilteringElement(element, enumeration);
    }

    private static boolean testMatch(Strings.List list, String string) {
        Strings.List list2 = list;
        while (list2 != null) {
            String string2 = list2.head;
            if (string2.equals(string) || string2.charAt(string2.length() - 1) == '*' && string2.regionMatches(0, string, 0, string2.length() - 1)) {
                return true;
            }
            list2 = list2.tail;
        }
        return false;
    }

    private static String classFileName(String string) {
        return string.replace('.', File.separatorChar) + cfileSuffix;
    }

    private static String classDirName(String string) {
        return Various.getPackageName(string).replace('.', File.separatorChar);
    }

    private static String JarClassFileName(String string) {
        return string.replace('.', '/') + cfileSuffix;
    }

    private static void getMembersOfDirectory(Strings.Set set, File file, String string) {
        D.pre(file.exists() && file.isDirectory());
        D.pre(set != null);
        String[] stringArray = file.list();
        for (int i = 0; i < stringArray.length; ++i) {
            File file2 = new File(file.getAbsolutePath() + File.separator + stringArray[i]);
            if (file2.isDirectory()) {
                ClassPath.getMembersOfDirectory(set, file2, string + stringArray[i] + ".");
                continue;
            }
            if (file2.isFile()) {
                if (!stringArray[i].toLowerCase().endsWith(cfileSuffix)) continue;
                String string2 = string + stringArray[i].substring(0, stringArray[i].lastIndexOf(46));
                set.add(string2);
                continue;
            }
            Log.debugln("ClassPath: nonfile/nondirectry - weird element: " + file2.getAbsolutePath());
        }
    }

    private static byte[] toByteArray(InputStream inputStream) {
        byte[] byArray = new byte[5120];
        boolean bl = false;
        int n = 0;
        while (true) {
            if (n < byArray.length) {
                int n2 = -1;
                try {
                    n2 = inputStream.read(byArray, n, byArray.length - n);
                }
                catch (IOException iOException) {
                    Log.debugln(D.getStackTrace(iOException));
                    iOException.printStackTrace();
                    return null;
                }
                if (n2 == -1) {
                    bl = true;
                } else {
                    n += n2;
                    continue;
                }
            }
            if (bl) break;
            byte[] byArray2 = new byte[byArray.length + 5120];
            System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
            byArray = byArray2;
        }
        if (n < byArray.length) {
            byte[] byArray3 = new byte[n];
            System.arraycopy(byArray, 0, byArray3, 0, n);
            byArray = byArray3;
        }
        return byArray;
    }

    private static InputStream toSafeInputStream(InputStream inputStream) {
        return new ByteArrayInputStream(ClassPath.toByteArray(inputStream));
    }

    static final class PkgExclusionFilteringElement
    implements Element {
        final Element base;
        final Strings.List excludePatterns;

        PkgExclusionFilteringElement(Element element, Strings.Enumeration enumeration) {
            this.excludePatterns = Strings.makeList(enumeration);
            this.base = element;
        }

        boolean accept(String string) {
            return !ClassPath.testMatch(this.excludePatterns, Various.getPackageName(string));
        }

        public InputStream forName(String string) throws IOException {
            return this.accept(string) ? this.base.forName(string) : null;
        }

        public File getContainingElement(String string) throws IOException {
            return this.accept(string) ? this.base.getContainingElement(string) : null;
        }

        public Strings.Set getMembers() {
            Strings.Set set = this.base.getMembers();
            Strings.Set set2 = new Strings.Set();
            Strings.UniqueEnumeration uniqueEnumeration = set.elements();
            while (uniqueEnumeration.hasMoreElements()) {
                String string = uniqueEnumeration.nextString();
                if (!this.accept(string)) continue;
                set2.add(string);
            }
            return set2;
        }

        public String toString() {
            return "ExclusionFilter(\n\tBase = " + this.base.toString() + "\n" + "\tPatterns = " + Strings.toString(this.excludePatterns) + "\n)\n";
        }
    }

    static final class PkgInclusionFilteringElement
    implements Element {
        final Element base;
        final Strings.List includePatterns;

        PkgInclusionFilteringElement(Element element, Strings.Enumeration enumeration) {
            this.includePatterns = Strings.makeList(enumeration);
            this.base = element;
        }

        boolean accept(String string) {
            return ClassPath.testMatch(this.includePatterns, Various.getPackageName(string));
        }

        public InputStream forName(String string) throws IOException {
            return this.accept(string) ? this.base.forName(string) : null;
        }

        public File getContainingElement(String string) throws IOException {
            return this.accept(string) ? this.base.getContainingElement(string) : null;
        }

        public Strings.Set getMembers() {
            Strings.Set set = this.base.getMembers();
            Strings.Set set2 = new Strings.Set();
            Strings.UniqueEnumeration uniqueEnumeration = set.elements();
            while (uniqueEnumeration.hasMoreElements()) {
                String string = uniqueEnumeration.nextString();
                if (!this.accept(string)) continue;
                set2.add(string);
            }
            return set2;
        }

        public String toString() {
            return "InclusionFilter(\n\tBase = " + this.base.toString() + "\n" + "\tPatterns = " + Strings.toString(this.includePatterns) + "\n)\n";
        }
    }

    static final class CompoundElement
    implements Element {
        Element head;
        CompoundElement tail;

        CompoundElement(Element element, CompoundElement compoundElement) {
            D.pre(element != null);
            this.head = element;
            this.tail = compoundElement;
        }

        public InputStream forName(String string) throws IOException {
            InputStream inputStream = this.head.forName(string);
            if (inputStream == null && this.tail != null) {
                inputStream = this.tail.forName(string);
            }
            return inputStream;
        }

        public File getContainingElement(String string) throws IOException {
            File file = this.head.getContainingElement(string);
            if (file == null && this.tail != null) {
                file = this.tail.getContainingElement(string);
            }
            return file;
        }

        public Strings.Set getMembers() {
            Strings.Set set = this.head.getMembers();
            if (this.tail != null) {
                set.add(this.tail.getMembers().elements());
            }
            return set;
        }
    }

    static final class JarElement1
    implements Element {
        File archiveFile;
        HashMap d_hmClassfiles;

        JarElement1(File file) {
            this.archiveFile = file;
        }

        private void checkAndSetClassfiles() {
            JarFile jarFile;
            if (this.d_hmClassfiles != null) {
                return;
            }
            this.d_hmClassfiles = new HashMap();
            try {
                jarFile = new JarFile(this.archiveFile);
            }
            catch (IOException iOException) {
                Log.debugln("ClassPath: unable to create JarFile: " + this.archiveFile.getPath());
                return;
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().toLowerCase().endsWith(ClassPath.cfileSuffix)) continue;
                String string = jarEntry.getName();
                string = string.substring(0, string.lastIndexOf(46)).replace('/', '.');
                try {
                    InputStream inputStream = jarFile.getInputStream(jarEntry);
                    byte[] byArray = ClassPath.toByteArray(inputStream);
                    inputStream.close();
                    this.d_hmClassfiles.put(string, byArray);
                }
                catch (IOException iOException) {
                    Log.debugln("ClassPath: unable to open InputStream: " + this.archiveFile.getPath());
                }
            }
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                Log.debugln("ClassPath: unable to close: " + this.archiveFile.getPath());
            }
        }

        public InputStream forName(String string) throws IOException {
            this.checkAndSetClassfiles();
            byte[] byArray = (byte[])this.d_hmClassfiles.get(string);
            if (byArray == null) {
                return null;
            }
            return new ByteArrayInputStream(byArray);
        }

        public File getContainingElement(String string) throws IOException {
            this.checkAndSetClassfiles();
            if (!this.d_hmClassfiles.containsKey(string)) {
                return null;
            }
            return this.archiveFile;
        }

        public Strings.Set getMembers() {
            this.checkAndSetClassfiles();
            Strings.Set set = new Strings.Set();
            Iterator iterator = this.d_hmClassfiles.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                set.add(string);
            }
            return set;
        }
    }

    static final class JarElement
    implements Element {
        File archiveFile;

        JarElement(File file) {
            this.archiveFile = file;
        }

        public InputStream forName(String string) throws IOException {
            InputStream inputStream;
            JarFile jarFile = new JarFile(this.archiveFile);
            if (jarFile == null) {
                throw new IOException("unable to open file" + this.archiveFile);
            }
            String string2 = ClassPath.JarClassFileName(string);
            JarEntry jarEntry = jarFile.getJarEntry(string2);
            if (jarEntry == null) {
                inputStream = null;
            } else {
                InputStream inputStream2 = jarFile.getInputStream(jarEntry);
                inputStream = ClassPath.toSafeInputStream(inputStream2);
                inputStream2.close();
            }
            if (jarFile != null) {
                jarFile.close();
            }
            return inputStream;
        }

        public File getContainingElement(String string) throws IOException {
            JarFile jarFile = new JarFile(this.archiveFile);
            if (jarFile == null) {
                throw new IOException("unable to open file" + this.archiveFile);
            }
            String string2 = ClassPath.JarClassFileName(string);
            JarEntry jarEntry = jarFile.getJarEntry(string2);
            File file = jarEntry == null ? null : this.archiveFile;
            if (jarFile != null) {
                jarFile.close();
            }
            return file;
        }

        public Strings.Set getMembers() {
            JarFile jarFile;
            Strings.Set set = new Strings.Set();
            try {
                jarFile = new JarFile(this.archiveFile);
            }
            catch (IOException iOException) {
                Log.debugln("ClassPath: unable to perform getMembers: " + this.archiveFile.getPath());
                return set;
            }
            Enumeration<JarEntry> enumeration = jarFile.entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().toLowerCase().endsWith(ClassPath.cfileSuffix)) continue;
                String string = jarEntry.getName();
                string = string.substring(0, string.lastIndexOf(46)).replace('/', '.');
                set.add(string);
            }
            try {
                jarFile.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return set;
        }
    }

    static final class DirElement
    implements Element {
        public final File dir;

        DirElement(File file) {
            this.dir = file;
        }

        public InputStream forName(String string) throws IOException {
            String string2 = ClassPath.classFileName(string);
            File file = new File(this.dir.getAbsolutePath() + File.separator + string2);
            if (file.exists() && file.isFile()) {
                return new FileInputStream(file);
            }
            return null;
        }

        public File getContainingElement(String string) throws IOException {
            String string2 = ClassPath.classFileName(string);
            File file = new File(this.dir.getAbsolutePath() + File.separator + string2);
            if (file.exists() && file.isFile()) {
                return this.dir;
            }
            return null;
        }

        public Strings.Set getMembers() {
            Strings.Set set = new Strings.Set();
            if (this.dir.exists() && this.dir.isDirectory()) {
                ClassPath.getMembersOfDirectory(set, this.dir, "");
            }
            return set;
        }
    }

    static final class NullElement
    implements Element {
        NullElement() {
        }

        public InputStream forName(String string) {
            return null;
        }

        public File getContainingElement(String string) {
            return null;
        }

        public Strings.Set getMembers() {
            return new Strings.Set();
        }
    }

    public static interface Element {
        public InputStream forName(String var1) throws IOException;

        public File getContainingElement(String var1) throws IOException;

        public Strings.Set getMembers();
    }
}

