/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.toad.utils;

import com.ibm.toad.utils.Parser;
import com.ibm.toad.utils.Token;
import java.io.IOException;
import java.io.Reader;
import java.util.Vector;

class Lexer {
    private Reader in;
    private int ch;
    Vector errorsDesc;
    Vector errorsLine;
    Vector errorsCol;
    int line;
    int col;

    private void Number(Token token) throws IOException {
        token.type = 3;
        token.intVal = 0;
        do {
            token.intVal = token.intVal * 10 + (char)(this.ch - 48);
            this.read();
        } while (this.ch >= 48 && this.ch <= 57);
    }

    private void Ident(Token token) throws IOException {
        token.type = 1;
        do {
            token.strVal.append((char)this.ch);
            this.read();
        } while (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90 || this.ch == 95);
    }

    private void String(Token token) throws IOException, Parser.ParseError {
        token.type = 2;
        this.read();
        while (this.ch != -1 && this.ch != 10 && this.ch != 34) {
            token.strVal.append((char)this.ch);
            this.read();
        }
        if (this.ch != 34) {
            this.Error("Unterminated String", this.line, this.col);
        }
        if (this.ch != -1) {
            this.read();
        }
    }

    private void Comment() throws IOException {
        do {
            this.read();
        } while (this.ch != 10 && this.ch != -1);
    }

    private int read() throws IOException {
        if (this.ch == 10) {
            ++this.line;
            this.col = 1;
        } else {
            ++this.col;
        }
        this.ch = this.in.read();
        return this.ch;
    }

    void Error(String string, int n, int n2) throws Parser.ParseError {
        this.errorsDesc.addElement(string);
        this.errorsLine.addElement(new Integer(n));
        this.errorsCol.addElement(new Integer(n2));
        throw new Parser.ParseError("\nError: " + string + " at line: " + n + " col: " + n2);
    }

    Lexer(Reader reader) {
        this.in = reader;
        this.ch = 32;
        this.line = 1;
        this.col = 1;
        this.errorsDesc = new Vector();
        this.errorsLine = new Vector();
        this.errorsCol = new Vector();
    }

    Token getTok() throws IOException, Parser.ParseError {
        while (this.ch != -1 && this.ch <= 32) {
            this.read();
        }
        Token token = new Token();
        token.line = this.line;
        token.col = this.col;
        token.intVal = -1;
        if (this.ch >= 97 && this.ch <= 122 || this.ch >= 65 && this.ch <= 90) {
            this.Ident(token);
        } else if (this.ch >= 48 && this.ch <= 57) {
            this.Number(token);
        } else {
            switch (this.ch) {
                case -1: {
                    token.type = 0;
                    break;
                }
                case 34: {
                    this.String(token);
                    break;
                }
                case 35: {
                    this.Comment();
                    token = this.getTok();
                    break;
                }
                case 40: {
                    token.type = 12;
                    this.read();
                    break;
                }
                case 41: {
                    token.type = 13;
                    this.read();
                    break;
                }
                case 91: {
                    token.type = 10;
                    this.read();
                    break;
                }
                case 93: {
                    token.type = 11;
                    this.read();
                    break;
                }
                case 61: {
                    token.type = 14;
                    this.read();
                    break;
                }
                case 59: {
                    token.type = 15;
                    this.read();
                    break;
                }
                case 44: {
                    token.type = 16;
                    this.read();
                    break;
                }
                default: {
                    this.Error("Unrecognized character " + (char)this.ch, this.line, this.col);
                    this.read();
                }
            }
        }
        return token;
    }
}

