/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.trl.util;

import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public final class Logger {
    public static final int MIN_LEVEL = 0;
    public static final int DEFAULT_LEVEL = 4;
    public static final int MAX_LEVEL = 9;
    private static final Object lock = new Object();
    private static int currentLevel = 4;
    private static PrintWriter out = new PrintWriter(System.out);
    private static final String PROPERTY_LOG_LEVEL = "com.ibm.trl.util.logLevel";
    private static final String PROPERTY_APPLICATION_NAME = "com.ibm.trl.util.applicationName";
    private static final String PROPERTY_NO_TIME_STAMP = "com.ibm.trl.util.noTimeStamp";
    private static final String applicationName;
    private static final boolean noTimeStamp;

    private Logger() {
    }

    public static void setOut(OutputStream outputStream) {
        Logger.setOut(new PrintWriter(outputStream));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOut(PrintWriter printWriter) {
        Object object = lock;
        synchronized (object) {
            out = printWriter;
        }
    }

    public static void setLevel(int n) {
        if (n < 0) {
            n = 0;
        }
        if (n > 9) {
            n = 9;
        }
        currentLevel = n;
    }

    public static int getLevel() {
        return currentLevel;
    }

    public static void normal(String string) {
        Logger.normal(string, 4);
    }

    public static void normal(String string, int n) {
        if (n >= currentLevel) {
            Logger.print(string, ' ');
        }
    }

    public static void warning(String string) {
        Logger.print(string, 'W');
    }

    public static void fatal(String string) {
        Logger.print(string, 'F');
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void print(String string, char c) {
        Object object = lock;
        synchronized (object) {
            if (out != null) {
                out.println(c + (applicationName == null ? "" : "[" + applicationName + "] ") + (noTimeStamp ? "" : "[" + Logger.getTime() + "] ") + Thread.currentThread().getName() + " \"" + string + "\"");
                out.flush();
            }
        }
    }

    private static String getTime() {
        return DateFormat.getDateTimeInstance(0, 0).format(new Date());
    }

    static {
        String string = System.getProperties().getProperty(PROPERTY_LOG_LEVEL);
        if (string != null) {
            try {
                Logger.setLevel(Integer.parseInt(string));
                Logger.normal("Set log level to " + string);
            }
            catch (NumberFormatException numberFormatException) {
                Logger.warning("Logger: " + numberFormatException.getMessage());
            }
        }
        applicationName = System.getProperties().getProperty(PROPERTY_APPLICATION_NAME);
        noTimeStamp = System.getProperties().getProperty(PROPERTY_NO_TIME_STAMP) != null;
    }
}

