/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vap.converters;

import com.ibm.vap.converters.VapAbstractConverter;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class VapStringCalendarConverter
extends VapAbstractConverter {
    static VapStringCalendarConverter singleton = null;
    private SimpleDateFormat formatter;
    private static final String copyright = "Licensed Materials -- Property of IBM\n(c) Copyright International Business Machines Corporation, 1999, 2000";

    public Object dataFrom(Object object) {
        if (object == null) {
            return null;
        }
        Calendar calendar = (Calendar)object;
        Date date = calendar.getTime();
        return this.getFormatter().format(date);
    }

    public String getFormatPattern() {
        return "yyyy.MM.dd";
    }

    public SimpleDateFormat getFormatter() {
        if (this.formatter == null) {
            this.formatter = new SimpleDateFormat(this.getFormatPattern());
        }
        return this.formatter;
    }

    public static String[] getSourceDatatype() {
        return VapStringCalendarConverter.getStringDatatypes();
    }

    public static String getTargetClassName() {
        return "java.util.Calendar";
    }

    public Object objectFrom(Object object) {
        if (object == null) {
            return null;
        }
        try {
            this.getFormatter().parse((String)object);
        }
        catch (Exception exception) {
            return null;
        }
        return this.getFormatter().getCalendar();
    }

    public static void reset() {
        singleton = null;
    }

    public static VapStringCalendarConverter singleton() {
        if (singleton == null) {
            singleton = new VapStringCalendarConverter();
        }
        return singleton;
    }
}

