/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.advanced.cm.factory;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.DSFactory;
import com.ibm.ejs.cm.DSMigrationHelper;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.advanced.cm.factory.Attributes;
import com.ibm.websphere.advanced.cm.factory.CMFactoryException;
import com.ibm.websphere.advanced.cm.factory.MissingRequiredPropertyException;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.spi.ObjectFactory;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class DataSourceFactory {
    public static final String DEFAULT_DATASOURCE_CONTEXT_NAME = "jdbc";
    public static DSFactory dsFactory;
    public static DSMigrationHelper dsMigrationHelper;
    public static final String NAME = "name";
    public static final String DATASOURCE_CLASS_NAME = "dataSourceClassName";
    public static final String DATABASE_VERSION = "dataBaseVersion";
    public static final String DESCRIPTION = "description";
    public static final String DEFAULT_DESCRIPTION;
    public static final String MIN_POOL_SIZE = "minimumPoolSize";
    public static final int DEFAULT_MIN_POOL_SIZE = 1;
    public static final String MAX_POOL_SIZE = "maximumPoolSize";
    public static final int DEFAULT_MAX_POOL_SIZE = 10;
    public static final String CONN_TIMEOUT = "connectionTimeout";
    public static final int DEFAULT_CONN_TIMEOUT = 180;
    public static final String IDLE_TIMEOUT = "idleTimeout";
    public static final int DEFAULT_IDLE_TIMEOUT = 1800;
    public static final String ORPHAN_TIMEOUT = "orphanTimeout";
    public static final int DEFAULT_ORPHAN_TIMEOUT = 1800;
    public static final String AGED_TIMEOUT = "agedTimeout";
    public static final int DEFAULT_AGED_TIMEOUT = 0;
    public static final String STATEMENT_CACHE_SIZE = "statementCacheSize";
    public static final int DEFAULT_STATEMENT_CACHE_SIZE = 10;
    public static final String USER = "user";
    public static final String DEFAULT_USER;
    public static final String PASSWORD = "password";
    public static final String DEFAULT_PASSWORD;
    public static final String DISABLE_AUTO_CONN_CLEANUP = "disableAutoConnectionCleanup";
    public static final boolean DEFAULT_DISABLE_AUTO_CONN_CLEANUP = false;
    public static final String ERROR_MAP = "errorMap";
    public static final Hashtable DEFAULT_ERROR_MAP;
    public static final String OEM_ID = "oemId";
    public static final String INFORMIX_LOCK_MODE_WAIT = "informixLockModeWait";
    public static final int DEFAULT_INFORMIX_LOCK_MODE_WAIT = 0;
    public static final String INFORMIX_ALLOW_NEWLINE = "informixAllowNewLine";
    public static final boolean DEFAULT_INFORMIX_ALLOW_NEWLINE = false;
    public static final String ORACLE_STMT_CACHE_SIZE = "oracleStmtCacheSize";
    public static final int DEFAULT_ORACLE_STMT_CACHE_SIZE = 0;
    public static final String DISABLE_2PHASE = "disable2Phase";
    public static final boolean DEFAULT_DISABLE_2PHASE = false;
    public static final String VALIDATE = "connectionValidation";
    public static final boolean DEFAULT_VALIDATE = false;
    public static final String VALIDATE_SQL = "validationSQL";
    public static final String RESET_READ_ONLY = "resetReadOnly";
    public static final boolean DEFAULT_RESET_READ_ONLY = false;
    public static final String SECURE_XA_CREDENTIAL = "secureXACredential";
    public static final boolean DEFAULT_SECURE_XA_CREDENTIAL = false;
    public static final String LOG_ORPHAN = "logOrphan";
    public static final boolean DEFAULT_LOG_ORPHAN = false;
    public static final String DIAG_OPTIONS = "diagOptions";
    public static final int DEFAULT_DIAG_OPTIONS = 0;
    public static final String ORA_TRANS_LOOSE = "transactionBranchesLooselyCoupled";
    private static String[] CM_PROPERTIES;
    private static final TraceComponent tc;
    static /* synthetic */ Class class$com$ibm$ejs$cm$portability$PortableDataSource;

    public DataSource createJDBCDataSource(Attributes attributes2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJDBCDataSource", attributes2);
        }
        DataSource dataSource = null;
        try {
            Properties properties = DataSourceFactory.convert35To40Interface(attributes2, false);
            dataSource = DataSourceFactory.getDataSource(properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (CMFactoryException cMFactoryException) {
            throw new IllegalArgumentException("CMFactoryException: " + cMFactoryException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Exception: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJDBCDataSource", dataSource);
        }
        return dataSource;
    }

    public DataSource createJTADataSource(Attributes attributes2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createJTADataSource", attributes2);
        }
        DataSource dataSource = null;
        try {
            Properties properties = DataSourceFactory.convert35To40Interface(attributes2, true);
            dataSource = DataSourceFactory.getDataSource(properties);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new IllegalArgumentException("ClassNotFoundException: " + classNotFoundException.getMessage());
        }
        catch (CMFactoryException cMFactoryException) {
            throw new IllegalArgumentException("CMFactoryException: " + cMFactoryException.getMessage());
        }
        catch (Exception exception) {
            throw new IllegalStateException("Exception: " + exception.getMessage());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createJTADataSource", dataSource);
        }
        return dataSource;
    }

    public static void bindDataSource(DataSource dataSource) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindDataSource", dataSource);
        }
        CMProperties cMProperties = ((PortableDataSource)dataSource).getAttributes();
        DataSourceFactory.getBindingContext().bind(cMProperties.getName(), (Object)new ResourceFactoryReferenceable(cMProperties));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindDataSource");
        }
    }

    public static void bindDataSource(Context context, DataSource dataSource) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "bindDataSource", new Object[]{context, dataSource});
        }
        CMProperties cMProperties = ((PortableDataSource)dataSource).getAttributes();
        context.bind(cMProperties.getName(), (Object)new ResourceFactoryReferenceable(cMProperties));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "bindDataSource");
        }
    }

    public static void rebindDataSource(DataSource dataSource) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rebindDataSource", dataSource);
        }
        CMProperties cMProperties = ((PortableDataSource)dataSource).getAttributes();
        DataSourceFactory.getBindingContext().rebind(cMProperties.getName(), (Object)new ResourceFactoryReferenceable(cMProperties));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rebindDataSource");
        }
    }

    public static void rebindDataSource(Context context, DataSource dataSource) throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "rebindDataSource", new Object[]{context, dataSource});
        }
        CMProperties cMProperties = ((PortableDataSource)dataSource).getAttributes();
        context.rebind(cMProperties.getName(), (Object)new ResourceFactoryReferenceable(cMProperties));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "rebindDataSource");
        }
    }

    public static Referenceable getBindableObject(Properties properties) {
        Properties properties2 = (Properties)properties.clone();
        String string = (String)properties2.remove(PASSWORD);
        if (string != null) {
            properties2.setProperty(PASSWORD, "XXXXXX");
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindableObject", properties2);
        }
        ResourceFactoryReferenceable resourceFactoryReferenceable = null;
        try {
            CMProperties cMProperties = DataSourceFactory.createCMProperties(properties);
            resourceFactoryReferenceable = new ResourceFactoryReferenceable(cMProperties);
        }
        catch (Exception exception) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getBindableObject: caught Exception", exception);
            }
            throw new IllegalStateException("getBindableObject: caught Exception");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindableObject", resourceFactoryReferenceable);
        }
        return resourceFactoryReferenceable;
    }

    public static DataSource getDataSource(Properties properties) throws ClassNotFoundException, CMFactoryException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSource", properties);
        }
        CMProperties cMProperties = DataSourceFactory.createCMProperties(properties);
        DataSource dataSource = DataSourceFactory.getDataSource(cMProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSource", dataSource);
        }
        return dataSource;
    }

    public static DataSource getDataSource(CMProperties cMProperties) throws ClassNotFoundException, CMFactoryException, Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getDataSource", cMProperties);
        }
        cMProperties.validate();
        DataSource dataSource = DataSourceFactory.getDSFactory().getDataSource(cMProperties);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getDataSource", dataSource);
        }
        return dataSource;
    }

    public static String[] getCMProperties() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCMProperties");
        }
        if (CM_PROPERTIES == null) {
            Field[] fieldArray = DataSourceFactory.class.getFields();
            ArrayList<String> arrayList = new ArrayList<String>(fieldArray.length);
            int n = 0;
            for (int i = 0; i < fieldArray.length; ++i) {
                String string;
                int n2 = fieldArray[i].getModifiers();
                if (!Modifier.isFinal(n2) || !Modifier.isStatic(n2) || (string = fieldArray[i].getName()).startsWith("DEFAULT")) continue;
                try {
                    arrayList.add((String)fieldArray[i].get(null));
                    ++n;
                    continue;
                }
                catch (IllegalAccessException illegalAccessException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getCMProperties, Illegal Access Exception", illegalAccessException);
                    }
                    return null;
                }
            }
            CM_PROPERTIES = new String[n];
            arrayList.trimToSize();
            CM_PROPERTIES = arrayList.toArray(CM_PROPERTIES);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCMProperties", arrayList);
            }
        }
        return CM_PROPERTIES;
    }

    public static DataSource removeDataSource(String string) {
        DSFactory dSFactory = null;
        try {
            dSFactory = DataSourceFactory.getDSFactory();
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "removeDataSource: failed with exception", exception);
            }
            throw new IllegalStateException("Exception: " + exception.getMessage());
        }
        return dSFactory.removeDataSource(string);
    }

    public static boolean isJTAEnabled(Properties properties) throws ClassNotFoundException, CMFactoryException {
        String string = properties.getProperty(DATASOURCE_CLASS_NAME);
        if (string == null) {
            String string2 = properties.getProperty(NAME);
            if (string2 == null) {
                string2 = "<unknown>";
            }
            Tr.error(tc, "MSG_CONM_1001E", new Object[]{"DataSourceFactory.DATASOURCE_CLASS_NAME", string2});
            throw new MissingRequiredPropertyException("Required property DataSourceFactory.DATASOURCE_CLASS_NAME for data source " + string2 + " is missing");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = properties.getProperty(NAME);
            if (string3 == null) {
                string3 = "<unknown>";
            }
            Tr.error(tc, "MSG_CONM_1006E", new Object[]{string, string3});
            throw classNotFoundException;
        }
        String string4 = properties.getProperty(DISABLE_2PHASE);
        if (string4 != null && string4.equals("true")) {
            return false;
        }
        return XADataSource.class.isAssignableFrom(clazz);
    }

    public static boolean isJTAEnabled(CMProperties cMProperties) throws ClassNotFoundException, CMFactoryException {
        String string = cMProperties.getDataSourceClassName();
        if (string == null) {
            String string2 = cMProperties.getName();
            if (string2 == null) {
                string2 = "<unknown>";
            }
            Tr.error(tc, "MSG_CONM_1001E", new Object[]{"DataSourceFactory.DATASOURCE_CLASS_NAME", string2});
            throw new MissingRequiredPropertyException("Required property DataSourceFactory.DATASOURCE_CLASS_NAME for data source " + string2 + " is missing");
        }
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        Class<?> clazz = null;
        try {
            clazz = classLoader.loadClass(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = cMProperties.getName();
            if (string3 == null) {
                string3 = "<unknown>";
            }
            Tr.error(tc, "MSG_CONM_1006E", new Object[]{string, string3});
            throw classNotFoundException;
        }
        if (cMProperties.isDisable2Phase()) {
            return false;
        }
        return XADataSource.class.isAssignableFrom(clazz);
    }

    public static boolean isRRSTransactional(CMProperties cMProperties, String string) throws CMFactoryException {
        String string2;
        String string3 = cMProperties.getDataSourceClassName();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "isRRSTransactional: inputDataSource Class Name is " + string3);
        }
        if (string3 == null) {
            String string4 = cMProperties.getName();
            if (string4 == null) {
                string4 = "<unknown>";
            }
            Tr.error(tc, "MSG_CONM_1001E", new Object[]{"DataSourceFactory.DATASOURCE_CLASS_NAME", string4});
            throw new MissingRequiredPropertyException("Required property DataSourceFactory.DATASOURCE_CLASS_NAME for data source " + string4 + " is missing");
        }
        boolean bl = false;
        if (string3.equals("com.ibm.db2.jcc.DB2ConnectionPoolDataSource") && ((string2 = System.getProperty("os.name")).equalsIgnoreCase("OS/390") || string2.equalsIgnoreCase("Z/OS"))) {
            if (string == null) {
                bl = true;
            } else if (string.equals("2")) {
                bl = true;
            }
        }
        if (tc.isDebugEnabled()) {
            if (bl) {
                Tr.debug(tc, "isRRSTransactional: DataSource is RRSTransactional");
            } else {
                Tr.debug(tc, "isRRSTransactional: DataSource is NOT RRSTransactional");
            }
        }
        return bl;
    }

    private static Context getBindingContext() throws NamingException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getBindingContext");
        }
        final Properties properties = new Properties();
        properties.put("java.naming.factory.initial", "com.ibm.websphere.naming.WsnInitialContextFactory");
        InitialContext initialContext = null;
        try {
            initialContext = (InitialContext)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return new InitialContext(properties);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (NamingException)privilegedActionException.getException();
        }
        Context context = null;
        final InitialContext initialContext2 = initialContext;
        try {
            context = (Context)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws NamingException {
                    return initialContext2.lookup(DataSourceFactory.DEFAULT_DATASOURCE_CONTEXT_NAME);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            NamingException namingException = (NamingException)privilegedActionException.getException();
            if (namingException instanceof NameNotFoundException) {
                try {
                    context = (Context)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                        public Object run() throws NamingException {
                            return initialContext2.createSubcontext(DataSourceFactory.DEFAULT_DATASOURCE_CONTEXT_NAME);
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException2) {
                    throw (NamingException)privilegedActionException2.getException();
                }
            }
            throw namingException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getBindingContext", context);
        }
        return context;
    }

    private static Properties convert35To40Interface(Attributes attributes2, boolean bl) throws MissingRequiredPropertyException, Exception {
        Object object;
        String string = null;
        String string2 = null;
        if (attributes2.url != null) {
            object = DataSourceFactory.getDSMigrationHelper().convertUrlToUrlPrefixAndDatabaseName(attributes2.url, attributes2.driver);
            string = object[0];
            string2 = object[1];
        } else {
            string2 = attributes2.databaseName;
            if (attributes2.driver.equals("COM.ibm.db2.jdbc.app.DB2Driver") || attributes2.driver.equals("COM.ibm.db2.jdbc.net.DB2Driver")) {
                string = "jdbc:db2";
            } else if (attributes2.driver.equals("com.ibm.as400.access.AS400JDBCDriver")) {
                string = "jdbc:as400";
            } else if (attributes2.driver.equals("com.ibm.db2.jdbc.app.DB2Driver")) {
                string = "jdbc:db2";
            } else if (attributes2.driver.equals("jdbc.idbDriver") || attributes2.driver.equals("org.enhydra.instantdb.jdbc.idbDriver")) {
                string = "jdbc:idb";
            } else {
                throw new MissingRequiredPropertyException("The 'url' attribute is required for this database");
            }
        }
        object = DataSourceFactory.getDSMigrationHelper().migrateDataSource(attributes2.driver, string, string2, bl ? "true" : "false");
        ((Properties)object).setProperty(MIN_POOL_SIZE, String.valueOf(attributes2.min));
        ((Properties)object).setProperty(MAX_POOL_SIZE, String.valueOf(attributes2.max));
        ((Properties)object).setProperty(CONN_TIMEOUT, String.valueOf((int)attributes2.connTimeout / 1000));
        ((Properties)object).setProperty(IDLE_TIMEOUT, String.valueOf((int)attributes2.idleTimeout / 1000));
        ((Properties)object).setProperty(ORPHAN_TIMEOUT, String.valueOf((int)attributes2.orphanTimeout / 1000));
        ((Properties)object).setProperty(STATEMENT_CACHE_SIZE, String.valueOf(attributes2.statementCacheSize));
        if (attributes2.name != null) {
            ((Properties)object).setProperty(NAME, attributes2.name);
        }
        if (attributes2.description != null) {
            ((Properties)object).setProperty(DESCRIPTION, attributes2.description);
        }
        return object;
    }

    private static CMProperties createCMProperties() throws Exception {
        CMProperties cMProperties = null;
        try {
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass("com.ibm.ejs.cm.CMPropertiesImpl");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            cMProperties = (CMProperties)clazz.newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"com.ibm.ejs.cm.CMPropertiesImpl", "Unknown", exception};
            Tr.error(tc, "MSG_CONM_7006E", objectArray);
            throw exception;
        }
        return cMProperties;
    }

    private static CMProperties createCMProperties(Properties properties) throws Exception {
        CMProperties cMProperties = null;
        try {
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass("com.ibm.ejs.cm.CMPropertiesImpl");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            Class<?> clazz2 = classLoader.loadClass("java.util.Properties");
            Constructor constructor = clazz.getConstructor(clazz2);
            cMProperties = (CMProperties)constructor.newInstance(properties);
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"com.ibm.ejs.cm.CMPropertiesImpl", "Unknown", exception};
            Tr.error(tc, "MSG_CONM_7006E", objectArray);
            throw exception;
        }
        return cMProperties;
    }

    private static DSFactory getDSFactory() throws Exception {
        if (dsFactory != null) {
            return dsFactory;
        }
        try {
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass("com.ibm.ejs.cm.DSFactoryImpl");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            dsFactory = (DSFactory)clazz.newInstance();
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"com.ibm.ejs.cm.DSFactoryImpl", "Unknown", exception};
            Tr.error(tc, "MSG_CONM_7006E", objectArray);
            throw exception;
        }
        return dsFactory;
    }

    public static DSMigrationHelper getDSMigrationHelper() {
        if (dsMigrationHelper != null) {
            return dsMigrationHelper;
        }
        try {
            final ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class clazz = null;
            try {
                clazz = (Class)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return classLoader.loadClass("com.ibm.ejs.cm.DSMigrationHelperImpl");
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw privilegedActionException.getException();
            }
            dsMigrationHelper = (DSMigrationHelper)clazz.newInstance();
            return dsMigrationHelper;
        }
        catch (Exception exception) {
            Object[] objectArray = new Object[]{"com.ibm.ejs.cm.DSMigrationHelperImpl", "Unknown", exception};
            Tr.error(tc, "MSG_CONM_7006E", objectArray);
            throw new IllegalStateException("getDSMigrationHelper: caught Exception");
        }
        finally {
            return dsMigrationHelper;
        }
    }

    static {
        DEFAULT_DESCRIPTION = null;
        DEFAULT_USER = null;
        DEFAULT_PASSWORD = null;
        DEFAULT_ERROR_MAP = null;
        CM_PROPERTIES = null;
        tc = Tr.register(DataSourceFactory.class, null, "com.ibm.ejs.resources.CONMMessages");
    }

    public static class ResourceReferenceObjectFactory
    implements ObjectFactory {
        public Object getObjectInstance(Object object, Name name2, Context context, Hashtable hashtable) throws NamingException {
            Object object2;
            Tr.entry(tc, "ResourceReferenceObjectFactory.getObjectInstance");
            try {
                object2 = DataSourceFactory.getDSFactory();
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException(exception.getMessage());
                namingException.setRootCause(exception);
                throw namingException;
            }
            dsFactory.verifyConfiguration();
            object2 = (Reference)object;
            if (!((Reference)object2).getClassName().equals((class$com$ibm$ejs$cm$portability$PortableDataSource == null ? (class$com$ibm$ejs$cm$portability$PortableDataSource = DataSourceFactory.class$("com.ibm.ejs.cm.portability.PortableDataSource")) : class$com$ibm$ejs$cm$portability$PortableDataSource).getName())) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Class " + ((Reference)object2).getClassName() + " does not equal " + "com.ibm.ejs.cm.portability.PortableDataSource");
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ResourceReferenceObjectFactory.getObjectInstance", null);
                }
                return null;
            }
            DataSource dataSource = null;
            try {
                CMProperties cMProperties = DataSourceFactory.createCMProperties();
                CMProperties cMProperties2 = cMProperties.loadFromReference((Reference)object2);
                dataSource = DataSourceFactory.getDataSource(cMProperties2);
            }
            catch (ClassNotFoundException classNotFoundException) {
                NamingException namingException = new NamingException("ClassNotFoundException: " + classNotFoundException.getMessage());
                namingException.setRootCause(classNotFoundException);
                throw namingException;
            }
            catch (CMFactoryException cMFactoryException) {
                NamingException namingException = new NamingException("CMFactoryException: " + cMFactoryException.getMessage());
                namingException.setRootCause(cMFactoryException);
                throw namingException;
            }
            catch (Exception exception) {
                NamingException namingException = new NamingException("Exception: " + exception.getMessage());
                namingException.setRootCause(exception);
                throw namingException;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResourceReferenceObjectFactory.getObjectInstance", dataSource);
            }
            return dataSource;
        }
    }

    static class ResourceFactoryReferenceable
    implements Referenceable {
        CMProperties cmProps = null;

        ResourceFactoryReferenceable(CMProperties cMProperties) {
            this.cmProps = cMProperties;
        }

        public Reference getReference() throws NamingException {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "ResourceFactoryReferenceable.getReference");
            }
            Reference reference = this.cmProps.getReference();
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ResourceFactoryReferenceable.getReference", reference);
            }
            return reference;
        }

        public String toString() {
            return this.cmProps.toString();
        }
    }
}

