/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.als;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.als.BufferManager;
import com.ibm.websphere.als.LogRecord;
import com.ibm.websphere.als.Logger;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class AnalysisLogger {
    private static final String REQID = "SA_REQID";
    private boolean myAutoSession = true;
    private boolean myHttpLogging = true;
    private boolean myCookieLogging = true;
    private boolean myEnabled = true;
    private String myAppID = null;
    private BufferManager myBufferMgr = null;
    protected static TraceComponent myTracer = Tr.register("com.ibm.websphere.als.AnalysisLogger", "ALS");
    private static String DASH = "-";
    private static String QUOTE = "\"";
    private static String SPACE = " ";
    private static String QMARK = "?";
    private static String EMPTY = "";
    private static String NULL = "null";
    private static SimpleDateFormat dateFormatter = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss ");

    public AnalysisLogger(ServletContext servletContext, Logger logger) {
        this(servletContext, logger, 50);
    }

    public AnalysisLogger(ServletContext servletContext, Logger logger, int n) {
        this.myBufferMgr = new BufferManager(servletContext, logger, n);
    }

    public void log(HttpServletRequest httpServletRequest, String string) throws Exception {
        if (myTracer.isEntryEnabled()) {
            Tr.entry(myTracer, "AnalysisLogger.log(HttpServletRequest, String)");
        }
        if (this.myEnabled) {
            if (myTracer.isDebugEnabled()) {
                Tr.debug(myTracer, "HttpServletRequest: " + httpServletRequest + " String: " + string);
            }
            if (string.charAt(string.length() - 1) != ';') {
                string = string + ";";
            }
            LogRecord logRecord = this.getLogRecord(httpServletRequest, string);
            this.myBufferMgr.log(logRecord);
            if (myTracer.isDebugEnabled()) {
                Tr.debug(myTracer, "LogRecord: " + logRecord);
            }
        }
        if (myTracer.isEntryEnabled()) {
            Tr.exit(myTracer, "AnalysisLogger.log(HttpServletRequest, String)");
        }
    }

    public void log(HttpServletRequest httpServletRequest, String string, String string2) throws Exception {
        if (this.myEnabled) {
            this.log(httpServletRequest, string + "=" + string2 + ";");
        }
    }

    private String makeReqID(HttpServletRequest httpServletRequest) {
        String string = null;
        try {
            HttpSession httpSession = httpServletRequest.getSession(false);
            if (httpSession == null && this.myAutoSession) {
                httpSession = httpServletRequest.getSession(true);
            }
            if (httpSession != null) {
                Long l = (Long)httpSession.getAttribute(REQID);
                l = l != null ? new Long(l + 1L) : new Long(1L);
                string = httpSession.getId() + "-" + l;
                httpSession.setAttribute(REQID, (Object)l);
            } else {
                string = "0-" + System.currentTimeMillis();
            }
            httpServletRequest.setAttribute(REQID, (Object)string);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.als.AnalysisLogger.makeReqID", "220", this);
            string = "0-" + System.currentTimeMillis();
        }
        return string;
    }

    private LogRecord getLogRecord(HttpServletRequest httpServletRequest, String string) {
        String string2;
        String string3 = null;
        String string4 = null;
        if (httpServletRequest != null) {
            string2 = (String)httpServletRequest.getAttribute(REQID);
            if (string2 == null) {
                if (this.myCookieLogging) {
                    string3 = httpServletRequest.getHeader("Cookies");
                }
                if (this.myHttpLogging) {
                    StringBuffer stringBuffer = new StringBuffer(256);
                    String string5 = httpServletRequest.getRemoteHost();
                    if (string5 == null) {
                        string5 = httpServletRequest.getRemoteAddr();
                    }
                    stringBuffer.append(string5).append(SPACE);
                    stringBuffer.append(DASH).append(SPACE);
                    String string6 = httpServletRequest.getRemoteUser();
                    if (string6 == null) {
                        string6 = DASH;
                    }
                    stringBuffer.append(string6).append(SPACE);
                    stringBuffer.append(this.formatDate(new Date())).append(SPACE);
                    stringBuffer.append(QUOTE).append(httpServletRequest.getMethod()).append(SPACE);
                    stringBuffer.append(httpServletRequest.getRequestURI());
                    String string7 = httpServletRequest.getQueryString();
                    if (string7 != null && !string7.equalsIgnoreCase(NULL)) {
                        stringBuffer.append(QMARK + string7);
                    }
                    stringBuffer.append(SPACE);
                    stringBuffer.append(httpServletRequest.getProtocol()).append(QUOTE).append(SPACE);
                    stringBuffer.append(DASH).append(SPACE);
                    stringBuffer.append(Integer.toString(httpServletRequest.getContentLength())).append(SPACE);
                    String string8 = httpServletRequest.getHeader("referer");
                    if (string8 == null || string8.equalsIgnoreCase(NULL)) {
                        string8 = EMPTY;
                    }
                    stringBuffer.append(QUOTE).append(string8).append(QUOTE).append(SPACE);
                    stringBuffer.append(QUOTE).append(httpServletRequest.getHeader("user-agent")).append(QUOTE);
                    string4 = stringBuffer.toString();
                }
                string2 = this.makeReqID(httpServletRequest);
            }
        } else {
            string2 = "0-" + System.currentTimeMillis();
        }
        return new LogRecord(this.myAppID, string2, string4, string3, string);
    }

    private String formatDate(Date date) {
        String string = dateFormatter.format(date);
        int n = 31;
        string = string + (n < 0 ? "-" : "+");
        n = n < 0 ? -n : n;
        int n2 = n / 3600000;
        int n3 = n / 60000 - n2 * 60;
        String string2 = "0" + Integer.toString(n2);
        string = string + string2.substring(string2.length() - 2);
        string2 = "0" + Integer.toString(n3);
        string = string + string2.substring(string2.length() - 2);
        return "[" + string + "]";
    }

    public void flush() throws Exception {
        this.myBufferMgr.flush();
    }

    public void setEnabled(boolean bl) {
        this.myEnabled = bl;
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public void setHttpLogging(boolean bl) {
        this.myHttpLogging = bl;
    }

    public boolean getHttpLogging() {
        return this.myHttpLogging;
    }

    public void setCookieLogging(boolean bl) {
        this.myCookieLogging = bl;
    }

    public boolean getCookieLogging() {
        return this.myCookieLogging;
    }

    public void setAutoSession(boolean bl) {
        this.myAutoSession = bl;
    }

    public boolean getAutoSession() {
        return this.myAutoSession;
    }

    public Logger getLogger() {
        return this.myBufferMgr.getLogger();
    }

    public void setAppID(String string) {
        this.myAppID = string;
    }

    public String getAppID() {
        return this.myAppID;
    }

    public int getLogSize() {
        return this.myBufferMgr.getSize();
    }

    public void terminate() {
        this.myBufferMgr.terminate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void debug(Exception exception) {
        StringWriter stringWriter = null;
        PrintWriter printWriter = null;
        try {
            stringWriter = new StringWriter();
            printWriter = new PrintWriter(stringWriter);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            Tr.debug(myTracer, stringWriter.toString());
        }
        catch (Exception exception2) {
            FFDCFilter.processException(exception2, "com.ibm.websphere.als.AnalysisLogger.debug", "508");
        }
        finally {
            try {
                stringWriter.close();
            }
            catch (Exception exception3) {
                FFDCFilter.processException(exception3, "com.ibm.websphere.als.AnalysisLogger.debug", "513");
            }
            try {
                printWriter.close();
            }
            catch (Exception exception4) {
                FFDCFilter.processException(exception4, "com.ibm.websphere.als.AnalysisLogger.debug", "516");
            }
        }
    }
}

