/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.als;

import com.ibm.websphere.als.LogRecord;
import com.ibm.websphere.als.Logger;
import com.ibm.ws.ffdc.FFDCFilter;
import java.io.DataOutputStream;
import java.io.FilterOutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;

public class HttpLogger
implements Logger {
    private URL myURL;
    private String mySite;
    private static String EMPTY_FIELD = "-";
    private static String LEFT_ANGLE = "<";
    private static String RIGHT_ANGLE = ">";
    private static String POST_METHOD = "POST";
    private static String QUERY_DELIM = "&";
    private static String EQUAL = "=";
    private static String WT_SITE = "sawt_site";
    private static String WT_TYPE = "sawt_type";
    private static String WT_WAS = "WT_WAS";
    private static String WT_DATA = "sawt_info";

    public HttpLogger(URL uRL) {
        this(uRL, uRL.getHost());
    }

    public HttpLogger(URL uRL, String string) {
        this.myURL = uRL;
        this.mySite = string;
    }

    public void write(LogRecord[] logRecordArray) throws Exception {
        String string = this.getData(logRecordArray);
        int n = 0;
        while (n < 3) {
            try {
                this.sendData(string);
                n = 5;
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.als.HttpLogger.write", "111", this);
                if (n++ <= 1) continue;
                throw exception;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendData(String string) throws Exception {
        HttpURLConnection httpURLConnection = null;
        FilterOutputStream filterOutputStream = null;
        try {
            httpURLConnection = (HttpURLConnection)this.myURL.openConnection();
            httpURLConnection.setRequestMethod(POST_METHOD);
            httpURLConnection.setUseCaches(false);
            httpURLConnection.setAllowUserInteraction(false);
            httpURLConnection.setDoInput(true);
            httpURLConnection.setDoOutput(true);
            filterOutputStream = new DataOutputStream(httpURLConnection.getOutputStream());
            ((DataOutputStream)filterOutputStream).writeBytes(string);
            ((DataOutputStream)filterOutputStream).flush();
            if (httpURLConnection.getResponseCode() >= 400) {
                throw new Exception(httpURLConnection.getResponseMessage());
            }
        }
        finally {
            try {
                httpURLConnection.disconnect();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.als.HttpLogger.sendData", "146", this);
            }
            try {
                filterOutputStream.close();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.als.HttpLogger.sendData", "149", this);
            }
        }
    }

    private String getData(LogRecord[] logRecordArray) {
        int n = 0;
        for (int i = 0; i < logRecordArray.length; ++i) {
            if (logRecordArray[i].appID == null) {
                logRecordArray[i].appID = EMPTY_FIELD;
            }
            if (logRecordArray[i].reqID == null) {
                logRecordArray[i].reqID = EMPTY_FIELD;
            }
            if (logRecordArray[i].httpData == null) {
                logRecordArray[i].httpData = EMPTY_FIELD;
            }
            if (logRecordArray[i].cookie == null) {
                logRecordArray[i].cookie = EMPTY_FIELD;
            }
            if (logRecordArray[i].appData == null) {
                logRecordArray[i].appData = EMPTY_FIELD;
            }
            n += logRecordArray[i].appID.length() + logRecordArray[i].reqID.length() + logRecordArray[i].httpData.length() + logRecordArray[i].cookie.length() + logRecordArray[i].appData.length() + 10;
        }
        n = 100 + this.mySite.length() + 3 * n;
        StringBuffer stringBuffer = new StringBuffer(n);
        stringBuffer.append(WT_SITE).append(EQUAL).append(URLEncoder.encode(this.mySite)).append(QUERY_DELIM);
        stringBuffer.append(WT_TYPE).append(EQUAL).append(WT_WAS).append(QUERY_DELIM);
        for (int i = 0; i < logRecordArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(QUERY_DELIM);
            }
            String string = LEFT_ANGLE + logRecordArray[i].appID + RIGHT_ANGLE + LEFT_ANGLE + logRecordArray[i].reqID + RIGHT_ANGLE + LEFT_ANGLE + logRecordArray[i].httpData + RIGHT_ANGLE + LEFT_ANGLE + logRecordArray[i].cookie + RIGHT_ANGLE + LEFT_ANGLE + logRecordArray[i].appData + RIGHT_ANGLE;
            stringBuffer.append(WT_DATA).append(EQUAL).append(URLEncoder.encode(string));
        }
        return stringBuffer.toString();
    }

    public Object getStorageSource() {
        return this.myURL;
    }
}

