/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.ejs.models.base.extensions.applicationext.ApplicationExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.etools.commonarchive.ApplicationClientFile;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.CommonarchivePackage;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.WARFile;
import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.websphere.models.config.init.ConfigInit;
import com.ibm.websphere.validation.base.extensions.applicationext.ApplicationExtensionValidator;
import com.ibm.websphere.validation.base.extensions.ejbext.EJBExtensionValidator;
import com.ibm.websphere.validation.base.extensions.webappext.WebAppExtensionValidator;
import com.ibm.websphere.validation.helpers.PassthruHelper;
import com.ibm.ws.ant.utils.ProjectUtils;
import java.util.List;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.model.internal.validation.ApplicationClientValidator;
import org.eclipse.jst.j2ee.model.internal.validation.EJBValidator;
import org.eclipse.jst.j2ee.model.internal.validation.EarValidator;
import org.eclipse.jst.j2ee.model.internal.validation.WarValidator;
import org.eclipse.wst.validation.internal.core.IMessageAccess;
import org.eclipse.wst.validation.internal.core.ValidationException;
import org.eclipse.wst.validation.internal.core.ValidatorLauncher;
import org.eclipse.wst.validation.internal.provisional.core.IMessage;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;
import org.eclipse.wst.validation.internal.provisional.core.MessageLimitException;

public class ModuleValidator
extends Task
implements IReporter {
    String src;
    private ValidatorLauncher launcher;
    private PassthruHelper helper;
    private boolean failonerror = false;

    public ModuleValidator() {
        ConfigInit.init();
        this.launcher = ValidatorLauncher.getLauncher();
        this.helper = new PassthruHelper();
    }

    public void execute() throws BuildException {
        CommonarchivePackage commonarchivePackage = (CommonarchivePackage)EPackage.Registry.INSTANCE.getEPackage("http:///com/ibm/etools/commonarchive.ecore");
        CommonarchiveFactory commonarchiveFactory = commonarchivePackage.getCommonarchiveFactory();
        try {
            Archive archive = commonarchiveFactory.openArchive(this.src);
            if (archive instanceof ModuleFile) {
                try {
                    this.validate((ModuleFile)archive, this);
                }
                catch (ValidationException validationException) {
                    this.addMessage(null, validationException.getAssociatedMessage());
                }
                catch (Exception exception) {
                    ProjectUtils.reportError(this.getProject(), this.failonerror, Messages.getString("Error_during_validation_of__1") + this.src + ": " + exception.getMessage());
                }
            } else {
                ProjectUtils.reportError(this.getProject(), this.failonerror, Messages.getString("Specified_source_module_is_not_a_J2EE_Module___3") + this.src);
            }
            archive.close();
        }
        catch (OpenFailureException openFailureException) {
            ProjectUtils.reportError(this.getProject(), this.failonerror, Messages.getString(Messages.getString("Unable_to_open_source_module___4") + this.src + ": " + openFailureException.getMessage()));
        }
    }

    public void setSrc(String string) {
        this.src = string;
    }

    protected void validate(ModuleFile moduleFile, IReporter iReporter) throws ValidationException, Exception {
        if (moduleFile instanceof EARFile) {
            this.validateEARFile((EARFile)moduleFile, iReporter);
        } else if (moduleFile instanceof WARFile) {
            this.validateWARFile((WARFile)moduleFile, iReporter);
        } else if (moduleFile instanceof EJBJarFile) {
            this.validateEJBJarFile((EJBJarFile)moduleFile, iReporter);
        } else if (moduleFile instanceof ApplicationClientFile) {
            this.validateApplicationClientFile((ApplicationClientFile)moduleFile, iReporter);
        } else {
            throw new IllegalArgumentException();
        }
    }

    protected void validateEARFile(EARFile eARFile, IReporter iReporter) throws Exception {
        this.log(Messages.getString("Validating_EAR_File___6") + eARFile.getURI(), 2);
        Object object = new EarValidator();
        this.validate((EObject)eARFile, (IValidator)object, iReporter);
        object = new ApplicationExtensionValidator();
        ApplicationExtension applicationExtension = eARFile.getExtensions();
        this.validate((EObject)applicationExtension, (IValidator)object, iReporter);
        List list = eARFile.getEJBJarFiles();
        for (int i = 0; i < list.size(); ++i) {
            this.validateEJBJarFile((EJBJarFile)list.get(i), iReporter);
        }
        List list2 = eARFile.getWARFiles();
        for (int i = 0; i < list2.size(); ++i) {
            this.validateWARFile((WARFile)list2.get(i), iReporter);
        }
        List list3 = eARFile.getApplicationClientFiles();
        for (int i = 0; i < list3.size(); ++i) {
            this.validateApplicationClientFile((ApplicationClientFile)list3.get(i), iReporter);
        }
        this.log(Messages.getString("Finished_Validating_EAR_File___7") + eARFile.getURI(), 2);
    }

    protected void validateWARFile(WARFile wARFile, IReporter iReporter) throws Exception {
        Object object = null;
        try {
            this.log(Messages.getString("Validating_WAR_File___8") + wARFile.getURI(), 2);
            object = new WarValidator();
            this.validate((EObject)wARFile, (IValidator)object, iReporter);
            object = new WebAppExtensionValidator();
            WebAppExtension webAppExtension = wARFile.getExtensions();
            this.validate((EObject)webAppExtension, (IValidator)object, iReporter);
        }
        catch (ValidationException validationException) {
            this.addMessage((IValidator)object, validationException.getAssociatedMessage());
        }
        this.log(Messages.getString("Finished_Validating_WAR_File___9") + wARFile.getURI(), 2);
    }

    protected void validateEJBJarFile(EJBJarFile eJBJarFile, IReporter iReporter) throws Exception {
        Object object = null;
        try {
            this.log(Messages.getString("Validating_EJB_Jar_File___10") + eJBJarFile.getURI(), 2);
            object = new EJBValidator();
            EJBJar eJBJar = eJBJarFile.getDeploymentDescriptor();
            this.validate((EObject)eJBJar, (IValidator)object, iReporter);
            object = new EJBExtensionValidator();
            EJBJarExtension eJBJarExtension = eJBJarFile.getExtensions();
            this.validate((EObject)eJBJarExtension, (IValidator)object, iReporter);
        }
        catch (ValidationException validationException) {
            this.addMessage((IValidator)object, validationException.getAssociatedMessage());
        }
        this.log(Messages.getString("Finished_Validating_EJB_Jar_File___11") + eJBJarFile.getURI(), 2);
    }

    protected void validateApplicationClientFile(ApplicationClientFile applicationClientFile, IReporter iReporter) throws Exception {
        ApplicationClientValidator applicationClientValidator = null;
        try {
            this.log(Messages.getString("Validating_Application_Client_Jar_File___12") + applicationClientFile.getURI(), 2);
            applicationClientValidator = new ApplicationClientValidator();
            this.validate((EObject)applicationClientFile, (IValidator)applicationClientValidator, iReporter);
        }
        catch (ValidationException validationException) {
            this.addMessage((IValidator)applicationClientValidator, validationException.getAssociatedMessage());
        }
        this.log(Messages.getString("Finished_Validating_Application_Client_Jar_File___13") + applicationClientFile.getURI(), 2);
    }

    private void validate(EObject eObject, IValidator iValidator, IReporter iReporter) throws ValidationException {
        this.helper.setObject(eObject);
        this.launcher.start((IValidationContext)this.helper, iValidator, iReporter);
    }

    public void addMessage(IValidator iValidator, IMessage iMessage) throws MessageLimitException {
        if (iMessage.getSeverity() == 1) {
            ProjectUtils.reportError(this.getProject(), this.failonerror, iMessage.getText());
        } else if (iMessage.getSeverity() == 2) {
            this.log(iMessage.getText(), 1);
        } else {
            this.log(iMessage.getText(), 2);
        }
    }

    public void displaySubtask(IValidator iValidator, IMessage iMessage) {
        this.addMessage(iValidator, iMessage);
    }

    public IMessageAccess getMessageAccess() {
        return null;
    }

    public boolean isCancelled() {
        return false;
    }

    public void removeAllMessages(IValidator iValidator, Object object) {
    }

    public void removeAllMessages(IValidator iValidator) {
    }

    public void removeMessageSubset(IValidator iValidator, Object object, String string) {
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public List getMessages() {
        return null;
    }
}

