/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.websphere.ant.tasks.Messages;
import com.ibm.ws.ant.utils.ProjectUtils;
import com.ibm.ws.profile.wsadmin.WsProfileAdminRequester;
import com.ibm.ws.scripting.WasxShell;
import java.util.ArrayList;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Commandline;
import org.apache.tools.ant.types.CommandlineJava;
import org.apache.tools.ant.types.Path;

public class WsAdminInProcess
extends Task {
    private static WasxShell wsadmin = null;
    private String wasHome = null;
    private String command = null;
    private String properties = null;
    private String profile = null;
    private String script = null;
    private String lang = null;
    private String profileName = null;
    private String conntype = null;
    private String host = null;
    private String port = null;
    private String user = null;
    private String password = null;
    private String tracefile = null;
    private Boolean appendtrace = null;
    private Commandline arguments = new Commandline();
    private Commandline commands = new Commandline();
    private String[] commandArgs = null;
    private CommandlineJava cmdlJava = new CommandlineJava();
    private Path wsadmin_classpath;
    private boolean reuse = true;
    private boolean failonerror = false;
    private boolean debug = false;
    private String ipcFilename = null;
    private static final String TRACE_PROP = "com.ibm.ws.scripting.traceString";
    private String localNode = null;
    private String localCell = null;
    private String userInstallRoot = null;
    private String wasInstallRoot = null;
    private String wasRepositoryRoot = null;
    private String wsadminProps = null;
    private String traceString = null;

    protected void validateAttributes() throws BuildException {
        if (this.commandArgs.length == 0 && this.command == null && this.script == null) {
            throw new BuildException(Messages.getString("Either_the_command_or_script_attribute_must_be_specified._1"));
        }
        if ((this.commandArgs.length > 0 || this.command != null) && this.script != null) {
            throw new BuildException(Messages.getString("The_command_and_script_attributes_cannot_be_specified_at_the_same_time._2"));
        }
        if ((this.host != null || this.port != null) && this.conntype == null) {
            throw new BuildException(Messages.getString("The_host/port_attributes_are_only_applicable_if_the_conntype_attribute_is_set._3"));
        }
        if (this.user == null && this.password != null || this.user != null && this.password == null) {
            throw new BuildException(Messages.getString("If_one_of_userid_or_password_is_specified,_both_attributes_must_be_specified._4"));
        }
        if (!(this.conntype == null || this.conntype.equalsIgnoreCase("SOAP") || this.conntype.equalsIgnoreCase("RMI") || this.conntype.equalsIgnoreCase("JMS") || this.conntype.equalsIgnoreCase("NONE"))) {
            throw new BuildException(Messages.getString("The_valid_values_for_the_conntype_attribute_are_SOAP,_RMI,_JMS,_or_NONE._9"));
        }
    }

    public void execute() throws BuildException {
        block35: {
            int n;
            this.commandArgs = this.commands.getArguments();
            try {
                this.validateAttributes();
            }
            catch (BuildException buildException) {
                if (this.failonerror) {
                    throw buildException;
                }
                this.getProject().log(buildException.getMessage(), 0);
                return;
            }
            if (this.localNode != null) {
                this.log("replacing value for local.node (" + System.getProperty("local.node") + ") with (" + this.localNode + ")");
                System.setProperty("local.node", this.localNode);
            }
            if (this.localCell != null) {
                this.log("replacing value for local.cell (" + System.getProperty("local.cell") + ") with (" + this.localCell + ")");
                System.setProperty("local.cell", this.localCell);
            }
            if (this.userInstallRoot != null) {
                this.log("replacing value for user.install.root (" + System.getProperty("user.install.root") + ") with (" + this.userInstallRoot + ")");
                System.setProperty("user.install.root", this.userInstallRoot);
            }
            if (this.wasInstallRoot != null) {
                this.log("replacing value for was.install.root (" + System.getProperty("was.install.root") + ") with (" + this.wasInstallRoot + ")");
                System.setProperty("was.install.root", this.wasInstallRoot);
            }
            if (this.wasRepositoryRoot != null) {
                this.log("replacing value for was.repository.root (" + System.getProperty("was.repository.root") + ") with (" + this.wasRepositoryRoot + ")");
                System.setProperty("was.repository.root", this.wasRepositoryRoot);
            }
            if (this.wsadminProps != null) {
                this.log("replacing value for com.ibm.ws.scripting.wsadminprops (" + System.getProperty("com.ibm.ws.scripting.wsadminprops") + ") with (" + this.wsadminProps + ")");
                System.setProperty("com.ibm.ws.scripting.wsadminprops", this.wsadminProps);
            }
            if (this.traceString != null) {
                this.log("replacing value for com.ibm.ws.scripting.traceString (" + System.getProperty(TRACE_PROP) + ") with (" + this.traceString + ")");
                System.setProperty(TRACE_PROP, this.traceString);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            if (this.command != null) {
                arrayList.add("-c");
                arrayList.add(this.command.toString());
            }
            for (int i = 0; i < this.commandArgs.length; ++i) {
                arrayList.add("-c");
                arrayList.add(this.commandArgs[i]);
            }
            if (this.properties != null && !this.properties.equals("")) {
                arrayList.add("-p");
                arrayList.add(this.properties.toString());
            }
            if (this.profile != null && !this.profile.equals("")) {
                arrayList.add("-profile");
                arrayList.add(this.profile.toString());
            }
            if (this.script != null) {
                arrayList.add("-f");
                arrayList.add(this.script.toString());
            }
            if (this.lang != null && !this.lang.equals("")) {
                arrayList.add("-lang");
                arrayList.add(this.lang.toString());
            }
            this.wsadmin_classpath = this.cmdlJava.getClasspath();
            if (this.wsadmin_classpath != null) {
                arrayList.add("-wsadmin_classpath");
                arrayList.add(this.wsadmin_classpath.toString());
            }
            if (this.profileName != null && !this.profileName.equals("")) {
                arrayList.add("-profileName");
                arrayList.add(this.profileName.toString());
            }
            if (this.conntype != null && !this.conntype.equals("")) {
                arrayList.add("-conntype");
                arrayList.add(this.conntype.toString());
                if (this.host != null && !this.host.equals("")) {
                    arrayList.add("-host");
                    arrayList.add(this.host.toString());
                }
                if (this.port != null && !this.port.equals("")) {
                    arrayList.add("-port");
                    arrayList.add(this.port.toString());
                }
            }
            if (this.user != null && !this.user.equals("")) {
                arrayList.add("-user");
                arrayList.add(this.user.toString());
            }
            if (this.password != null && !this.password.equals("")) {
                arrayList.add("-password");
                arrayList.add(this.password.toString());
            }
            if (this.tracefile != null && !this.tracefile.equals("")) {
                arrayList.add("-tracefile");
                arrayList.add(this.tracefile.toString());
            }
            if (this.appendtrace != null && !this.appendtrace.equals("")) {
                arrayList.add("-appendtrace");
                arrayList.add(this.appendtrace.toString());
            }
            String[] stringArray = this.arguments.getArguments();
            for (int i = 0; i < stringArray.length; ++i) {
                arrayList.add(stringArray[i]);
            }
            String[] stringArray2 = arrayList.toArray(new String[arrayList.size()]);
            if (this.isDebug()) {
                for (n = 0; n < stringArray2.length; ++n) {
                    this.log("- debug cmd arg > " + stringArray2[n]);
                }
            }
            try {
                n = 0;
                if (this.ipcFilename == null) {
                    if (wsadmin == null || !this.reuse) {
                        wsadmin = new WasxShell();
                    }
                    wsadmin.run(stringArray2);
                    n = wsadmin.getReturnCode();
                } else {
                    n = WsProfileAdminRequester.sendWsAdminRequest(stringArray2, this.ipcFilename);
                }
                if (n == 0 || n == 101) {
                    this.log("Task completed successfully");
                } else {
                    ProjectUtils.reportError(this.getProject(), this.failonerror, Messages.getString("Wsadmin_task_failed_with_return_code") + n);
                }
            }
            catch (Throwable throwable) {
                this.log("wsadmin failed with exception = " + throwable);
                if (!this.failonerror) break block35;
                throwable.printStackTrace();
                throw new BuildException(throwable);
            }
        }
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String string) {
        this.command = string;
    }

    public String getConntype() {
        return this.conntype;
    }

    public void setConntype(String string) {
        this.conntype = string;
    }

    public boolean isFailonerror() {
        return this.failonerror;
    }

    public void setFailonerror(boolean bl) {
        this.failonerror = bl;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String string) {
        this.host = string;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String string) {
        this.lang = string;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String string) {
        this.port = string;
    }

    public String getProfile() {
        return this.profile;
    }

    public void setProfile(String string) {
        this.profile = string;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String string) {
        this.profileName = string;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String string) {
        this.properties = string;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String string) {
        this.script = string;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String string) {
        this.user = string;
    }

    public String getWasHome() {
        return this.wasHome;
    }

    public void setWasHome(String string) {
        this.wasHome = string;
    }

    public boolean isReuse() {
        return this.reuse;
    }

    public void setReuse(boolean bl) {
        this.reuse = bl;
    }

    public Commandline.Argument createArg() {
        return this.arguments.createArgument();
    }

    public Commandline.Argument createCommand() {
        return this.commands.createArgument();
    }

    public Path createWsadmin_classpath() {
        return this.cmdlJava.createClasspath(this.getProject()).createPath();
    }

    public void setTracefile(String string) {
        this.tracefile = string;
    }

    public void setAppendtrace(Boolean bl) {
        this.appendtrace = bl;
    }

    public void setLocalCell(String string) {
        this.localCell = string;
    }

    public void setLocalNode(String string) {
        this.localNode = string;
    }

    public void setUserInstallRoot(String string) {
        this.userInstallRoot = string;
    }

    public void setWasInstallRoot(String string) {
        this.wasInstallRoot = string;
    }

    public void setWasRepositoryRoot(String string) {
        this.wasRepositoryRoot = string;
    }

    public void setWsadminProps(String string) {
        this.wsadminProps = string;
    }

    public void setTraceString(String string) {
        this.traceString = string;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean bl) {
        this.debug = bl;
    }

    public String getIpcFilename() {
        return this.ipcFilename;
    }

    public void setIpcFilename(String string) {
        this.ipcFilename = string;
    }
}

