/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ant.tasks;

import com.ibm.ws.ant.utils.OsUtils;
import com.ibm.ws.ant.utils.WebSpherePumpStreamHandler;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.taskdefs.ExecTask;
import org.apache.tools.ant.taskdefs.Execute;
import org.apache.tools.ant.taskdefs.ExecuteStreamHandler;
import org.apache.tools.ant.taskdefs.LogOutputStream;
import org.apache.tools.ant.taskdefs.condition.Os;
import org.apache.tools.ant.util.StringUtils;

public class ZOSExecTask
extends ExecTask {
    protected static String encoding = OsUtils.getPlatform() == 3 ? "ISO-8859-1" : null;
    protected ByteArrayOutputStream baos = null;
    private File out;
    private String outputprop;
    private FileOutputStream fos = null;
    private boolean append = false;

    public void setOutput(File file) {
        this.out = file;
        super.setOutput(file);
    }

    public void setOutputproperty(String string) {
        this.outputprop = string;
        super.setOutputproperty(string);
    }

    public void setOutputEncoding(String string) {
        encoding = string;
    }

    public String getOutputEncoding() {
        return encoding;
    }

    protected ExecuteStreamHandler createHandler() throws BuildException {
        try {
            if (this.out != null) {
                try {
                    this.fos = new FileOutputStream(this.out, this.append);
                    this.log("Output redirected to " + this.out, 3);
                    return new WebSpherePumpStreamHandler((OutputStream)this.fos, encoding);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new BuildException("Cannot write to " + this.out, (Throwable)fileNotFoundException, this.location);
                }
                catch (IOException iOException) {
                    throw new BuildException("Cannot write to " + this.out, (Throwable)iOException, this.location);
                }
            }
            if (this.outputprop != null) {
                this.baos = new ByteArrayOutputStream();
                this.log("Output redirected to ByteArray", 3);
                return new WebSpherePumpStreamHandler((OutputStream)this.baos, encoding);
            }
            return new WebSpherePumpStreamHandler((OutputStream)new LogOutputStream((Task)this, 2), (OutputStream)new LogOutputStream((Task)this, 1));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new BuildException((Throwable)unsupportedEncodingException);
        }
    }

    protected void runWASExecute(Execute execute) throws IOException {
        int n = -1;
        n = execute.execute();
        if (execute.killedProcess()) {
            this.log("Timeout: killed the sub-process", 1);
        }
        this.maybeSetResultPropertyValue(n);
        if (n != 0) {
            if (this.failOnError) {
                throw new BuildException(this.taskType + " returned: " + n, this.location);
            }
            this.log("Result: " + n, 0);
        }
        if (this.baos != null) {
            BufferedReader bufferedReader = new BufferedReader(new StringReader(ZOSExecTask.toString(this.baos)));
            String string = null;
            StringBuffer stringBuffer = new StringBuffer();
            while ((string = bufferedReader.readLine()) != null) {
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(StringUtils.LINE_SEP);
                }
                stringBuffer.append(string);
            }
            this.project.setProperty(this.outputprop, stringBuffer.toString());
        }
    }

    public static String toString(ByteArrayOutputStream byteArrayOutputStream) {
        if (Os.isFamily((String)"z/os")) {
            try {
                return byteArrayOutputStream.toString(WebSpherePumpStreamHandler.getEncoding());
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return byteArrayOutputStream.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runExec(Execute execute) throws BuildException {
        this.log("Running with WAS Exec", 3);
        this.log(this.cmdl.describeCommand(), 3);
        execute.setCommandline(this.cmdl.getCommandline());
        try {
            if (encoding != null && !encoding.equals("")) {
                this.runWASExecute(execute);
            } else {
                this.runExecute(execute);
            }
        }
        catch (IOException iOException) {
            this.log("Execute failed: " + iOException.toString(), 0);
        }
        finally {
            this.logFlush();
        }
    }

    protected void logFlush() {
        try {
            if (this.fos != null) {
                this.fos.close();
            }
            if (this.baos != null) {
                this.baos.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setAppend(boolean bl) {
        this.append = bl;
    }
}

