/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.asynchbeans;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.asynchbeans.EventSource;
import com.ibm.websphere.asynchbeans.EventSourceEvents;
import com.ibm.websphere.asynchbeans.Work;
import com.ibm.websphere.asynchbeans.WorkException;
import com.ibm.ws.asynchbeans.AsynchContextDescriptor;
import com.ibm.ws.asynchbeans.J2EEContext;
import com.ibm.ws.asynchbeans.J2EEServiceManager;
import com.ibm.ws.asynchbeans.util.AsynchBeanUtil;
import com.ibm.ws.ffdc.FFDCFilter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.HashSet;

public abstract class JMXBroadcaster
implements EventSource {
    private static final transient TraceComponent tc = Tr.register(JMXBroadcaster.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private static final transient TraceComponent tc_trip = Tr.register(JMXListenerTriple.class, "AsynchBeans", "com.ibm.ws.asynchbeans.AsynchBeansMessages");
    private ArrayList[] sequenceList;
    protected AsynchContextDescriptor contextDescriptor;
    private EventSource eventSource;
    private boolean destroyed;

    public void setAsynchContext(EventSource eventSource, AsynchContextDescriptor asynchContextDescriptor) {
        this.eventSource = eventSource;
        this.contextDescriptor = asynchContextDescriptor;
    }

    public synchronized int getNumListeners() {
        int n = 0;
        for (int i = 0; i < this.sequenceList.length; ++i) {
            n += this.sequenceList[i] != null ? this.sequenceList[i].size() : 0;
        }
        return n;
    }

    public JMXBroadcaster(EventSource eventSource, AsynchContextDescriptor asynchContextDescriptor) {
        this.initConstructor(eventSource, asynchContextDescriptor);
    }

    private final void initConstructor(EventSource eventSource, AsynchContextDescriptor asynchContextDescriptor) {
        this.eventSource = eventSource;
        this.contextDescriptor = asynchContextDescriptor;
        this.sequenceList = new ArrayList[10];
        for (int i = 0; i < this.sequenceList.length; ++i) {
            this.sequenceList[i] = new ArrayList(10);
        }
        this.setDestroyed(false);
    }

    public void destroy() {
        this.sequenceList = null;
        this.setDestroyed(true);
    }

    public void addListener(Object object) {
        this.addListener(object, 5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Object object, int n) {
        J2EEServiceManager.checkValidAsyncBean(object);
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "addListener", new Object[]{object});
        }
        if (n < 0 || n > 9) {
            throw new IllegalArgumentException("Listener Sequence number out of range, 0..9");
        }
        try {
            if (this.getDestroyed()) {
                throw new IllegalStateException("JMXBroadcaster has been destroyed");
            }
            int n2 = 0;
            Object object2 = this;
            synchronized (object2) {
                if (object == null) {
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Listener is null");
                    FFDCFilter.processException((Throwable)illegalArgumentException, "com.ibm.websphere.asynchbeans.JMXBroadcaster.addListener", "198", this);
                    throw illegalArgumentException;
                }
                this.sequenceList[n].add(new JMXListenerTriple(object));
                n2 = this.getNumListeners();
            }
            object2 = (EventSourceEvents)this.getEventTrigger(EventSourceEvents.class, false);
            object2.listenerCountChanged(this, n2 - 1, n2);
        }
        finally {
            if (bl) {
                Tr.exit(tc, "addListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Object object) {
        boolean bl = tc.isEntryEnabled();
        if (bl) {
            Tr.entry(tc, "removeListener", new Object[]{object});
        }
        try {
            boolean bl2 = false;
            int n = -1;
            int n2 = -1;
            Object object2 = this;
            synchronized (object2) {
                if (this.sequenceList != null) {
                    n = this.getNumListeners();
                    for (int i = 0; i < this.sequenceList.length; ++i) {
                        ArrayList arrayList = this.sequenceList[i];
                        for (int j = 0; j < arrayList.size(); ++j) {
                            JMXListenerTriple jMXListenerTriple = (JMXListenerTriple)arrayList.get(j);
                            if (jMXListenerTriple.listener != object) continue;
                            arrayList.remove(jMXListenerTriple);
                            --j;
                            bl2 = true;
                        }
                    }
                    n2 = this.getNumListeners();
                }
            }
            if (bl2) {
                object2 = (EventSourceEvents)this.getEventTrigger(EventSourceEvents.class, false);
                object2.listenerCountChanged(this, n, n2);
            } else if (tc.isEventEnabled()) {
                Tr.info(tc, "MSG_INFO_LISTENER_NOT_FOUND", new Object[]{object, this});
            }
        }
        finally {
            if (bl) {
                Tr.exit(tc, "removeListener");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object fireEvent(Class clazz, boolean bl, Method method2, Object[] objectArray) {
        boolean bl2 = tc.isEntryEnabled();
        boolean bl3 = tc.isDebugEnabled();
        if (bl2) {
            Tr.entry(tc, "fireEvent");
        }
        Object object = null;
        if (bl3) {
            Tr.debug(tc, "Firing event: " + clazz.getName() + "." + method2.getName(), objectArray);
        }
        try {
            ArrayList arrayList = null;
            for (int i = 9; i >= 0; --i) {
                JMXListenerTriple[] jMXListenerTripleArray = null;
                JMXBroadcaster jMXBroadcaster = this;
                synchronized (jMXBroadcaster) {
                    if (this.sequenceList == null) {
                        break;
                    }
                    arrayList = this.sequenceList[i];
                    jMXListenerTripleArray = new JMXListenerTriple[arrayList.size()];
                    arrayList.toArray(jMXListenerTripleArray);
                }
                if (bl3 && jMXListenerTripleArray.length > 0) {
                    Tr.debug(tc, "Firing listeners at sequence #" + i);
                }
                for (int j = 0; j < jMXListenerTripleArray.length; ++j) {
                    JMXListenerTriple jMXListenerTriple = jMXListenerTripleArray[j];
                    if (!jMXListenerTriple.isThisType(clazz)) continue;
                    if (bl3) {
                        Tr.debug(tc, "Firing event for listener " + jMXListenerTriple.listener + ": " + clazz.getName() + "." + method2.getName(), objectArray);
                    }
                    Object object2 = jMXListenerTriple.fireEvent(clazz, bl, method2, objectArray);
                    object = object != null ? object : object2;
                }
            }
        }
        finally {
            if (bl2) {
                Tr.exit(tc, "fireEvent");
            }
        }
        return object;
    }

    public Object getEventTrigger(Class clazz, boolean bl) {
        Class[] classArray = new Class[]{clazz};
        return Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new TriggerProxy(clazz, bl));
    }

    public Object getEventTrigger(Class clazz) {
        Class[] classArray = new Class[]{clazz};
        return Proxy.newProxyInstance(clazz.getClassLoader(), classArray, (InvocationHandler)new TriggerProxy(clazz, false));
    }

    private synchronized void setDestroyed(boolean bl) {
        this.destroyed = bl;
    }

    private synchronized boolean getDestroyed() {
        return this.destroyed;
    }

    class TriggerProxy
    implements InvocationHandler {
        Class desiredInterface;
        boolean sameTransaction;

        TriggerProxy(Class clazz, boolean bl) {
            this.sameTransaction = bl;
            this.desiredInterface = clazz;
        }

        public Object invoke(Object object, Method method2, Object[] objectArray) {
            return JMXBroadcaster.this.fireEvent(this.desiredInterface, this.sameTransaction, method2, objectArray);
        }
    }

    private class JMXListenerTriple
    implements Work {
        public Object listener;
        J2EEContext callerContext;
        J2EEContext callerContextFlowJTA;
        Class desiredInterface;
        Method m;
        Object[] args;
        Object result;
        Throwable curException;

        public JMXListenerTriple(Object object) {
            this.listener = object;
            this.callerContext = J2EEServiceManager.getSelf().peek(JMXBroadcaster.this.contextDescriptor, null, AsynchBeanUtil.isAsynchBeanEJB(object), 1280, 0);
            this.callerContextFlowJTA = new J2EEContext(this.callerContext);
            HashSet<String> hashSet = new HashSet<String>();
            hashSet.add("JTA");
            this.callerContextFlowJTA.setServiceExcludeList(hashSet);
        }

        boolean isThisType(Class clazz) {
            return clazz.isInstance(this.listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized Object fireEvent(Class clazz, boolean bl, Method method2, Object[] objectArray) {
            boolean bl2 = tc_trip.isEntryEnabled();
            if (bl2) {
                Tr.entry(tc_trip, "fireEvent");
            }
            this.m = method2;
            this.desiredInterface = clazz;
            this.args = objectArray;
            try {
                J2EEContext j2EEContext = bl ? this.callerContextFlowJTA : this.callerContext;
                this.curException = null;
                WorkException workException = j2EEContext.run(JMXBroadcaster.this.eventSource, JMXBroadcaster.this.contextDescriptor, this, null, this.callerContext, null, null, 48, 0);
                if (workException != null) {
                    throw workException;
                }
                if (this.curException != null) {
                    throw this.curException;
                }
            }
            catch (Throwable throwable) {
                if (!clazz.equals(class$com$ibm$websphere$asynchbeans$EventSourceEvents == null ? (class$com$ibm$websphere$asynchbeans$EventSourceEvents = JMXBroadcaster.class$("com.ibm.websphere.asynchbeans.EventSourceEvents")) : class$com$ibm$websphere$asynchbeans$EventSourceEvents) || !method2.getName().equals("listenerExceptionThrown")) {
                    EventSourceEvents eventSourceEvents = (EventSourceEvents)JMXBroadcaster.this.getEventTrigger(class$com$ibm$websphere$asynchbeans$EventSourceEvents == null ? (class$com$ibm$websphere$asynchbeans$EventSourceEvents = JMXBroadcaster.class$("com.ibm.websphere.asynchbeans.EventSourceEvents")) : class$com$ibm$websphere$asynchbeans$EventSourceEvents, false);
                    eventSourceEvents.listenerExceptionThrown(JMXBroadcaster.this, this.listener, method2.getName(), throwable);
                }
                FFDCFilter.processException(throwable, "com.ibm.websphere.asynchbeans.JMXBroadcaster.JMXListenerTriple.fireEvent", "117", this);
            }
            finally {
                if (bl2) {
                    Tr.exit(tc_trip, "fireEvent");
                }
            }
            return this.result;
        }

        public void run() {
            try {
                this.result = this.m.invoke(this.listener, this.args);
            }
            catch (InvocationTargetException invocationTargetException) {
                FFDCFilter.processException((Throwable)invocationTargetException, "com.ibm.websphere.asynchbeans.JMXBroadcaster.JMXListenerTriple.run", "139", this);
                this.curException = invocationTargetException.getTargetException();
            }
            catch (IllegalAccessException illegalAccessException) {
                FFDCFilter.processException((Throwable)illegalAccessException, "com.ibm.websphere.asynchbeans.JMXBroadcaster.JMXListenerTriple.run", "143", this);
                this.curException = illegalAccessException;
            }
        }

        public void release() {
        }
    }
}

