/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.client.applicationclient;

import com.ibm.websphere.client.applicationclient.ClientLauncherHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class ClientLauncherHelperFactory {
    private static final String PROPERTY_BOOTCLASSPATH = "com.ibm.websphere.client.launcher.bootClassPath";
    private static final String PROPERTY_BOOTCLASSPATH_SPECIAL = "com.ibm.websphere.client.launcher.bootClassPathSpecial";
    private static final String PROPERTY_EXT_DIRS = "com.ibm.websphere.client.launcher.extDirs";
    private static final String PROPERTY_CLASSPATH = "com.ibm.websphere.client.launcher.classPath";
    private static final String PROPERTY_JAVA_LIBRARY_PATH = "com.ibm.websphere.client.launcher.java.library.path";
    private static final String PROPERTY_OPTIONS = "com.ibm.websphere.client.launcher.option";
    private static final String VARIABLE_WASHOME = "\\$\\{WAS_ROOT\\}";
    private static final String VARIABLE_USERHOME = "\\$\\{USER_ROOT\\}";
    private static final String SUN_OS_NAME = "SunOS";
    private static final String HP_OS_NAME = "HP-UX";

    private static void trace(String string) {
        System.out.println("ClientLauncherHelperFactory - " + string);
    }

    static void getPropertiesFromFile(String string, Properties properties) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream(string);
        if (inputStream == null) {
            String string2 = "File not found: " + string;
            ClientLauncherHelperFactory.trace(string2);
            throw new RuntimeException(string2);
        }
        properties.load(inputStream);
        inputStream.close();
    }

    private static List getProperties(String string, String string2, Properties properties) {
        String string3;
        String string4 = string2 + ".";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string3 = (String)properties.get(string4 + n)) != null) {
            if (!(string3 = string3.replace('\\', '/')).startsWith("/")) {
                string3 = "/" + string3;
            }
            string3 = string + string3;
            arrayList.add(string3.replace('/', File.separatorChar));
            ++n;
        }
        return arrayList;
    }

    public static String doSubstitutions(String string, String string2) {
        return ClientLauncherHelperFactory.doSubstitutions(string, string, string2);
    }

    public static String doSubstitutions(String string, String string2, String string3) {
        string3 = string3.replaceAll(VARIABLE_WASHOME, string);
        string3 = string3.replaceAll(VARIABLE_USERHOME, string2);
        return string3;
    }

    private static List getOptionProperties(String string, String string2, String string3, Properties properties) {
        String string4;
        String string5 = string3 + ".";
        ArrayList<String> arrayList = new ArrayList<String>();
        int n = 1;
        while ((string4 = (String)properties.get(string5 + n)) != null) {
            string4 = ClientLauncherHelperFactory.doSubstitutions(string, string2, string4);
            arrayList.add(string4);
            ++n;
        }
        return arrayList;
    }

    private static boolean isSpecial() {
        String string = System.getProperty("os.name");
        boolean bl = string != null && (string.startsWith(HP_OS_NAME) || string.startsWith(SUN_OS_NAME));
        return bl;
    }

    public static ClientLauncherHelper getClientLauncherHelper(String string) throws FileNotFoundException, IOException {
        return new J2EEClientLauncherHelper(string);
    }

    public static ClientLauncherHelper getClientLauncherHelper(String string, String string2) throws FileNotFoundException, IOException {
        return new J2EEClientLauncherHelper(string, string2);
    }

    public static ClientLauncherHelper getClientLauncherHelper(String string, String string2, String string3) throws FileNotFoundException, IOException {
        return new J2EEClientLauncherHelper(string, string2, string3);
    }

    private static void printAll(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            System.out.println(stringArray[i]);
        }
        System.out.println("-----------");
    }

    public static void main(String[] stringArray) {
        try {
            ClientLauncherHelper clientLauncherHelper = ClientLauncherHelperFactory.getClientLauncherHelper(stringArray[0], stringArray[1]);
            ClientLauncherHelperFactory.printAll(clientLauncherHelper.getExtDirs());
            ClientLauncherHelperFactory.printAll(clientLauncherHelper.getClasspathEntries());
            ClientLauncherHelperFactory.printAll(clientLauncherHelper.getVMArguments());
            System.out.println(clientLauncherHelper.getJavaLibraryPath());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private static class J2EEClientLauncherHelper
    implements ClientLauncherHelper {
        private String _wasHome;
        private String _profileHome;
        private Properties _properties = new Properties();
        private static final String OSGI_DEBUG = "com.ibm.websphere.client.launcher.ClientLaunch.ogsidebug";
        private static final String[] MAIN_CLASS_NAME = new String[]{"com.ibm.wsspi.bootstrap.WSPreLauncher", "-nosplash", "-noExit", "-application", "com.ibm.ws.bootstrap.WSLauncher", "com.ibm.ws.runtime.LaunchClient"};
        private static final String[] DEBUG_MAIN_CLASS_NAME = new String[]{"com.ibm.wsspi.bootstrap.WSPreLauncher", "-debug", "-nosplash", "-noExit", "-application", "com.ibm.ws.bootstrap.WSLauncher", "com.ibm.ws.runtime.LaunchClient"};
        private static final String DEFAULT_PROPERTIES_FILE_NAME = "com/ibm/websphere/client/applicationclient/clientLauncherHelper.properties";

        J2EEClientLauncherHelper(String string) throws FileNotFoundException, IOException {
            this(string, string, DEFAULT_PROPERTIES_FILE_NAME);
        }

        J2EEClientLauncherHelper(String string, String string2) throws FileNotFoundException, IOException {
            this(string, string2, DEFAULT_PROPERTIES_FILE_NAME);
        }

        J2EEClientLauncherHelper(String string, String string2, String string3) throws FileNotFoundException, IOException {
            this._wasHome = string.replace('\\', '/');
            this._profileHome = string2.replace('\\', '/');
            ClientLauncherHelperFactory.getPropertiesFromFile(string3, this._properties);
        }

        public String[] getBootstrapClasspathEntries() {
            List list = ClientLauncherHelperFactory.getProperties(this._wasHome, ClientLauncherHelperFactory.PROPERTY_BOOTCLASSPATH, this._properties);
            if (ClientLauncherHelperFactory.isSpecial()) {
                List list2 = ClientLauncherHelperFactory.getProperties(this._wasHome, ClientLauncherHelperFactory.PROPERTY_BOOTCLASSPATH_SPECIAL, this._properties);
                if (list == null) {
                    list = list2;
                } else if (list2 != null) {
                    list.addAll(list2);
                }
            }
            return list.toArray(new String[list.size()]);
        }

        public String[] getExtDirs() {
            List list = ClientLauncherHelperFactory.getProperties(this._wasHome, ClientLauncherHelperFactory.PROPERTY_EXT_DIRS, this._properties);
            return list.toArray(new String[list.size()]);
        }

        public String getJavaLibraryPath() {
            List list = ClientLauncherHelperFactory.getProperties(this._wasHome, ClientLauncherHelperFactory.PROPERTY_JAVA_LIBRARY_PATH, this._properties);
            String string = null;
            if (!list.isEmpty()) {
                StringBuffer stringBuffer = new StringBuffer("-Djava.library.path=").append(list.get(0));
                for (int i = 1; i < list.size(); ++i) {
                    String string2 = (String)list.get(i);
                    stringBuffer.append(File.pathSeparatorChar).append(string2);
                }
                if (System.getProperty("java.library.path") != null) {
                    stringBuffer.append(File.pathSeparatorChar).append(System.getProperty("java.library.path").replaceAll("\"", ""));
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public String[] getMainClassName() {
            if (System.getProperty(OSGI_DEBUG) == null) {
                return MAIN_CLASS_NAME;
            }
            return DEBUG_MAIN_CLASS_NAME;
        }

        public String[] getVMArguments() {
            List list = ClientLauncherHelperFactory.getOptionProperties(this._wasHome, this._profileHome, ClientLauncherHelperFactory.PROPERTY_OPTIONS, this._properties);
            return list.toArray(new String[list.size()]);
        }

        public String[] getClasspathEntries() {
            List list = ClientLauncherHelperFactory.getProperties(this._wasHome, ClientLauncherHelperFactory.PROPERTY_CLASSPATH, this._properties);
            if (!this._wasHome.equals(this._profileHome)) {
                String string = this._profileHome.replace('/', File.separatorChar) + File.separatorChar + "properties";
                list.add(0, string);
            }
            return list.toArray(new String[list.size()]);
        }
    }
}

