/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.client.applicationclient;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.RARFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.client.applicationclient.ClientRARException;
import com.ibm.ws.client.applicationclient.Utility;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.OpenFailureException;
import org.eclipse.jst.j2ee.commonarchivecore.internal.exception.SaveFailureException;
import org.eclipse.jst.j2ee.jca.OutboundResourceAdapter;

public class ClientRAR {
    private static final String _sourceInfo = "SERV1/ws/code/client/src/com/ibm/websphere/client/applicationclient/ClientRAR.java, WAS.client, WAS61.SERV1, cf311012.09, ver. 1.5";
    private static final String ADD_TASK = "add";
    private static final String DELETE_TASK = "delete";
    private static final String CR_ARG_PREFIX = "-CR";
    private static final String USER_INSTALLED_COLLECTORS = "-CRDcom.ibm.ws.client.installedConnectors";
    private static final String TRACE_SETTINGS_FILE = "-CRDtraceSettingsFile";
    private static final boolean ERROR_FLAG = true;
    private static TraceComponent tc;

    private static void _extractArchive(String string, String string2, String string3) throws ClientRARException, OpenFailureException, SaveFailureException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "extractArchive: " + string);
        }
        ArchiveInit.init();
        CommonarchiveFactory commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
        String string4 = string.replace('\\', '/');
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ArchivePath: " + string4);
        }
        Archive archive = commonarchiveFactory.openArchive(string4);
        RARFile rARFile = commonarchiveFactory.openRARFile(string4);
        int n = rARFile.getSpecVersionID();
        if (n != 15) {
            throw new ClientRARException("rar.badjca", "");
        }
        OutboundResourceAdapter outboundResourceAdapter = rARFile.getDeploymentDescriptor().getResourceAdapter().getOutboundResourceAdapter();
        if (outboundResourceAdapter == null) {
            throw new ClientRARException("rar.nooutbound", "");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Archive: " + archive);
        }
        if (archive != null) {
            string4 = string2.replace('/', File.separatorChar);
            File file = new File(string4);
            if (!file.exists() || !file.isDirectory()) {
                throw new ClientRARException("rar.extracterror", string4);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Dest: " + string4);
            }
            archive.extractTo(string4 + string3, 0);
            archive.close();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "extractArchive");
        }
    }

    public static void installRAR(String string, String string2, String string3) throws ClientRARException, OpenFailureException, SaveFailureException {
        ClientRAR._extractArchive(string, string2, string3);
    }

    private static boolean deleteDir(File file) {
        boolean bl = !file.isDirectory() || !file.exists() ? false : ClientRAR.deleteDirOrFile(file);
        return bl;
    }

    private static boolean deleteDirOrFile(File file) {
        if (file.isDirectory()) {
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                boolean bl = ClientRAR.deleteDirOrFile(new File(file, stringArray[i]));
                if (bl) continue;
                return false;
            }
        }
        return file.delete();
    }

    public static boolean uninstallRAR(String string, String string2) {
        String string3 = string2 + string;
        File file = new File(string3);
        return ClientRAR.deleteDir(file);
    }

    private static boolean processParameters(String[] stringArray, List list, List list2) {
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            bl = false;
            String string = stringArray[i];
            if (string.equals("-help") || string.equals("-?")) {
                bl = true;
                break;
            }
            if (string.startsWith(CR_ARG_PREFIX)) {
                if (string.startsWith(USER_INSTALLED_COLLECTORS)) {
                    list2.add(string.substring(USER_INSTALLED_COLLECTORS.length() + 1));
                }
                if (!string.startsWith(TRACE_SETTINGS_FILE)) continue;
                System.setProperty("traceSettingsFile", string.substring(TRACE_SETTINGS_FILE.length() + 1));
                continue;
            }
            list.add(string);
        }
        return bl;
    }

    private static void usage(boolean bl) {
        if (bl) {
            Utility.printWarning(Utility.getMessage("clientRAR.usage"));
        } else {
            Utility.printMessage(Utility.getMessage("clientRAR.usage"));
        }
    }

    public static void main(String[] stringArray) {
        String string = null;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        boolean bl = ClientRAR.processParameters(stringArray, arrayList, arrayList2);
        tc = Tr.register(ClientRAR.class, null, "com.ibm.ws.client.applicationclient.ResourceBundle");
        string = arrayList2.size() == 1 ? (String)arrayList2.get(0) : System.getProperty("com.ibm.ws.client.installedConnectors");
        if (!(string = string.replace('\\', '/')).endsWith("/")) {
            string = string + '/';
        }
        if (bl || arrayList.size() != 2 || string == null) {
            ClientRAR.usage(!bl);
        } else {
            String string2 = (String)arrayList.get(0);
            String string3 = (String)arrayList.get(1);
            try {
                if (string2.equals(ADD_TASK)) {
                    int n = (string3 = string3.replace('\\', '/')).lastIndexOf(47);
                    n = n == -1 ? 0 : ++n;
                    ClientRAR.installRAR(string3, string, string3.substring(n));
                    Utility.printMessage(Utility.getMessage("rar.installSuccess", new String[]{string3, string}));
                } else if (string2.equals(DELETE_TASK)) {
                    boolean bl2 = ClientRAR.uninstallRAR(string3, string);
                    if (bl2) {
                        Utility.printMessage(Utility.getMessage("rar.uninstallSuccess", new String[]{string3, string}));
                    } else {
                        Utility.printMessage(Utility.getMessage("rar.uninstallFail", new String[]{string3, string}));
                    }
                } else {
                    ClientRAR.usage(true);
                }
            }
            catch (Exception exception) {
                System.err.println(exception.getMessage());
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                exception.printStackTrace(printWriter);
                printWriter.flush();
                Tr.debug(tc, stringWriter.toString());
            }
        }
    }
}

