/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.cache.EntryInfo;
import com.ibm.websphere.command.CacheableCommand;
import com.ibm.websphere.command.CommandCaller;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetableCommandImpl;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.ws.cache.SerializationUtility;
import com.ibm.ws.cache.ServerCache;
import com.ibm.ws.cache.Trace;
import com.ibm.ws.cache.command.CommandCache;
import com.ibm.ws.cache.command.CommandCacheProcessor;
import com.ibm.ws.cache.config.ConfigEntry;
import com.ibm.ws.cache.config.ConfigManager;
import com.ibm.ws.cache.servlet.CacheHook;
import com.ibm.ws.ffdc.FFDCFilter;
import java.rmi.RemoteException;
import java.util.ArrayList;

public abstract class CacheableCommandImpl
extends TargetableCommandImpl
implements CacheableCommand {
    private transient CommandCache commandCache = ServerCache.commandCache;
    private static TraceComponent tc = Trace.register(CacheableCommandImpl.class, "WebSphere Dynamic Cache", "com.ibm.ws.cache.resources.dynacache");
    private transient boolean delayInvalidations = false;
    private transient boolean doNotCache = false;
    private transient CommandCacheProcessor commandCacheProcessor = null;
    private com.ibm.ws.cache.EntryInfo entryInfo = new com.ibm.ws.cache.EntryInfo();
    private transient CommandCaller caller = null;

    public final String getId() {
        return this.entryInfo.getId();
    }

    public final int getSharingPolicy() {
        return this.entryInfo.getSharingPolicy();
    }

    public boolean preExecute() {
        return false;
    }

    public void postExecute() {
    }

    public void execute() throws CommandException {
        if (this.commandCache == null || CacheHook.isSkipCache()) {
            super.execute();
            return;
        }
        if (!this.isReadyToCallExecute()) {
            throw new UnsetInputPropertiesException();
        }
        if (this.entryInfo.getId() != null) {
            throw new IllegalStateException("EntryInfo id is non-null: Command " + this.toString() + " has already been executed.");
        }
        try {
            if (targetPolicy == null) {
                throw new IllegalStateException("TargetPolicy is not set");
            }
            CommandTarget commandTarget = targetPolicy.getCommandTarget(this);
            CacheableCommand cacheableCommand = null;
            this.prepareMetadata();
            if (this.doNotCache) {
                super.execute();
                return;
            }
            cacheableCommand = this.getId() == null ? this.commandCache.executeCommand(this, commandTarget) : this.commandCache.getCommand(this, true);
            CommandCaller commandCaller = this.getCaller();
            if (commandCaller != null) {
                EntryInfo entryInfo = cacheableCommand.getEntryInfo();
                commandCaller.unionDependencies(entryInfo);
            }
            if (this.hasOutputProperties() && this != cacheableCommand) {
                if (cacheableCommand == null) {
                    throw new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                }
                try {
                    this.setOutputProperties(cacheableCommand);
                }
                catch (RuntimeException runtimeException) {
                    byte[] byArray = SerializationUtility.serialize(cacheableCommand);
                    cacheableCommand = (CacheableCommand)SerializationUtility.deserialize(byArray);
                    this.setOutputProperties(cacheableCommand);
                    this.commandCache.setCommand(this);
                }
            }
            if (this.delayInvalidations) {
                this.invalidateEntries();
            }
        }
        catch (CommandException commandException) {
            FFDCFilter.processException((Throwable)commandException, "com.ibm.websphere.command.CacheableCommandImpl.execute", "203", this.getClass().getName());
            throw commandException;
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.command.CacheableCommandImpl.execute", "207", this.getClass().getName());
            if (exception instanceof RemoteException) {
                RemoteException remoteException = (RemoteException)exception;
                if (remoteException.detail != null) {
                    throw new CommandException(remoteException.detail);
                }
            }
            throw new CommandException(exception);
        }
    }

    public void setCaller(CommandCaller commandCaller) {
        this.caller = commandCaller;
    }

    public CommandCaller getCaller() {
        return this.caller;
    }

    public void unionDependencies(EntryInfo entryInfo) {
        if (this.entryInfo == null) {
            return;
        }
        if (entryInfo == null) {
            throw new IllegalArgumentException("entryInfo is null");
        }
        this.entryInfo.unionDependencies(entryInfo);
    }

    public EntryInfo getEntryInfo() {
        if (this.entryInfo.getTemplate() == null) {
            this.entryInfo.addTemplate(this.getClass().getName());
        }
        return this.entryInfo;
    }

    public void reset() {
        this.entryInfo = new com.ibm.ws.cache.EntryInfo();
        this.caller = null;
        this.commandCacheProcessor = null;
        this.delayInvalidations = false;
        this.doNotCache = false;
    }

    public boolean executeFromCache() throws CommandException {
        if (this.commandCache == null) {
            return false;
        }
        if (!this.isReadyToCallExecute()) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            throw new UnsetInputPropertiesException();
        }
        CacheableCommand cacheableCommand = null;
        this.prepareMetadata();
        if (this.getId() == null) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            return false;
        }
        cacheableCommand = this.commandCache.getCommand(this, false);
        if (cacheableCommand == null) {
            this.entryInfo = new com.ibm.ws.cache.EntryInfo();
            return false;
        }
        if (this.hasOutputProperties() && this != cacheableCommand) {
            this.setOutputProperties(cacheableCommand);
        }
        if (this.delayInvalidations) {
            this.invalidateEntries();
        }
        return true;
    }

    public void updateCache() {
        if (this.commandCache == null) {
            System.out.println("warning: updateCache called with dynacache disabled");
            return;
        }
        if (!this.isReadyToCallExecute()) {
            throw new IllegalStateException("cannot call updateCache() on commands that are not ready for execution");
        }
        if (this.getId() == null) {
            this.prepareMetadata();
        }
        if (this.entryInfo.getId() == null) {
            throw new IllegalStateException("cannot call updateCache() on commands that are not cacheable");
        }
        this.commandCache.setCommand(this);
        if (this.delayInvalidations) {
            this.invalidateEntries();
        }
    }

    protected void prepareMetadata() {
        ConfigEntry configEntry = ConfigManager.getInstance().getCacheEntry(this, null);
        if (configEntry != null) {
            this.commandCache = ServerCache.getCommandCache(configEntry.instanceName);
            this.commandCacheProcessor = (CommandCacheProcessor)ConfigManager.getInstance().getCacheProcessor(configEntry);
            this.commandCacheProcessor.setCacheableCommand(this);
            this.commandCacheProcessor.execute();
            this.delayInvalidations = this.commandCacheProcessor.isDelayInvalidations();
            this.doNotCache = this.commandCacheProcessor.getDoNotCache();
            this.commandCacheProcessor.setEntryInfo(this.getEntryInfo());
            if (!this.delayInvalidations) {
                this.invalidateEntries();
            }
        }
    }

    protected void invalidateEntries() {
        if (this.commandCacheProcessor != null) {
            this.commandCacheProcessor.setInvalidationIds();
            ArrayList arrayList = this.commandCacheProcessor.getInvalidationIds();
            if (arrayList != null) {
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    this.commandCache.invalidateById((String)arrayList.get(i), i == n - 1);
                }
            }
            ConfigManager.getInstance().returnCacheProcessor(this.commandCacheProcessor);
        }
    }
}

