/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.command;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.command.CommandException;
import com.ibm.websphere.command.CommandTarget;
import com.ibm.websphere.command.TargetPolicy;
import com.ibm.websphere.command.TargetPolicyDefault;
import com.ibm.websphere.command.TargetableCommand;
import com.ibm.websphere.command.UnsetInputPropertiesException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.security.util.AccessController;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;

public abstract class TargetableCommandImpl
implements TargetableCommand {
    private static final TraceComponent _tc = Tr.register(TargetableCommandImpl.class);
    public static String LOCAL = "com.ibm.websphere.command.LocalTarget";
    protected static TargetPolicy targetPolicy = new TargetPolicyDefault();
    protected transient CommandTarget commandTarget = null;
    protected String commandTargetName = null;
    protected boolean hasOutputProperties = true;

    public void execute() throws CommandException {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "execute");
        }
        if (!this.isReadyToCallExecute()) {
            UnsetInputPropertiesException unsetInputPropertiesException = new UnsetInputPropertiesException();
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", unsetInputPropertiesException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", "The command is not ready to execute");
            }
            throw unsetInputPropertiesException;
        }
        try {
            if (targetPolicy == null) {
                IllegalStateException illegalStateException = new IllegalStateException("TargetPolicy is not set");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "execute", illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "execute", "Target policy is null");
                }
                throw illegalStateException;
            }
            CommandTarget commandTarget = targetPolicy.getCommandTarget(this);
            TargetableCommand targetableCommand = commandTarget.executeCommand(this);
            if (this.hasOutputProperties() && this != targetableCommand) {
                if (targetableCommand == null) {
                    CommandException commandException = new CommandException("Command returned from CommandTarget was null and this command has output properties.");
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "execute", commandException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "execute", "returned command is null");
                    }
                    throw commandException;
                }
                this.setOutputProperties(targetableCommand);
            }
        }
        catch (CommandException commandException) {
            FFDCFilter.processException((Throwable)commandException, "com.ibm.websphere.command.TargetableCommandImpl.execute", "133", this);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", commandException);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", commandException);
            }
            throw commandException;
        }
        catch (Exception exception) {
            Exception exception2;
            FFDCFilter.processException((Throwable)exception, "com.ibm.websphere.command.TargetableCommandImpl.execute", "137", this);
            if (exception instanceof RemoteException) {
                exception2 = (RemoteException)exception;
                if (exception2.detail != null) {
                    CommandException commandException = new CommandException(exception2.detail);
                    if (_tc.isEventEnabled()) {
                        Tr.event(_tc, "execute", commandException);
                    }
                    if (_tc.isDebugEnabled()) {
                        Tr.debug(_tc, "execute", commandException);
                    }
                    throw commandException;
                }
            }
            exception2 = new CommandException(exception);
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "execute", exception2);
            }
            if (_tc.isDebugEnabled()) {
                Tr.debug(_tc, "execute", exception2);
            }
            throw exception2;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "execute");
        }
    }

    public CommandTarget getCommandTarget() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCommandTarget");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCommandTarget", this.commandTarget);
        }
        return this.commandTarget;
    }

    public String getCommandTargetName() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getCommandTargetName");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getCommandTargetName", this.commandTargetName);
        }
        return this.commandTargetName;
    }

    public static TargetPolicy getTargetPolicy() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "getTargetPolicy");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "getTargetPolicy", targetPolicy);
        }
        return targetPolicy;
    }

    public final boolean hasOutputProperties() {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "hasOutputProperties");
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "hasOutputProperties", new Boolean(this.hasOutputProperties));
        }
        return this.hasOutputProperties;
    }

    public abstract boolean isReadyToCallExecute();

    public abstract void performExecute() throws Exception;

    public abstract void reset();

    public void setCommandTarget(CommandTarget commandTarget) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCommandTarget", commandTarget);
        }
        this.commandTarget = commandTarget;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCommandTarget");
        }
    }

    public void setCommandTargetName(String string) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setCommandTargetName", string);
        }
        this.commandTargetName = string;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setCommandTargetName");
        }
    }

    public final void setHasOutputProperties(boolean bl) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setHasOutputProperties", new Boolean(bl));
        }
        this.hasOutputProperties = bl;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setHasOutputProperties");
        }
    }

    public void setOutputProperties(final TargetableCommand targetableCommand) {
        if (_tc.isEntryEnabled()) {
            Tr.entry(_tc, "setOutputProperties", targetableCommand);
        }
        try {
            final Class<?> clazz = this.getClass();
            final TargetableCommandImpl targetableCommandImpl = this;
            if (!targetableCommand.getClass().equals(clazz)) {
                IllegalStateException illegalStateException = new IllegalStateException("fromCommand is not of the same class");
                if (_tc.isEventEnabled()) {
                    Tr.event(_tc, "setOutputProperties", illegalStateException);
                }
                if (_tc.isDebugEnabled()) {
                    Tr.debug(_tc, "setOutputProperties", "fromCommand is not of the same class");
                }
                throw illegalStateException;
            }
            AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    AccessibleObject[] accessibleObjectArray = clazz.getDeclaredFields();
                    Field.setAccessible(accessibleObjectArray, true);
                    for (int i = 0; i < accessibleObjectArray.length; ++i) {
                        int n = ((Field)accessibleObjectArray[i]).getModifiers();
                        if (Modifier.isFinal(n) || Modifier.isTransient(n) || Modifier.isStatic(n)) continue;
                        ((Field)accessibleObjectArray[i]).set(targetableCommandImpl, ((Field)accessibleObjectArray[i]).get(targetableCommand));
                    }
                    Field.setAccessible(accessibleObjectArray, false);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            FFDCFilter.processException((Throwable)privilegedActionException, "com.ibm.websphere.command.TargetableCommandImpl.setOutputProperties", "371", this);
            IllegalStateException illegalStateException = new IllegalStateException("Since not all your variables are public in your command, you need to override the default implementation of TargetableCommand.setOutputProperties().");
            if (_tc.isEventEnabled()) {
                Tr.event(_tc, "setOutputProperties", illegalStateException);
            }
            throw illegalStateException;
        }
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setOutputProperties");
        }
    }

    public static void setTargetPolicy(TargetPolicy targetPolicy) {
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTargetPolicy", targetPolicy);
        }
        TargetableCommandImpl.targetPolicy = targetPolicy;
        if (_tc.isEntryEnabled()) {
            Tr.exit(_tc, "setTargetPolicy");
        }
    }
}

