/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.commons.logging;

import com.ibm.websphere.logging.WsLevel;
import com.ibm.ws.logging.WsLogger;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.eclipse.hyades.logging.java.CommonBaseEventLogRecord;

public class WsJDK14Logger
implements Log {
    private Logger logger;
    private Logger internalLogger;
    private String classname;
    private boolean usingWASLogging;
    private Level[] actualLevels;
    private Level[] levelsForPlainJDK14Logging = new Level[]{Level.FINEST, Level.FINE, Level.INFO, Level.WARNING, Level.SEVERE, Level.SEVERE};
    private Level[] levelsForWASJDK14Logging = new Level[]{WsLevel.FINEST, WsLevel.FINE, WsLevel.INFO, WsLevel.WARNING, WsLevel.SEVERE, WsLevel.FATAL};
    private final int LEVEL_TRACE = 0;
    private final int LEVEL_DEBUG = 1;
    private final int LEVEL_INFO = 2;
    private final int LEVEL_WARNING = 3;
    private final int LEVEL_ERROR = 4;
    private final int LEVEL_FATAL = 5;

    public WsJDK14Logger(String string) {
        this.logger = Logger.getLogger(string);
        this.classname = this.getClass().getName();
        this.internalLogger = Logger.getLogger(this.classname);
        this.usingWASLogging = this.logger instanceof WsLogger;
        this.actualLevels = this.usingWASLogging ? this.levelsForWASJDK14Logging : this.levelsForPlainJDK14Logging;
        this.internalLogger.logp(Level.FINE, this.classname, "constructor", "Instantiated, running in WAS environment: " + this.usingWASLogging);
    }

    public boolean isDebugEnabled() {
        return this.logger.isLoggable(this.actualLevels[1]);
    }

    public boolean isErrorEnabled() {
        return this.logger.isLoggable(this.actualLevels[4]);
    }

    public boolean isFatalEnabled() {
        return this.logger.isLoggable(this.actualLevels[5]);
    }

    public boolean isInfoEnabled() {
        return this.logger.isLoggable(this.actualLevels[2]);
    }

    public boolean isTraceEnabled() {
        return this.logger.isLoggable(this.actualLevels[0]);
    }

    public boolean isWarnEnabled() {
        return this.logger.isLoggable(this.actualLevels[3]);
    }

    public void trace(Object object) {
        this.log(this.actualLevels[0], object, null);
    }

    public void trace(Object object, Throwable throwable) {
        this.log(this.actualLevels[0], object, throwable);
    }

    public void debug(Object object) {
        this.log(this.actualLevels[1], object, null);
    }

    public void debug(Object object, Throwable throwable) {
        this.log(this.actualLevels[1], object, throwable);
    }

    public void info(Object object) {
        this.log(this.actualLevels[2], object, null);
    }

    public void info(Object object, Throwable throwable) {
        this.log(this.actualLevels[2], object, throwable);
    }

    public void warn(Object object) {
        this.log(this.actualLevels[3], object, null);
    }

    public void warn(Object object, Throwable throwable) {
        this.log(this.actualLevels[3], object, throwable);
    }

    public void error(Object object) {
        this.log(this.actualLevels[4], object, null);
    }

    public void error(Object object, Throwable throwable) {
        this.log(this.actualLevels[4], object, throwable);
    }

    public void fatal(Object object) {
        this.log(this.actualLevels[5], object, null);
    }

    public void fatal(Object object, Throwable throwable) {
        this.log(this.actualLevels[5], object, throwable);
    }

    public void setLogFactory(LogFactory logFactory) {
        if (this.internalLogger != null && logFactory != null) {
            this.internalLogger.logp(Level.FINE, this.classname, "setLogFactory", "Instantiated by " + logFactory.getClass().getName());
            this.internalLogger.logp(Level.FINE, this.classname, "setLogFactory", "Factory instantiated by " + logFactory.getClass().getClassLoader().toString());
        }
    }

    private void log(Level level, Object object, Throwable throwable) {
        if (this.logger.isLoggable(level)) {
            Object object2 = null;
            try {
                if (object instanceof CommonBaseEvent) {
                    object2 = new CommonBaseEventLogRecord((CommonBaseEvent)object);
                } else if (object instanceof CommonBaseEventLogRecord || object instanceof LogRecord) {
                    object2 = (LogRecord)object;
                }
            }
            catch (Exception exception) {
                this.internalLogger.logp(Level.WARNING, this.classname, "log", "Exception. ", exception);
                object2 = null;
            }
            if (object2 == null) {
                object2 = new LogRecord(level, String.valueOf(object));
            }
            if (throwable != null) {
                ((LogRecord)object2).setThrown(throwable);
            }
            this.logger.log((LogRecord)object2);
        }
    }
}

