/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.cdf.tsapi;

import com.ibm.websphere.edge.cdf.tsapi.ListenThread;
import com.ibm.websphere.edge.cdf.tsapi.MalformedTriggerException;
import com.ibm.websphere.edge.cdf.tsapi.Trigger;
import com.ibm.websphere.edge.cdf.tsapi.TriggerWrapper;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class CdsPublish {
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.cdf.tsapi.tsapi");
    private LogModule logModule = LogPackage.register("CdsPublish");
    static final int UPDATE = 1;
    static final int INVALIDATE = 2;
    private static final String WCPP_PROTO_STR = "WCPP/1.0";
    private static final String UPDATE_STR = "update";
    private static final String INVALIDATE_STR = "invalidate";
    private static final String URL_TYPE_STR = "url";
    private static final String FILEPATH_TYPE_STR = "file";
    private static final String ABSTRACT_TYPE_STR = "abstract";
    private static final String WEAK_STR = "weak";
    private static final String STRONG_STR = "strong";
    private static final String STATIC_AGENT_STR = "static-agent";
    private static final String DYNAMIC_AGENT_STR = "dynamic-agent";
    private static final String AGENTS_STR = "agents";
    private static final String SOURCE_STR = "source";
    private static final String SERVERS_STR = "servers";
    private static final String TRIGGER_ID_STR = "id";
    private static final String NOTIFY_STR = "notify";
    private static final String FORCE_STR = "force";
    private static final String BUNDLE_STR = "bundle";
    static final int PUBERR_BASE = 56000;
    public static final int PUBERR_SENDFAIL = 56003;
    public static final int PUBERR_MUSTRETRY = 56007;
    public static final int PUBERR_INVALID = 56008;
    public static final int PUBERR_WRITEFAIL = 56009;
    public static final int PUBERR_SUCCESS = 0;
    private static final char BEGIN = '{';
    private static final char END = '}';
    private static final char BLANK = ' ';
    private static final char TAB = '\t';
    private static final char NEWLINE = '\n';
    private URL MasterCDSUrl;
    private String CDSDomain;
    Vector TriggerVec;
    HashSet activeObjectSet;
    private String CDShost;
    private int CDSport;
    private String strListenAddr;
    private boolean shutdownStatus = false;

    public CdsPublish(String string, String string2, int n, String string3, boolean bl) throws MalformedURLException {
        this(new URL(string, string2, n, string3), bl);
    }

    public CdsPublish(String string, String string2, int n, boolean bl) throws MalformedURLException {
        this(new URL(string, string2, n, "/"), bl);
    }

    public CdsPublish(URL uRL, boolean bl) throws MalformedURLException {
        String string = "CdsPublish() ";
        this.MasterCDSUrl = uRL;
        if (bl) {
            this.logModule.setDebug(true);
        }
        this.TriggerVec = new Vector();
        this.activeObjectSet = new HashSet();
        this.CDShost = uRL.getHost();
        this.CDSport = uRL.getPort();
        if (this.CDShost.equals("")) {
            throw new MalformedURLException();
        }
        if (this.CDSport == -1) {
            this.CDSport = 80;
        }
        this.logModule.trace(string + "CDS host=" + this.CDShost + " port=" + this.CDSport);
        try {
            ListenThread listenThread = new ListenThread(this);
            InetAddress inetAddress = listenThread.getInetAddress();
            int n = listenThread.getLocalPort();
            byte[] byArray = inetAddress.getAddress();
            long l = 0L;
            for (int i = 0; i < byArray.length; ++i) {
                l <<= 8;
                l += (long)(byArray[i] & 0xFF);
            }
            this.strListenAddr = Long.toString(l) + ":" + n + ":1";
            listenThread.start();
            this.logModule.trace(string + "Listening for ACKs at: " + this.strListenAddr);
        }
        catch (Exception exception) {
            this.logModule.log(this.rb.getString("TSAPI_ACK_LISTENER_SPAWN_FAILED"));
            this.logModule.trace(string + "Exception spawning ACK listener " + exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pubHold(TriggerWrapper triggerWrapper, boolean bl) {
        Object object;
        String string = "pubHold() ";
        Vector<TriggerWrapper> vector = new Vector<TriggerWrapper>();
        Object object2 = this.TriggerVec;
        synchronized (object2) {
            object = triggerWrapper.getObjects();
            if (!this.activeObjectSet.isEmpty()) {
                this.logModule.trace(string + "objects in-progress: " + this.activeObjectSet.toString());
                block7: for (int i = 0; i < ((String[])object).length; ++i) {
                    this.logModule.trace(string + "looking for " + object[i]);
                    if (!this.activeObjectSet.contains(object[i])) continue;
                    this.logModule.trace(string + "conflicting object " + object[i]);
                    if (bl) {
                        Iterator iterator = this.TriggerVec.iterator();
                        while (iterator.hasNext()) {
                            TriggerWrapper triggerWrapper2 = (TriggerWrapper)iterator.next();
                            List<String> list = Arrays.asList(triggerWrapper2.getObjects());
                            if (!list.contains(object[i])) continue;
                            this.logModule.trace(string + "releasing conflicting trigger objs:" + list);
                            iterator.remove();
                            vector.add(triggerWrapper2);
                            try {
                                this.activeObjectSet.removeAll(list);
                            }
                            catch (UnsupportedOperationException unsupportedOperationException) {
                                this.logModule.trace(string + "Exception " + "releasing from activeObjectSet" + unsupportedOperationException);
                            }
                            continue block7;
                        }
                        continue;
                    }
                    return false;
                }
            }
            try {
                this.activeObjectSet.addAll(Arrays.asList(object));
                this.logModule.trace(string + "Marked all objects as in-progress");
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logModule.trace("Exception adding objs to set " + unsupportedOperationException);
                return false;
            }
            this.TriggerVec.add(triggerWrapper);
            this.logModule.trace(string + "Added Trigger to In-progress list");
        }
        if (!vector.isEmpty()) {
            object2 = vector.iterator();
            while (object2.hasNext()) {
                object = (TriggerWrapper)object2.next();
                object.trg.pubDone(-1);
                object.trg = null;
                object2.remove();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    TriggerWrapper findTrigger(String string) {
        String string2 = "findTrigger() ";
        Vector vector = this.TriggerVec;
        synchronized (vector) {
            Iterator iterator = this.TriggerVec.iterator();
            while (iterator.hasNext()) {
                TriggerWrapper triggerWrapper = (TriggerWrapper)iterator.next();
                if (!triggerWrapper.getTriggerId().equals(string)) continue;
                this.logModule.trace(string2 + "Found trigger with id " + string);
                return triggerWrapper;
            }
        }
        this.logModule.trace(string2 + "Could not find trigger with id " + string);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean pubRelease(TriggerWrapper triggerWrapper) {
        String string = "pubRelease() ";
        Vector vector = this.TriggerVec;
        synchronized (vector) {
            if (!this.TriggerVec.remove(triggerWrapper)) {
                this.logModule.trace(string + "Trigger not in in-progress list");
            }
            try {
                String[] stringArray = triggerWrapper.getObjects();
                this.activeObjectSet.removeAll(Arrays.asList(stringArray));
                this.logModule.trace(string + "object count=" + stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    this.logModule.trace(string + "remove from in-progress " + stringArray[i]);
                }
                this.logModule.trace(string + "objects remaining: " + this.activeObjectSet.toString());
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                this.logModule.trace(string + "UnsupportedOperationException " + unsupportedOperationException);
                return false;
            }
            triggerWrapper.trg = null;
        }
        this.logModule.trace(string + "completed successfully");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pubUpdate(Trigger trigger, boolean bl) {
        TriggerWrapper triggerWrapper;
        String string = "pubUpdate() ";
        int n = 0;
        boolean bl2 = false;
        try {
            triggerWrapper = new TriggerWrapper(this, trigger, 1);
        }
        catch (MalformedTriggerException malformedTriggerException) {
            this.logModule.trace(string + "Trigger malformed " + malformedTriggerException);
            this.logModule.log(this.rb.getString("TSAPI_TRIGGER_INVALID"));
            return 56008;
        }
        try {
            if (!this.pubHold(triggerWrapper, bl)) {
                this.logModule.log(this.rb.getString("TSAPI_MUSTRETRY"));
                n = 56007;
            } else {
                bl2 = true;
                n = triggerWrapper.pubWrite();
                if (n != 0) {
                    this.logModule.trace(string + "Trigger Write callback error" + n);
                    this.logModule.log(this.rb.getString("TSAPI_WRITE_CALLBACK_ERROR") + n);
                    n = 56009;
                } else {
                    n = this.sendTrigger(triggerWrapper);
                    if (n != 0) {
                        this.logModule.log(this.rb.getString("TSAPI_TRIGGER_SEND_FAIL") + n);
                    } else {
                        this.logModule.log(this.rb.getString("TSAPI_TRIGGER_SENT_TO_CDS"));
                        bl2 = false;
                    }
                }
            }
            Object var9_8 = null;
            if (bl2 && !this.pubRelease(triggerWrapper)) {
                this.logModule.log(this.rb.getString("TSAPI_TRIGGER_RELEASE_FAIL"));
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl2 && !this.pubRelease(triggerWrapper)) {
                this.logModule.log(this.rb.getString("TSAPI_TRIGGER_RELEASE_FAIL"));
            }
            throw throwable;
        }
        this.logModule.trace(string + "returning " + n);
        return n;
    }

    public int pubUpdate(Trigger trigger) {
        return this.pubUpdate(trigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pubInvalidate(Trigger trigger, boolean bl) {
        TriggerWrapper triggerWrapper;
        String string = "pubInvalidate() ";
        int n = 0;
        boolean bl2 = false;
        try {
            triggerWrapper = new TriggerWrapper(this, trigger, 2);
        }
        catch (MalformedTriggerException malformedTriggerException) {
            this.logModule.trace(string + "Trigger malformed " + malformedTriggerException);
            this.logModule.log(this.rb.getString("TSAPI_TRIGGER_INVALID"));
            return 56008;
        }
        try {
            if (!this.pubHold(triggerWrapper, bl)) {
                this.logModule.log(this.rb.getString("TSAPI_MUSTRETRY"));
                n = 56007;
            } else {
                bl2 = true;
                n = this.sendTrigger(triggerWrapper);
                if (n != 0) {
                    this.logModule.log(this.rb.getString("TSAPI_TRIGGER_SEND_FAIL") + n);
                } else {
                    this.logModule.log(this.rb.getString("TSAPI_TRIGGER_SENT_TO_CDS"));
                    bl2 = false;
                }
            }
            Object var9_8 = null;
            if (bl2 && !this.pubRelease(triggerWrapper)) {
                this.logModule.log(this.rb.getString("TSAPI_TRIGGER_RELEASE_FAIL"));
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (bl2 && !this.pubRelease(triggerWrapper)) {
                this.logModule.log(this.rb.getString("TSAPI_TRIGGER_RELEASE_FAIL"));
            }
            throw throwable;
        }
        this.logModule.trace(string + "returning " + n);
        return n;
    }

    public int pubInvalidate(Trigger trigger) {
        return this.pubInvalidate(trigger, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    int sendTrigger(TriggerWrapper var1_1) {
        block21: {
            block20: {
                var2_2 = "sendTrigger() ";
                var3_3 = null;
                var4_4 = null;
                var5_5 = null;
                var6_6 = 0;
                try {
                    try {
                        var7_7 = this.genTriggerId();
                        var1_1.setTriggerId(var7_7);
                        this.logModule.trace(var2_2 + "set trigger id " + var7_7);
                        var8_9 = this.composeMessage(var1_1);
                        if (var8_9 == null) {
                            this.logModule.trace(var2_2 + "Invalid Trigger parmeters");
                            var9_10 = 56008;
                            var12_12 = null;
                            break block20;
                        }
                        var3_3 = new Socket(this.CDShost, this.CDSport);
                        var4_4 = new BufferedReader(new InputStreamReader(var3_3.getInputStream()));
                        var5_5 = new BufferedWriter(new OutputStreamWriter(var3_3.getOutputStream()));
                        var5_5.write("POST / HTTP/1.0 \r\n");
                        var5_5.write("Content-type: ibmcdf/message\r\n");
                        var9_11 = var8_9.length() + 2;
                        var5_5.write("Content-length: " + var9_11 + "\r\n\r\n");
                        var5_5.write(var8_9 + "\r\n");
                        var5_5.flush();
                        var10_20 = null;
                        while ((var10_20 = var4_4.readLine()) != null) {
                            this.logModule.trace(var2_2 + "recv: " + var10_20);
                            if (!var10_20.equals("")) continue;
                            break block21;
                        }
                        break block21;
                    }
                    catch (Exception var7_8) {
                        var6_6 = 56003;
                        this.logModule.trace("Exception " + var7_8);
                        var12_14 = null;
                        try {
                            if (var4_4 != null) {
                                var4_4.close();
                            }
                            if (var5_5 != null) {
                                var5_5.close();
                            }
                            if (var3_3 == null) return var6_6;
                            var3_3.close();
                            return var6_6;
                        }
                        catch (Exception var13_18) {
                            return var6_6;
                        }
                    }
                }
                catch (Throwable var11_21) {
                    var12_15 = null;
                    ** try [egrp 2[TRYBLOCK] [6 : 365->396)] { 
lbl52:
                    // 1 sources

                    if (var4_4 != null) {
                        var4_4.close();
                    }
                    if (var5_5 != null) {
                        var5_5.close();
                    }
                    if (var3_3 == null) throw var11_21;
                    var3_3.close();
                    throw var11_21;
lbl59:
                    // 1 sources

                    catch (Exception var13_19) {
                        // empty catch block
                    }
                    throw var11_21;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 365->396)] { 
lbl64:
            // 1 sources

            if (var4_4 != null) {
                var4_4.close();
            }
            if (var5_5 != null) {
                var5_5.close();
            }
            if (var3_3 == null) return var9_10;
            var3_3.close();
            return var9_10;
lbl71:
            // 1 sources

            catch (Exception var13_16) {
                // empty catch block
            }
            return var9_10;
        }
        var12_13 = null;
        try {}
        catch (Exception var13_17) {}
        if (var4_4 != null) {
            var4_4.close();
        }
        if (var5_5 != null) {
            var5_5.close();
        }
        if (var3_3 == null) return var6_6;
        var3_3.close();
        return var6_6;
        return var6_6;
    }

    String composeMessage(TriggerWrapper triggerWrapper) {
        String string = "composeMessage() ";
        StringBuffer stringBuffer = new StringBuffer();
        try {
            stringBuffer.append('{');
            stringBuffer.append(WCPP_PROTO_STR).append('\t');
            int n = triggerWrapper.getTriggerType();
            if (n == 1) {
                stringBuffer.append(UPDATE_STR);
            } else {
                stringBuffer.append(INVALIDATE_STR);
            }
            stringBuffer.append(' ');
            int n2 = triggerWrapper.getFlags();
            if ((n2 & 1) != 0) {
                stringBuffer.append(FORCE_STR).append(' ');
            }
            if ((n2 & 2) != 0) {
                stringBuffer.append(BUNDLE_STR);
            }
            stringBuffer.append('\n').append('\t').append('\t');
            stringBuffer.append('{').append(SOURCE_STR);
            stringBuffer.append('\t').append(this.strListenAddr).append('}');
            stringBuffer.append('\n').append('\t').append('\t');
            stringBuffer.append('{');
            stringBuffer.append(TRIGGER_ID_STR);
            stringBuffer.append('\t');
            stringBuffer.append(triggerWrapper.getTriggerId());
            stringBuffer.append('}');
            stringBuffer.append('\n').append('\t').append('\t');
            stringBuffer.append('{');
            int n3 = triggerWrapper.getObjectType();
            if (n3 == 1) {
                stringBuffer.append(URL_TYPE_STR);
            } else if (n3 == 0) {
                stringBuffer.append(FILEPATH_TYPE_STR);
            } else {
                stringBuffer.append(ABSTRACT_TYPE_STR);
            }
            stringBuffer.append('\n').append('\t').append('\t');
            String[] stringArray = triggerWrapper.getObjects();
            for (int i = 0; i < stringArray.length; ++i) {
                stringBuffer.append(stringArray[i]);
                stringBuffer.append('\n').append('\t').append('\t');
            }
            stringBuffer.append('}');
            stringBuffer.append('\n').append('\t').append('\t');
            if (triggerWrapper.getConsistency() == 0) {
                stringBuffer.append(WEAK_STR);
            } else {
                stringBuffer.append(STRONG_STR);
            }
            stringBuffer.append('\n').append('\t').append('\t');
            stringBuffer.append('{').append(AGENTS_STR).append('\t');
            int[] nArray = triggerWrapper.getAgents();
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == 0) {
                    stringBuffer.append(STATIC_AGENT_STR).append(' ');
                    continue;
                }
                stringBuffer.append(DYNAMIC_AGENT_STR).append(' ');
            }
            stringBuffer.append('}');
            stringBuffer.append('\n').append('\t').append('\t');
            if (n == 1) {
                stringBuffer.append('{');
                stringBuffer.append(SERVERS_STR).append('\t');
                URL[] uRLArray = triggerWrapper.getStagingServerURLs();
                for (int i = 0; i < uRLArray.length; ++i) {
                    String string2 = CdsPublish.flattenAddr(uRLArray[i]);
                    if (string2 == null) {
                        return null;
                    }
                    stringBuffer.append(string2).append(' ');
                }
                stringBuffer.append('}');
            }
            stringBuffer.append('\n').append('\t').append('\t');
            String string3 = triggerWrapper.getBlob();
            if (string3.length() > 0) {
                stringBuffer.append('{');
                stringBuffer.append(NOTIFY_STR).append('\t');
                stringBuffer.append(string3);
                stringBuffer.append('}');
                stringBuffer.append('\n');
            }
            stringBuffer.append('}');
            this.logModule.trace(string + "Trigger Message\r\n" + stringBuffer.toString());
            return stringBuffer.toString();
        }
        catch (Exception exception) {
            this.logModule.trace(string + "Exception " + exception);
            return null;
        }
    }

    public String getCdsDomain() {
        return null;
    }

    public synchronized void pubShutdown() {
        this.shutdownStatus = true;
        this.logModule.trace("pubShutdown called");
        LogPackage.unregister(this.logModule);
    }

    synchronized boolean shutdownStatus() {
        return this.shutdownStatus;
    }

    String genTriggerId() {
        long l = new Date().getTime();
        return "" + l + ":0";
    }

    static String flattenAddr(URL uRL) {
        String string;
        String string2 = "flattenAddr() ";
        try {
            int n;
            InetAddress inetAddress = InetAddress.getByName(uRL.getHost());
            byte[] byArray = inetAddress.getAddress();
            long l = 0L;
            for (n = 0; n < byArray.length; ++n) {
                l <<= 8;
                l += (long)(byArray[n] & 0xFF);
            }
            String string3 = uRL.getProtocol();
            n = string3.equals("http") ? 1 : (string3.equals("https") ? 2 : 1);
            int n2 = uRL.getPort();
            if (n2 == -1) {
                n2 = 80;
            }
            string = "" + l + ":" + n2 + ":" + n;
        }
        catch (UnknownHostException unknownHostException) {
            string = null;
        }
        return string;
    }
}

