/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.cdf.tsapi;

import com.ibm.websphere.edge.cdf.tsapi.CdsPublish;
import com.ibm.websphere.edge.cdf.tsapi.WorkerThread;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

class ListenThread
extends Thread {
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.cdf.tsapi.tsapi");
    private LogModule logModule = LogPackage.register("CdsPublish");
    private CdsPublish publisher;
    private ServerSocket listenSocket;
    private InetAddress selfIP;
    private int selfPort;

    public ListenThread(CdsPublish cdsPublish) throws Exception {
        this.publisher = cdsPublish;
        String string = System.getProperty("publish.ip");
        if (string == null || string.length() == 0) {
            this.selfIP = InetAddress.getLocalHost();
            this.logModule.trace("Using " + this.selfIP + " as host IP.");
        } else {
            try {
                this.selfIP = InetAddress.getByName(string);
                this.logModule.trace("IP address specified as system property.");
                this.logModule.trace("Using " + this.selfIP + " as host IP.");
            }
            catch (UnknownHostException unknownHostException) {
                this.selfIP = InetAddress.getLocalHost();
                this.logModule.trace("Unable to resolve host " + string + ".");
                this.logModule.trace("Using " + this.selfIP + " as host IP.");
            }
        }
        Integer n = Integer.getInteger("publish.port");
        if (n == null) {
            this.selfPort = 0;
        } else {
            this.selfPort = n;
            if (this.selfPort >= 0 && this.selfPort <= 65535) {
                this.logModule.trace("Valid local port specified as system property.");
            } else {
                this.selfPort = 0;
            }
        }
        this.listenSocket = new ServerSocket(this.selfPort, 50, this.selfIP);
        this.selfPort = this.listenSocket.getLocalPort();
        this.logModule.trace("Bound to port " + this.selfPort + ".");
        this.listenSocket.setSoTimeout(500);
    }

    protected InetAddress getInetAddress() throws UnknownHostException {
        return this.selfIP;
    }

    protected int getLocalPort() {
        return this.selfPort;
    }

    public void run() {
        String string = "ListenThread:run() ";
        this.logModule.trace(string + "started");
        block4: while (true) {
            try {
                while (true) {
                    if (this.publisher.shutdownStatus()) {
                        this.logModule.trace(string + " Shutting down...");
                        this.listenSocket.close();
                        LogPackage.unregister(this.logModule);
                        break block4;
                    }
                    Socket socket = this.listenSocket.accept();
                    WorkerThread workerThread = new WorkerThread(this.publisher, socket);
                    this.logModule.trace(string + "Accepted a connection");
                    workerThread.start();
                }
            }
            catch (InterruptedIOException interruptedIOException) {
                continue;
            }
            catch (IOException iOException) {
                this.logModule.trace(string + "IOException " + iOException);
                continue;
            }
            catch (Exception exception) {
                this.logModule.trace(string + "Excecption " + exception);
                continue;
            }
            break;
        }
    }
}

