/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.cdf.tsapi;

import com.ibm.websphere.edge.cdf.tsapi.CdsPublish;
import com.ibm.websphere.edge.cdf.tsapi.MalformedTriggerException;
import com.ibm.websphere.edge.cdf.tsapi.Trigger;
import java.net.URL;

class TriggerWrapper
implements Trigger {
    String triggerId;
    Trigger trg;
    CdsPublish publisher;
    int type;
    String[] obj;
    int objType;
    int consistency;
    URL[] stagingServers;
    int[] agents;
    int flags;
    String blob;

    public TriggerWrapper(CdsPublish cdsPublish, Trigger trigger, int n) throws MalformedTriggerException {
        this.trg = trigger;
        this.publisher = cdsPublish;
        this.type = n;
        this.ValidateTrigger(trigger);
    }

    protected void ValidateTrigger(Trigger trigger) throws MalformedTriggerException {
        int n;
        this.obj = this.trg.getObjects();
        if (this.obj == null || this.obj.length == 0) {
            throw new MalformedTriggerException("NULL objects");
        }
        for (n = 0; n < this.obj.length; ++n) {
            if (this.obj[n] != null && this.obj[n].length() != 0) continue;
            throw new MalformedTriggerException("NULL objects at index " + n);
        }
        this.objType = this.trg.getObjectType();
        if (this.objType != 1 && this.objType != 0 && this.objType != 2) {
            throw new MalformedTriggerException("Invalid Object Type " + this.objType);
        }
        this.flags = this.trg.getFlags();
        if ((this.flags & 0xFFFFFFFC) != 0) {
            throw new MalformedTriggerException("Invalid flags " + this.flags);
        }
        this.consistency = this.trg.getConsistency();
        if (this.consistency != 1 && this.consistency != 0) {
            throw new MalformedTriggerException("Invalid consistency type " + this.consistency);
        }
        this.agents = this.trg.getAgents();
        if (this.agents == null || this.agents.length == 0) {
            throw new MalformedTriggerException("Invalid agents");
        }
        for (n = 0; n < this.agents.length; ++n) {
            if (this.agents[n] == 0 || this.agents[n] == 1) continue;
            throw new MalformedTriggerException("Invalid agent " + this.agents[n] + " at index " + n);
        }
        this.stagingServers = this.trg.getStagingServerURLs();
        if (this.type == 1) {
            if (this.stagingServers == null || this.stagingServers.length == 0) {
                throw new MalformedTriggerException("Invalid staging servers");
            }
            for (n = 0; n < this.stagingServers.length; ++n) {
                if (this.stagingServers[n] == null) {
                    throw new MalformedTriggerException("NULL Staging Server URL at index " + n);
                }
                if (CdsPublish.flattenAddr(this.stagingServers[n]) != null) continue;
                throw new MalformedTriggerException("Unknown host error for staging server " + this.stagingServers[n]);
            }
        }
        this.blob = this.trg.getBlob();
    }

    public String[] getObjects() {
        return this.obj;
    }

    public int getTriggerType() {
        return this.type;
    }

    public int getObjectType() {
        return this.objType;
    }

    public URL[] getStagingServerURLs() {
        return this.stagingServers;
    }

    public int getFlags() {
        return this.flags;
    }

    public int[] getAgents() {
        return this.agents;
    }

    public int getConsistency() {
        return this.consistency;
    }

    public String getBlob() {
        return this.blob;
    }

    public int pubWrite() {
        return this.trg.pubWrite();
    }

    public void pubDone(int n) {
        this.trg.pubDone(n);
    }

    public String getTriggerId() {
        return this.triggerId;
    }

    public void setTriggerId(String string) {
        this.triggerId = string;
    }
}

