/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.cdf.tsapi;

import com.ibm.websphere.edge.cdf.tsapi.CdsPublish;
import com.ibm.websphere.edge.cdf.tsapi.TriggerWrapper;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.util.StringTokenizer;

class WorkerThread
extends Thread {
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.cdf.tsapi.tsapi");
    private LogModule logModule = LogPackage.register("CdsPublish");
    CdsPublish publisher;
    Socket sock;

    public WorkerThread(CdsPublish cdsPublish, Socket socket) throws Exception {
        this.publisher = cdsPublish;
        this.sock = socket;
        socket.setSoTimeout(5000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        block26: {
            OutputStreamWriter outputStreamWriter;
            BufferedReader bufferedReader;
            String string;
            block24: {
                string = "WorkerThread:run() ";
                bufferedReader = null;
                outputStreamWriter = null;
                this.logModule.trace(string + "start");
                bufferedReader = new BufferedReader(new InputStreamReader(this.sock.getInputStream()));
                outputStreamWriter = new OutputStreamWriter(this.sock.getOutputStream());
                String string2 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    this.logModule.trace(string + "recv: " + string2);
                    if (!string2.equals("")) continue;
                    string2 = bufferedReader.readLine();
                    break;
                }
                int n = 0;
                String string3 = null;
                if (string2 == null) break block24;
                this.logModule.trace(string + "body: " + string2);
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                for (int i = 0; i < 4 && stringTokenizer.hasMoreTokens(); ++i) {
                    String string4 = stringTokenizer.nextToken();
                    this.logModule.trace(string + "token[" + i + "]=" + string4);
                    if (i == 1) {
                        if (string4.compareToIgnoreCase("ack") == 0) continue;
                        this.logModule.trace(string + "did not find ack token!");
                        continue;
                    }
                    if (i == 2) {
                        string3 = string4;
                        this.logModule.trace(string + "trigger id=" + string3);
                        this.logModule.log(this.rb.getString("TSAPI_RECEIVED_ACK") + string3);
                        continue;
                    }
                    if (i != 3) continue;
                    try {
                        n = Integer.parseInt(string4);
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.logModule.trace(string + "Invalid code " + string4);
                        this.logModule.log(this.rb.getString("TSAPI_ACK_MALFORMATTED") + string2);
                        n = 0;
                    }
                    break;
                }
                if (string3 != null) {
                    TriggerWrapper triggerWrapper = this.publisher.findTrigger(string3);
                    if (triggerWrapper == null) {
                        this.logModule.log(this.rb.getString("TSAPI_TRIGGER_NOT_FOUND") + string3);
                    } else {
                        triggerWrapper.pubDone(n);
                        this.logModule.trace(string + "pubDone called on this trigger");
                        if (!this.publisher.pubRelease(triggerWrapper)) {
                            this.logModule.log(this.rb.getString("TSAPI_TRIGGER_RELEASE_FAIL"));
                        }
                    }
                }
                this.logModule.trace(string + "sending HTTP_OK for ACK");
                outputStreamWriter.write("HTTP/1.0 200 OK\r\n");
                outputStreamWriter.write("Content-type: ibmcdf/heartbeat\r\n");
                outputStreamWriter.write("Content-length: 0\r\n");
                outputStreamWriter.write("\r\n");
                outputStreamWriter.flush();
                this.logModule.trace(string + "HTTP_OK sent for ACK");
                this.logModule.log(this.rb.getString("TSAPI_TRIGGER_PROCESSED"));
            }
            Object var12_13 = null;
            try {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
                if (outputStreamWriter != null) {
                    outputStreamWriter.close();
                }
                this.sock.close();
            }
            catch (IOException iOException) {
                this.logModule.trace(string + "Exception in finally " + iOException);
            }
            LogPackage.unregister(this.logModule);
            {
                break block26;
                catch (IOException iOException) {
                    this.logModule.trace(string + "Exception " + iOException);
                    Object var12_14 = null;
                    try {
                        if (bufferedReader != null) {
                            bufferedReader.close();
                        }
                        if (outputStreamWriter != null) {
                            outputStreamWriter.close();
                        }
                        this.sock.close();
                    }
                    catch (IOException iOException2) {
                        this.logModule.trace(string + "Exception in finally " + iOException2);
                    }
                    LogPackage.unregister(this.logModule);
                }
            }
            catch (Throwable throwable) {
                Object var12_15 = null;
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStreamWriter.close();
                    }
                    this.sock.close();
                }
                catch (IOException iOException) {
                    this.logModule.trace(string + "Exception in finally " + iOException);
                }
                LogPackage.unregister(this.logModule);
                throw throwable;
            }
        }
    }
}

