/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.dynacache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.edge.dynacache.ConnProperties;
import com.ibm.websphere.edge.dynacache.EdgeServerConfig;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import java.io.File;
import java.io.FileInputStream;
import java.util.Vector;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class EdgeServerDistParser {
    private static Document doc;
    private static Element elm;
    private static EdgeServerDistParser esdp;
    private static TraceComponent tc;
    private EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.localize.dynacache");
    private LogModule logModule = LogPackage.register("dynaedge");
    static /* synthetic */ Class class$com$ibm$websphere$edge$dynacache$EdgeServerDistParser;

    private EdgeServerDistParser(String string) {
        Tr.entry(tc, "EdgeServerDistParser");
        try {
            DOMParser dOMParser = new DOMParser();
            File file = new File(string);
            FileInputStream fileInputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(fileInputStream);
            dOMParser.parse(inputSource);
            doc = dOMParser.getDocument();
            elm = doc.getDocumentElement();
        }
        catch (Exception exception) {
            this.logModule.log(this.rb.getString("WSES_CONF_PARSE_ERR"));
            exception.printStackTrace();
        }
        Tr.exit(tc, "EdgeServerDistParser");
    }

    private static synchronized void edgeServerDistParserInit(String string) {
        if (null == esdp) {
            esdp = new EdgeServerDistParser(string);
        }
    }

    public static EdgeServerDistParser getEdgeServerDistParserObj(String string) {
        EdgeServerDistParser.edgeServerDistParserInit(string);
        return esdp;
    }

    public Vector getMasterCDSUri() {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = elm.getElementsByTagName("MasterCDS");
        Tr.entry(tc, "getMasterCDSUri");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                if (!namedNodeMap.item(j).getNodeName().equals("endpoint")) continue;
                vector.addElement(namedNodeMap.item(j).getNodeValue());
                Tr.debug(tc, "Added ", namedNodeMap.item(j).getNodeValue());
            }
        }
        Tr.exit(tc, "getMasterCDSUri");
        return vector;
    }

    public Vector getMasterCDSDomains() {
        Vector<String> vector = new Vector<String>();
        NodeList nodeList = elm.getElementsByTagName("MasterCDS");
        Tr.entry(tc, "getMasterCDSDomains");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            for (int j = 0; j < namedNodeMap.getLength(); ++j) {
                if (!namedNodeMap.item(j).getNodeName().equals("domain-name")) continue;
                vector.addElement(namedNodeMap.item(j).getNodeValue());
            }
        }
        Tr.exit(tc, "getMasterCDSDomains");
        return vector;
    }

    public Vector getEdgeServerList() {
        Vector<EdgeServerConfig> vector = new Vector<EdgeServerConfig>();
        NodeList nodeList = elm.getElementsByTagName("EdgeServer");
        Tr.entry(tc, "getEdgeServerList");
        Tr.debug(tc, "getEdgeServerList - processing EdgeServers " + nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            int n;
            EdgeServerConfig edgeServerConfig = new EdgeServerConfig();
            NamedNodeMap namedNodeMap = nodeList.item(i).getAttributes();
            Tr.debug(tc, "getEdgeServerList - processing Attributes " + namedNodeMap.getLength());
            for (n = 0; n < namedNodeMap.getLength(); ++n) {
                if (namedNodeMap.item(n).getNodeName().equals("user")) {
                    edgeServerConfig.user = namedNodeMap.item(n).getNodeValue();
                    continue;
                }
                if (namedNodeMap.item(n).getNodeName().equals("userPasswd")) {
                    edgeServerConfig.userpw = namedNodeMap.item(n).getNodeValue();
                    continue;
                }
                if (namedNodeMap.item(n).getNodeName().equals("invalidation-url")) {
                    edgeServerConfig.invalidationUrl = namedNodeMap.item(n).getNodeValue();
                    continue;
                }
                if (namedNodeMap.item(n).getNodeName().equals("endpoint")) {
                    edgeServerConfig.endPoint = namedNodeMap.item(n).getNodeValue();
                    continue;
                }
                if (!namedNodeMap.item(n).getNodeName().equals("URI-type")) continue;
                edgeServerConfig.uriType = namedNodeMap.item(n).getNodeValue();
            }
            if (edgeServerConfig.endPoint == null) {
                Tr.debug(tc, "Invalid Edge Server Config: no endpoint");
                this.logModule.log(this.rb.getString("WSES_CONF_PARSE_NOENDPOINT"));
                continue;
            }
            boolean bl = false;
            for (n = 0; n < vector.size(); ++n) {
                EdgeServerConfig edgeServerConfig2 = (EdgeServerConfig)vector.get(n);
                if (!edgeServerConfig2.equals(edgeServerConfig)) continue;
                Tr.debug(tc, "Duplicate Edge Server Config discarding");
                bl = true;
                break;
            }
            if (bl) continue;
            vector.addElement(edgeServerConfig);
        }
        Tr.exit(tc, "getEdgeServerList");
        return vector;
    }

    public ConnProperties getConnProperties() {
        Tr.entry(tc, "getConnProperties");
        ConnProperties connProperties = new ConnProperties();
        NodeList nodeList = elm.getElementsByTagName("ConnectionProperties");
        if (nodeList.getLength() > 0) {
            NamedNodeMap namedNodeMap = nodeList.item(0).getAttributes();
            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                if (namedNodeMap.item(i).getNodeName().equals("certFile")) {
                    connProperties.certFile = namedNodeMap.item(i).getNodeValue();
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName().equals("certPasswd")) {
                    connProperties.certPasswd = namedNodeMap.item(i).getNodeValue();
                    continue;
                }
                if (namedNodeMap.item(i).getNodeName().equals("certFileType")) {
                    connProperties.certFileType = namedNodeMap.item(i).getNodeValue();
                    continue;
                }
                if (!namedNodeMap.item(i).getNodeName().equals("timeOut")) continue;
                connProperties.timeOut = Integer.parseInt(namedNodeMap.item(i).getNodeValue());
            }
        }
        if (null == connProperties.certFileType) {
            connProperties.certFileType = "JKS";
        }
        Tr.exit(tc, "getConnProperties");
        return connProperties;
    }

    public String getCacheManager() {
        Tr.entry(tc, "getCacheManager");
        String string = "IBM-WAS";
        NamedNodeMap namedNodeMap = elm.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            if (!namedNodeMap.item(i).getNodeName().equals("CacheManager")) continue;
            string = namedNodeMap.item(i).getNodeValue();
        }
        Tr.exit(tc, "getCacheManager", string);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        esdp = null;
        tc = Tr.register(class$com$ibm$websphere$edge$dynacache$EdgeServerDistParser == null ? (class$com$ibm$websphere$edge$dynacache$EdgeServerDistParser = EdgeServerDistParser.class$("com.ibm.websphere.edge.dynacache.EdgeServerDistParser")) : class$com$ibm$websphere$edge$dynacache$EdgeServerDistParser);
    }
}

