/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.dynacache;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.edge.cdf.tsapi.CdsPublish;
import com.ibm.websphere.edge.dynacache.ConnProperties;
import com.ibm.websphere.edge.dynacache.DynaTriggerImpl;
import com.ibm.websphere.edge.dynacache.EdgeServerConfig;
import com.ibm.websphere.edge.dynacache.EdgeServerDistParser;
import com.ibm.websphere.edge.util.connection.NoSocketFromPoolException;
import com.ibm.websphere.edge.util.connection.SockConnection;
import com.ibm.websphere.edge.util.encode.Base64;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import com.ibm.websphere.servlet.cache.ExternalCacheAdapter;
import com.ibm.websphere.servlet.cache.ExternalCacheEntry;
import com.ibm.websphere.servlet.cache.FragmentInfo;
import com.ibm.websphere.servlet.cache.ServletCacheRequest;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URL;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.net.ssl.SSLSocket;
import javax.servlet.http.HttpServletResponse;

public class WteAdapter
implements ExternalCacheAdapter {
    private static TraceComponent tc = Tr.register(class$com$ibm$websphere$edge$dynacache$WteAdapter == null ? (class$com$ibm$websphere$edge$dynacache$WteAdapter = WteAdapter.class$("com.ibm.websphere.edge.dynacache.WteAdapter")) : class$com$ibm$websphere$edge$dynacache$WteAdapter);
    private static boolean adapterInitialized = false;
    private static boolean CDFEnabled = false;
    private static Vector cdfDomains;
    private static Vector cdfPublishers;
    private static Vector sharedEdgeServers;
    private static ConnProperties cProp;
    private static String CacheManager;
    private Vector aliasList = new Vector();
    private HashSet serverHostSet = new HashSet();
    private Vector edgeServers = new Vector();
    private boolean useRelativeUri = true;
    private SockConnection sockConnObj = null;
    private DynaTriggerImpl dynaTrigger;
    private boolean doDebug = tc.isEntryEnabled();
    private final String UNIX_ASATE_ROOT = "/opt/ibm/edge/asate";
    private final String WINDOWS_ASATE_ROOT = "C:\\Progra~1\\IBM\\edge\\asate\\";
    private final String WINDOWS_DYNA_CONF_FILE = "\\conf\\dynaedge-cfg.xml";
    private final String WINDOWS_DYNA_WAS_CONF_FILE = "\\properties\\dynaedge-cfg.xml";
    private final String UNIX_DYNA_CONF_FILE = "/conf/dynaedge-cfg.xml";
    private final String UNIX_DYNA_WAS_CONF_FILE = "/properties/dynaedge-cfg.xml";
    private EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.localize.dynacache");
    private LogModule logModule = null;
    static /* synthetic */ Class class$com$ibm$websphere$edge$dynacache$WteAdapter;

    public void clear() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void preInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        String string;
        int n;
        Tr.entry(tc, "preInvoke");
        FragmentInfo fragmentInfo = servletCacheRequest.getFragmentInfo();
        Vector vector = WteAdapter.getCDFDomains();
        String string2 = servletCacheRequest.getHeader("Host");
        if (string2 != null) {
            int n2;
            string2.toUpperCase();
            if (-1 == string2.indexOf(58) && (n2 = servletCacheRequest.getServerPort()) > 0) {
                string2 = string2 + ":" + String.valueOf(n2);
            }
            HashSet hashSet = this.serverHostSet;
            synchronized (hashSet) {
                this.serverHostSet.add(string2);
            }
        }
        if ((n = fragmentInfo.getTimeLimit()) == 0 || n == -1) {
            n = 864000;
        }
        if (CDFEnabled) {
            string = "cache-mgr=" + CacheManager + ", cachemgr-timeout=" + n + ", CDFEnabled";
            String string3 = (String)vector.elementAt(0);
            httpServletResponse.setHeader("CDIST_CDN", string3);
            Tr.debug(tc, "Setting CDIST_CDN header " + string3);
            String string4 = fragmentInfo.getId();
            httpServletResponse.setHeader("CDIST_FILENAME", string4);
            Tr.debug(tc, "Setting CDIST_FILENAME header " + string4);
        } else {
            string = "cache-mgr=" + CacheManager + ", cachemgr-timeout=" + n;
        }
        httpServletResponse.setHeader("Cache-Control", string);
        Tr.debug(tc, "Setting cache-control header " + string);
        Tr.exit(tc, "preInvoke");
    }

    public void postInvoke(ServletCacheRequest servletCacheRequest, HttpServletResponse httpServletResponse) {
        Tr.entry(tc, "postInvoke");
        Tr.exit(tc, "postInvoke");
    }

    public void invalidateIds(Iterator iterator) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidatePages(Iterator iterator) {
        String string;
        String string2;
        Tr.entry(tc, "invalidatePages");
        Vector<String> vector = new Vector<String>();
        StringBuffer stringBuffer = new StringBuffer();
        StringBuffer stringBuffer2 = new StringBuffer();
        while (iterator.hasNext()) {
            string2 = (String)iterator.next();
            vector.addElement(string2);
            Tr.debug(tc, "edge invalidating " + string2);
            string = "INVALIDATE " + string2;
            stringBuffer2.append(string + " ");
            if (this.useRelativeUri) continue;
            HashSet hashSet = this.serverHostSet;
            synchronized (hashSet) {
                Iterator iterator2 = this.serverHostSet.iterator();
                while (iterator2.hasNext()) {
                    String string3;
                    String string4 = (String)iterator2.next();
                    if (string4 == null) continue;
                    String string5 = string4 + string2;
                    if (string5.indexOf(":443") != -1) {
                        string3 = "INVALIDATE HTTPS://" + string5;
                        stringBuffer.append(string3 + " ");
                        continue;
                    }
                    string3 = "INVALIDATE HTTP://" + string5;
                    stringBuffer.append(string3 + " ");
                }
            }
        }
        string2 = stringBuffer.toString();
        string = stringBuffer2.toString();
        this.PostMessage(string2, string, vector);
        Tr.exit(tc, "invalidatePages");
    }

    public void setAddress(String string) {
        Tr.entry(tc, "setAddress(host) " + string);
        this.initConfig();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreElements()) {
            boolean bl = false;
            String string2 = (String)stringTokenizer.nextElement();
            EdgeServerConfig edgeServerConfig = new EdgeServerConfig();
            edgeServerConfig.setEndPoint(string2);
            for (int i = 0; i < sharedEdgeServers.size(); ++i) {
                EdgeServerConfig edgeServerConfig2 = (EdgeServerConfig)sharedEdgeServers.get(i);
                if (!edgeServerConfig2.equals(edgeServerConfig)) continue;
                Tr.debug(tc, "setAddress: Endpoint in shared list - discarding entry from dynacache.xml");
                bl = true;
                break;
            }
            if (bl) continue;
            this.edgeServers.addElement(edgeServerConfig);
            this.useRelativeUri = false;
        }
        this.edgeServers.addAll(sharedEdgeServers);
        Tr.debug(tc, "setAddress: Initialized Edgeservers = " + this.edgeServers.size());
        Tr.exit(tc, "setAddress(host)");
    }

    private synchronized void initConfig() {
        if (!adapterInitialized) {
            int n;
            Object[] objectArray = null;
            MessageFormat messageFormat = null;
            String string = null;
            String string2 = this.findConfigFile();
            if (string2 == null) {
                Tr.debug(tc, "Could not locate dynaedge-cfg.xml");
                return;
            }
            objectArray = new Object[]{string2};
            messageFormat = new MessageFormat("");
            messageFormat.applyPattern(this.rb.getString("WSES_CONF_FILE", 1));
            string = messageFormat.format(objectArray);
            this.logModule.log(string);
            EdgeServerDistParser edgeServerDistParser = EdgeServerDistParser.getEdgeServerDistParserObj(string2);
            Vector vector = edgeServerDistParser.getMasterCDSUri();
            cdfDomains = edgeServerDistParser.getMasterCDSDomains();
            sharedEdgeServers = edgeServerDistParser.getEdgeServerList();
            cProp = edgeServerDistParser.getConnProperties();
            CacheManager = edgeServerDistParser.getCacheManager();
            cdfPublishers = new Vector();
            URL uRL = null;
            CdsPublish cdsPublish = null;
            for (n = 0; n < vector.size(); ++n) {
                try {
                    uRL = new URL((String)vector.get(n));
                    Tr.debug(tc, "WteAdapter: about to create publisher");
                    cdsPublish = new CdsPublish(uRL, this.doDebug);
                    Tr.debug(tc, "WteAdapter: Create publisher");
                    cdfPublishers.addElement(cdsPublish);
                    CDFEnabled = true;
                    Tr.debug(tc, "WteAdapter: initialized publisher");
                    continue;
                }
                catch (MalformedURLException malformedURLException) {
                    objectArray = new Object[]{uRL};
                    messageFormat = new MessageFormat("");
                    messageFormat.applyPattern(this.rb.getString("WSES_CDF_URL_INCORRECT", 1));
                    string = messageFormat.format(objectArray);
                    this.logModule.log(string);
                }
            }
            Tr.debug(tc, "WteAdapter: CDS Domains " + vector.size());
            for (n = 0; n < sharedEdgeServers.size(); ++n) {
                EdgeServerConfig edgeServerConfig = (EdgeServerConfig)sharedEdgeServers.get(n);
                if (edgeServerConfig.uriType.compareToIgnoreCase("absolute") != 0) continue;
                this.useRelativeUri = false;
            }
            Tr.debug(tc, "WteAdapter: Shared Edge Servers (from dynaedge-cfg.xml) - " + sharedEdgeServers.size());
            adapterInitialized = true;
        }
        if (CDFEnabled) {
            this.dynaTrigger = new DynaTriggerImpl();
        }
    }

    private void createEdgeConn(EdgeServerConfig edgeServerConfig) {
        Tr.entry(tc, "createEdgeConn");
        String string = null;
        try {
            if (!edgeServerConfig.isEndpointInitialized()) {
                String string2;
                String string3 = edgeServerConfig.getEndPoint();
                int n = string3.indexOf("//");
                if (-1 == n) {
                    string = new String("http");
                    string2 = new String(string3);
                } else {
                    string = new String(string3.substring(0, n - 1));
                    string2 = new String(string3.substring(n + 2));
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, ":");
                String string4 = (String)stringTokenizer.nextElement();
                int n2 = stringTokenizer.hasMoreElements() ? Integer.parseInt((String)stringTokenizer.nextElement()) : (string.compareToIgnoreCase("http") == 0 ? 80 : (string.compareToIgnoreCase("https") == 0 ? 443 : 0));
                edgeServerConfig.protocol = string;
                edgeServerConfig.hostname = string4;
                edgeServerConfig.port = n2;
            }
            Tr.debug(tc, "Protocol: " + edgeServerConfig.protocol + " HostName: " + edgeServerConfig.hostname + " Port: " + edgeServerConfig.port + " URI: " + edgeServerConfig.getInvalidationUrl());
            Socket socket = edgeServerConfig.protocol.compareToIgnoreCase("http") == 0 ? this.sockConnObj.getSockFromPool(edgeServerConfig.hostname, edgeServerConfig.port) : (edgeServerConfig.protocol.compareToIgnoreCase("https") == 0 ? this.sockConnObj.getSecSockFromPool(edgeServerConfig.hostname, edgeServerConfig.port, WteAdapter.cProp.certFile, WteAdapter.cProp.certFileType, WteAdapter.cProp.certPasswd) : null);
            edgeServerConfig.sock = socket;
            Tr.debug(tc, "CreateConnection: got connection " + socket);
        }
        catch (Exception exception) {
            this.logModule.log(this.rb.getString("WSES_CONN_FAIL") + edgeServerConfig);
            Tr.debug(tc, "Could not create connection to Edge Server: " + edgeServerConfig);
        }
        Tr.exit(tc, "createEdgeConn");
    }

    public void CloseEdgeConn(EdgeServerConfig edgeServerConfig) {
        Tr.entry(tc, "CloseEdgeConn");
        try {
            if (edgeServerConfig.protocol.compareToIgnoreCase("http") == 0) {
                this.sockConnObj.returnSockToPool(edgeServerConfig.hostname, edgeServerConfig.port, edgeServerConfig.sock);
            } else {
                this.sockConnObj.returnSecSockToPool(edgeServerConfig.hostname, edgeServerConfig.port, (SSLSocket)edgeServerConfig.sock);
            }
        }
        catch (Exception exception) {
            this.logModule.log(this.rb.getString("WSES_CLOSE_FAIL") + edgeServerConfig);
            Tr.debug(tc, "Exception in closing connection to EdgeServer");
            exception.printStackTrace();
        }
        Tr.exit(tc, "CloseEdgeConn");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writePages(Iterator iterator) {
        Tr.entry(tc, "writePages" + this.useRelativeUri);
        if (!this.useRelativeUri) {
            while (iterator.hasNext()) {
                ExternalCacheEntry externalCacheEntry = (ExternalCacheEntry)iterator.next();
                String string = externalCacheEntry.host;
                Vector vector = this.aliasList;
                synchronized (vector) {
                    if (!this.aliasList.contains(string)) {
                        this.aliasList.add(string);
                        Tr.debug(tc, "Alias: " + string);
                    }
                }
            }
        }
        Tr.exit(tc, "writePages");
    }

    private void PostMessage(String string, String string2, Vector vector) {
        int n;
        Tr.entry(tc, "PostMessage");
        EdgeServerConfig edgeServerConfig = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.sockConnObj == null) {
            this.sockConnObj = SockConnection.getSockConnObj(0, 0, 0, WteAdapter.cProp.timeOut);
        }
        for (n = 0; n < this.edgeServers.size(); ++n) {
            BufferedWriter bufferedWriter;
            Socket socket;
            try {
                edgeServerConfig = (EdgeServerConfig)this.edgeServers.get(n);
                this.createEdgeConn(edgeServerConfig);
                if (edgeServerConfig.sock == null) {
                    Tr.debug(tc, "Could not connect to the caching proxy server " + edgeServerConfig + ". Trying next server");
                    continue;
                }
                Tr.debug(tc, "PostMessage: processing EdgeServer " + edgeServerConfig);
                Tr.debug(tc, "PostMessage: make http header and body");
                stringBuffer.append("POST ");
                stringBuffer.append(edgeServerConfig.getInvalidationUrl());
                stringBuffer.append(" HTTP/1.1\r\nHost: ");
                stringBuffer.append(edgeServerConfig.hostname);
                stringBuffer.append(":");
                stringBuffer.append(String.valueOf(edgeServerConfig.port));
                stringBuffer.append("\r\n");
                if (edgeServerConfig.anyCredentials()) {
                    String string3 = edgeServerConfig.getUser();
                    String string4 = edgeServerConfig.getUserPasswd();
                    String string5 = string3 + ":" + string4;
                    String string6 = Base64.encode(string5.getBytes());
                    String string7 = "Basic " + string6;
                    stringBuffer.append("Authorization:");
                    stringBuffer.append(string7);
                    stringBuffer.append("\r\n");
                }
                if (edgeServerConfig.useAbsoluteUri()) {
                    stringBuffer.append("Content-length:");
                    stringBuffer.append(String.valueOf(string.length()));
                    stringBuffer.append("\r\n\r\n");
                    stringBuffer.append(string);
                } else {
                    stringBuffer.append("Content-length:");
                    stringBuffer.append(String.valueOf(string2.length()));
                    stringBuffer.append("\r\n\r\n");
                    stringBuffer.append(string2);
                }
                Tr.debug(tc, "PostMessage:" + stringBuffer);
                socket = edgeServerConfig.sock;
                Tr.debug(tc, "PostMessage: Connection " + socket);
                bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                Tr.debug(tc, "PostMessage: finished getting outputstream");
                bufferedWriter.write(stringBuffer.toString());
                bufferedWriter.flush();
                InputStream inputStream = socket.getInputStream();
                this.CloseEdgeConn(edgeServerConfig);
                Tr.debug(tc, "PostMessage: close connection");
            }
            catch (IOException iOException) {
                try {
                    Tr.debug(tc, "try one more time");
                    socket = this.sockConnObj.openEdgeSock(edgeServerConfig.hostname, edgeServerConfig.port);
                    bufferedWriter = new BufferedWriter(new OutputStreamWriter(socket.getOutputStream()));
                    bufferedWriter.write(stringBuffer.toString());
                    bufferedWriter.flush();
                    this.CloseEdgeConn(edgeServerConfig);
                }
                catch (IOException iOException2) {
                    this.logModule.log(this.rb.getString("WSES_POST_FAIL") + edgeServerConfig);
                    Tr.debug(tc, "IO:Not able to POST the invalidate message to remote edge" + edgeServerConfig);
                    iOException2.printStackTrace();
                }
                catch (NoSocketFromPoolException noSocketFromPoolException) {
                    this.logModule.log(this.rb.getString("WSES_POST_FAIL") + edgeServerConfig);
                    Tr.debug(tc, "SK:Not able to POST the invalidate message to remote edge" + edgeServerConfig);
                    noSocketFromPoolException.printStackTrace();
                }
            }
            WteAdapter wteAdapter = this;
            wteAdapter.sockConnObj.returnSockConnObj();
        }
        if (CDFEnabled) {
            Tr.debug(tc, "PostMessage: Processing CDS list");
            n = 0;
            this.dynaTrigger.setObjects(vector);
            for (int i = 0; i < cdfPublishers.size(); ++i) {
                CdsPublish cdsPublish = (CdsPublish)cdfPublishers.get(i);
                n = cdsPublish.pubInvalidate(this.dynaTrigger);
                Tr.debug(tc, "Publish: Invalidate URI " + n);
            }
        }
        Tr.exit(tc, "PostMessage");
    }

    protected static Vector getCDFDomains() {
        Tr.entry(tc, "getCDFDomains");
        Vector vector = null;
        if (CDFEnabled) {
            vector = cdfDomains;
            Tr.exit(tc, "getCDFDomains", vector.elementAt(0));
        }
        Tr.exit(tc, "getCDFDomains");
        return vector;
    }

    public String findConfigFile() {
        Tr.entry(tc, "findConfigFile");
        String string = null;
        String string2 = System.getProperty("os.name");
        String string3 = File.separator;
        String string4 = System.getProperty("server.root");
        String string5 = string4 + string3 + "logs";
        if (string2.startsWith("Windows")) {
            String string6 = LogPackage.getRegKeyValue(-2147483646, "SOFTWARE\\IBM\\WSES-Application Service at the Edge\\CurrentVersion", "PathName");
            if (string6 == null && string4 != null) {
                string = new String(string4 + "\\properties\\dynaedge-cfg.xml");
                System.setProperty("logs.package", string5 + string3 + "edge");
                Tr.debug(tc, "Log directory set to " + string5 + string3 + "edge");
            }
        } else {
            File file = new File("/opt/ibm/edge/asate");
            if (file.exists()) {
                string = new String("/opt/ibm/edge/asate/conf/dynaedge-cfg.xml");
            } else if (string4 != null) {
                string = new String(string4 + "/properties/dynaedge-cfg.xml");
                System.setProperty("logs.package", string5 + string3 + "edge");
                Tr.debug(tc, "Log directory set to " + string5 + string3 + "edge");
            }
        }
        this.logModule = LogPackage.register("dynaedge");
        Tr.debug(tc, "WteAdapter: using xml file " + string);
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

