/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.util.connection;

import com.ibm.websphere.edge.util.connection.NoSocketFromPoolException;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Properties;

public class ConnMgrBase {
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.localize.connmgr");
    public int poolSizeMin;
    public int poolSizeMax;
    public int siteSize;
    public int connTimeout;

    public void setPoolSizeMin(int n) {
        this.poolSizeMin = n;
    }

    public void setPoolSizeMax(int n) {
        this.poolSizeMax = n;
    }

    public void setSiteSize(int n) {
        this.siteSize = n;
    }

    public void setConnTimeout(int n) {
        this.connTimeout = n;
    }

    public int getPoolSizeMin() {
        return this.poolSizeMin;
    }

    public int getPoolSizeMax() {
        return this.poolSizeMax;
    }

    public int getSiteSize() {
        return this.siteSize;
    }

    public int getConnTimeout() {
        return this.connTimeout;
    }

    public String getProtocolFromURL(String string) {
        int n = string.indexOf("//");
        String string2 = -1 != n ? new String(string.substring(0, n - 1)) : new String("http");
        return string2;
    }

    public String getHostnameFromURL(String string) {
        String string2;
        int n = string.indexOf("//");
        if (-1 == n) {
            int n2 = string.indexOf(47);
            int n3 = string.indexOf(":");
            string2 = -1 == n2 ? (-1 == n3 ? new String(string) : new String(string.substring(0, n3 - 1))) : (-1 == n3 ? new String(string.substring(0, n2 - 1)) : new String(string.substring(0, n3 - 1)));
        } else {
            int n4 = string.indexOf("/", n + 2);
            int n5 = string.indexOf(":", n + 2);
            string2 = -1 == n4 ? (-1 == n5 ? new String(string.substring(n + 2)) : new String(string.substring(n + 2, n5 - 1))) : (-1 == n5 ? new String(string.substring(n + 2, n4 - 1)) : new String(string.substring(n + 2, n5 - 1)));
        }
        return string2;
    }

    public int getPortFromURL(String string) {
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf("//");
        if (-1 == n4) {
            n3 = string.indexOf(47);
            n2 = string.indexOf(":");
        } else {
            n3 = string.indexOf("/", n4 + 2);
            n2 = string.indexOf(":", n4 + 2);
        }
        if (-1 == n2) {
            n = 0;
        } else {
            String string2 = -1 == n3 ? new String(string.substring(n2 + 1)) : new String(string.substring(n2 + 1, n3 - 1));
            n = Integer.parseInt(string2);
        }
        return n;
    }

    public String getFileFromURL(String string) {
        int n = string.indexOf("//");
        int n2 = -1 == n ? string.indexOf(47) : string.indexOf("/", n + 2);
        String string2 = -1 == n2 ? null : new String(string.substring(n2 + 1));
        return string2;
    }

    public boolean isHttpsProtocol(String string) {
        return 0 == string.compareToIgnoreCase("https");
    }

    public String transferHostnameToIPString(String string) throws NoSocketFromPoolException {
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            return inetAddress.getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            String string2 = this.rb.getString("WSES_CONNMGR_UNKNOWNHOST");
            throw new NoSocketFromPoolException(string, string2);
        }
    }

    public String makeKey(String string, String string2, int n) throws NoSocketFromPoolException {
        String string3 = new String(string);
        string3 = string3.concat("://");
        String string4 = this.transferHostnameToIPString(string2);
        string3 = string3.concat(string4);
        Integer n2 = new Integer(n);
        String string5 = n2.toString();
        string3 = string3.concat(":");
        string3 = string3.concat(string5);
        return string3;
    }

    public String makeKey(String string) throws NoSocketFromPoolException {
        return this.makeKey("http", string, 80);
    }

    public String makeKey(String string, int n) throws NoSocketFromPoolException {
        return this.makeKey("http", string, n);
    }

    public String makeKey(String string, String string2) throws NoSocketFromPoolException {
        return this.makeKey(string, string2, 80);
    }

    public String makeKeyFromURL(String string) throws NoSocketFromPoolException {
        String string2 = this.getProtocolFromURL(string);
        String string3 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        if (0 == n) {
            return this.makeKey(string2, string3);
        }
        return this.makeKey(string2, string3, n);
    }

    public String makeHostPort(String string, int n) {
        String string2 = new String(string);
        if (0 == n) {
            return string2;
        }
        Integer n2 = new Integer(n);
        String string3 = n2.toString();
        string2 = string2.concat(":");
        string2 = string2.concat(string3);
        return string2;
    }

    public void setSSLPkg(String string, String string2, String string3) {
        Properties properties = System.getProperties();
        properties.put("java.protocol.handler.pkgs", "com.ibm.net.ssl.internal.www.protocol");
        if (null != string && null != string3) {
            properties.put("javax.net.ssl.trustStore", string);
            properties.put("javax.net.ssl.trustStorePassword", string3);
            if (null != string2) {
                properties.put("javax.net.ssl.trustStoreType", string2);
            }
        }
        System.setProperties(properties);
    }
}

