/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.util.connection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.edge.util.connection.ConnMgrBase;
import com.ibm.websphere.edge.util.connection.NoSocketFromPoolException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Stack;

public class EdgeConnection
extends ConnMgrBase {
    private static TraceComponent tc = Tr.register(class$com$ibm$websphere$edge$util$connection$EdgeConnection == null ? (class$com$ibm$websphere$edge$util$connection$EdgeConnection = EdgeConnection.class$("com.ibm.websphere.edge.util.connection.EdgeConnection")) : class$com$ibm$websphere$edge$util$connection$EdgeConnection);
    private static EdgeConnection edgeConn = null;
    private Hashtable connSiteHtb = new Hashtable();
    static /* synthetic */ Class class$com$ibm$websphere$edge$util$connection$EdgeConnection;

    private EdgeConnection() {
        this.setPoolSizeMin(0);
        this.setPoolSizeMax(16);
        this.setSiteSize(10);
        this.setConnTimeout(10000);
    }

    private EdgeConnection(int n, int n2, int n3, int n4) {
        this.setPoolSizeMin(n);
        this.setPoolSizeMax(n2 > 0 ? n2 : 16);
        this.setSiteSize(n3 > 0 ? n3 : 10);
        this.setConnTimeout(n4 > 0 ? n4 : 10000);
    }

    private static synchronized void edgeConnObjInit() {
        if (null == edgeConn) {
            edgeConn = new EdgeConnection();
        }
    }

    private static synchronized void edgeConnObjInit(int n, int n2, int n3, int n4) {
        if (null == edgeConn) {
            edgeConn = new EdgeConnection(n, n2, n3, n4);
        }
    }

    public static EdgeConnection getEdgeConnObj() {
        EdgeConnection.edgeConnObjInit();
        return edgeConn;
    }

    public static EdgeConnection getEdgeConnObj(int n, int n2, int n3, int n4) {
        EdgeConnection.edgeConnObjInit(n, n2, n3, n4);
        return edgeConn;
    }

    public HttpURLConnection makeSecEdgeConn(String string, String string2, int n, String string3, String string4, String string5, String string6) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeEdgeConn");
            Tr.debug(tc, "(protocol, host, port, file)= (" + string + ", " + string2 + ", " + n + ", " + string3 + ")");
        }
        HttpURLConnection httpURLConnection = null;
        if (null == string || null == string2) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "some not defined in (protocol, host)= (" + string + ", " + string2 + ")");
            }
            httpURLConnection = null;
        } else {
            if (0 == string.compareToIgnoreCase("https")) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "load security package");
                }
                this.setSSLPkg(string4, string5, string6);
            }
            try {
                URL uRL = n == 0 ? new URL(string, string2, string3) : new URL(string, string2, n, string3);
                httpURLConnection = (HttpURLConnection)uRL.openConnection();
            }
            catch (MalformedURLException malformedURLException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, string2 + "/" + string3 + " can be resolved\n");
                }
                malformedURLException.printStackTrace();
            }
            catch (IOException iOException) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "makeEdgeConn IO exception");
                }
                iOException.printStackTrace();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeEdgeConn");
        }
        return httpURLConnection;
    }

    public HttpURLConnection makeSecEdgeConn(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "makeEdgeConn");
            Tr.debug(tc, "url " + string);
        }
        String string5 = this.getProtocolFromURL(string);
        String string6 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        String string7 = this.getFileFromURL(string);
        HttpURLConnection httpURLConnection = this.makeSecEdgeConn(string5, string6, n, string7, string2, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "makeEdgeConn");
        }
        return httpURLConnection;
    }

    private int edgeSecConnPoolInit(String string, String string2, int n, String string3, String string4, String string5, String string6) throws NoSocketFromPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "edgeConnPoolInit");
            Tr.debug(tc, "(protocol, host, port, file, keyFile, keyFileType, passwd)= (" + string + ", " + string2 + ", " + n + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + ")");
        }
        Stack<HttpURLConnection> stack = new Stack<HttpURLConnection>();
        int n2 = 0;
        for (int i = 0; i < this.poolSizeMax; ++i) {
            HttpURLConnection httpURLConnection = this.makeSecEdgeConn(string, string2, n, string3, string4, string5, string6);
            if (null == httpURLConnection) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "can not make conn");
                }
                n2 = 1;
                break;
            }
            stack.push(httpURLConnection);
        }
        if (n2 == 0) {
            String string7 = n == 0 ? this.makeKey(string, string2) : this.makeKey(string, string2, n);
            this.connSiteHtb.put(string7, stack);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "put one conn pool to the table with key " + string7);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "edgeConnPoolInit");
        }
        return n2;
    }

    private int edgeSecConnPoolInit(String string, String string2, String string3, String string4) throws NoSocketFromPoolException {
        String string5 = this.getProtocolFromURL(string);
        String string6 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        String string7 = this.getFileFromURL(string);
        return this.edgeSecConnPoolInit(string5, string6, n, string7, string2, string3, string4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpURLConnection getSecEdgeConnFromPool(String string, String string2, int n, String string3, String string4, String string5, String string6) throws NoSocketFromPoolException {
        HttpURLConnection httpURLConnection;
        Stack stack;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEdgeConnFromPool");
            Tr.debug(tc, "(protocol, host, port, file, keyFile, keyFileType, passwd)= (" + string + ", " + string2 + ", " + n + ", " + string3 + ", " + string4 + ", " + string5 + ", " + string6 + ")");
        }
        boolean bl = true;
        String string7 = n == 0 ? this.makeKey(string, string2) : this.makeKey(string, string2, n);
        Cloneable cloneable = this.connSiteHtb;
        synchronized (cloneable) {
            if (!this.connSiteHtb.containsKey(string7)) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "the conn is not initialized with key " + string7);
                }
                bl = false;
            } else {
                stack = (Stack)this.connSiteHtb.get(string7);
                if (stack.empty()) {
                    this.connSiteHtb.remove(string7);
                    bl = false;
                } else {
                    bl = true;
                }
            }
            if (!bl) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "make new conn pool with key " + string7);
                }
                if (this.edgeSecConnPoolInit(string, string2, n, string3, string4, string5, string6) != 0) {
                    HttpURLConnection httpURLConnection2 = null;
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getEdgeConnFromPool");
                    }
                    return httpURLConnection2;
                }
            }
        }
        stack = (Stack)this.connSiteHtb.get(string7);
        cloneable = stack;
        synchronized (cloneable) {
            httpURLConnection = (HttpURLConnection)stack.pop();
            if (null != httpURLConnection) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "get one from the pool");
                }
            } else {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "no connection left, make a pool");
                }
                httpURLConnection = this.makeSecEdgeConn(string, string2, n, string3, string4, string5, string6);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEdgeConnFromPool");
        }
        return httpURLConnection;
    }

    public HttpURLConnection getSecEdgeConnFromPool(String string, String string2, String string3, String string4) throws NoSocketFromPoolException {
        String string5 = this.getProtocolFromURL(string);
        String string6 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        String string7 = this.getFileFromURL(string);
        return this.getSecEdgeConnFromPool(string5, string6, n, string7, string2, string3, string4);
    }

    private void closeSecEdgeConn(HttpURLConnection httpURLConnection) {
        httpURLConnection.disconnect();
    }

    public void returnSecEdgeConn(String string, String string2, int n, HttpURLConnection httpURLConnection) {
    }

    public void returnSecEdgeConn(String string, HttpURLConnection httpURLConnection) {
    }

    public HttpURLConnection getEdgeConnFromPool(String string, String string2, int n, String string3) throws NoSocketFromPoolException {
        return this.getSecEdgeConnFromPool(string, string2, n, string3, null, null, null);
    }

    public HttpURLConnection getEdgeConnFromPool(String string) throws NoSocketFromPoolException {
        return this.getSecEdgeConnFromPool(string, null, null, null);
    }

    private void closeEdgeConn(HttpURLConnection httpURLConnection) {
        this.closeSecEdgeConn(httpURLConnection);
    }

    public void returnEdgeConn(String string, String string2, int n, HttpURLConnection httpURLConnection) {
    }

    public void returnEdgeConn(String string, HttpURLConnection httpURLConnection) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

