/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.util.connection;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.net.ssl.SSLContext;
import com.ibm.websphere.edge.util.connection.ConnMgrBase;
import com.ibm.websphere.edge.util.connection.NoSocketFromPoolException;
import com.ibm.websphere.edge.util.connection.OneSiteSocks;
import com.ibm.websphere.edge.util.connection.ReturnSocketException;
import com.ibm.websphere.edge.util.connection.SecSockWithTime;
import com.ibm.websphere.edge.util.connection.SockContext;
import com.ibm.websphere.edge.util.connection.SockWithTime;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SockConnection
extends ConnMgrBase {
    private static TraceComponent tc = Tr.register(class$com$ibm$websphere$edge$util$connection$SockConnection == null ? (class$com$ibm$websphere$edge$util$connection$SockConnection = SockConnection.class$("com.ibm.websphere.edge.util.connection.SockConnection")) : class$com$ibm$websphere$edge$util$connection$SockConnection);
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.localize.connmgr");
    private static SockConnection sockConn = null;
    private static int connObjRefCounter = 0;
    private Hashtable sockSiteHtb = new Hashtable();
    static /* synthetic */ Class class$com$ibm$websphere$edge$util$connection$SockConnection;

    private SockConnection() {
        this.setPoolSizeMin(0);
        this.setPoolSizeMax(16);
        this.setSiteSize(10);
        this.setConnTimeout(10000);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SockConnection.this.doPoolCheck();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            }
        };
        new Thread(runnable).start();
    }

    private SockConnection(int n, int n2, int n3, int n4) {
        this.setPoolSizeMin(n);
        this.setPoolSizeMax(n2 > 0 ? n2 : 16);
        this.setSiteSize(n3 > 0 ? n3 : 10);
        this.setConnTimeout(n4 > 0 ? n4 : 10000);
        Runnable runnable = new Runnable(){

            public void run() {
                try {
                    SockConnection.this.doPoolCheck();
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            }
        };
        new Thread(runnable).start();
    }

    private static synchronized void sockConnInit() {
        if (null == sockConn) {
            sockConn = new SockConnection();
        }
        ++connObjRefCounter;
    }

    private static synchronized void sockConnInit(int n, int n2, int n3, int n4) {
        if (null == sockConn) {
            sockConn = new SockConnection(n, n2, n3, n4);
        }
        ++connObjRefCounter;
    }

    public static SockConnection getSockConnObj() {
        SockConnection.sockConnInit();
        return sockConn;
    }

    public static SockConnection getSockConnObj(int n, int n2, int n3, int n4) {
        SockConnection.sockConnInit(n, n2, n3, n4);
        return sockConn;
    }

    public static synchronized void returnSockConnObj() {
        --connObjRefCounter;
    }

    public Socket openEdgeSock(String string, int n) throws NoSocketFromPoolException {
        Socket socket = null;
        String string2 = this.makeHostPort(string, n);
        try {
            socket = new Socket(string, n);
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            String string3 = this.rb.getString("WSES_CONNMGR_UNKNOWNHOST");
            throw new NoSocketFromPoolException(string2, string3);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string4 = this.rb.getString("WSES_CONNMGR_IO_OPEN");
            throw new NoSocketFromPoolException(string2, string4);
        }
        return socket;
    }

    public Socket openEdgeSock(String string) throws NoSocketFromPoolException {
        String string2 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        Object var4_4 = null;
        String string3 = this.makeHostPort(string2, n);
        return this.openEdgeSock(string2, n);
    }

    public void closeEdgeSock(Socket socket) throws ReturnSocketException {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = this.rb.getString("WSES_CONNMGR_IO_CLOSE");
            throw new ReturnSocketException(socket.toString(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket getSockFromPool(String string, int n) throws NoSocketFromPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSockFromPool");
            Tr.debug(tc, "hostname " + string + " port " + n);
        }
        OneSiteSocks oneSiteSocks = null;
        Socket socket = null;
        boolean bl = true;
        String string2 = this.makeKey(string, n);
        Object object = this.sockSiteHtb;
        synchronized (object) {
            if (this.sockSiteHtb.containsKey(string2)) {
                oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string2);
            }
        }
        if (null != oneSiteSocks) {
            object = oneSiteSocks;
            synchronized (object) {
                Stack stack = oneSiteSocks.getSocks();
                while (!stack.empty()) {
                    SockWithTime sockWithTime = (SockWithTime)stack.pop();
                    if (new Date().getTime() - sockWithTime.getSockTimeStamp() < (long)this.connTimeout) {
                        socket = sockWithTime.getSock();
                        bl = false;
                        if (!tc.isEntryEnabled()) break;
                        Tr.debug(tc, "get a socket from pool");
                        break;
                    }
                    try {
                        this.closeEdgeSock(sockWithTime.getSock());
                    }
                    catch (ReturnSocketException returnSocketException) {
                        returnSocketException.printStackTrace();
                    }
                }
            }
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "no socket left, open one");
            }
            socket = this.openEdgeSock(string, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEdgeConnFromPool");
        }
        return socket;
    }

    public Socket getSockFromPool(String string) throws NoSocketFromPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSockFromPool");
            Tr.debug(tc, "url " + string);
        }
        String string2 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        Socket socket = this.getSockFromPool(string2, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEdgeConnFromPool");
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSockToPool(String string, int n, Socket socket) throws ReturnSocketException {
        Stack<SockWithTime> stack;
        String string2;
        String string3;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSockToPool");
            Tr.debug(tc, " hostname " + string + " port " + n);
        }
        OneSiteSocks oneSiteSocks = null;
        boolean bl = false;
        try {
            string3 = this.makeKey(string, n);
        }
        catch (NoSocketFromPoolException noSocketFromPoolException) {
            noSocketFromPoolException.printStackTrace();
            return;
        }
        SockWithTime sockWithTime = new SockWithTime(socket, new Date().getTime());
        try {
            string2 = this.transferHostnameToIPString(string);
        }
        catch (NoSocketFromPoolException noSocketFromPoolException) {
            noSocketFromPoolException.printStackTrace();
            return;
        }
        Object object = this.sockSiteHtb;
        synchronized (object) {
            if (!this.sockSiteHtb.containsKey(string3)) {
                stack = new Stack<SockWithTime>();
                stack.push(sockWithTime);
                oneSiteSocks = new OneSiteSocks("http", string2, n, null, stack);
                this.sockSiteHtb.put(string3, oneSiteSocks);
            } else {
                bl = true;
            }
        }
        if (bl) {
            oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string3);
            object = oneSiteSocks;
            synchronized (object) {
                stack = oneSiteSocks.getSocks();
                if (null == stack) {
                    stack = new Stack<SockWithTime>();
                    stack.push(sockWithTime);
                    oneSiteSocks.setSocks(stack);
                } else if (this.poolSizeMax > stack.size()) {
                    stack.push(sockWithTime);
                } else {
                    this.closeEdgeSock(socket);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSockToPool");
        }
    }

    public void returnSockToPool(String string, Socket socket) throws ReturnSocketException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSockToPool");
            Tr.debug(tc, "url " + string);
        }
        String string2 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        this.returnSockToPool(string2, n, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSockToPool");
        }
    }

    public void returnSockToPool(Socket socket) throws ReturnSocketException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSockToPool");
        }
        InetAddress inetAddress = socket.getInetAddress();
        String string = inetAddress.getHostAddress();
        int n = socket.getPort();
        this.returnSockToPool(string, n, socket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSockToPool");
        }
    }

    public SSLSocket openEdgeSecSock(String string, int n, String string2, String string3, String string4) throws NoSocketFromPoolException {
        String string5 = this.makeKey("https", string, n);
        OneSiteSocks oneSiteSocks = null;
        SockContext sockContext = null;
        SSLContext sSLContext = null;
        SSLSocket sSLSocket = null;
        String string6 = this.makeHostPort(string, n);
        if (this.sockSiteHtb.containsKey(string5)) {
            oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string5);
        }
        if (null != oneSiteSocks && null != (sockContext = oneSiteSocks.getSockContext())) {
            sSLContext = sockContext.getSSLContext();
        }
        if (null == sSLContext) {
            sockContext = new SockContext(string6, string2, string3, string4);
            sSLContext = sockContext.getSSLContext();
            oneSiteSocks = new OneSiteSocks("https", this.transferHostnameToIPString(string), n, sockContext, null);
            this.sockSiteHtb.put(string5, oneSiteSocks);
        }
        try {
            SSLSocketFactory sSLSocketFactory = sSLContext.getSocketFactory();
            sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(string, n);
            sSLSocket.startHandshake();
        }
        catch (UnknownHostException unknownHostException) {
            unknownHostException.printStackTrace();
            String string7 = this.rb.getString("WSES_CONNMGR_UNKNOWNHOST");
            throw new NoSocketFromPoolException(string6, string7);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string8 = this.rb.getString("WSES_CONNMGR_IO_OPEN");
            throw new NoSocketFromPoolException(string6, string8);
        }
        return sSLSocket;
    }

    public SSLSocket openEdgeSecSock(String string, String string2, String string3, String string4) throws NoSocketFromPoolException {
        String string5 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        return this.openEdgeSecSock(string5, n, string2, string3, string4);
    }

    public void closeEdgeSecSock(SSLSocket sSLSocket) throws ReturnSocketException {
        try {
            sSLSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string = this.rb.getString("WSES_CONNMGR_IO_CLOSE");
            throw new ReturnSocketException(sSLSocket.toString(), string);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SSLSocket getSecSockFromPool(String string, int n, String string2, String string3, String string4) throws NoSocketFromPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecSockFromPool");
            Tr.debug(tc, "hostname " + string + " port " + n + " key " + string2 + " type " + string3 + " passwd *");
        }
        String string5 = this.makeKey("https", string, n);
        OneSiteSocks oneSiteSocks = null;
        SSLSocket sSLSocket = null;
        boolean bl = true;
        Object object = this.sockSiteHtb;
        synchronized (object) {
            if (this.sockSiteHtb.containsKey(string5)) {
                oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string5);
            }
        }
        if (null != oneSiteSocks) {
            object = oneSiteSocks;
            synchronized (object) {
                Stack stack = oneSiteSocks.getSocks();
                if (null != stack) {
                    while (!stack.empty()) {
                        SecSockWithTime secSockWithTime = (SecSockWithTime)stack.pop();
                        if (new Date().getTime() - secSockWithTime.getSecSockTimeStamp() < (long)this.connTimeout) {
                            sSLSocket = secSockWithTime.getSecSock();
                            bl = false;
                            if (!tc.isEntryEnabled()) break;
                            Tr.debug(tc, "get a SSLSocket from pool");
                            break;
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.debug(tc, "drop one SSLSocket from pool");
                        }
                        try {
                            this.closeEdgeSecSock(secSockWithTime.getSecSock());
                        }
                        catch (ReturnSocketException returnSocketException) {
                            returnSocketException.printStackTrace();
                        }
                    }
                }
            }
        }
        if (bl) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "no SSLSocket left, open one");
            }
            sSLSocket = this.openEdgeSecSock(string, n, string2, string3, string4);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEdgeConnFromPool");
        }
        return sSLSocket;
    }

    public SSLSocket getSecSockFromPool(String string, String string2, String string3, String string4) throws NoSocketFromPoolException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getSecSockFromPool");
            Tr.debug(tc, "url " + string + " key " + string2 + " type " + string3 + " passwd *");
        }
        String string5 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        SSLSocket sSLSocket = this.getSecSockFromPool(string5, n, string2, string3, string4);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEdgeConnFromPool");
        }
        return sSLSocket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnSecSockToPool(String string, int n, SSLSocket sSLSocket) throws ReturnSocketException {
        String string2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSecSockToPool");
            Tr.debug(tc, " hostname " + string + " port " + n);
        }
        try {
            string2 = this.makeKey("https", string, n);
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "key " + string2 + " is not registered, CHECK key!!!");
            }
        }
        catch (NoSocketFromPoolException noSocketFromPoolException) {
            noSocketFromPoolException.printStackTrace();
            return;
        }
        SecSockWithTime secSockWithTime = new SecSockWithTime(sSLSocket, new Date().getTime());
        OneSiteSocks oneSiteSocks = null;
        boolean bl = false;
        Object object = this.sockSiteHtb;
        synchronized (object) {
            if (!this.sockSiteHtb.containsKey(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.debug(tc, "key " + string2 + " is not registered, CHECK key!!!");
                }
                this.closeEdgeSecSock(sSLSocket);
            } else {
                bl = true;
            }
        }
        if (bl) {
            oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string2);
            object = oneSiteSocks;
            synchronized (object) {
                Stack<SecSockWithTime> stack = oneSiteSocks.getSocks();
                if (null == stack) {
                    stack = new Stack<SecSockWithTime>();
                    stack.push(secSockWithTime);
                    oneSiteSocks.setSocks(stack);
                } else if (this.poolSizeMax > stack.size()) {
                    stack.push(secSockWithTime);
                } else {
                    this.closeEdgeSecSock(sSLSocket);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSecSockToPool");
        }
    }

    public void returnSecSockToPool(String string, SSLSocket sSLSocket) throws ReturnSocketException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSecSockToPool");
            Tr.debug(tc, "url " + string);
        }
        String string2 = this.getHostnameFromURL(string);
        int n = this.getPortFromURL(string);
        this.returnSecSockToPool(string2, n, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSecSockToPool");
        }
    }

    public void returnSecSockToPool(SSLSocket sSLSocket) throws ReturnSocketException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "returnSecSockToPool");
        }
        InetAddress inetAddress = sSLSocket.getInetAddress();
        String string = inetAddress.getHostAddress();
        int n = sSLSocket.getPort();
        this.returnSecSockToPool(string, n, sSLSocket);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "returnSecSockToPool");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int poolSize(String string, String string2, int n) {
        String string3;
        int n2 = 0;
        OneSiteSocks oneSiteSocks = null;
        boolean bl = false;
        try {
            string3 = this.makeKey(string, string2, n);
        }
        catch (NoSocketFromPoolException noSocketFromPoolException) {
            noSocketFromPoolException.printStackTrace();
            return 0;
        }
        Hashtable hashtable = this.sockSiteHtb;
        synchronized (hashtable) {
            Stack stack;
            if (this.sockSiteHtb.containsKey(string3) && null != (stack = (oneSiteSocks = (OneSiteSocks)this.sockSiteHtb.get(string3)).getSocks())) {
                n2 = stack.size();
            }
        }
        return n2;
    }

    public int poolSize(String string, int n) {
        return this.poolSize("http", string, n);
    }

    private void freshAllSiteSockPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "freshAllSiteSockPool");
        }
        Enumeration enumeration = this.sockSiteHtb.elements();
        while (enumeration.hasMoreElements()) {
            long l;
            Object object;
            OneSiteSocks oneSiteSocks = (OneSiteSocks)enumeration.nextElement();
            String string = oneSiteSocks.getProtocol();
            Stack stack = oneSiteSocks.getSocks();
            Stack<Object> stack2 = new Stack<Object>();
            if (null == stack) continue;
            if (0 == string.compareToIgnoreCase("http")) {
                while (!stack.empty()) {
                    object = (SockWithTime)stack.pop();
                    l = new Date().getTime() - ((SockWithTime)object).getSockTimeStamp();
                    if (l < (long)this.connTimeout) {
                        stack2.push(object);
                        continue;
                    }
                    try {
                        this.closeEdgeSock(((SockWithTime)object).getSock());
                    }
                    catch (ReturnSocketException returnSocketException) {
                        returnSocketException.printStackTrace();
                    }
                }
            } else if (0 == string.compareToIgnoreCase("https")) {
                while (!stack.empty()) {
                    object = (SecSockWithTime)stack.pop();
                    l = new Date().getTime() - ((SecSockWithTime)object).getSecSockTimeStamp();
                    if (l < (long)this.connTimeout) {
                        stack2.push(object);
                        continue;
                    }
                    try {
                        this.closeEdgeSecSock(((SecSockWithTime)object).getSecSock());
                    }
                    catch (ReturnSocketException returnSocketException) {
                        returnSocketException.printStackTrace();
                    }
                }
            } else {
                if (!tc.isEntryEnabled()) continue;
                Tr.debug(tc, "unkown protocol " + string);
                continue;
            }
            oneSiteSocks.setSocks(stack2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "freshAllSiteSockPool");
        }
    }

    private void cleanAllSiteSockPool() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanupAllSiteSockPool");
        }
        Enumeration enumeration = this.sockSiteHtb.elements();
        while (enumeration.hasMoreElements()) {
            Object object;
            OneSiteSocks oneSiteSocks = (OneSiteSocks)enumeration.nextElement();
            String string = oneSiteSocks.getProtocol();
            Stack stack = oneSiteSocks.getSocks();
            if (null == stack) continue;
            if (0 == string.compareToIgnoreCase("http")) {
                while (!stack.empty()) {
                    object = (SockWithTime)stack.pop();
                    try {
                        this.closeEdgeSock(((SockWithTime)object).getSock());
                    }
                    catch (ReturnSocketException returnSocketException) {
                        returnSocketException.printStackTrace();
                    }
                }
                continue;
            }
            if (0 == string.compareToIgnoreCase("https")) {
                while (!stack.empty()) {
                    object = (SecSockWithTime)stack.pop();
                    try {
                        this.closeEdgeSecSock(((SecSockWithTime)object).getSecSock());
                    }
                    catch (ReturnSocketException returnSocketException) {
                        returnSocketException.printStackTrace();
                    }
                }
                continue;
            }
            if (!tc.isEntryEnabled()) continue;
            Tr.debug(tc, "unkown protocol " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanAllSiteSockPool");
        }
    }

    public synchronized void doPoolCheck() throws InterruptedException {
        while (connObjRefCounter > 0) {
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "gabage collection thread do its work");
            }
            this.wait(this.connTimeout);
            this.freshAllSiteSockPool();
        }
        this.cleanAllSiteSockPool();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

