/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.util.connection;

import com.ibm.net.ssl.KeyManagerFactory;
import com.ibm.net.ssl.SSLContext;
import com.ibm.net.ssl.TrustManager;
import com.ibm.net.ssl.TrustManagerFactory;
import com.ibm.websphere.edge.util.connection.NoSocketFromPoolException;
import com.ibm.websphere.edge.util.localize.EdgeResourceBundle;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

public class SockContext {
    EdgeResourceBundle rb = new EdgeResourceBundle("com.ibm.websphere.edge.localize.connmgr");
    String m_keyFile;
    String m_keyFileType;
    String m_password;
    SSLContext m_sslCt;

    public SockContext(String string, String string2, String string3, String string4) throws NoSocketFromPoolException {
        this.m_keyFile = string2;
        this.m_keyFileType = string3;
        this.m_password = string4;
        try {
            KeyStore keyStore = null == string3 ? KeyStore.getInstance("JKS") : KeyStore.getInstance(string3);
            keyStore.load(new FileInputStream(string2), string4.toCharArray());
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance((String)"IbmX509");
            keyManagerFactory.init(keyStore, string4.toCharArray());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance((String)"IbmX509");
            trustManagerFactory.init(keyStore);
            TrustManager[] trustManagerArray = trustManagerFactory.getTrustManagers();
            this.m_sslCt = SSLContext.getInstance((String)"SSL");
            this.m_sslCt.init(keyManagerFactory.getKeyManagers(), trustManagerArray, null);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            String string5 = this.rb.getString("WSES_CONNMGR_AlGO");
            throw new NoSocketFromPoolException(string, string5);
        }
        catch (KeyStoreException keyStoreException) {
            keyStoreException.printStackTrace();
            String string6 = this.rb.getString("WSES_CONNMGR_KEYSTORE");
            throw new NoSocketFromPoolException(string, string6);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            String string7 = this.rb.getString("WSES_CONNMGR_KEYFILE");
            throw new NoSocketFromPoolException(string, string7);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            String string8 = this.rb.getString("WSES_CONNMGR_IO_OPEN");
            throw new NoSocketFromPoolException(string, string8);
        }
        catch (UnrecoverableKeyException unrecoverableKeyException) {
            unrecoverableKeyException.printStackTrace();
            String string9 = this.rb.getString("WSES_CONNMGR_BADKEY");
            throw new NoSocketFromPoolException(string, string9);
        }
        catch (KeyManagementException keyManagementException) {
            keyManagementException.printStackTrace();
            String string10 = this.rb.getString("WSES_CONNMGR_KEYMAG");
            throw new NoSocketFromPoolException(string, string10);
        }
        catch (CertificateException certificateException) {
            certificateException.printStackTrace();
            String string11 = this.rb.getString("WSES_CONNMGR_CERT");
            throw new NoSocketFromPoolException(string, string11);
        }
    }

    public SSLContext getSSLContext() {
        return this.m_sslCt;
    }

    public void setSSLContext(SSLContext sSLContext) {
        this.m_sslCt = sSLContext;
    }
}

