/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.edge.util.log;

import com.ibm.websphere.edge.util.log.LogModule;
import com.ibm.websphere.edge.util.log.LogPackage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

public class LogModuleImpl
implements LogModule {
    String ModuleName = null;
    PrintWriter logWriter = null;
    PrintStream traceStream = null;
    int refCount = 1;
    DateFormat dfLocalized;
    DateFormat df;
    boolean debug = false;

    LogModuleImpl(String string, boolean bl) {
        String string2;
        this.ModuleName = string;
        if (!bl && Boolean.getBoolean("edge.debug")) {
            bl = true;
        }
        this.debug = bl;
        String string3 = this.getDateString().replace('/', '.');
        String string4 = System.getProperty("logs.package");
        if (string4 == null || string4.length() == 0) {
            string4 = LogPackage.getAsateDir();
        } else if (!string4.endsWith(File.separator)) {
            string4 = string4 + File.separator;
        }
        if (string4 == null && string.equals("CdsPublish")) {
            string4 = LogPackage.getCdistDir();
        }
        if (string4 == null) {
            this.debug = false;
            return;
        }
        String string5 = string4 + "logs" + File.separator;
        File file = new File(string5);
        if (!file.exists()) {
            file.mkdirs();
        }
        if (!(file = new File(string2 = string4 + "traces" + File.separator)).exists()) {
            file.mkdirs();
        }
        String string6 = string5 + string + "-" + string3 + ".log";
        String string7 = string2 + string + "-" + string3 + ".trace";
        this.dfLocalized = DateFormat.getDateTimeInstance();
        this.df = DateFormat.getDateTimeInstance(3, 0, Locale.US);
        try {
            this.logWriter = new PrintWriter(new FileOutputStream(string6, true), true);
        }
        catch (Exception exception) {
            this.logWriter = null;
        }
        try {
            this.traceStream = new PrintStream(new FileOutputStream(string7, true), true);
        }
        catch (Exception exception) {
            this.traceStream = null;
        }
    }

    public synchronized void setDebug(boolean bl) {
        this.debug = bl;
    }

    public synchronized void log(String string) {
        if (this.logWriter == null) {
            return;
        }
        this.logWriter.println(this.dfLocalized.format(new Date()) + ": " + string);
    }

    public synchronized void trace(String string) {
        if (this.traceStream == null || !this.debug) {
            return;
        }
        this.traceStream.println(this.df.format(new Date()) + ": " + Integer.toHexString(Thread.currentThread().hashCode()) + " " + string);
    }

    public String getModuleName() {
        return this.ModuleName;
    }

    protected String getDateString() {
        DateFormat dateFormat = DateFormat.getDateInstance(3, Locale.US);
        return dateFormat.format(new Date());
    }

    protected synchronized int holdRef() {
        ++this.refCount;
        return this.refCount;
    }

    protected synchronized int releaseRef() {
        --this.refCount;
        if (this.refCount == 0) {
            this.cleanup();
        }
        return this.refCount;
    }

    protected void cleanup() {
        try {
            if (this.traceStream != null) {
                this.traceStream.close();
            }
            if (this.logWriter != null) {
                this.logWriter.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

