/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.ejbquery;

import com.ibm.ObjectQuery.IObjectQueryServiceImpl;
import com.ibm.ObjectQuery.IPreparedQuery;
import com.ibm.ObjectQuery.engine.GlbThreadLocal;
import com.ibm.ObjectQuery.engine.OSQLTypeMapper;
import com.ibm.websphere.eexquery.EEXConfig;
import com.ibm.websphere.ejbquery.QueryException;
import com.ibm.websphere.ejbquery.QueryIterator;
import com.ibm.websphere.ejbquery.QueryLocalIterator;
import java.rmi.RemoteException;
import java.sql.Blob;
import java.sql.Clob;
import java.util.Calendar;
import java.util.Properties;
import javax.ejb.CreateException;
import javax.ejb.EJBObject;
import javax.ejb.SessionBean;
import javax.ejb.SessionContext;

public class QueryBean
implements SessionBean {
    private SessionContext mySessionCtx = null;
    private static final long serialVersionUID = 3206093459760846163L;
    protected IObjectQueryServiceImpl queryService = null;

    public void ejbActivate() throws RemoteException {
    }

    public void ejbCreate() throws CreateException, RemoteException {
        EEXConfig eEXConfig = EEXConfig.getInstance();
        try {
            this.queryService = IObjectQueryServiceImpl.getInstance(eEXConfig);
        }
        catch (QueryException queryException) {
            throw new RemoteException(queryException.toString(), queryException);
        }
    }

    public void ejbPassivate() throws RemoteException {
    }

    public void ejbRemove() throws RemoteException {
    }

    public SessionContext getSessionContext() {
        return this.mySessionCtx;
    }

    public void setSessionContext(SessionContext sessionContext) throws RemoteException {
        this.mySessionCtx = sessionContext;
    }

    public QueryIterator executePlan(String string, Object[] objectArray, int n, int n2) throws RemoteException, QueryException {
        EEXConfig.getInstance().getLogger().setLogging(false);
        QueryIterator queryIterator = null;
        try {
            queryIterator = this.queryService.executeQueryPlan(string, objectArray, n, n2);
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        this.freeHlpObj();
        return queryIterator;
    }

    public QueryIterator executeQuery(String string, Object[] objectArray, Properties properties, int n, int n2) throws RemoteException, QueryException {
        EEXConfig.getInstance().getLogger().setLogging(false);
        QueryIterator queryIterator = null;
        String string2 = null;
        try {
            IPreparedQuery iPreparedQuery = this.prepareQry(string, objectArray, properties);
            string2 = iPreparedQuery.getQueryPlan();
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        catch (RemoteException remoteException) {
            this.freeHlpObj();
            throw remoteException;
        }
        try {
            queryIterator = this.queryService.executeQueryPlan(string2, objectArray, n, n2);
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        this.freeHlpObj();
        return queryIterator;
    }

    public String prepareQuery(String string, Object[] objectArray, Properties properties) throws RemoteException, QueryException {
        EEXConfig.getInstance().getLogger().setLogging(false);
        IPreparedQuery iPreparedQuery = null;
        try {
            iPreparedQuery = this.prepareQry(string, objectArray, properties);
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        this.freeHlpObj();
        return iPreparedQuery.getQueryPlan();
    }

    public QueryLocalIterator executePlan(String string, Object[] objectArray) throws QueryException {
        EEXConfig.getInstance().getLogger().setLogging(false);
        QueryLocalIterator queryLocalIterator = null;
        try {
            queryLocalIterator = this.queryService.executeQueryPlan(string, objectArray);
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        this.freeHlpObj();
        return queryLocalIterator;
    }

    public QueryLocalIterator executeQuery(String string, Object[] objectArray, Properties properties) throws QueryException {
        EEXConfig.getInstance().getLogger().setLogging(false);
        QueryLocalIterator queryLocalIterator = null;
        String string2 = null;
        try {
            IPreparedQuery iPreparedQuery = this.prepareQry(string, objectArray, properties);
            string2 = iPreparedQuery.getQueryPlan();
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        catch (RemoteException remoteException) {
            this.freeHlpObj();
            throw new QueryException(remoteException.toString());
        }
        try {
            queryLocalIterator = this.queryService.executeQueryPlan(string2, objectArray);
        }
        catch (QueryException queryException) {
            this.freeHlpObj();
            throw queryException;
        }
        this.freeHlpObj();
        return queryLocalIterator;
    }

    private void freeHlpObj() throws QueryException {
        Object object = GlbThreadLocal.get();
        GlbThreadLocal.set(null);
        if (object != null) {
            IObjectQueryServiceImpl.getConfiguration().returnQueryHelper(object);
        }
    }

    private IPreparedQuery prepareQry(String string, Object[] objectArray, Properties properties) throws RemoteException, QueryException {
        Object object;
        String[] stringArray = null;
        if (objectArray != null) {
            int n = objectArray.length;
            object = new String[n];
            stringArray = new String[n];
            String string2 = null;
            for (int i = 0; i < n; ++i) {
                object[i] = objectArray[i].getClass().getName();
                string2 = OSQLTypeMapper.getOSQLType(object[i]);
                if (string2 != null) {
                    stringArray[i] = string2;
                    continue;
                }
                if (objectArray[i] instanceof EJBObject) {
                    stringArray[i] = this.obj2type(object[i]);
                    System.out.println("type string is: " + stringArray[i]);
                    continue;
                }
                if (objectArray[i] instanceof Calendar) {
                    stringArray[i] = "calendar";
                    continue;
                }
                if (objectArray[i] instanceof Blob) {
                    stringArray[i] = "blob";
                    continue;
                }
                if (objectArray[i] instanceof Clob) {
                    stringArray[i] = "clob";
                    continue;
                }
                if (objectArray[i] instanceof Byte[]) {
                    stringArray[i] = "_varbinary";
                    continue;
                }
                System.out.println("Parameter: " + object[i] + " is not supported.");
            }
        }
        object = this.queryService.prepareQuery(string, new Boolean(false), stringArray);
        return object;
    }

    public String obj2type(String string) {
        String string2;
        int n;
        if (string == null) {
            return string;
        }
        int n2 = 0;
        char[] cArray = string.toCharArray();
        for (n = string.length(); n2 < n && cArray[n - 1] != '.'; --n) {
        }
        String string3 = string2 = n < string.length() ? string.substring(n, string.length()) : string;
        if (string2.startsWith("_")) {
            string2 = string2.substring(1);
            n = string2.length();
            string2 = string2.substring(0, n - 5);
        }
        return string2 + "Bean";
    }
}

