/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.i18n.localizabletext;

import com.ibm.websphere.i18n.localizabletext.LocalizableTextLTZ;
import java.io.Serializable;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class LocalizableTextDateTimeArgument
implements LocalizableTextLTZ,
Serializable {
    public static final int DATE = 1;
    public static final int TIME = 2;
    public static final int DATEANDTIME = 3;
    public static final int TIMEANDDATE = 4;
    private int dateTimeStyle = 1;
    private Date date = null;
    private int dateFormatStyle = 0;
    private String dateString = null;
    private String timeString = null;
    private String returnString = null;
    private DateFormat df = null;

    public LocalizableTextDateTimeArgument(Date date, int n, int n2) {
        if (date == null || n < 1 || 4 < n) {
            throw new IllegalArgumentException();
        }
        this.date = date;
        this.dateTimeStyle = n;
        this.dateFormatStyle = n2;
    }

    public boolean equals(Object object) {
        LocalizableTextDateTimeArgument localizableTextDateTimeArgument;
        boolean bl = true;
        try {
            localizableTextDateTimeArgument = (LocalizableTextDateTimeArgument)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (this.date != localizableTextDateTimeArgument.date) {
            bl = false;
        } else if (this.dateTimeStyle != localizableTextDateTimeArgument.dateTimeStyle) {
            bl = false;
        } else if (this.dateFormatStyle != localizableTextDateTimeArgument.dateFormatStyle) {
            bl = false;
        }
        return bl;
    }

    public String format(Locale locale, TimeZone timeZone) throws IllegalArgumentException {
        String string = null;
        switch (this.dateTimeStyle) {
            case 1: {
                string = DateFormat.getDateInstance(this.dateFormatStyle, locale).format(this.date);
                break;
            }
            case 2: {
                this.df = DateFormat.getTimeInstance(this.dateFormatStyle, locale);
                this.df.setTimeZone(timeZone);
                string = this.df.format(this.date);
                break;
            }
            case 3: {
                this.dateString = DateFormat.getDateInstance(this.dateFormatStyle, locale).format(this.date);
                this.df = DateFormat.getTimeInstance(this.dateFormatStyle, locale);
                this.df.setTimeZone(timeZone);
                this.timeString = this.df.format(this.date);
                string = this.dateString + " " + this.timeString;
                break;
            }
            case 4: {
                this.dateString = DateFormat.getDateInstance(this.dateFormatStyle, locale).format(this.date);
                this.df = DateFormat.getTimeInstance(this.dateFormatStyle, locale);
                this.df.setTimeZone(timeZone);
                this.timeString = this.df.format(this.date);
                string = this.timeString + " " + this.dateString;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return string;
    }

    public int hashCode() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        if (this.date != null) {
            n = this.date.hashCode() << 12 & 0xFFFFF000;
        }
        n3 = this.dateFormatStyle << 4 & 0xFF0;
        n2 = this.dateTimeStyle & 0xF;
        return n | n3 | n2;
    }

    public String toString() {
        String string = this.date + ", dateTimeStyle = " + this.dateTimeStyle + ", dateFormatStyle = " + this.dateFormatStyle;
        return string;
    }
}

