/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application;

import com.ibm.ejs.models.base.extensions.ejbext.ContainerManagedEntityExtension;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.application.AppManagementExtensions;
import com.ibm.websphere.management.application.EarUtils;
import com.ibm.websphere.management.application.Scheduler;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppAssociation;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.EditApplication;
import com.ibm.ws.management.application.ExtensionHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.j2ee.deploy.spi.TargetModuleIDImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.runtime.service.Repository;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.client.ApplicationClient;
import org.eclipse.jst.j2ee.common.EnvEntry;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.ejb.EnterpriseBean;
import org.eclipse.jst.j2ee.ejb.Entity;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class AppDeploymentUtil {
    private static TraceComponent tc = Tr.register(AppDeploymentUtil.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static int[][] versionTable = new int[][]{{12, 5}, {13, 5}, {14, 6}};
    private static int[][] JCAVersionTable = new int[][]{{12, 10, 0}, {13, 10, 0}, {14, 10, 15}};
    public static final Integer BAD_VERSION = new Integer(0);
    public static final String APPDEPL_SYSTEM_APP2_FLAG = "META-INF/ibm-application-sa2.props";
    private static final String[] keys = new String[]{"filepermission.option.allr", "filepermission.option.dlle", "filepermission.option.weba"};
    private static final int[] keyI = new int[]{1, 16, 256};

    public static Hashtable getNodeVersionForAppTargets(Hashtable hashtable, RepositoryContext repositoryContext, WorkSpace workSpace) throws AdminException {
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "getNodeVersionForAppTargets: " + hashtable);
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable == null || hashtable.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation: empty mod2svr table");
            }
            return hashtable2;
        }
        Enumeration enumeration = hashtable.keys();
        Session session = new Session(workSpace.getUserName(), true);
        while (enumeration.hasMoreElements()) {
            try {
                String string = (String)enumeration.nextElement();
                String string2 = (String)hashtable.get(string);
                Vector vector = AppAssociation.getServerNames(string2, string, false, repositoryContext, workSpace);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, string2 + " = " + vector);
                }
                for (int i = 0; i < vector.size(); ++i) {
                    Object object;
                    RepositoryContext repositoryContext2 = (RepositoryContext)vector.elementAt(i);
                    ObjectName objectName = ConfigRepoHelper.getObjectName(repositoryContext2);
                    if (hashtable2.get(objectName) != null) continue;
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    if (AppUtils.isServer(repositoryContext2)) {
                        arrayList.add(repositoryContext2.getParent().getName());
                        object = AppUtils.getNodeMajorVersion(session, repositoryContext.getName(), repositoryContext2.getParent().getName());
                        arrayList.add(object);
                        if (Integer.parseInt((String)object) >= 6) {
                            arrayList.add(AppUtils.getNodeMinorVersion(session, repositoryContext.getName(), repositoryContext2.getParent().getName()));
                        } else {
                            arrayList.add("No Minor Version");
                        }
                    } else {
                        object = new Vector<RepositoryContext>();
                        ((Vector)object).add(repositoryContext2);
                        Hashtable hashtable3 = ConfigRepoHelper.getNodeServerRelation(workSpace, object);
                        Enumeration enumeration2 = hashtable3.keys();
                        while (enumeration2.hasMoreElements()) {
                            RepositoryContext repositoryContext3 = (RepositoryContext)enumeration2.nextElement();
                            arrayList.add(repositoryContext3.getName());
                            String string3 = AppUtils.getNodeMajorVersion(session, repositoryContext.getName(), repositoryContext3.getName());
                            arrayList.add(string3);
                            if (Integer.parseInt(string3) >= 6) {
                                arrayList.add(AppUtils.getNodeMinorVersion(session, repositoryContext.getName(), repositoryContext3.getName()));
                                continue;
                            }
                            arrayList.add("No Minor Version");
                        }
                    }
                    hashtable2.put(objectName, arrayList);
                }
            }
            catch (AdminException adminException) {
                throw adminException;
            }
            catch (Throwable throwable) {
                throw new AdminException(throwable, null);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getNodeVersionForAppTargets: " + hashtable2);
        }
        return hashtable2;
    }

    public static Vector appValidation(AppDeploymentController appDeploymentController, String string, WorkSpace workSpace) throws AdminException {
        Hashtable hashtable;
        Vector vector;
        block9: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "appValidation ");
            }
            vector = new Vector();
            hashtable = new Hashtable();
            try {
                hashtable = appDeploymentController.getServerTable();
            }
            catch (AppDeploymentException appDeploymentException) {
                if (!tc.isDebugEnabled()) break block9;
                Tr.debug(tc, "Exception when calling getServerTable: " + appDeploymentException);
            }
        }
        if (hashtable == null || hashtable.size() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation: empty mod2svr table");
            }
            return vector;
        }
        try {
            int n = appDeploymentController.getAppVersion();
            int n2 = appDeploymentController.getAppVersion(true);
            List list = appDeploymentController.getSelectedOptions();
            int n3 = appDeploymentController.getRarVersion();
            Tr.debug(tc, "earVersion: " + n + " appversion: " + n2 + " rarVersion: " + n3);
            RepositoryContext repositoryContext = AppUtils.findContext("cells", string, null, null, workSpace, true);
            Tr.debug(tc, "cellc " + repositoryContext);
            Hashtable hashtable2 = AppDeploymentUtil.getNodeVersionForAppTargets(hashtable, repositoryContext, workSpace);
            vector = AppDeploymentUtil.appValidation(n3, n, n2, list, hashtable2);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "appValidation");
            }
            return vector;
        }
        catch (AdminException adminException) {
            throw adminException;
        }
        catch (Throwable throwable) {
            throw new AdminException(throwable, null);
        }
    }

    public static Vector appValidation(int n, int n2, int n3, List list, Hashtable hashtable) throws Exception {
        Vector<String> vector;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appValidation ");
        }
        Vector vector2 = new Vector();
        Tr.debug(tc, "earVersion: " + n2 + " appVersion: " + n3 + " rarVersion: " + n);
        int n4 = AppDeploymentUtil.getLowestSupportedNodeVersion(n3);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "lowest node: " + n4);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            vector = (Vector<String>)hashtable.get(enumeration.nextElement());
            for (int i = 0; i < vector.size(); i += 3) {
                String string2 = (String)vector.get(i);
                int n5 = Integer.parseInt((String)vector.get(i + 1));
                if (n5 >= n4 || arrayList.contains(string2)) continue;
                arrayList.add(string2);
                string = (String)vector.get(i + 1);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "failed nodes: " + arrayList + " version: " + string);
        }
        vector = new Vector<String>();
        String string3 = null;
        if (arrayList.size() > 0) {
            string3 = n2 < n3 && list.size() > 0 ? AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0111E", new String[]{list.toString(), ((Object)arrayList).toString(), string}) : AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0110E", new String[]{Integer.toString(n3), ((Object)arrayList).toString(), string});
            vector.addElement(string3);
        }
        vector2.addAll(vector);
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "messages = " + vector2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appValidation");
        }
        return vector2;
    }

    private static void concatException(AdminException adminException, StringBuffer stringBuffer) {
        if (adminException == null) {
            return;
        }
        stringBuffer.append("\n" + adminException.getMessage());
        Throwable throwable = adminException.getCause();
        if (throwable == null) {
            return;
        }
        if (throwable instanceof AdminException) {
            AppDeploymentUtil.concatException((AdminException)throwable, stringBuffer);
        } else {
            stringBuffer.append("\n" + throwable.toString());
        }
    }

    private static int getLowestSupportedNodeVersion(int n) {
        for (int i = 0; i < versionTable.length; ++i) {
            if (n != versionTable[i][0]) continue;
            return versionTable[i][1];
        }
        return Integer.MAX_VALUE;
    }

    public static Vector MDBValidation(Hashtable hashtable, Hashtable hashtable2, AppDeploymentTask appDeploymentTask) {
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "MDBValidation ");
        }
        Vector<String> vector = new Vector<String>();
        String[][] stringArray = appDeploymentTask.getTaskData();
        String[] stringArray2 = appDeploymentTask.getColumnNames();
        int n2 = stringArray2.length;
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = -1;
        for (n = 0; n < n2; ++n) {
            if ("uri".equals(stringArray2[n])) {
                n3 = n;
            }
            if ("listenerPort".equals(stringArray2[n])) {
                n4 = n;
            }
            if ("EJBModule".equals(stringArray2[n])) {
                n5 = n;
            }
            if (!"EJB".equals(stringArray2[n])) continue;
            n6 = n;
        }
        if (stringArray != null) {
            for (n = 1; n < stringArray.length; ++n) {
                String string = util.getModuleUriFromUriString(stringArray[n][n3]);
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    String string2 = (String)enumeration.nextElement();
                    Tr.debug(tc, "key: " + string2);
                    String string3 = util.getModuleURIFromUniqueName(string2);
                    if (!string.equals(string3)) continue;
                    Enumeration enumeration2 = hashtable.keys();
                    while (enumeration2.hasMoreElements()) {
                        List list = (List)hashtable.get(enumeration2.nextElement());
                        for (int i = 0; i < list.size(); i += 3) {
                            String string4 = (String)list.get(i);
                            int n7 = Integer.parseInt((String)list.get(i + 1));
                            Tr.debug(tc, "Node: " + string4 + " version:" + n7);
                            if (n7 != 5 || stringArray[n][n4] != null && !stringArray[n][n4].trim().equals("")) continue;
                            String string5 = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0001E", new String[]{appDeploymentTask.getName(), stringArray[n][n6], stringArray[n][n5]});
                            vector.addElement(string5);
                        }
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "MDBValidation ");
        }
        return vector;
    }

    public static Vector validateLightweightEJBs(EARFile eARFile, Hashtable hashtable) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "validateLightweightEJBs");
        }
        Vector<String> vector = new Vector<String>();
        if (AppDeploymentUtil.isNodeVersionPriorTo61(hashtable)) {
            EList eList = eARFile.getDeploymentDescriptor().getModules();
            Iterator iterator = eList.iterator();
            block0: while (iterator.hasNext()) {
                Module module = (Module)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + module);
                }
                if (!module.isEjbModule()) continue;
                EJBJarExtension eJBJarExtension = (EJBJarExtension)eARFile.getExtensions(module);
                EJBJar eJBJar = eJBJarExtension.getEjbJar();
                List list = eJBJar.getContainerManagedBeans();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "list of ContainerManagedBeans: " + list + ", size: " + list.size());
                }
                for (int i = 0; i < list.size(); ++i) {
                    Entity entity = (Entity)list.get(i);
                    ContainerManagedEntityExtension containerManagedEntityExtension = (ContainerManagedEntityExtension)eJBJarExtension.getEJBExtension((EnterpriseBean)entity);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "ContainerManagedEntityExtension: " + containerManagedEntityExtension);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isSetLightweightLocal: " + containerManagedEntityExtension.isSetLightweightLocal());
                    }
                    if (!containerManagedEntityExtension.isSetLightweightLocal()) continue;
                    String string = AppUtils.getMessage(AppUtils.getBundle(null), "ADMA9002E", new String[]{module.getUri()});
                    vector.addElement(string);
                    continue block0;
                }
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "messages = " + vector);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "validateLightweightEJBs");
        }
        return vector;
    }

    private static boolean isNodeVersionPriorTo61(Hashtable hashtable) throws Exception {
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        block0: while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            List list = (List)hashtable.get(k);
            Tr.debug(tc, "targets node version: " + list);
            for (int i = 0; i < list.size(); i += 3) {
                String string = (String)list.get(i);
                int n = Integer.parseInt((String)list.get(i + 1));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node: " + string + ", major version " + n);
                }
                if (n > 6) continue;
                if (n <= 5) {
                    bl = true;
                    continue block0;
                }
                int n2 = Integer.parseInt((String)list.get(i + 2));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Node: " + string + ", minor version " + n2);
                }
                if (n != 6 || n2 >= 1) continue;
                bl = true;
                continue block0;
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "is node version prior to 6.1: " + bl);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List listSystemApps(Repository repository2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listSystemApps");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Resource resource = null;
        Resource resource2 = null;
        try {
            String string = repository2.getConfigRoot().getAbsolutePath(3, "systemapps.xml");
            if (!new File(string).exists()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "no system apps: " + string);
                }
                ArrayList<String> arrayList2 = arrayList;
                return arrayList2;
            }
            resource = repository2.getConfigRoot().getResource(3, "systemapps.xml");
            Vector vector = AppUtils.listSystemApps(resource);
            if (vector != null) {
                arrayList.addAll(vector);
            }
            resource2 = repository2.getConfigRoot().getResource(3, "serverindex.xml");
            ServerIndex serverIndex = (ServerIndex)resource2.getContents().get(0);
            EList eList = serverIndex.getServerEntries();
            for (int i = 0; i < eList.size(); ++i) {
                ServerEntry serverEntry = (ServerEntry)eList.get(i);
                EList eList2 = serverEntry.getDeployedApplications();
                for (int j = 0; j < eList2.size(); ++j) {
                    String string2 = (String)eList2.get(j);
                    String string3 = repository2.getConfigRoot().getAbsolutePath(0, "applications/" + string2 + "/" + APPDEPL_SYSTEM_APP2_FLAG);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Check for : " + string3);
                    }
                    if (!new File(string3).exists()) continue;
                    arrayList.add(string2.substring(string2.lastIndexOf("/") + 1));
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error getting system app xml " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppDeploymentUtil", "307", null);
        }
        finally {
            if (resource != null) {
                resource.unload();
            }
            if (resource2 != null) {
                resource2.unload();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listSystemApps: " + arrayList);
        }
        return arrayList;
    }

    public static String getTargetName(String string, String string2, String string3, boolean bl) {
        if (bl) {
            return "WebSphere:cluster=" + string + ",j2eeType=" + "J2EEServer" + ",cell=" + string3;
        }
        return "WebSphere:server=" + string + ",j2eeType=" + "J2EEServer" + ",node=" + string2 + ",cell=" + string3;
    }

    public static String getModuleID(String string, String string2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("WebSphere:name=");
        stringBuffer.append(string);
        stringBuffer.append(",type=");
        stringBuffer.append(string2);
        return stringBuffer.toString();
    }

    public static TargetModuleIDImpl createTargetMod(String string, String string2, Target target, TargetModuleID targetModuleID) throws Exception {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createTargetMod: " + string + ", " + string2 + ", " + target);
        }
        TargetModuleIDImpl targetModuleIDImpl = new TargetModuleIDImpl();
        targetModuleIDImpl.setTarget(target);
        targetModuleIDImpl.setWebURL(null);
        String string3 = AppDeploymentUtil.getModuleID(string, string2);
        targetModuleIDImpl.setModuleID(string3);
        targetModuleIDImpl.setObjectName(new ObjectName(string3 + ",*"));
        targetModuleIDImpl.setModuleType(string2);
        if (targetModuleID != null) {
            targetModuleIDImpl.setParentTargetModuleID(targetModuleID);
            targetModuleIDImpl.setChildTargetModuleID(null);
        } else {
            targetModuleIDImpl.setParentTargetModuleID(null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createTargetMod: " + string + ", " + string2 + ", " + target);
        }
        return targetModuleIDImpl;
    }

    public static String[][] getFilePermissionOptions(Hashtable hashtable) {
        String[][] stringArray = new String[keys.length][2];
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        for (int i = 0; i < keys.length; ++i) {
            stringArray[i][0] = AppUtils.getMessage(resourceBundle, keys[i]);
            stringArray[i][1] = keys[i];
        }
        return stringArray;
    }

    public static String getFilePermissionString(List list) {
        String string = "";
        int n = 0;
        for (int i = 0; i < keys.length; ++i) {
            if (!list.contains(keys[i])) continue;
            n |= keyI[i];
        }
        switch (n) {
            case 1: {
                string = ".*=755";
                break;
            }
            case 16: {
                string = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755";
                break;
            }
            case 17: {
                string = ".*=755";
                break;
            }
            case 256: {
                string = ".*\\.htm=755#.*\\.html=755#.*\\.gif=755#.*\\.jpg=755#.*\\.pdf=755";
                break;
            }
            case 257: {
                string = ".*=755";
                break;
            }
            case 272: {
                string = ".*\\.dll=755#.*\\.so=755#.*\\.a=755#.*\\.sl=755#.*\\.htm=755#.*\\.html=755#.*\\.gif=755#.*\\.jpg=755#.*\\.pdf=755";
                break;
            }
            case 273: {
                string = ".*=755";
            }
        }
        return string;
    }

    public static Vector envEntryValidation(EARFile eARFile) {
        Vector vector = new Vector();
        EList eList = eARFile.getDeploymentDescriptor().getModules();
        for (int i = 0; i < eList.size(); ++i) {
            try {
                Object object;
                Module module = (Module)eList.get(i);
                EObject eObject = eARFile.getDeploymentDescriptor(module);
                String string = module.getUri() + "," + eObject.eResource().getURI();
                ArrayList arrayList = null;
                if (module.isEjbModule()) {
                    object = (EJBJar)eObject;
                    EList eList2 = object.getEnterpriseBeans();
                    arrayList = new ArrayList();
                    Iterator iterator = eList2.iterator();
                    while (iterator.hasNext()) {
                        EnterpriseBean enterpriseBean = (EnterpriseBean)iterator.next();
                        ArrayList arrayList2 = new ArrayList(enterpriseBean.getEnvironmentProperties());
                        arrayList.addAll(arrayList2);
                    }
                } else if (module.isWebModule()) {
                    arrayList = new ArrayList(((WebApp)eObject).getEnvironmentProperties());
                } else if (module.isJavaModule()) {
                    arrayList = new ArrayList(((ApplicationClient)eObject).getEnvironmentProps());
                }
                object = AppDeploymentUtil.validateEnvEntry(arrayList, string);
                vector.addAll(object);
                continue;
            }
            catch (Throwable throwable) {
                Tr.info(tc, "Exception thrown - getdeploymentdescriptor(module); " + throwable.getMessage());
            }
        }
        return vector;
    }

    public static Vector validateEnvEntry(List list, String string) {
        Vector<String> vector = new Vector<String>();
        if (list != null && list.size() > 0) {
            EnvEntry[] envEntryArray = list.toArray(new EnvEntry[list.size()]);
            for (int i = 0; i < envEntryArray.length; ++i) {
                String string2 = envEntryArray[i].getName();
                String string3 = envEntryArray[i].getValue();
                if (string3 != null) continue;
                String string4 = "The Environment Entry defined in " + string + " has NULL value for name \"" + string2 + "\"";
                vector.add(string4);
            }
        }
        return vector;
    }

    public static List getTargetNodes(Scheduler scheduler, String string, String string2) {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getTargetNodess : " + string + " dd = " + string2);
        }
        if ((hashtable = (Hashtable)scheduler.getProperties().get("moduleToServer")) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes");
            }
            return new ArrayList();
        }
        String string3 = AppDeploymentUtil.getTargets(hashtable, util.createUniqueModuleName(string2, string), string);
        if (string3 == null || string3.trim().length() == 0) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes: no targets");
            }
            return new ArrayList();
        }
        Hashtable hashtable2 = (Hashtable)scheduler.getProperties().get("nodeVersionTable");
        if (hashtable2 == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getTargetNodes: no nodeVerTable");
            }
            return new ArrayList();
        }
        String[] stringArray = string3.split("\\+");
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < stringArray.length; ++i) {
            try {
                ObjectName objectName = new ObjectName(stringArray[i]);
                List list = (List)hashtable2.get(objectName);
                if (list == null) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "ERROR:: list in nodeversiontable can not be null for key:" + objectName);
                    continue;
                }
                for (int j = 0; j < list.size(); j += 3) {
                    arrayList.add(list.get(j));
                }
                continue;
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Malformed object name: " + stringArray[i]);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "getTargetNodes: " + arrayList);
        }
        return arrayList;
    }

    private static String getTargets(Hashtable hashtable, String string, String string2) {
        String string3 = (String)hashtable.get(string);
        if (string3 != null) {
            return string3;
        }
        int n = string2.lastIndexOf(46);
        if (n != -1 && (string3 = (String)hashtable.get("*" + string2.substring(n))) != null) {
            return string3;
        }
        string3 = (String)hashtable.get("*");
        if (string3 != null) {
            return string3;
        }
        return null;
    }

    public static void isNodeValidForCluster(String string, String string2, String string3, String string4, Locale locale, List list) throws AdminException {
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "isApplicationDeployable: " + string2 + ", " + string3);
        }
        Hashtable<String, Locale> hashtable = new Hashtable<String, Locale>();
        hashtable.put("app.client.locale", locale);
        ResourceBundle resourceBundle = AppUtils.getBundle(hashtable);
        Vector vector = EditApplication.listApplications("WebSphere:cell=" + string + ",cluster=" + string3, hashtable, string4);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "apps are : " + vector);
        }
        Vector vector2 = new Vector();
        try {
            ExtensionHelper.provideValidationExtensions(vector2);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error getting validation extensions: " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppDeploymentUtil", "811", null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "validation helpers: " + vector2);
        }
        WorkSpace workSpace = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(string4);
            int n = Integer.parseInt(AppUtils.getNodeMajorVersion(string, string2));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "node version: " + n);
            }
            for (int i = 0; i < vector.size(); ++i) {
                String string5 = (String)vector.elementAt(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Handling app: " + string5);
                }
                RepositoryContext repositoryContext = AppUtils.findAppContextFromConfig(string5, workSpace, hashtable);
                EARFile eARFile = null;
                try {
                    eARFile = ConfigRepoHelper.getEarFileForApp(workSpace, repositoryContext, resourceBundle, true);
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "error getting ear: " + throwable);
                    }
                    FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppDeploymentUtil", "841", null);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ear = " + eARFile);
                }
                if (eARFile == null) continue;
                int n2 = EarUtils.getAppVersionForDeployment(eARFile);
                int n3 = AppDeploymentUtil.getLowestSupportedNodeVersion(n2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "appV: " + n2 + ", lowest node: " + n3);
                }
                if (n < n3) {
                    list.add(AppUtils.getMessage(resourceBundle, "ADMA0111E", new String[]{"" + n2, string2, "" + n}));
                    continue;
                }
                for (int j = 0; j < vector2.size(); ++j) {
                    Object e2 = vector2.elementAt(j);
                    if (!(e2 instanceof AppManagementExtensions.AppValidationHelper2)) continue;
                    AppManagementExtensions.AppValidationHelper2 appValidationHelper2 = (AppManagementExtensions.AppValidationHelper2)e2;
                    appValidationHelper2.isApplicationDeployable(string2, string3, string5, eARFile, string4, locale, list);
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "error in isNodeValidForCluster: " + throwable);
            }
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.application.AppDeploymentUtil", "880", null);
            if (throwable instanceof AdminException) {
                throw (AdminException)throwable;
            }
            throw new AdminException(throwable);
        }
    }
}

