/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentMessages;
import com.ibm.websphere.management.application.client.AppDeploymentTaskInfo;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.connector.interop.JMXVersionValidation;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.Vector;

public abstract class AppDeploymentTask
implements Serializable {
    static final long serialVersionUID = -2021644844665692021L;
    private static TraceComponent tc = Tr.register(AppDeploymentTask.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    public static final String HIGHEST_VERSION = "999999";
    protected transient AppDeploymentController appController;
    protected String name;
    protected boolean isTaskEmpty;
    protected boolean isSufficientlyDone;
    protected boolean isTaskDisabled;
    protected boolean isValidationEnabled = true;
    protected String[][] taskData;
    protected String[] colNames;
    protected String[] taskValidateErrorMessages;
    protected boolean[] mutables;
    protected boolean[] requiredColumns;
    protected boolean[] hiddenColumns;
    protected boolean hasHiddenColumns;

    public AppDeploymentTask(AppDeploymentController appDeploymentController) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AppDeploymentTask");
        }
        this.appController = appDeploymentController;
        this.isSufficientlyDone = true;
        this.isTaskDisabled = false;
        this.isTaskEmpty = false;
        this.taskData = null;
        this.hasHiddenColumns = false;
        this.mutables = null;
        this.requiredColumns = null;
        this.hiddenColumns = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AppDeploymentTask");
        }
    }

    public void setAppDeploymentController(AppDeploymentController appDeploymentController) {
        this.appController = appDeploymentController;
    }

    public String getName() {
        return this.name;
    }

    public boolean isTaskEmpty() {
        return this.isTaskEmpty;
    }

    public boolean isTaskDisabled() {
        return this.isTaskDisabled;
    }

    public boolean isSufficientlyDone() {
        return this.isSufficientlyDone;
    }

    public void setIsTaskDisabled(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsTaskDisabled");
        }
        this.isTaskDisabled = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsTaskDisabled");
        }
    }

    public void setIsSufficientlyDone(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setIsSufficientlyDone");
        }
        this.isSufficientlyDone = bl;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setIsSufficientlyDone");
        }
    }

    public String[] getColumnNames() {
        return this.colNames;
    }

    public boolean[] getMutableColumns() {
        return this.mutables;
    }

    public boolean getMutableColumns(int n) {
        if (this.mutables != null && n < this.mutables.length) {
            return this.mutables[n];
        }
        return false;
    }

    public boolean[] getRequiredColumns() {
        return this.requiredColumns;
    }

    public boolean getRequiredColumns(int n) {
        if (this.requiredColumns != null && n < this.requiredColumns.length) {
            return this.requiredColumns[n];
        }
        return false;
    }

    public boolean isHiddenColumn(int n) {
        if (this.hasHiddenColumns && this.hiddenColumns != null && n < this.hiddenColumns.length) {
            return this.hiddenColumns[n];
        }
        return false;
    }

    public String[][] getTaskData() {
        String[][] stringArray = null;
        if (this.taskData != null) {
            stringArray = new String[this.taskData.length][];
            for (int i = 0; i < this.taskData.length; ++i) {
                stringArray[i] = new String[this.taskData[i].length];
                for (int j = 0; j < this.taskData[i].length; ++j) {
                    stringArray[i][j] = this.taskData[i][j];
                }
            }
        }
        return stringArray;
    }

    public void setTaskData(String[][] stringArray) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setTaskData");
        }
        this.verifyTaskData(stringArray);
        if (this.taskData != null && this.appController != null) {
            this.appController.getDependencyTask(this.name);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setTaskData");
        }
    }

    protected void verifyTaskData(String[][] stringArray) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "verifyTaskData");
        }
        this.taskData = stringArray;
        if (this.taskData == null) {
            this.isTaskEmpty = true;
            this.isSufficientlyDone = true;
        } else {
            this.isTaskEmpty = false;
            this.isSufficientlyDone = true;
            for (int i = 0; i < this.taskData.length; ++i) {
                if (this.taskData[i].length != this.colNames.length) {
                    this.isSufficientlyDone = false;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Wrong task data format: incorrect length " + this.taskData.length);
                    }
                    throw new AppDeploymentException(MessageFormat.format(util.getMessage(this, "ADMA0015E"), Integer.toString(this.taskData.length)), null);
                }
                for (int j = 0; this.isSufficientlyDone && j < this.taskData[i].length; ++j) {
                    if (!this.mutables[j] || !this.requiredColumns[j] || this.taskData[i][j] != null && !this.taskData[i][j].trim().equals("")) continue;
                    this.isSufficientlyDone = false;
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "verifyTaskData");
        }
    }

    public String[] validate() {
        return null;
    }

    protected void buildErrorMessages(Vector vector) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildErrorMessages");
        }
        this.taskValidateErrorMessages = null;
        if (vector != null && vector.size() > 0) {
            this.taskValidateErrorMessages = new String[vector.size()];
            for (int i = 0; i < vector.size(); ++i) {
                this.taskValidateErrorMessages[i] = (String)vector.elementAt(i);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildErrorMessages");
        }
    }

    public AppDeploymentMessages getTaskMessages() {
        AppDeploymentTaskInfo appDeploymentTaskInfo;
        AppDeploymentMessages appDeploymentMessages = null;
        if (this.appController != null && (appDeploymentTaskInfo = this.appController.getTaskInfo(this.name)) != null) {
            appDeploymentMessages = appDeploymentTaskInfo.appMessages;
        }
        return appDeploymentMessages;
    }

    public AppDeploymentController getAppDeploymentController() {
        return this.appController;
    }

    public String getCallerVersion() {
        if (this.appController != null && (this.appController.getDeploymentMode() & 0x110L) != 0L && AdminServiceFactory.getAdminService() != null) {
            JMXVersionValidation jMXVersionValidation = new JMXVersionValidation();
            String string = jMXVersionValidation.getClientVersion();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "ClientVersion in JMX thread = " + string);
            }
            if (string != null) {
                return string;
            }
        }
        return HIGHEST_VERSION;
    }

    public void setValidationEnabled(boolean bl) {
        this.isValidationEnabled = bl;
    }

    public boolean isValidationEnabled() {
        return this.isValidationEnabled;
    }
}

