/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.models.base.bindings.ejbbnd.EJBJarBinding;
import com.ibm.ejs.models.base.bindings.webappbnd.WebAppBinding;
import com.ibm.ejs.models.base.extensions.ejbext.EJBJarExtension;
import com.ibm.ejs.models.base.extensions.webappext.WebAppExtension;
import com.ibm.ejs.models.base.resources.ResourcesFactory;
import com.ibm.ejs.models.base.resources.ResourcesPackage;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.deployment.deploywrapper.DeployUtil;
import com.ibm.etools.commonarchive.CommonarchiveFactory;
import com.ibm.etools.commonarchive.EARFile;
import com.ibm.etools.commonarchive.EJBJarFile;
import com.ibm.etools.commonarchive.impl.CommonarchiveFactoryImpl;
import com.ibm.etools.commonarchive.util.ArchiveInit;
import com.ibm.websphere.management.application.AppConstants;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.appdeployment.ApplicationDeployment;
import com.ibm.websphere.models.config.appdeployment.Deployment;
import com.ibm.websphere.resource.WASResourceSetImpl;
import com.ibm.ws.bootstrap.ExtClassLoader;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.J2CAppUtils;
import com.ibm.ws.management.application.client.AppInstallHelper;
import com.ibm.ws.management.application.dfltbndngs.BindEarCmd;
import com.ibm.ws.management.application.dfltbndngs.BindingError;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.component.InstallRAHelper;
import com.ibm.ws.management.configarchive.EnhancedEarConfigurator;
import com.ibm.ws.management.configarchive.EnhancedEarReader;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Vector;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.jst.j2ee.application.Module;
import org.eclipse.jst.j2ee.commonarchivecore.internal.Archive;
import org.eclipse.jst.j2ee.commonarchivecore.internal.File;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ModuleFile;
import org.eclipse.jst.j2ee.commonarchivecore.internal.ReadOnlyDirectory;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.ArchiveManifest;
import org.eclipse.jst.j2ee.commonarchivecore.internal.helpers.FileIterator;
import org.eclipse.jst.j2ee.commonarchivecore.internal.util.ArchiveFileDynamicClassLoader;
import org.eclipse.jst.j2ee.ejb.EJBJar;
import org.eclipse.jst.j2ee.webapplication.WebApp;

public class ArchiveDeploymentInfo
extends AppDeploymentInfo {
    public static final String destModPath = "ibm.update.mod.path";
    protected EARFile archive;
    protected String archivePath;
    protected Vector saveAsFileTempDirs;
    protected String j2ee12SecurityWarning;
    protected Hashtable moduleForDD;
    protected ApplicationDeployment appDepl;
    protected String modPath = null;
    protected List enhancedEarWorkspaces = new ArrayList();
    protected List enhancedEarConfigurators = new ArrayList();
    private static long saveAsTempDirBase = System.currentTimeMillis();
    protected Resource deplResource;
    protected Resource enh_deplResource;
    private boolean _isEntitled = false;
    private static final TraceComponent tc = Tr.register(ArchiveDeploymentInfo.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME = ArchiveDeploymentInfo.class.getName();

    public ArchiveDeploymentInfo(EARFile eARFile) throws AppDeploymentException {
        this(eARFile, new Hashtable());
    }

    public ArchiveDeploymentInfo(EARFile eARFile, Hashtable hashtable) throws AppDeploymentException {
        super(hashtable);
        this.archive = eARFile;
        this.j2ee12SecurityWarning = null;
        this.moduleForDD = null;
        this.modPath = (String)hashtable.get(destModPath);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ArchiveDeploymentInfo", new Object[]{"ear=" + eARFile.getURI(), "prefs=" + hashtable});
        }
        this.setApplication(this.archive.getDeploymentDescriptor());
        this.setApplicationBindings(this.archive.getBindings());
        this.setApplicationExtensions(this.archive.getExtensions());
        if (this.appBinding == null) {
            AppDeploymentException appDeploymentException = new AppDeploymentException("Null application bindings. Possibly corrupt ear file.", null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ArchiveDeploymentInfo", appDeploymentException);
            }
            throw appDeploymentException;
        }
        if (this.appExtension == null) {
            AppDeploymentException appDeploymentException = new AppDeploymentException("Null application extension. Possibly corrupt ear file.", null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ArchiveDeploymentInfo", appDeploymentException);
            }
            throw appDeploymentException;
        }
        if (this.appBinding.getApplication() == null) {
            AppDeploymentException appDeploymentException = new AppDeploymentException("Application bindings file does not contain a reference to the deployment descriptor. Corrupt ear file. Check if META-INF/ibm-application-bnd.xmi uri in the ear file contains a valid application href tag.", null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ArchiveDeploymentInfo", appDeploymentException);
            }
            throw appDeploymentException;
        }
        if (this.appExtension.getApplication() == null) {
            AppDeploymentException appDeploymentException = new AppDeploymentException("Application extensions file does not contain a reference to the deployment descriptor. Corrupt ear file. Check if META-INF/ibm-application-ext.xmi uri in the ear file contains a valid application href tag.", null);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "ArchiveDeploymentInfo", appDeploymentException);
            }
            throw appDeploymentException;
        }
        String string = eARFile.getURI();
        if (new java.io.File(string).exists() && AppUtils.isEntitled()) {
            if (hashtable.get("EditAppOnly") == null && hashtable.get("EditModuleOnly") == null && !AppUtils.isAppEntitled(string)) {
                Tr.error(tc, "ADMA9006E", new Object[]{string, AppUtils.getProductName()});
                AppDeploymentException appDeploymentException = new AppDeploymentException("This application is not licensed to be installed in this server", null);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "ArchiveDeploymentInfo", appDeploymentException);
                }
                throw appDeploymentException;
            }
            this._isEntitled = true;
        }
        eARFile.rollUpRoles();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ArchiveDeploymentInfo");
        }
    }

    protected Vector createModuleConfig(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createModuleConfig");
        }
        if (this.archive == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createModuleConfig", "Archive is null.");
            }
            return null;
        }
        Vector<EObject> vector = new Vector<EObject>();
        EList eList = this.archive.getDeploymentDescriptor().getModules();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            Object object;
            Module module = (Module)iterator.next();
            if (!(string.startsWith("JAR") && module.isEjbModule() || string.startsWith("WAR") && module.isWebModule()) && (!string.startsWith("RAR") || !module.isConnectorModule())) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Processing JAR/WAR/RAR module " + module.getUri());
            }
            try {
                EJBJar eJBJar;
                EObject eObject;
                if (string.endsWith("DD")) {
                    vector.addElement(this.archive.getDeploymentDescriptor(module));
                    continue;
                }
                if (string.endsWith("BND")) {
                    eObject = this.archive.getBindings(module);
                    object = eObject.eResource().getURI().toString();
                    if (string.equals("JAR_BND") && ((eJBJar = ((EJBJarBinding)eObject).getEjbJar()) == null || eJBJar.eIsProxy())) {
                        Tr.warning(tc, "ADMA0091E", new String[]{object, object, module.getUri(), "" + eJBJar});
                        ((EJBJarBinding)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                    }
                    if (string.equals("WAR_BND") && ((eJBJar = ((WebAppBinding)eObject).getWebapp()) == null || eJBJar.eIsProxy())) {
                        Tr.warning(tc, "ADMA0091E", new String[]{object, object, module.getUri(), "" + eJBJar});
                        ((WebAppBinding)eObject).setWebapp((WebApp)this.archive.getDeploymentDescriptor(module));
                    }
                    vector.addElement(eObject);
                    continue;
                }
                if (!string.endsWith("EXT") || string.startsWith("RAR")) continue;
                eObject = this.archive.getExtensions(module);
                object = eObject.eResource().getURI().toString();
                if (string.equals("JAR_EXT") && ((eJBJar = ((EJBJarExtension)eObject).getEjbJar()) == null || eJBJar.eIsProxy())) {
                    Tr.warning(tc, "ADMA0091E", new String[]{object, object, module.getUri(), "" + eJBJar});
                    ((EJBJarExtension)eObject).setEjbJar((EJBJar)this.archive.getDeploymentDescriptor(module));
                }
                if (string.equals("WAR_EXT") && ((eJBJar = ((WebAppExtension)eObject).getWebApp()) == null || eJBJar.eIsProxy())) {
                    Tr.warning(tc, "ADMA0091E", new String[]{object, object, module.getUri(), "" + eJBJar});
                    ((WebAppExtension)eObject).setWebApp((WebApp)this.archive.getDeploymentDescriptor(module));
                }
                vector.addElement(eObject);
            }
            catch (Exception exception) {
                object = new AppDeploymentException("Unexpected exception.", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "createModuleConfig", object);
                }
                throw object;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createModuleConfig", vector);
        }
        return vector;
    }

    public Module getModuleForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleForDD");
        }
        Module module = null;
        if (this.moduleForDD == null) {
            this.moduleForDD = new Hashtable();
            EList eList = this.archive.getDeploymentDescriptor().getModules();
            Iterator iterator = eList.iterator();
            while (iterator.hasNext()) {
                Module module2 = (Module)iterator.next();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getModuleForDD", "Processing module: " + module2);
                }
                if (module2.isJavaModule()) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "getModuleForDD", "Skipping module: is Java module.");
                    continue;
                }
                try {
                    this.moduleForDD.put(this.archive.getDeploymentDescriptor(module2), module2);
                }
                catch (Exception exception) {
                    AppDeploymentException appDeploymentException = new AppDeploymentException("Unexpected exception processing deployment descriptors for module " + module2 + ".", exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "getModuleForDDLocal", appDeploymentException);
                    }
                    throw appDeploymentException;
                }
            }
        }
        module = (Module)this.moduleForDD.get(eObject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleForDDLocal", "module=" + module);
        }
        return module;
    }

    public ModuleFile getModuleFileForDD(EObject eObject) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getModuleFileForDD");
        }
        ModuleFile moduleFile = null;
        Module module = this.getModuleForDD(eObject);
        if (module != null) {
            try {
                moduleFile = this.archive.getModuleRef(module).getModuleFile();
            }
            catch (Exception exception) {
                AppDeploymentException appDeploymentException = new AppDeploymentException("Unexpected exception getting module file for module " + module + ".", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getModuleFileForDD", appDeploymentException);
                }
                throw appDeploymentException;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getModuleFileForDD", "moduleFile=" + moduleFile);
        }
        return moduleFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean bl) throws AppDeploymentException {
        String string;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close", "save=" + bl);
        }
        if (this.archive == null) {
            Tr.warning(tc, "ADMA0142W", "Trying to close the archive that is already closed.");
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "close", "Null archive.");
            }
            return;
        }
        java.io.File file = new java.io.File(this.archive.getURI());
        try {
            try {
                int n2 = n = file.exists() && file.isDirectory() ? 1 : 0;
                if (bl) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "isDir: " + (n != 0));
                    }
                    if (n == 0) {
                        this.archive.save();
                    } else {
                        this.archive.extractNoReopen(66);
                    }
                }
                if (n == 0 && this.modPath != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "modPath =  " + this.modPath);
                    }
                    ModuleFile moduleFile = (ModuleFile)this.archive.getModuleFiles().get(0);
                    moduleFile.saveAs(this.modPath);
                }
                if (this.deplResource != null) {
                    this.deplResource.unload();
                }
                if (this.enh_deplResource != null) {
                    this.enh_deplResource.unload();
                }
            }
            catch (Throwable throwable) {
                AppDeploymentException appDeploymentException = new AppDeploymentException("Unexpected exception processing archive file.", throwable);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", appDeploymentException);
                }
                throw appDeploymentException;
            }
            Object var6_8 = null;
            string = this.getURI();
        }
        catch (Throwable throwable) {
            Object var6_9 = null;
            String string2 = this.getURI();
            this.archive.close();
            this.archive = null;
            if (this._isEntitled && bl) {
                try {
                    if (!new java.io.File(string2).isDirectory()) {
                        AppUtils.signEntitledApplication(string2);
                    }
                    if (this.modPath != null && !new java.io.File(this.modPath).isDirectory()) {
                        AppUtils.signEntitledApplication(this.modPath);
                    }
                }
                catch (Exception exception) {
                    AppDeploymentException appDeploymentException = new AppDeploymentException("Error re-signing entitled application", exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "close", appDeploymentException);
                    }
                    throw appDeploymentException;
                }
            }
            if (this.modPath != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "deleting " + file.getPath());
                }
                file.delete();
            }
            throw throwable;
        }
        this.archive.close();
        this.archive = null;
        if (this._isEntitled && bl) {
            try {}
            catch (Exception exception) {
                AppDeploymentException appDeploymentException = new AppDeploymentException("Error re-signing entitled application", exception);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "close", appDeploymentException);
                }
                throw appDeploymentException;
            }
            if (!new java.io.File(string).isDirectory()) {
                AppUtils.signEntitledApplication(string);
            }
            if (this.modPath != null && !new java.io.File(this.modPath).isDirectory()) {
                AppUtils.signEntitledApplication(this.modPath);
            }
        }
        if (this.modPath != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "deleting " + file.getPath());
            }
            file.delete();
        }
        this.moduleData.clear();
        if (this.saveAsFileTempDirs != null) {
            for (n = 0; n < this.saveAsFileTempDirs.size(); ++n) {
                try {
                    AppUtils.deleteDirTree((String)this.saveAsFileTempDirs.elementAt(n));
                    continue;
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Error deleting temp dir: " + (String)this.saveAsFileTempDirs.elementAt(n) + ", " + exception);
                }
            }
            this.saveAsFileTempDirs = null;
        }
        if (this.enhancedEarWorkspaces != null) {
            for (n = 0; n < this.enhancedEarWorkspaces.size(); ++n) {
                this.cleanUpEarWorkSpace((WorkSpace)this.enhancedEarWorkspaces.get(n));
            }
            this.enhancedEarWorkspaces.clear();
        }
        if (this.enhancedEarConfigurators != null) {
            for (n = 0; n < this.enhancedEarConfigurators.size(); ++n) {
                this.cleanUpEarConfigurator((EnhancedEarConfigurator)this.enhancedEarConfigurators.get(n));
            }
            this.enhancedEarConfigurators.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    public Hashtable getSavedResults() {
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this.options.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            hashtable.put(string, this.options.get(string));
        }
        if (this.archivePath != null) {
            hashtable.put("original.ear.location", this.archivePath);
        }
        return hashtable;
    }

    public void createDefaultBindings(Preferences preferences) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createDefaultBindings", "prefs=" + preferences);
        }
        try {
            Vector vector = this.getModuleConfig("JAR_BND");
            Vector vector2 = this.getModuleConfig("WAR_BND");
            Vector vector3 = this.getModuleConfig("JAR_EXT");
            Vector vector4 = this.getModuleConfig("WAR_EXT");
            BindEarCmd bindEarCmd = null;
            bindEarCmd = preferences != null ? new BindEarCmd(this.archive, preferences) : new BindEarCmd(this.archive, true);
            bindEarCmd.bind();
        }
        catch (BindingError bindingError) {
            Throwable throwable = this.getRootError(bindingError);
            AppDeploymentException appDeploymentException = new AppDeploymentException(bindingError.toString(), throwable);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "createDefaultBindings", appDeploymentException);
            }
            throw appDeploymentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "createDefaultBindings");
        }
    }

    public String getSecurityPolicyData(ResourceBundle resourceBundle) throws AppDeploymentException {
        String string;
        block19: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "getSecurityPolicyData");
            }
            string = null;
            InputStream inputStream = null;
            if (this.archive != null) {
                try {
                    Object object;
                    block18: {
                        try {
                            inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                        }
                        catch (FileNotFoundException fileNotFoundException) {
                            if (!tc.isDebugEnabled()) break block18;
                            Tr.debug(tc, "getSecurityPolicyData", "Ignoring exception: " + fileNotFoundException);
                        }
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Input stream: " + inputStream);
                    }
                    if (inputStream == null) {
                        object = this.getJ2EEAppVersion();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "getSecurityPolicyData", "App Version: " + (String)object);
                        }
                        if (object != null && ((String)object).equals(AppConstants.APPDEPL_APP_VERSION_1_2)) {
                            ClassLoader classLoader = this.getClass().getClassLoader();
                            inputStream = classLoader.getResourceAsStream("was.policy");
                            if (inputStream != null) {
                                this.saveAsFile(null, "META-INF/was.policy", inputStream);
                                this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0080W");
                                Tr.warning(tc, "ADMA0080W");
                                try {
                                    inputStream = this.archive.getResourceInputStream("META-INF/was.policy");
                                }
                                catch (FileNotFoundException fileNotFoundException) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "getSecurityPolicyData", "Ignoring exception: " + fileNotFoundException);
                                    }
                                    inputStream = null;
                                }
                            } else {
                                this.j2ee12SecurityWarning = AppUtils.getMessage(resourceBundle, "ADMA0081W");
                                Tr.warning(tc, "ADMA0081W");
                            }
                        }
                    }
                    if (inputStream != null) {
                        byte[] byArray;
                        int n;
                        object = new ByteArrayOutputStream();
                        int n2 = inputStream.available();
                        while (n2 > 0 && (n = inputStream.read(byArray = new byte[n2])) != -1) {
                            ((ByteArrayOutputStream)object).write(byArray, 0, n);
                            n2 = inputStream.available();
                        }
                        ((OutputStream)object).flush();
                        string = ((ByteArrayOutputStream)object).toString();
                        ((ByteArrayOutputStream)object).close();
                        inputStream.close();
                    }
                }
                catch (Exception exception) {
                    if (!tc.isDebugEnabled()) break block19;
                    Tr.debug(tc, "getSecurityPolicyData", new Object[]{"Ignoring unexpected exception.", exception});
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getSecurityPolicyData", string);
        }
        return string;
    }

    public String getSecurityPolicyWarning() {
        return this.j2ee12SecurityWarning;
    }

    public void saveAsFile(String string, String string2, InputStream inputStream) throws AppDeploymentException {
        String string3 = ArchiveDeploymentInfo.saveAsFile(this.archive, string, string2, inputStream);
        if (string3 != null) {
            if (this.saveAsFileTempDirs == null) {
                this.saveAsFileTempDirs = new Vector();
            }
            this.saveAsFileTempDirs.addElement(string3);
        }
    }

    public static String saveAsFile(EARFile eARFile, String string, String string2, InputStream inputStream) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "saveAsFile", new Object[]{"moduleURI=" + string, "fileURI=" + string2});
        }
        String string3 = null;
        if (inputStream == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "InputStream is null");
            }
        } else {
            CommonarchiveFactory commonarchiveFactory;
            if (eARFile == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null archive.");
                }
                return null;
            }
            EARFile eARFile2 = null;
            if (string == null || string.trim().equals("")) {
                eARFile2 = eARFile;
            } else {
                commonarchiveFactory = eARFile.getArchiveFiles().iterator();
                while (commonarchiveFactory.hasNext() && !(eARFile2 = (Archive)commonarchiveFactory.next()).getURI().equals(string)) {
                    eARFile2 = null;
                }
            }
            if (eARFile2 != null) {
                Exception exception;
                block39: {
                    FileOutputStream fileOutputStream;
                    block38: {
                        java.io.File file;
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "saveAsFile", "Found matching archive: " + eARFile2);
                        }
                        ArchiveInit.init();
                        commonarchiveFactory = CommonarchiveFactoryImpl.getActiveFactory();
                        exception = null;
                        String string4 = AppUtils.getTempDir();
                        while ((file = new java.io.File(string3 = string4 + "save_" + String.valueOf(++saveAsTempDirBase))).exists()) {
                        }
                        file.mkdirs();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "saveAsFile", "Temp dirname=" + string3);
                        }
                        String string5 = string3;
                        if (string2 != null && !string2.equals("")) {
                            string5 = string5 + java.io.File.separator + string2;
                        }
                        file = new java.io.File(string5);
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Save file location=" + string5);
                        }
                        file = new java.io.File(file.getParent());
                        fileOutputStream = null;
                        try {
                            if (file.exists()) {
                                AppUtils.deleteDirTree(file);
                            }
                            file.mkdirs();
                            fileOutputStream = new FileOutputStream(string5);
                            if (fileOutputStream != null) {
                                int n = 0;
                                byte[] byArray = new byte[1024];
                                while ((n = inputStream.read(byArray)) != -1) {
                                    fileOutputStream.write(byArray, 0, n);
                                }
                                fileOutputStream.close();
                                fileOutputStream = null;
                                ReadOnlyDirectory readOnlyDirectory = commonarchiveFactory.openReadOnlyDirectory(string3);
                                File file2 = null;
                                try {
                                    file2 = readOnlyDirectory.getFileInSelfOrSubdirectory(string2);
                                }
                                catch (Throwable throwable) {
                                    if (tc.isDebugEnabled()) {
                                        Tr.debug(tc, "saveAsFile", new Object[]{"Ignoring exception:", throwable});
                                    }
                                    file2 = null;
                                }
                                if (tc.isDebugEnabled()) {
                                    Tr.debug(tc, "saveAsFile", "File in readDir=" + file2);
                                }
                                if (file2 != null && eARFile2.isDuplicate(string2)) {
                                    FileIterator fileIterator = eARFile2.getFilesForSave();
                                    while (fileIterator.hasNext()) {
                                        File file3 = fileIterator.next();
                                        if (!file3.getURI().equals(string2)) continue;
                                        if (tc.isDebugEnabled()) {
                                            Tr.debug(tc, ".... Removing existing file");
                                        }
                                        eARFile2.remove(file3);
                                        break;
                                    }
                                }
                                if (file2 != null) {
                                    eARFile2.addCopy(file2);
                                }
                                break block38;
                            }
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "Not able to create the input stream as a file");
                            }
                        }
                        catch (Exception exception2) {
                            if (tc.isDebugEnabled()) {
                                Tr.debug(tc, "saveAsFile", "File IO exception: " + exception2);
                            }
                            exception = exception2;
                        }
                    }
                    if (fileOutputStream != null) {
                        try {
                            fileOutputStream.close();
                        }
                        catch (IOException iOException) {
                            if (!tc.isDebugEnabled()) break block39;
                            Tr.debug(tc, "saveAsFile", "Error closing save file: " + fileOutputStream + ", " + iOException);
                        }
                    }
                }
                if (exception != null) {
                    AppDeploymentException appDeploymentException = new AppDeploymentException("Unexpected exception.", exception);
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "saveAsFile", appDeploymentException);
                    }
                    throw appDeploymentException;
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Not able to find matching module: " + string);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "saveAsFile", string3);
        }
        return string3;
    }

    public String getAppDisplayName() {
        Object v = this.options.get("appname");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "app name from options " + v);
        }
        if (v != null && v instanceof String) {
            return (String)v;
        }
        return AppInstallHelper.getAppDisplayName(this.archive, this.options);
    }

    public String getURI() {
        return this.archive.getURI();
    }

    private Throwable getRootError(BindingError bindingError) {
        Throwable throwable;
        for (throwable = bindingError; throwable != null && throwable instanceof BindingError && throwable.getChainedEx() != null; throwable = throwable.getChainedEx()) {
        }
        return throwable;
    }

    public Resource getResource(String string, String string2, String string3) throws IOException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResource", new Object[]{string, string2, string3});
        }
        Resource resource = null;
        if (this.archive.containsFile(string2)) {
            InputStream inputStream = this.archive.getInputStream(string2);
            WASResourceSetImpl wASResourceSetImpl = new WASResourceSetImpl();
            URI uRI = URI.createURI((String)string3);
            resource = wASResourceSetImpl.createResource(uRI);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "res is: " + resource);
            }
            HashMap hashMap = new HashMap();
            resource.load(inputStream, hashMap);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResource", resource);
        }
        return resource;
    }

    public Resource getAppDeploymentResource(boolean bl) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppDeploymentResoource", new Object[]{"processEmbeddedCfg=" + bl});
        }
        Resource resource = super.getAppDeploymentResource(bl);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplres in memory: " + resource);
        }
        if (resource != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", resource);
            }
            return resource;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "deplResource: " + this.deplResource);
        }
        if (this.deplResource != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.deplResource);
            }
            return this.deplResource;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "enh_deplResource: " + this.enh_deplResource);
        }
        if (bl && this.enh_deplResource != null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.enh_deplResource);
            }
            return this.enh_deplResource;
        }
        try {
            this.deplResource = this.getResource(null, "deployment.xml", "deployment.xml");
            if (this.deplResource == null && EnhancedEarReader.isEnhancedEar(this.archive)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Null root deployment.xml. Get deployment.xml from enhanced ear");
                }
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "getAppDeploymentResource", this.enh_deplResource);
                }
                return this.enh_deplResource;
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getAppDeploymentResource", this.deplResource);
            }
            return this.deplResource;
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Ignoring exception loading depl resource:", throwable);
            }
            FFDCFilter.processException(throwable, CLASS_NAME + ".getAppDeploymentResource", "898", this);
            return null;
        }
    }

    public ApplicationDeployment getAppDeploymentObject(boolean bl) {
        ApplicationDeployment applicationDeployment = null;
        Resource resource = this.getAppDeploymentResource(bl);
        if (resource != null) {
            Deployment deployment = (Deployment)resource.getContents().get(0);
            applicationDeployment = (ApplicationDeployment)deployment.getDeployedObject();
        }
        return applicationDeployment;
    }

    public boolean checkIfEarDeployed() {
        boolean bl;
        block11: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkIfEarDeployed");
            }
            bl = true;
            try {
                try {
                    Class.forName("com.ibm.etools.ejbdeploy.EJBDeploymentException");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "com.ibm.etools.ejbdeploy.EJBDeploymentException is not packaged in the install");
                    }
                    if (tc.isEntryEnabled()) {
                        Tr.exit(tc, "checkIfEarDeployed", bl);
                    }
                    return bl;
                }
                List list = this.archive.getEJBJarFiles();
                for (int i = 0; i < list.size(); ++i) {
                    boolean bl2;
                    EJBJarFile eJBJarFile = (EJBJarFile)list.get(i);
                    String string = eJBJarFile.getURI();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJB Jar file: " + string);
                    }
                    if (bl2 = DeployUtil.isEJBJarDeployed(eJBJarFile)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "EJB jar not deployed. Defaulting to run EJBDeploy.");
                    }
                    bl = false;
                    break;
                }
            }
            catch (Throwable throwable) {
                Tr.warning(tc, "ADMA0143W", new Object[]{throwable});
                if (!tc.isDebugEnabled()) break block11;
                Tr.debug(tc, "checkIfEarDeployed", new Object[]{"Ignoring exception:", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEarDeployed", bl);
        }
        return bl;
    }

    public boolean checkIfEnhancedEar() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "checkIfEnhancedEar");
        }
        boolean bl = true;
        try {
            bl = EnhancedEarReader.isEnhancedEar(this.archive);
            if (bl) {
                this.enh_deplResource = EnhancedEarReader.getDeployment(this.archive);
            }
        }
        catch (Throwable throwable) {
            Tr.warning(tc, "ADMA0104W", throwable);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "checkIfEnhancedEar", new Object[]{"Ignoring exception:", throwable});
            }
            bl = false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkIfEnhancedEar", bl);
        }
        return bl;
    }

    public boolean isStandaloneDeployment() {
        if (this.archive == null) {
            return false;
        }
        return this.archive.containsFile("META-INF/was.ejbmodule") || this.archive.containsFile("META-INF/was.webmodule");
    }

    public InputStream getInputStream(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getInputStream", new Object[]{"moduleURI=" + string, "fileURI=" + string2});
        }
        InputStream inputStream = null;
        try {
            if (string == null) {
                inputStream = this.archive.getInputStream(string2);
            } else {
                List list = this.archive.getModuleFiles();
                for (int i = 0; i < list.size(); ++i) {
                    ModuleFile moduleFile = (ModuleFile)list.get(i);
                    if (!moduleFile.getURI().equals(string)) continue;
                    inputStream = moduleFile.getInputStream(string2);
                    break;
                }
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream", inputStream);
            }
            return inputStream;
        }
        catch (IOException iOException) {
            AppDeploymentException appDeploymentException = new AppDeploymentException("Unexpected exception.", iOException);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getInputStream", appDeploymentException);
            }
            throw appDeploymentException;
        }
    }

    public boolean containsURI(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "containsURI", new Object[]{"moduleURI=" + string, "fileURI=" + string2});
        }
        boolean bl = false;
        if (string == null) {
            bl = this.archive.containsFile(string2);
        } else {
            List list = this.archive.getModuleFiles();
            for (int i = 0; i < list.size(); ++i) {
                ModuleFile moduleFile = (ModuleFile)list.get(i);
                if (!moduleFile.getURI().equals(string)) continue;
                bl = moduleFile.containsFile(string2);
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "containsURI", bl);
        }
        return bl;
    }

    public Class loadClass(EObject eObject, String string, String string2) {
        Class clazz;
        block13: {
            ModuleFile moduleFile;
            block12: {
                if (tc.isEntryEnabled()) {
                    Tr.entry(tc, "loadClass", new Object[]{"obj=" + eObject, "className=" + string, "type=" + string2});
                }
                ResourcesPackage resourcesPackage = (ResourcesPackage)EPackage.Registry.INSTANCE.getEPackage("http://www.ibm.com/websphere/appserver/schemas/5.0/resources.xmi");
                ResourcesFactory resourcesFactory = resourcesPackage.getResourcesFactory();
                clazz = null;
                moduleFile = null;
                try {
                    moduleFile = this.getModuleFileForDD(eObject);
                }
                catch (AppDeploymentException appDeploymentException) {
                    if (!tc.isDebugEnabled()) break block12;
                    Tr.debug(tc, "Failed to get DD", appDeploymentException);
                }
            }
            if (moduleFile == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadClass", "Null module file for DD.");
                }
                return null;
            }
            Object object = ExtClassLoader.getInstance();
            if (object == null) {
                object = InstallRAHelper.class.getClassLoader();
            }
            ArchiveFileDynamicClassLoader archiveFileDynamicClassLoader = new ArchiveFileDynamicClassLoader((Archive)moduleFile, (ClassLoader)object, null);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "module=" + moduleFile + ", classLoader=" + archiveFileDynamicClassLoader);
            }
            if (archiveFileDynamicClassLoader == null) {
                if (tc.isEntryEnabled()) {
                    Tr.exit(tc, "loadClass", "Null archive file dynamic class loader.");
                }
                return null;
            }
            try {
                clazz = J2CAppUtils.getDefinedClass(string, (ClassLoader)archiveFileDynamicClassLoader);
            }
            catch (AdminException adminException) {
                if (!tc.isDebugEnabled()) break block13;
                Tr.debug(tc, "loadClass", new Object[]{"Failed to get defined class.", adminException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadClass", "class=" + clazz);
        }
        return clazz;
    }

    public ArchiveManifest getEarManifest() {
        return this.archive.getManifest();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Resource getEnhancedEarDeploymentResource(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getEnhancedEarDeploymentResource", new Object[]{string});
        }
        EnhancedEarConfigurator enhancedEarConfigurator = null;
        WorkSpace workSpace = null;
        Resource resource = null;
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(null);
            enhancedEarConfigurator = new EnhancedEarConfigurator(workSpace, this.archive, true, "default", "appName", "appName.ear_");
            if (enhancedEarConfigurator.isEnhancedEar()) {
                resource = enhancedEarConfigurator.getDeploymentResource(string);
                if (resource != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "getEnhancedEarDeploymentResource", "Adding enhanced ear workspace " + workSpace + " to list to be deleted");
                    }
                    this.enhancedEarWorkspaces.add(workSpace);
                    this.enhancedEarConfigurators.add(enhancedEarConfigurator);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getEnhancedEarDeploymentResource", "No Deployment resource.");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "getEnhancedEarDeploymentResource", "Not an enhanced ear.");
            }
            if (resource == null) {
                this.cleanUpEarWorkSpace(workSpace);
                this.cleanUpEarConfigurator(enhancedEarConfigurator);
            }
        }
        catch (Throwable throwable) {
            try {
                Tr.warning(tc, "ADMA0104W", throwable);
                if (resource == null) {
                    this.cleanUpEarWorkSpace(workSpace);
                    this.cleanUpEarConfigurator(enhancedEarConfigurator);
                }
            }
            catch (Throwable throwable2) {
                if (resource == null) {
                    this.cleanUpEarWorkSpace(workSpace);
                    this.cleanUpEarConfigurator(enhancedEarConfigurator);
                }
                throw throwable2;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getEnhancedEarDeploymentResource", new Object[]{resource});
        }
        return resource;
    }

    public static Hashtable loadJCAProps(org.eclipse.jst.j2ee.commonarchivecore.internal.EARFile eARFile) {
        Hashtable hashtable;
        block6: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadJCAProps", "earFile=" + eARFile.getName());
            }
            hashtable = null;
            try {
                File file = eARFile.getFile("META-INF/ibm-jcajndi.props");
                InputStream inputStream = file.getInputStream();
                hashtable = new Hashtable();
                ArchiveDeploymentInfo.loadJcaProps(inputStream, hashtable);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "loadJCAProps", new Object[]{"Ignoring exception:", fileNotFoundException});
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block6;
                Tr.debug(tc, "loadJCAProps", new Object[]{"Ignoring exception:", iOException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJCAProps", hashtable);
        }
        return hashtable;
    }

    private static void loadJcaProps(InputStream inputStream, Hashtable hashtable) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "loadJcaProps", "tbl=" + hashtable);
            }
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            try {
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    int n = string.indexOf("=");
                    if (n == -1) continue;
                    String string2 = string.substring(0, n);
                    String string3 = string.substring(n + 1);
                    hashtable.put(string2, string3);
                }
            }
            catch (IOException iOException) {
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "loadJcaProps", new Object[]{"Ignoring exception:", iOException});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "loadJcaProps", "tbl=" + hashtable);
        }
    }

    private void cleanUpEarWorkSpace(WorkSpace workSpace) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "cleanUpEarWorkSpace", "workSpace=" + workSpace);
        }
        try {
            if (workSpace != null) {
                ConfigRepoHelper.removeWorkSpace(false, workSpace);
            }
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, CLASS_NAME + ".cleanUpEarWorkSpace", "1216", this);
            Tr.warning(tc, "ADMA0077W", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpEarWorkSpace");
        }
    }

    private void cleanUpEarConfigurator(EnhancedEarConfigurator enhancedEarConfigurator) {
        block5: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "cleanUpEarConfigurator", "configurator=" + enhancedEarConfigurator);
            }
            try {
                if (enhancedEarConfigurator != null) {
                    enhancedEarConfigurator.cleanup();
                }
            }
            catch (Throwable throwable) {
                FFDCFilter.processException(throwable, CLASS_NAME + ".cleanUpEarConfigurator", "1230", this);
                if (!tc.isDebugEnabled()) break block5;
                Tr.debug(tc, "checkIfEnhancedEar", new Object[]{"Wrote FFDC for exception:", throwable});
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "cleanUpEarConfigurator");
        }
    }
}

