/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentInfo;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.DefaultBinding;
import com.ibm.ws.management.application.client.DefaultBindingHelper;
import com.ibm.ws.management.application.client.EmbeddedRarHelper;
import com.ibm.ws.management.application.client.util;
import com.ibm.ws.management.application.dfltbndngs.Preferences;
import java.util.Hashtable;
import java.util.Vector;

public class RedeploymentController
extends AppDeploymentController {
    private static TraceComponent tc = Tr.register(RedeploymentController.class, null, "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME = RedeploymentController.class.getName();
    private static final long serialVersionUID = 6387558788656394772L;
    Vector tasksWOBindings = null;
    Vector oldAppTasks = null;
    boolean forceDfltBndg = false;
    String mode = "redeploy.default.merge";

    public RedeploymentController(AppDeploymentInfo appDeploymentInfo, Hashtable hashtable, Vector vector, Vector vector2, Vector vector3) throws AppDeploymentException {
        super(appDeploymentInfo, hashtable, vector);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "RedeploymentController");
        }
        this.oldAppTasks = vector2;
        this.tasksWOBindings = vector3;
        RedeploymentController.patchInfo(this.deploymentInfo, vector2);
        if (hashtable.get("redeploy.ignore.new") != null) {
            this.mode = "redeploy.ignore.new";
        }
        RedeploymentController.dbg("Mode is: " + this.mode);
        Object v = hashtable.get("usedefaultbindings");
        if (v != null) {
            Preferences preferences = null;
            if (v instanceof Preferences) {
                preferences = (Preferences)v;
            } else if (v instanceof DefaultBinding) {
                preferences = DefaultBindingHelper.getPreferences((DefaultBinding)v);
            }
            if (preferences != null) {
                this.forceDfltBndg = preferences.getForceBindings();
            }
            RedeploymentController.dbg("Force : " + this.forceDfltBndg);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "RedeploymentController");
        }
    }

    protected void setDeploymentMode(Hashtable hashtable) throws AppDeploymentException {
        String string;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setDeploymentMode");
        }
        if ("modulefile".equals(string = (String)hashtable.get("contenttype"))) {
            this._deploymentMode = 65536L;
        } else if ("app".equals(string)) {
            this._deploymentMode = 4096L;
        } else {
            throw new AppDeploymentException("Internal Error: Invalid content type for app update: " + string, null);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setDeploymentMode:" + this._deploymentMode);
        }
    }

    private static void patchInfo(AppDeploymentInfo appDeploymentInfo, Vector vector) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "patchInfo");
        }
        if (vector == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "patchInfo = null");
            }
            return;
        }
        Hashtable hashtable = appDeploymentInfo.getAppOptions();
        for (int i = 0; i < vector.size(); ++i) {
            Object object;
            if (((AppDeploymentTask)vector.elementAt(i)).getName().equals("AppDeploymentOptions")) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Found AppDeplOptions");
                }
                object = ((AppDeploymentTask)vector.elementAt(i)).getTaskData();
                for (int j = 0; j < object[0].length; ++j) {
                    if (object[0][j].equals("buildVersion")) continue;
                    if (object[1][j].equals("AppDeploymentOption.Yes")) {
                        hashtable.put(object[0][j], Boolean.TRUE);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Patched option: " + (String)object[0][j] + "val: TRUE");
                        continue;
                    }
                    if (object[1][j].equals("AppDeploymentOption.No")) {
                        hashtable.put(object[0][j], Boolean.FALSE);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Patched option: " + (String)object[0][j] + "val: FALSE");
                        continue;
                    }
                    hashtable.put(object[0][j], object[1][j]);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Patched option: " + (String)object[0][j] + "val: " + (String)object[1][j]);
                }
                continue;
            }
            if (!((AppDeploymentTask)vector.elementAt(i)).getName().equals("MapModulesToServers")) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Found MapMod2Svr");
            }
            if ((object = (Hashtable)hashtable.get("moduleToServer")) == null) {
                object = new Hashtable();
                hashtable.put("moduleToServer", object);
            }
            String[][] stringArray = ((AppDeploymentTask)vector.elementAt(i)).getTaskData();
            for (int j = 1; j < stringArray.length; ++j) {
                String string = util.createUniqueModuleNameFromUriString(stringArray[j][1]);
                ((Hashtable)object).put(string, stringArray[j][2]);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Patched in: " + string + " = " + stringArray[j][2]);
            }
        }
    }

    protected void prepareTask(int n, AppDeploymentTask appDeploymentTask) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "prepareTask: redepl:" + appDeploymentTask.getName());
        }
        super.prepareTask(n, appDeploymentTask);
        if (appDeploymentTask.isTaskEmpty()) {
            return;
        }
        if (this.oldAppTasks == null && this.tasksWOBindings == null) {
            return;
        }
        AppDeploymentTask appDeploymentTask2 = this.findMatchingTask(appDeploymentTask, this.oldAppTasks);
        AppDeploymentTask appDeploymentTask3 = this.findMatchingTask(appDeploymentTask, this.tasksWOBindings);
        if (appDeploymentTask2 == null && appDeploymentTask3 == null) {
            RedeploymentController.dbg("No match: " + appDeploymentTask.getName());
            return;
        }
        String[][] stringArray = this.createNewData(appDeploymentTask, appDeploymentTask2, appDeploymentTask3);
        appDeploymentTask.setTaskData(stringArray);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "prepareTask");
        }
    }

    private AppDeploymentTask findMatchingTask(AppDeploymentTask appDeploymentTask, Vector vector) {
        if (vector == null) {
            return null;
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "findMatchingTask");
        }
        AppDeploymentTask appDeploymentTask2 = null;
        for (int i = 0; i < vector.size(); ++i) {
            String[] stringArray;
            AppDeploymentTask appDeploymentTask3 = (AppDeploymentTask)vector.elementAt(i);
            if (!appDeploymentTask3.getName().equals(appDeploymentTask.getName())) continue;
            String[] stringArray2 = appDeploymentTask.getColumnNames();
            if (stringArray2.length != (stringArray = appDeploymentTask3.getColumnNames()).length) break;
            boolean bl = true;
            for (int j = 0; j < stringArray2.length; ++j) {
                if (stringArray2[j].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) break;
            appDeploymentTask2 = (AppDeploymentTask)vector.elementAt(i);
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "found match: " + appDeploymentTask2.getName());
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "findMatchingTask: " + appDeploymentTask2);
        }
        return appDeploymentTask2;
    }

    private String[][] createNewData(AppDeploymentTask appDeploymentTask, AppDeploymentTask appDeploymentTask2, AppDeploymentTask appDeploymentTask3) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewData: " + appDeploymentTask.getName());
        }
        String[][] stringArray = appDeploymentTask.getTaskData();
        String[][] stringArray2 = new String[stringArray.length][];
        stringArray2[0] = stringArray[0];
        RedeploymentController.dbg("For: " + appDeploymentTask.getName() + " data rows: " + (stringArray.length - 1));
        boolean bl = false;
        Vector vector = null;
        if ("EmbeddedRar".equals(appDeploymentTask.getName())) {
            bl = true;
            vector = new Vector();
        }
        for (int i = 1; i < stringArray.length; ++i) {
            String[] stringArray3 = this.findMatchingRow(stringArray[i], appDeploymentTask, appDeploymentTask2, vector);
            String[] stringArray4 = this.findMatchingRow(stringArray[i], appDeploymentTask, appDeploymentTask3, null);
            String[] stringArray5 = stringArray[i];
            if (appDeploymentTask.getName().equals("AppDeploymentOptions") || appDeploymentTask.getName().equals("MapModulesToServers")) {
                stringArray4 = stringArray5;
                RedeploymentController.dbg("Setting b to c for AppDeplOptions and Mod2Svr");
            }
            RedeploymentController.printSA(stringArray3, "a row");
            RedeploymentController.printSA(stringArray4, "b row");
            RedeploymentController.printSA(stringArray5, "c row");
            if (this.mode.equals("redeploy.ignore.new")) {
                if (this.isFull(appDeploymentTask, stringArray3)) {
                    stringArray2[i] = stringArray3;
                    RedeploymentController.dbg("a won ignoreNew.");
                } else {
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won ignoreNew.");
                }
            } else {
                if (this.isFull(appDeploymentTask, stringArray4)) {
                    if (this.forceDfltBndg) {
                        stringArray2[i] = stringArray5;
                        RedeploymentController.dbg("c won - default mode - forcedflt.");
                    } else {
                        stringArray2[i] = stringArray4;
                        RedeploymentController.dbg("b won - default mode.");
                        this.copyNonReqColumns(stringArray2[i], stringArray3 != null ? stringArray3 : stringArray5, appDeploymentTask);
                    }
                } else if (this.tasksWOBindings == null && this.isFull(appDeploymentTask, stringArray5)) {
                    if (!this.isDefaultDSSet(appDeploymentTask) && this.isFull(appDeploymentTask, stringArray3)) {
                        stringArray5 = stringArray3;
                    }
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won nodfltbndg.");
                    this.copyNonReqColumns(stringArray2[i], stringArray3, appDeploymentTask);
                } else if (this.isFull(appDeploymentTask, stringArray3)) {
                    stringArray2[i] = stringArray3;
                    RedeploymentController.dbg("a won - default mode.");
                }
                if (stringArray2[i] == null) {
                    stringArray2[i] = stringArray5;
                    RedeploymentController.dbg("c won finally in default mode.");
                }
            }
            RedeploymentController.printSA(stringArray2[i], appDeploymentTask.getName() + "[" + i + "]");
        }
        if (bl) {
            stringArray2 = this.mergeValidDataFromOldTask(appDeploymentTask.getName(), stringArray2, appDeploymentTask2.getTaskData(), vector);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "createNewData");
        }
        return stringArray2;
    }

    private String[] findMatchingRow(String[] stringArray, AppDeploymentTask appDeploymentTask, AppDeploymentTask appDeploymentTask2, Vector vector) {
        if (appDeploymentTask2 == null || appDeploymentTask2.getTaskData() == null) {
            return null;
        }
        boolean[] blArray = appDeploymentTask.getMutableColumns();
        String[][] stringArray2 = appDeploymentTask2.getTaskData();
        for (int i = 1; i < stringArray2.length; ++i) {
            boolean bl = true;
            for (int j = 0; j < stringArray2[i].length; ++j) {
                if (blArray[j] || appDeploymentTask.isHiddenColumn(j) || stringArray2[i][j] == null || stringArray2[i][j].equals(stringArray[j])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            if (vector != null) {
                vector.add(Integer.toString(i));
            }
            return stringArray2[i];
        }
        return null;
    }

    private boolean isDefaultDSSet(AppDeploymentTask appDeploymentTask) {
        if (appDeploymentTask.getName().equals("DataSourceFor20EJBModules")) {
            String[][] stringArray = appDeploymentTask.getTaskData();
            for (int i = 1; i < stringArray.length; ++i) {
                Tr.debug(tc, "default DS jndi: " + stringArray[i][3]);
                if (stringArray[i][3] != null && !stringArray[i][3].trim().equals("")) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isFull(AppDeploymentTask appDeploymentTask, String[] stringArray) {
        if (stringArray == null) {
            return false;
        }
        boolean[] blArray = appDeploymentTask.getRequiredColumns();
        if (blArray.length != stringArray.length) {
            RedeploymentController.printSA(stringArray, "isFull - Something wrong in " + appDeploymentTask.getName());
            return false;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!blArray[i] || !AppUtils.isEmpty(stringArray[i])) continue;
            return false;
        }
        return true;
    }

    private void copyNonReqColumns(String[] stringArray, String[] stringArray2, AppDeploymentTask appDeploymentTask) {
        if (stringArray2 == null || stringArray == null) {
            return;
        }
        String string = appDeploymentTask.getName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray2[i] == null) continue;
            if (AppUtils.isEmpty(stringArray[i])) {
                stringArray[i] = stringArray2[i];
                continue;
            }
            if (string.equals("MapRolesToUsers")) {
                if (!"AppDeploymentOption.No".equals(stringArray[i]) || !"AppDeploymentOption.Yes".equals(stringArray2[i])) continue;
                stringArray[i] = stringArray2[i];
                continue;
            }
            if (!string.equals("CtxRootForWebMod")) continue;
            Hashtable hashtable = this.deploymentInfo.getAppOptions();
            try {
                if (i != 2 || !"/".equals(stringArray[i]) || hashtable.get("contextroot") != null || !this.deploymentInfo.containsURI(null, "META-INF/was.webmodule")) continue;
                stringArray[i] = stringArray2[i];
                continue;
            }
            catch (AppDeploymentException appDeploymentException) {
                FFDCFilter.processException((Throwable)appDeploymentException, CLASS_NAME + ".copyNonReqColumns", "526", this);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "copyNonReqColumns", appDeploymentException);
            }
        }
    }

    private static void printSA(String[] stringArray, String string) {
        if (stringArray == null) {
            RedeploymentController.dbg("Null array");
            return;
        }
        String string2 = string + " --> ";
        for (int i = 0; i < stringArray.length; ++i) {
            if (i != 0) {
                string2 = string2 + ", ";
            }
            string2 = string2 + stringArray[i];
        }
        RedeploymentController.dbg(string2);
    }

    private static void dbg(String string) {
        if (System.getProperty("redeploy.debug") != null) {
            AppUtils.dbg(tc, string);
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, string);
        }
    }

    private String[][] mergeValidDataFromOldTask(String string, String[][] stringArray, String[][] stringArray2, Vector vector) {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "mergeValidDataFromOldTask");
            }
            try {
                if (vector.size() < stringArray2.length - 1) {
                    if ("EmbeddedRar".equals(string)) {
                        String[][] stringArray3 = ((EmbeddedRarHelper)RedeploymentController.getTaskHelper(string)).mergeValidDataFromOldTask(stringArray, stringArray2, vector);
                        if (stringArray3 != null && stringArray3.length > 0) {
                            for (int i = 0; i < stringArray3.length; ++i) {
                                RedeploymentController.printSA(stringArray3[i], string + "[" + i + "]");
                            }
                            if (tc.isEntryEnabled()) {
                                Tr.exit(tc, "mergeValidDataFromOldTask");
                            }
                            return stringArray3;
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Invalid Merge: merge result is null or empty so ignoring it...");
                        }
                    }
                } else if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "oldTaskData exists in new, nothing to merge");
                }
            }
            catch (Throwable throwable) {
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception mergeValidDataFromOldTask: " + throwable.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "mergeValidDataFromOldTask");
        }
        return stringArray;
    }
}

