/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.application.client;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.application.AppManagementFactory;
import com.ibm.websphere.management.application.client.AppDeploymentController;
import com.ibm.websphere.management.application.client.AppDeploymentException;
import com.ibm.websphere.management.application.client.AppDeploymentTask;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.websphere.models.config.serverindex.ServerEntry;
import com.ibm.websphere.models.config.serverindex.ServerIndex;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.application.AppUtils;
import com.ibm.ws.management.application.client.ResourceMapperDefaultImpl;
import com.ibm.ws.management.application.task.ConfigRepoHelper;
import com.ibm.ws.management.configservice.MOFUtil;
import com.ibm.ws.management.configservice.WorkspaceHelper;
import com.ibm.ws.sm.workspace.RepositoryContext;
import com.ibm.ws.sm.workspace.WorkSpace;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.management.ObjectName;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;

public class ResourceValidationHelper {
    public static final String CLUSTER_MEMBER_ATTR = "memberName";
    public static final String CLUSTER_NODE_ATTR = "nodeName";
    private static TraceComponent tc = Tr.register(ResourceValidationHelper.class, "Admin", "com.ibm.ws.management.resources.AppDeploymentMessages");
    private static final String CLASS_NAME = ResourceValidationHelper.class.getName();
    private static final String WEBSPHERE_DOMAIN = "WebSphere:";
    private static final String RES_CONFIG_OBJECT = "resource.config.object";
    private static final String EMBEDDED_CONFIG_SCOPE = "WebSphere:scope=EmbeddedAppConfig";
    private static final String EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE = "WebSphere:scope=EmbeddedRarResource";
    private static final String EMBEDDED_RAR_RESOURCE_NO_URI = "noUriForEmbeddedRarTaskResource";
    private static final String VALIDATION_TASK_DATA_KEY = "resource.validation.invalidate.task.data";
    private static final String VALIDATION_MESSAGE_KEY = "resource.validation.invalidate.message";
    private static final String CLUSTER_XML = "cluster.xml";
    private static final Hashtable _mapPropertyTable = new Hashtable();
    private AppDeploymentController _controller;
    private boolean _thisObjectOwnsController;
    private ResourceMapperDefaultImpl _resMapper;
    private String _operation;
    private String _sessionId;
    private List _configFilesToLoad;
    private List _inAppConfigFilesToLoad;
    private Hashtable _scopeToModuleTbl;
    private Hashtable _moduleToScopeTbl;
    private Hashtable _scopeToResourceTbl;
    private Hashtable _valueToResourceTbl;
    private Hashtable _taskToTypeTbl;
    private Hashtable _clusterToMemberTbl;

    public static void addToScopeResultTable(String string, EObject eObject, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addToScopeResultTable", new Object[]{string, eObject, hashtable});
        }
        List<Object> list = new ArrayList<EObject>();
        if (hashtable.containsKey(string)) {
            list = (List)hashtable.get(string);
        }
        list.add(eObject);
        hashtable.put(string, list);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addToScopeResultTable");
        }
    }

    public static String buildTargetString(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "buildTargetString", new Object[]{list});
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                stringBuffer.append("+");
            }
            stringBuffer.append((String)list.get(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "buildTargetString", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }

    public static int getMatchingColIndex(AppDeploymentTask appDeploymentTask, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getMatchingColIndex", new Object[]{appDeploymentTask, string});
        }
        int n = -1;
        String[] stringArray = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equals(stringArray[i])) continue;
            n = i;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getMatchingColIndex", new Object[]{new Integer(n)});
        }
        return n;
    }

    public ResourceValidationHelper(String string, String string2, Hashtable hashtable, String string3, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceValidationHelper", new Object[]{string, string2, hashtable});
        }
        this._thisObjectOwnsController = true;
        this._controller = AppManagementFactory.readArchive(string, hashtable);
        if (this._controller != null) {
            this._controller.getAppOptions().putAll(hashtable);
        }
        if (bl) {
            this._init(string2, string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceValidationHelper");
        }
    }

    public ResourceValidationHelper(AppDeploymentController appDeploymentController, String string, String string2, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "ResourceValidationHelper", new Object[]{appDeploymentController, string, string2});
        }
        this._thisObjectOwnsController = false;
        this._controller = appDeploymentController;
        if (bl) {
            this._init(string, string2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "ResourceValidationHelper");
        }
    }

    public void init() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init");
        }
        this._init(this._sessionId, this._operation);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void init(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "init", new Object[]{string});
        }
        this._init(this._sessionId, string);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "init");
        }
    }

    public void close() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "close");
        }
        if (this._controller != null) {
            if (!this._thisObjectOwnsController && tc.isDebugEnabled()) {
                Tr.debug(tc, "close", "This object does not own the controller.");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "close", "Controller is null.");
        }
        this._controller = null;
        this._resMapper = null;
        this._operation = null;
        this._sessionId = null;
        this._configFilesToLoad = null;
        this._inAppConfigFilesToLoad = null;
        this._scopeToModuleTbl = null;
        this._moduleToScopeTbl = null;
        this._scopeToResourceTbl = null;
        this._valueToResourceTbl = null;
        this._taskToTypeTbl = null;
        this._clusterToMemberTbl = null;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "finalize");
        }
        try {
            this.close();
        }
        finally {
            super.finalize();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "finalize");
        }
    }

    public List getResourceJNDINames(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceJNDINames", new Object[]{string});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        ArrayList arrayList = new ArrayList();
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = (Hashtable)this._scopeToResourceTbl.get((String)enumeration.nextElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resTypes: " + hashtable);
            }
            if (hashtable == null || !hashtable.containsKey(string)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resType for type " + string + ": " + hashtable.get(string));
            }
            List list = this._getResourceKeyValues(string, (List)hashtable.get(string));
            this._addObjectsToList(list, arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceJNDINames", new Object[]{arrayList});
        }
        return arrayList;
    }

    public Hashtable getResourceObjectsWithRefKeys(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceObjectsWithRefKeys", new Object[]{string, string2});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable hashtable = this._getResourceObjectsWithRefKeys(string, string2, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceObjectsWithRefKeys", new Object[]{hashtable});
        }
        return hashtable;
    }

    public Hashtable taskResourceValidation(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "taskResourceValidation", new Object[]{string});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable hashtable = (Hashtable)this._taskResourceValidation(string, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "taskResourceValidation", new Object[]{hashtable});
        }
        return hashtable;
    }

    public Vector appResourceValidation() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "appResourceValidation");
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Vector vector = new Vector();
        String[] stringArray = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < stringArray.length; ++i) {
            List list = (List)this._taskResourceValidation(stringArray[i], true);
            if (list == null || list.size() <= 0) continue;
            vector.addAll(list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "appResourceValidation", new Object[]{vector});
        }
        return vector;
    }

    public Hashtable getAppResourceObjects() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getAppResourceObjects");
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable hashtable = new Hashtable();
        String[] stringArray = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < stringArray.length; ++i) {
            AppDeploymentTask appDeploymentTask = this._controller.getTaskByName(stringArray[i], false);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Proccessing task " + stringArray[i] + ": " + appDeploymentTask);
            }
            if (appDeploymentTask.isTaskEmpty()) continue;
            String[][] stringArray2 = appDeploymentTask.getTaskData();
            for (int j = 1; j < stringArray2.length; ++j) {
                Hashtable hashtable2 = this._getResourceConfigObject(appDeploymentTask, j);
                Enumeration enumeration = hashtable2.elements();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable3 = (Hashtable)enumeration.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "typeToConfigObjectTbl: " + hashtable3);
                    }
                    Enumeration enumeration2 = hashtable3.keys();
                    while (enumeration2.hasMoreElements()) {
                        String string = (String)enumeration2.nextElement();
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "processing type " + string);
                        }
                        Object v = hashtable3.get(string);
                        List list = new ArrayList();
                        if (hashtable.containsKey(string)) {
                            list = (List)hashtable.get(string);
                        }
                        if (!list.contains(v)) {
                            list.add(v);
                        }
                        hashtable.put(string, list);
                    }
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getAppResourceObjects", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable getResourceObjectsWithRefKeys(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceObjectsWithRefKeys", new Object[]{string});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable hashtable = new Hashtable();
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable2 = (Hashtable)this._scopeToResourceTbl.get((String)enumeration.nextElement());
            if (hashtable2 == null) continue;
            if (hashtable2.containsKey(string)) {
                List list = (List)hashtable2.get(string);
                Hashtable hashtable3 = this._resMapper.getResourceValuesWithObjects(string, list);
                this._addObjectsToTbl(hashtable3, hashtable);
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "scope does not obtain any resource object of type " + string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceObjectsWithRefKeys", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable getResourceConfigObject(String string, int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getResourceConfigObject", new Object[]{string, new Integer(n)});
        }
        this._checkInit();
        this._buildInAppTaskResource();
        Hashtable hashtable = this._getResourceConfigObject(this._controller.getTaskByName(string, false), n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getResourceConfigObject", new Object[]{hashtable});
        }
        return hashtable;
    }

    private void _checkInit() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkInit");
        }
        if (this._scopeToResourceTbl == null) {
            AppDeploymentException appDeploymentException = new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0163E"), null);
            FFDCFilter.processException((Throwable)appDeploymentException, CLASS_NAME + "._checkInit", "587", this);
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "_checkInit", appDeploymentException);
            }
            throw appDeploymentException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkInit");
        }
    }

    private Hashtable _getResourceConfigObject(AppDeploymentTask appDeploymentTask, int n) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{appDeploymentTask, new Integer(n)});
        }
        Hashtable<Integer, Hashtable> hashtable = new Hashtable<Integer, Hashtable>();
        if (appDeploymentTask != null) {
            if (!appDeploymentTask.isTaskEmpty()) {
                String[][] stringArray = appDeploymentTask.getTaskData();
                if (stringArray.length <= n) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Incorrect row index");
                    }
                    throw new AppDeploymentException("Incorrect row index passed in: " + n, null);
                }
                List list = this._resMapper.getTypesForTask(appDeploymentTask, stringArray[n]);
                Hashtable hashtable2 = this._resMapper.getColumnValue(appDeploymentTask, stringArray[n]);
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Integer n2 = (Integer)enumeration.nextElement();
                    String string = (String)hashtable2.get(n2);
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Processing col index: " + n2 + " with col value: " + string);
                    }
                    ArrayList<String> arrayList = new ArrayList<String>();
                    arrayList.add(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                    ArrayList<String> arrayList2 = new ArrayList<String>();
                    arrayList2.add(EMBEDDED_RAR_RESOURCE_NO_URI);
                    Hashtable hashtable3 = this._getResourceConfigObject(arrayList, arrayList2, list, string, false);
                    if (hashtable3.size() == 0) {
                        arrayList.clear();
                        arrayList.add(EMBEDDED_CONFIG_SCOPE);
                        hashtable3 = this._getResourceConfigObject(arrayList, this._inAppConfigFilesToLoad, list, string, false);
                    }
                    if (hashtable3.size() == 0) {
                        List list2 = this._getScopeForUri(appDeploymentTask, stringArray[n]);
                        hashtable3 = this._getResourceConfigObject(list2, this._configFilesToLoad, list, string, true);
                    }
                    if (hashtable3.size() <= 0) continue;
                    hashtable.put(n2, hashtable3);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task is empty");
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "Task is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getResourceObjectsWithRefKeys(String string, String string2, boolean bl) throws AppDeploymentException {
        List list;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeys", new Object[]{string, string2, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        string = string.replace(',', '+');
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleUri: " + string);
        }
        if ((list = (List)this._moduleToScopeTbl.get(string)) == null) {
            list = this.patchSipModuleUriAndGetScope(string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "moduleScopes: " + list);
        }
        if (list == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "internal error as no matching uri " + string + " is found in _moduleToScopeTbl");
            }
        } else {
            hashtable = this._getResourceObjectsWithRefKeys(list, string2, bl);
            if (hashtable != null && hashtable.size() > 0) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "getting node version info from each scope");
                }
                Hashtable hashtable2 = new Hashtable();
                for (int i = 0; i < list.size(); ++i) {
                    Properties properties = this._getKeyProperties((String)list.get(i));
                    if (properties.get("node") != null) {
                        Hashtable hashtable3 = new Hashtable();
                        try {
                            hashtable2.put(list.get(i), AppUtils.getNodeMajorVersion((String)properties.get("cell"), (String)properties.get("node")));
                            continue;
                        }
                        catch (AdminException adminException) {
                            throw new AppDeploymentException("", adminException);
                        }
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Scope " + properties + " does not contain node");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "scopeToNodeTbl: " + hashtable2);
                }
                this._resMapper.resourceObjectsPostProcessing(hashtable2, string2, hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeys", new Object[]{hashtable});
        }
        return hashtable;
    }

    private List patchSipModuleUriAndGetScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "patchSipModuleUriAndGetScope: " + string);
        }
        List list = null;
        if (string.indexOf("WEB-INF/web.xml") > 0) {
            string = string.replaceFirst("WEB-INF/web.xml", "WEB-INF/sip.xml");
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri is " + string);
            }
            list = (List)this._moduleToScopeTbl.get(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "patchSipModuleUriAndGetScope: " + list);
        }
        return list;
    }

    private Hashtable _getResourceObjectsWithRefKeys(List list, String string, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeys", new Object[]{list, string, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        ArrayList<Hashtable> arrayList = new ArrayList<Hashtable>();
        for (int i = 0; i < list.size(); ++i) {
            Hashtable hashtable2 = this._getResourceObjectsWithRefKeysForOneScope((String)list.get(i), string, bl);
            Hashtable hashtable3 = this._getCommonClusterResObjectsWithValues((String)list.get(i), string);
            if (hashtable3 != null && hashtable3.size() > 0) {
                this._addObjectsToTbl(hashtable3, hashtable2);
            }
            if (hashtable2 != null && hashtable2.size() > 0) {
                arrayList.add(hashtable2);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding resource table " + hashtable2 + " for scope " + list.get(i));
                continue;
            }
            arrayList.clear();
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "No resource of the type is found in scope " + list.get(i) + " - clear the scope resource table and get out");
            break;
        }
        if (arrayList.size() > 0) {
            hashtable = this._getResObjectsWithCommonValues(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeys", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getResourceObjectsWithRefKeysForOneScope(String string, String string2, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceObjectsWithRefKeysForOneScope", new Object[]{string, string2, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        if (string != null && string.length() > 0) {
            String string3;
            Hashtable hashtable2;
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(string);
            if (bl) {
                arrayList.add(0, EMBEDDED_CONFIG_SCOPE);
                arrayList.add(1, EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleScopes with embedded config scope: " + arrayList);
                }
            }
            for (int i = 0; i < arrayList.size(); ++i) {
                hashtable2 = new Hashtable();
                ArrayList<String> arrayList2 = new ArrayList<String>();
                arrayList2.add(string2);
                hashtable2 = EMBEDDED_CONFIG_SCOPE.equals((String)arrayList.get(i)) ? this._buildScopeResTypeTbl((String)arrayList.get(i), arrayList2, this._inAppConfigFilesToLoad, false) : (EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)arrayList.get(i)) ? this._getEmbeddedRarResource(arrayList2) : this._buildScopeResTypeTbl((String)arrayList.get(i), arrayList2, this._configFilesToLoad, false));
                Enumeration enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    Hashtable hashtable3 = (Hashtable)hashtable2.get((String)enumeration.nextElement());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "resTypes: " + hashtable3);
                    }
                    if (hashtable3 == null) continue;
                    if (hashtable3.containsKey(string2)) {
                        List list = (List)hashtable3.get(string2);
                        Hashtable hashtable4 = this._resMapper.getResourceValuesWithObjects(string2, list);
                        this._addObjectsToTbl(hashtable4, hashtable);
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "scope does not obtain any resource object of type " + string2);
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "seaching in parent scope");
            }
            if (bl) {
                arrayList.remove(EMBEDDED_CONFIG_SCOPE);
                arrayList.remove(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "moduleScopes with embedded config scope removed: " + arrayList);
                }
            }
            if ((string3 = this._getParentInScope(string)) != null && string3.length() > 0 && (hashtable2 = this._getResourceObjectsWithRefKeysForOneScope(string3, string2, false)).size() > 0) {
                this._addObjectsToTbl(hashtable2, hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceObjectsWithRefKeysForOneScope", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getCommonClusterResObjectsWithValues(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getCommonClusterResObjectsWithValues", new Object[]{string});
        }
        Hashtable hashtable = new Hashtable();
        List list = this._checkForClusterScope(string);
        if (list != null && list.size() > 0) {
            hashtable = this._getResourceObjectsWithRefKeys(list, string2, false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getCommonClusterResObjectsWithValues", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getResObjectsWithCommonValues(List list) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResObjectsWithCommonValues", new Object[]{list});
        }
        Hashtable hashtable = new Hashtable();
        if (list.size() > 0) {
            Hashtable hashtable2 = (Hashtable)list.get(0);
            Enumeration enumeration = hashtable2.keys();
            while (enumeration.hasMoreElements()) {
                boolean bl = true;
                Object k = enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resKey: " + k);
                }
                List list2 = new ArrayList();
                if (k instanceof List) {
                    list2 = (List)k;
                } else {
                    list2.add(k);
                }
                for (int i = 0; i < list2.size(); ++i) {
                    ArrayList arrayList = new ArrayList();
                    String string = (String)list2.get(i);
                    for (int j = 1; bl && j < list.size(); ++j) {
                        Hashtable hashtable3 = (Hashtable)list.get(j);
                        if (!hashtable3.containsKey(string)) {
                            bl = false;
                            if (!tc.isDebugEnabled()) continue;
                            Tr.debug(tc, "No common resource found for " + k);
                            continue;
                        }
                        Object v = hashtable3.get(string);
                        if (v instanceof List) {
                            arrayList.addAll((List)v);
                        } else {
                            arrayList.add(v);
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "Adding common resource eObject: " + hashtable3.get(k));
                    }
                    if (!bl) continue;
                    if (arrayList.size() > 0) {
                        Object v = hashtable2.get(k);
                        if (v instanceof List) {
                            arrayList.addAll((List)v);
                        } else {
                            arrayList.add(v);
                        }
                        hashtable.put(k, arrayList);
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug(tc, "find commom member resource - " + k + " " + arrayList);
                        continue;
                    }
                    hashtable.put(k, (ArrayList<Object>)hashtable2.get(k));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "find commom member resource - " + k + " " + hashtable2.get(k));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResObjectsWithCommonValues", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Object _taskResourceValidation(String string, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{string, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        ArrayList<String> arrayList = new ArrayList<String>();
        List list = this._getTypeForTask(string);
        if (list != null && list.size() > 0) {
            AppDeploymentTask appDeploymentTask = this._controller.getTaskByName(string, false);
            if (!appDeploymentTask.isTaskEmpty()) {
                this._resMapper.addValidationTypes(list);
                String[][] stringArray = appDeploymentTask.getTaskData();
                for (int i = 1; i < stringArray.length; ++i) {
                    List list2 = this._getScopeForUri(appDeploymentTask, stringArray[i]);
                    if (list2 != null && list2.size() > 0) {
                        int n;
                        String[] stringArray2;
                        list = this._resMapper.getTypesForTask(appDeploymentTask, stringArray[i]);
                        List list3 = this._taskResourceValidation(list2, appDeploymentTask, stringArray[i], list, true);
                        if (list3 != null && list3.size() > 0) {
                            if (bl) {
                                for (int j = 0; j < list3.size(); ++j) {
                                    arrayList.add(this._resMapper.buildWarningMsg(string, (Hashtable)list3.get(j)));
                                }
                            } else {
                                for (int j = 0; j < list3.size(); ++j) {
                                    hashtable.put(Integer.toString(i), list3.get(j));
                                }
                            }
                        }
                        if ((stringArray2 = this._resMapper.postDataToValidate(appDeploymentTask, stringArray[i])) == null || (list3 = this._taskResourceValidation(list2, appDeploymentTask, stringArray2, list, true)) == null || list3.size() <= 0) continue;
                        if (bl) {
                            for (n = 0; n < list3.size(); ++n) {
                                arrayList.add(this._resMapper.buildWarningMsg(string, (Hashtable)list3.get(n)));
                            }
                            continue;
                        }
                        for (n = 0; n < list3.size(); ++n) {
                            hashtable.put(Integer.toString(i), list3.get(n));
                        }
                        continue;
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "no target info for row " + i + "; skipping validation for this row");
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug(tc, "empty task");
            }
        }
        Cloneable cloneable = bl ? arrayList : hashtable;
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{cloneable});
        }
        return cloneable;
    }

    private Hashtable _getResourceConfigObject(List list, List list2, List list3, String string, boolean bl) throws AppDeploymentException {
        Object object;
        int n;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{list, list2, list3, string, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (list != null && list.size() > 0) {
            for (n = 0; n < list.size(); ++n) {
                object = new Hashtable();
                object = EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)list.get(n)) ? this._getEmbeddedRarResource(list3) : this._buildScopeResTypeTbl((String)list.get(n), list3, list2, false);
                if (object == null || ((Hashtable)object).size() <= 0) continue;
                hashtable2.putAll(object);
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "scopeToResObjTbl: " + hashtable2);
        }
        for (n = 0; n < list3.size(); ++n) {
            object = this._getResourceConfigObject(list, hashtable2, (String)list3.get(n), string, bl);
            if (object == null) continue;
            hashtable.put(list3.get(n), object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Object _getResourceConfigObject(List list, List list2, String string, String string2, boolean bl) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{list, list2, string, string2, new Boolean(bl)});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(string);
        Hashtable hashtable = this._getResourceConfigObject(list, list2, arrayList, string2, bl);
        Enumeration enumeration = hashtable.keys();
        Object var9_9 = null;
        while (enumeration.hasMoreElements()) {
            var9_9 = hashtable.get(enumeration.nextElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{var9_9});
        }
        return var9_9;
    }

    private Object _getResourceConfigObject(List list, Hashtable hashtable, String string, String string2, boolean bl) throws AppDeploymentException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceConfigObject", new Object[]{list, hashtable, string, string2, new Boolean(bl)});
        }
        Object object2 = null;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            object = (Hashtable)hashtable.get((String)enumeration.nextElement());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "processing for type " + string + "with resObjTbl " + object);
            }
            Hashtable hashtable2 = this._resMapper.getResourceValuesWithObjects(string, (List)((Hashtable)object).get(string));
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "valueObjTbl: " + hashtable2);
            }
            if (hashtable2 == null || !hashtable2.containsKey(string2)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Find matching value");
            }
            Object v = hashtable2.get(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "object for it: " + v);
            }
            if (v instanceof String) {
                object2 = v;
                break;
            }
            if (v instanceof EObject) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object is an EObject");
                }
                object2 = this._createConfigObjectName((EObject)v);
                break;
            }
            if (v instanceof List) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "object is a list");
                }
                if (((List)v).size() <= 0) break;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "get the first object from the list");
                }
                object2 = this._createConfigObjectName((EObject)((List)v).get(0));
                break;
            }
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "Unknow object type " + v);
            break;
        }
        if (object2 == null && bl) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "seaching in parent scope");
            }
            if ((object = this._getParentInScope(list)).size() > 0) {
                object2 = this._getResourceConfigObject((List)object, this._configFilesToLoad, string, string2, bl);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceConfigObject", new Object[]{object2});
        }
        return object2;
    }

    private List _getResourceKeyValues(String string, List list) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getResourceKeyValues", new Object[]{string, list});
        }
        ArrayList arrayList = new ArrayList();
        Hashtable hashtable = this._resMapper.getResourceValuesWithObjects(string, list);
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getResourceKeyValues", new Object[]{arrayList});
        }
        return arrayList;
    }

    private void _init(String string, String string2) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_init", new Object[]{string, string2});
        }
        if (this._controller == null) {
            throw new AppDeploymentException(AppUtils.getMessage(AppUtils.getBundle(null), "ADMA0170E"), null);
        }
        this._operation = string2;
        this._sessionId = string;
        this._resMapper = new ResourceMapperDefaultImpl();
        this._initScopeToModuleTable();
        this._scopeToResourceTbl = new Hashtable();
        this._initScopeToResourceTable(this._scopeToModuleTbl);
        this._initInAppResourceToResourceTable();
        this._buildClusterMemberAndResourceTable();
        this._buildValueToResourceTable();
        this._buildTaskTypeTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_init");
        }
    }

    private void _initScopeToModuleTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initScopeToModuleTable");
        }
        Hashtable hashtable = new Hashtable();
        try {
            hashtable = this._controller.getServerTable();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "serverTbl: " + hashtable);
            }
            if (hashtable == null || hashtable.size() == 0) {
                this._controller.getTaskByName("MapModulesToServers", false);
                hashtable = this._controller.getServerTable();
            }
        }
        catch (AppDeploymentException appDeploymentException) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception when calling getServerTable: " + appDeploymentException);
            }
            throw appDeploymentException;
        }
        this._scopeToModuleTbl = this._buildServerModuleTable(hashtable);
        this._moduleToScopeTbl = this._buildModuleServerTable(hashtable);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initScopeToModuleTable");
        }
    }

    private WorkSpace _getWorkSpace() throws AppDeploymentException {
        WorkSpace workSpace;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getWrokSpace");
        }
        try {
            workSpace = ConfigRepoHelper.getWorkSpace(this._sessionId);
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception when calling getWorkSpace: " + throwable);
            }
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException("", throwable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getWrokSpace", new Object[]{workSpace});
        }
        return workSpace;
    }

    private void _initScopeToResourceTable(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initScopeToResourceTable", new Object[]{hashtable});
        }
        WorkSpace workSpace = this._getWorkSpace();
        this._configFilesToLoad = this._resMapper.getConfigFilesToLoad(this._operation);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "config files to load: " + this._configFilesToLoad);
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            for (int i = 0; i < this._configFilesToLoad.size(); ++i) {
                String string2 = this._addUriToScope(string, (String)this._configFilesToLoad.get(i));
                if (this._scopeToResourceTbl.containsKey(string2)) continue;
                Properties properties = this._getKeyProperties(string);
                String string3 = (String)properties.get("cell");
                String string4 = (String)properties.get("node");
                String string5 = (String)properties.get("server");
                String string6 = (String)properties.get("cluster");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "cell: " + string3 + " node: " + string4 + " server: " + string5 + " cluster: " + string6);
                }
                RepositoryContext repositoryContext = null;
                RepositoryContext repositoryContext2 = null;
                RepositoryContext repositoryContext3 = null;
                RepositoryContext repositoryContext4 = null;
                ArrayList<RepositoryContext> arrayList = new ArrayList<RepositoryContext>();
                try {
                    if (string3 != null && string3.trim().length() > 0 && (repositoryContext = AppUtils.findContext("cells", string3, null, null, workSpace, true)) != null) {
                        arrayList.add(repositoryContext);
                    }
                    if (string4 != null && string4.trim().length() > 0 && (repositoryContext2 = AppUtils.findContext("nodes", string4, null, repositoryContext, workSpace, true)) != null) {
                        arrayList.add(0, repositoryContext2);
                    }
                    if (string5 != null && string5.trim().length() > 0 && (repositoryContext3 = AppUtils.findContext("servers", string5, null, repositoryContext2, workSpace, true)) != null) {
                        arrayList.add(0, repositoryContext3);
                    }
                    if (string6 != null && string6.trim().length() > 0 && (repositoryContext4 = AppUtils.findContext("clusters", string6, null, repositoryContext, workSpace, true)) != null) {
                        arrayList.add(0, repositoryContext4);
                    }
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scope context order: " + arrayList);
                    }
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when calling findContext: " + throwable);
                    }
                    if (throwable instanceof AppDeploymentException) {
                        throw (AppDeploymentException)throwable;
                    }
                    throw new AppDeploymentException("", throwable);
                }
                for (int j = 0; j < arrayList.size(); ++j) {
                    String string7 = this._buildUriFromContext((RepositoryContext)arrayList.get(j));
                    if (this._scopeToResourceTbl.containsKey(string7)) continue;
                    Hashtable hashtable2 = this._getRefObjects((RepositoryContext)arrayList.get(j), (String)this._configFilesToLoad.get(i));
                    this._scopeToResourceTbl.put(this._addUriToScope(string7, (String)this._configFilesToLoad.get(i)), hashtable2);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initScopeToResourceTable", new Object[]{this._scopeToResourceTbl});
        }
    }

    private void _initInAppResourceToResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_initInAppResourceToResourceable");
        }
        this._inAppConfigFilesToLoad = this._resMapper.getInAppConfigFilesToLoad(this._operation);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "In app config files to load: " + this._inAppConfigFilesToLoad);
        }
        for (int i = 0; i < this._inAppConfigFilesToLoad.size(); ++i) {
            if (!this._scopeToResourceTbl.containsKey(this._addUriToScope(EMBEDDED_CONFIG_SCOPE, (String)this._inAppConfigFilesToLoad.get(i)))) {
                Hashtable hashtable = this._getInAppRefObjects((String)this._inAppConfigFilesToLoad.get(i));
                if (hashtable.size() > 0) {
                    this._scopeToResourceTbl.put(this._addUriToScope(EMBEDDED_CONFIG_SCOPE, (String)this._inAppConfigFilesToLoad.get(i)), hashtable);
                }
                this._buildInAppTaskResource();
                continue;
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "Duplicate key " + this._inAppConfigFilesToLoad.get(i) + " in _scopeToResourceTbl");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_initInAppResourceToResourceTable", new Object[]{this._scopeToResourceTbl});
        }
    }

    private void _buildInAppTaskResource() throws AppDeploymentException {
        Hashtable hashtable;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildInAppTaskResource");
        }
        if ((hashtable = this._getInAppTaskResource()).size() > 0) {
            this._scopeToResourceTbl.put(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE, hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildInAppTaskResource");
        }
    }

    private String _buildUriFromContext(RepositoryContext repositoryContext) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildUriFromContext", new Object[]{repositoryContext});
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (repositoryContext != null) {
            String string = repositoryContext.getURI();
            String[] stringArray = string.split("/");
            stringBuffer.append(WEBSPHERE_DOMAIN);
            for (int i = 0; i < stringArray.length && i + 1 < stringArray.length; i += 2) {
                String string2 = (String)_mapPropertyTable.get(stringArray[i]);
                if (string2 == null || string2.equals("")) {
                    string2 = stringArray[i];
                }
                if (i > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(string2);
                stringBuffer.append("=");
                stringBuffer.append(stringArray[i + 1]);
            }
        } else if (tc.isDebugEnabled()) {
            Tr.debug(tc, "context is null");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildUriFromContext", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }

    private String _buildOrderedScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildOrderedScope", new Object[]{string});
        }
        Properties properties = this._getKeyProperties(string);
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WEBSPHERE_DOMAIN);
        if (properties.get("cell") != null) {
            stringBuffer.append("cell=" + (String)properties.get("cell"));
        }
        if (properties.get("node") != null) {
            stringBuffer.append(",");
            stringBuffer.append("node=" + (String)properties.get("node"));
        }
        if (properties.get("server") != null) {
            stringBuffer.append(",");
            stringBuffer.append("server=" + (String)properties.get("server"));
        }
        if (properties.get("cluster") != null) {
            stringBuffer.append(",");
            stringBuffer.append("cluster=" + (String)properties.get("cluster"));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildOrderedScope", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }

    private String _addUriToScope(String string, String string2) {
        return string + ",uri=" + string2;
    }

    private String _removeUriFromScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_removeUriFromScope", new Object[]{string});
        }
        String string2 = string;
        if (string.indexOf(",uri=") > 0) {
            int n = string.indexOf(",uri=");
            string2 = string.substring(0, n);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_removeUriFromScope", new Object[]{string2});
        }
        return string2;
    }

    private Properties _getKeyProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getKeyProperties", new Object[]{string});
        }
        Properties properties = new Properties();
        if (string.startsWith(WEBSPHERE_DOMAIN)) {
            string = string.substring(10, string.length());
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Target: " + string);
            }
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            String string3 = null;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Token: " + string2);
            }
            if (string2.startsWith("cell")) {
                string3 = "cell";
            } else if (string2.startsWith("node")) {
                string3 = "node";
            } else if (string2.startsWith("server")) {
                string3 = "server";
            } else if (string2.startsWith("cluster")) {
                string3 = "cluster";
            }
            if (string3 == null) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding Key: " + string3 + " +  value: " + string2.substring(string2.indexOf("=") + 1));
            }
            properties.setProperty(string3, string2.substring(string2.indexOf("=") + 1));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getKeyProperties", new Object[]{properties});
        }
        return properties;
    }

    private Resource _load(RepositoryContext repositoryContext, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_load", new Object[]{repositoryContext, string});
        }
        Resource resource = null;
        if (repositoryContext != null) {
            resource = repositoryContext.getResourceSet().getResource(URI.createURI((String)string), true);
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_load", new Object[]{resource});
        }
        return resource;
    }

    private Hashtable _getRefObjects(RepositoryContext repositoryContext, String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getRefObjects", new Object[]{repositoryContext, string});
        }
        Hashtable hashtable = this._getRefObjects(this._load(repositoryContext, string));
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getRefObjects", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getRefObjects(Resource resource) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getRefObjects", new Object[]{resource});
        }
        Hashtable hashtable = new Hashtable();
        if (resource != null) {
            Iterator iterator = resource.getContents().iterator();
            while (iterator.hasNext()) {
                EObject eObject = (EObject)iterator.next();
                String string = eObject.eClass().getName();
                ResourceValidationHelper.addToScopeResultTable(string, eObject, hashtable);
                this._getSubtypesForRefObject(eObject, hashtable);
                this._getChildTypesFromParentRefObject(eObject, hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getRefObjects", new Object[]{hashtable});
        }
        return hashtable;
    }

    private void _getChildTypesFromParentRefObject(EObject eObject, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getChildTypesFromParentRefObject", new Object[]{eObject, hashtable});
        }
        Hashtable hashtable2 = this._resMapper.getChildTypesAndObjects(eObject);
        Enumeration enumeration = hashtable2.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            List list = (List)hashtable2.get(string);
            for (int i = 0; i < list.size(); ++i) {
                ResourceValidationHelper.addToScopeResultTable(string, (EObject)list.get(i), hashtable);
                this._getSubtypesForRefObject((EObject)list.get(i), hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getChildTypesFromParentRefObject", new Object[]{hashtable});
        }
    }

    private void _getSubtypesForRefObject(EObject eObject, Hashtable hashtable) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getSubtypesFromRefObject", new Object[]{eObject, hashtable});
        }
        List list = this._resMapper.getSubtypes(eObject);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "subtypes: " + list);
        }
        for (int i = 0; i < list.size(); ++i) {
            ResourceValidationHelper.addToScopeResultTable((String)list.get(i), eObject, hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getSubtypesFromRefObject");
        }
    }

    private void _buildValueToResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildValueToResourceTable");
        }
        this._valueToResourceTbl = new Hashtable();
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            Hashtable hashtable = new Hashtable();
            String string = (String)enumeration.nextElement();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "scope: " + string);
            }
            Hashtable hashtable2 = (Hashtable)this._scopeToResourceTbl.get(string);
            Enumeration enumeration2 = hashtable2.keys();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "typeToResTbl: " + hashtable2);
            }
            while (enumeration2.hasMoreElements()) {
                String string2 = (String)enumeration2.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type: " + string2);
                }
                List list = (List)hashtable2.get(string2);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resList: " + list);
                }
                if (list == null) continue;
                Hashtable hashtable3 = this._resMapper.getResourceValuesWithObjects(string2, list);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "resValueToObjTbl: " + hashtable3);
                }
                if (hashtable3 == null) continue;
                Enumeration enumeration3 = hashtable3.keys();
                while (enumeration3.hasMoreElements()) {
                    Object k = enumeration3.nextElement();
                    Object v = hashtable3.get(k);
                    List<Hashtable<String, String>> list2 = new ArrayList();
                    if (hashtable.containsKey(k)) {
                        list2 = (List)hashtable.get(k);
                    }
                    Hashtable<String, String> hashtable4 = new Hashtable<String, String>();
                    hashtable4.put("resource.type", string2);
                    hashtable4.put("resource.object", (String)v);
                    list2.add(hashtable4);
                    hashtable.put(k, list2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "jndiTbl: " + hashtable);
                }
            }
            this._valueToResourceTbl.put(string, hashtable);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildValueToResourceTable", new Object[]{this._valueToResourceTbl});
        }
    }

    private Hashtable _buildServerModuleTable(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildServerModuleTable", new Object[]{hashtable});
        }
        Hashtable<String, Hashtable> hashtable2 = new Hashtable<String, Hashtable>();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + string);
                }
                String string2 = (String)hashtable.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target: " + string2);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (this._isWebServerScope(string3)) continue;
                    string3 = this._buildOrderedScope(string3);
                    Hashtable hashtable3 = new Hashtable();
                    if (hashtable2.containsKey(string3)) {
                        hashtable3 = (Hashtable)hashtable2.get(string3);
                    }
                    if (!hashtable3.containsKey(string)) {
                        hashtable3.put(string, new Hashtable());
                    }
                    hashtable2.put(string3, hashtable3);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildServerModuleTable", new Object[]{hashtable2});
        }
        return hashtable2;
    }

    private Hashtable _buildModuleServerTable(Hashtable hashtable) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildModuleServerTable", new Object[]{hashtable});
        }
        Hashtable hashtable2 = new Hashtable();
        if (hashtable != null) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "module: " + string);
                }
                String string2 = (String)hashtable.get(string);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "target: " + string2);
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2, "+");
                ArrayList<String> arrayList = new ArrayList<String>();
                while (stringTokenizer.hasMoreTokens()) {
                    String string3 = stringTokenizer.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "scope: " + string3);
                    }
                    if (this._isWebServerScope(string3)) continue;
                    string3 = this._buildOrderedScope(string3);
                    arrayList.add(string3);
                }
                hashtable2.put(string, arrayList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildModuleServerTable", new Object[]{hashtable2});
        }
        return hashtable2;
    }

    private boolean _isWebServerScope(String string) throws AppDeploymentException {
        Object object;
        boolean bl = false;
        Properties properties = this._getKeyProperties(string);
        String string2 = (String)properties.get("server");
        String string3 = (String)properties.get("node");
        String string4 = (String)properties.get("cell");
        String string5 = (String)properties.get("cluster");
        if (string5 != null) {
            return false;
        }
        RepositoryContext repositoryContext = null;
        RepositoryContext repositoryContext2 = null;
        try {
            object = this._getWorkSpace();
            if (string4 != null && string4.trim().length() > 0) {
                repositoryContext = AppUtils.findContext("cells", string4, null, null, (WorkSpace)object, true);
            }
            if (string2 != null && string2.trim().length() > 0) {
                repositoryContext2 = AppUtils.findContext("nodes", string3, null, repositoryContext, (WorkSpace)object, true);
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception when calling findContext: " + throwable);
            }
            if (throwable instanceof AppDeploymentException) {
                throw (AppDeploymentException)throwable;
            }
            throw new AppDeploymentException("", throwable);
        }
        object = this._getRefObjects(repositoryContext2, "serverindex.xml");
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "ref objects from serverindex.xml: " + object);
        }
        ServerIndex serverIndex = (ServerIndex)((ArrayList)((Hashtable)object).get("ServerIndex")).get(0);
        EList eList = serverIndex.getServerEntries();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ServerEntry serverEntry = (ServerEntry)iterator.next();
            String string6 = serverEntry.getServerName();
            String string7 = serverEntry.getServerType();
            Tr.debug(tc, "the name of SERVERS is is" + serverEntry.getServerName());
            Tr.debug(tc, "the name of SERVER TYPES is is is" + serverEntry.getServerType());
            if (!string6.equals(string2)) continue;
            if (string7.equals("WEB_SERVER")) {
                bl = true;
                continue;
            }
            bl = false;
        }
        return bl;
    }

    private void _buildClusterMemberAndResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterMemberAndResourceTable");
        }
        this._buildClusterToMemberTable();
        this._buildClusterMemberResourceTable();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterMemberAndResourceTable");
        }
    }

    private void _buildClusterToMemberTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterToMemberTable");
        }
        if (this._scopeToModuleTbl != null) {
            WorkSpace workSpace = this._getWorkSpace();
            this._clusterToMemberTbl = new Hashtable();
            Enumeration enumeration = this._scopeToModuleTbl.keys();
            while (enumeration.hasMoreElements()) {
                List list;
                Hashtable hashtable;
                String string = (String)enumeration.nextElement();
                Properties properties = this._getKeyProperties(string);
                String string2 = (String)properties.get("cluster");
                if (string2 == null || this._clusterToMemberTbl.containsKey(string)) continue;
                String string3 = (String)properties.get("cell");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "find a cluster - cell: " + string3 + " cluster: " + string2);
                }
                RepositoryContext repositoryContext = null;
                RepositoryContext repositoryContext2 = null;
                try {
                    if (string3 != null && string3.trim().length() > 0) {
                        repositoryContext = AppUtils.findContext("cells", string3, null, null, workSpace, true);
                    }
                    if (string2 != null && string2.trim().length() > 0) {
                        repositoryContext2 = AppUtils.findContext("clusters", string2, null, repositoryContext, workSpace, true);
                    }
                }
                catch (Throwable throwable) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Exception when calling findContext: " + throwable);
                    }
                    if (throwable instanceof AppDeploymentException) {
                        throw (AppDeploymentException)throwable;
                    }
                    throw new AppDeploymentException("", throwable);
                }
                Hashtable hashtable2 = this._getRefObjects(repositoryContext2, CLUSTER_XML);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "ref objects from cluster.xml: " + hashtable2);
                }
                if (hashtable2 == null || (hashtable = this._resMapper.getResourceValuesWithAttrsAndObjects("ClusterMember", list = (List)hashtable2.get("ClusterMember"))) == null) continue;
                ArrayList<String> arrayList = new ArrayList<String>();
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                    Hashtable hashtable3 = (Hashtable)enumeration2.nextElement();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "key: " + hashtable3);
                    }
                    List list2 = this._resMapper.getResourceTypeAttr("ClusterMember");
                    String string4 = null;
                    String string5 = null;
                    for (int i = 0; i < list2.size(); ++i) {
                        String string6 = (String)hashtable3.get(list2.get(i));
                        if (string6 != null && ((String)list2.get(i)).equals(CLUSTER_NODE_ATTR)) {
                            string4 = string6;
                        }
                        if (string6 == null || !((String)list2.get(i)).equals(CLUSTER_MEMBER_ATTR)) continue;
                        string5 = string6;
                    }
                    if (string4 == null || string5 == null) continue;
                    arrayList.add("WebSphere:cell=" + string3 + ",node=" + string4 + ",server=" + string5);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Added member: WebSphere:cell=" + string3 + ",node=" + string4 + ",server=" + string5);
                }
                this._clusterToMemberTbl.put(string, arrayList);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Added cluster scope " + string + " with members: " + arrayList);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterToMemberTable", new Object[]{this._clusterToMemberTbl});
        }
    }

    private void _buildClusterMemberResourceTable() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildClusterMemberResourceTable");
        }
        if (this._clusterToMemberTbl != null && this._clusterToMemberTbl.size() > 0) {
            Enumeration enumeration = this._clusterToMemberTbl.elements();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable = new Hashtable();
                List list = (List)enumeration.nextElement();
                for (int i = 0; i < list.size(); ++i) {
                    hashtable.put(list.get(i), "");
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "member table: " + hashtable);
                }
                this._initScopeToResourceTable(hashtable);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildClusterMemberResourceTable");
        }
    }

    private void _buildTaskTypeTable() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildTaskTypeTable");
        }
        this._taskToTypeTbl = new Hashtable();
        String[] stringArray = this._controller.getAppDeploymentTaskNames();
        for (int i = 0; i < stringArray.length; ++i) {
            List list = this._resMapper.getTypesForTask(stringArray[i]);
            if (list == null || list.size() == 0) continue;
            this._taskToTypeTbl.put(stringArray[i], list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildTaskTypeTable");
        }
    }

    private Hashtable _buildTaskDataInTbl(AppDeploymentTask appDeploymentTask, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildTaskDataInTabl", new Object[]{appDeploymentTask, stringArray});
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        String[] stringArray2 = appDeploymentTask.getColumnNames();
        for (int i = 0; i < stringArray2.length; ++i) {
            if (appDeploymentTask.isHiddenColumn(i)) {
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Skipping hidden " + i + " column");
                continue;
            }
            if (stringArray[i] == null) {
                hashtable.put(stringArray2[i], "");
                continue;
            }
            hashtable.put(stringArray2[i], stringArray[i]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildTaskDataInTabl", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getEmbeddedResources(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedResource", new Object[]{list});
        }
        Hashtable hashtable = this._buildScopeResTypeTbl(EMBEDDED_CONFIG_SCOPE, list, this._inAppConfigFilesToLoad, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getEmbeddedResource", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _getEmbeddedRarResource(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedRarResource", new Object[]{list});
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        if (list != null && list.size() > 0) {
            Hashtable hashtable3 = (Hashtable)this._scopeToResourceTbl.get(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE);
            if (hashtable3 != null && hashtable3.size() > 0) {
                for (int i = 0; i < list.size(); ++i) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "type: " + list.get(i));
                    }
                    if (!hashtable3.containsKey(list.get(i))) continue;
                    List list2 = new ArrayList();
                    if (hashtable2.containsKey(list.get(i))) {
                        list2 = (List)hashtable2.get(list.get(i));
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "adding to existing list: " + list2);
                        }
                    }
                    list2.addAll((List)hashtable3.get(list.get(i)));
                    hashtable2.put((String)list.get(i), list2);
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "new or modified type list: " + list2);
                }
            }
            if (hashtable2.size() > 0) {
                hashtable.put(EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE, hashtable2);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getEmbeddedRarResource", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _buildScopeResTypeTbl(String string, List list, List list2, boolean bl) {
        String string2;
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildScopeResTypeTbl", new Object[]{string, list, list2, new Boolean(bl)});
        }
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        for (int i = 0; i < list2.size(); ++i) {
            object = string;
            if (string.indexOf("uri=") == -1) {
                object = this._addUriToScope(string, (String)list2.get(i));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "uriScope: " + (String)object);
                }
            }
            Hashtable hashtable3 = (Hashtable)this._scopeToResourceTbl.get(object);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resTypeTbl: " + hashtable3);
            }
            if (hashtable3 == null || hashtable3.size() <= 0) continue;
            for (int j = 0; j < list.size(); ++j) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "type: " + list.get(j));
                }
                if (!hashtable3.containsKey(list.get(j))) continue;
                List list3 = new ArrayList();
                if (hashtable2.containsKey(list.get(j))) {
                    list3 = (List)hashtable2.get(list.get(j));
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "adding to existing list: " + list3);
                    }
                }
                list3.addAll((List)hashtable3.get(list.get(j)));
                hashtable2.put((String)list.get(j), list3);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "new or modified type list: " + list3);
            }
        }
        if (hashtable2.size() > 0) {
            hashtable.put(this._removeUriFromScope(string), hashtable2);
        }
        if (bl && ((Hashtable)(object = this._buildScopeResTypeTbl(string2 = this._getParentInScope(string), list, list2, bl))).size() > 0) {
            hashtable.putAll(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildScopeResTypeTbl", new Object[]{hashtable});
        }
        return hashtable;
    }

    private Hashtable _buildScopeResValueTbl(String string, List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildScopeResValueTbl", new Object[]{string, list});
        }
        Hashtable<String, Hashtable> hashtable = new Hashtable<String, Hashtable>();
        for (int i = 0; i < list.size(); ++i) {
            String string2 = string;
            if (string.indexOf("uri=") == -1 && !EMBEDDED_RAR_RESOURCE_NO_URI.equals((String)list.get(i))) {
                string2 = this._addUriToScope(string, (String)list.get(i));
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "uri: " + string2);
            }
            Hashtable hashtable2 = (Hashtable)this._valueToResourceTbl.get(string2);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "resValueTbl: " + hashtable2);
            }
            if (hashtable2 == null || hashtable2.size() <= 0) continue;
            Hashtable hashtable3 = new Hashtable();
            if (hashtable.containsKey(this._removeUriFromScope(string2))) {
                hashtable3 = (Hashtable)hashtable.get(this._removeUriFromScope(string2));
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Adding to existing value table: " + hashtable3);
                }
            }
            hashtable3.putAll(hashtable2);
            hashtable.put(this._removeUriFromScope(string2), hashtable3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_buildScopeResValueTbl", new Object[]{hashtable});
        }
        return hashtable;
    }

    private List _taskResourceValidation(List list, AppDeploymentTask appDeploymentTask, String[] stringArray, List list2, boolean bl) throws AppDeploymentException {
        ArrayList arrayList;
        ArrayList arrayList2;
        String[] stringArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{list, appDeploymentTask, stringArray, list2, new Boolean(bl)});
        }
        if ((stringArray2 = this._taskResourceValidation(true, list, appDeploymentTask, stringArray, list2, list, bl, true, true, arrayList2 = new ArrayList(), arrayList = new ArrayList())) != null && arrayList2.size() > 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "found not in scope resource ... look for mistype");
            }
            stringArray2 = this._taskResourceValidation(false, list, appDeploymentTask, stringArray2, list2, list, bl, false, false, arrayList2, arrayList);
        }
        ArrayList arrayList3 = new ArrayList();
        if (arrayList2.size() > 0) {
            arrayList3.addAll(arrayList2);
        }
        if (arrayList.size() > 0) {
            arrayList3.addAll(arrayList);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{arrayList3});
        }
        return arrayList3;
    }

    private String[] _taskResourceValidation(boolean bl, List list, AppDeploymentTask appDeploymentTask, String[] stringArray, List list2, List list3, boolean bl2, boolean bl3, boolean bl4, List list4, List list5) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_taskResourceValidation", new Object[]{new Boolean(bl), list, appDeploymentTask, stringArray, list2, list3, new Boolean(bl2), new Boolean(bl3), new Boolean(bl4), list4, list5});
        }
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < list.size(); ++i) {
            Object object;
            Hashtable hashtable2 = new Hashtable();
            if (bl) {
                object = new Hashtable();
                for (int j = 0; j < list2.size(); ++j) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.add(list.get(i));
                    Hashtable hashtable3 = this._getResourceObjectsWithRefKeys(arrayList, (String)list2.get(j), true);
                    Hashtable hashtable4 = this._getCommonClusterResObjectsWithValues((String)list.get(i), (String)list2.get(j));
                    if (hashtable4.size() > 0) {
                        hashtable3.putAll(hashtable4);
                    }
                    if (hashtable3 == null || hashtable3.size() <= 0) continue;
                    ((Hashtable)object).put(list2.get(j), hashtable3);
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Res obj tbl for scope " + list.get(i) + ": " + object);
                }
                hashtable2.put(list.get(i), object);
            } else {
                object = new ArrayList();
                if (EMBEDDED_CONFIG_SCOPE.equals((String)list.get(i))) {
                    object = this._inAppConfigFilesToLoad;
                } else if (EMBEDDED_RAR_RESOURCE_IN_TASK_SCOPE.equals((String)list.get(i))) {
                    object.add(EMBEDDED_RAR_RESOURCE_NO_URI);
                } else {
                    object = this._configFilesToLoad;
                }
                hashtable2 = this._buildScopeResValueTbl((String)list.get(i), (List)object);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Res value tbl for scope " + list.get(i) + ": " + hashtable2);
                }
            }
            if (hashtable2.size() == 0 && bl4) {
                hashtable.put(list.get(i), new Hashtable());
            }
            if (hashtable2.size() <= 0) continue;
            hashtable.putAll(hashtable2);
        }
        String[] stringArray2 = bl ? this._resMapper.validateInScopeResource(appDeploymentTask, stringArray, hashtable, bl4, list3, list4) : this._resMapper.validateMisTypeResource(appDeploymentTask, stringArray, hashtable, list3, list4, list5);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_taskResourceValidation", new Object[]{stringArray2});
        }
        return stringArray2;
    }

    private List _getParentInScope(List list) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getParentInScope", new Object[]{list});
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = this._getParentInScope((String)list.get(i));
            if (string == null || arrayList.contains(string)) continue;
            arrayList.add(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getParentInScope", new Object[]{arrayList});
        }
        return arrayList;
    }

    private String _getParentInScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getParentInScope", new Object[]{string});
        }
        String string2 = null;
        Properties properties = this._getKeyProperties(string);
        if (properties.get("server") != null) {
            string2 = this._buildParentScope("node", properties);
        } else if (properties.get("node") != null) {
            string2 = this._buildParentScope("cell", properties);
        } else if (properties.get("cluster") != null) {
            string2 = this._buildParentScope("cell", properties);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getParentInScope", new Object[]{string2});
        }
        return string2;
    }

    private String _buildParentScope(String string, Properties properties) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildParentScope", new Object[]{string, properties});
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(WEBSPHERE_DOMAIN);
        if (properties.get("cell") != null) {
            stringBuffer.append("cell=" + (String)properties.get("cell"));
        }
        if (string.equals("node") && properties.get("node") != null) {
            stringBuffer.append(",");
            stringBuffer.append("node=" + (String)properties.get("node"));
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_buildParentScope", new Object[]{stringBuffer.toString()});
        }
        return stringBuffer.toString();
    }

    private List _getTypeForTask(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getTypeForTask", new Object[]{string});
        }
        List list = (List)this._taskToTypeTbl.get(string);
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "types: " + list);
        }
        if ((list == null || list.size() == 0) && tc.isDebugEnabled()) {
            Tr.debug(tc, "Task " + string + " does not have resource to be validated");
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getTypeForTask", new Object[]{list});
        }
        return list;
    }

    private List _getScopeForUri(AppDeploymentTask appDeploymentTask, String[] stringArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getScopeForUri", new Object[]{appDeploymentTask, stringArray});
        }
        ArrayList arrayList = new ArrayList();
        int n = ResourceValidationHelper.getMatchingColIndex(appDeploymentTask, "uri");
        if (n == -1) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Task does not have uri column");
            }
        } else {
            String string = stringArray[n];
            List list = (List)this._moduleToScopeTbl.get(string = string.replace(',', '+'));
            if (list != null && list.size() > 0) {
                arrayList.addAll(list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getScopeForUri", new Object[]{arrayList});
        }
        return arrayList;
    }

    private List _checkForClusterScope(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_checkForClusterScope", new Object[]{string});
        }
        ArrayList arrayList = new ArrayList();
        Properties properties = this._getKeyProperties(string);
        if (properties.getProperty("cluster") != null) {
            List list = (List)this._clusterToMemberTbl.get(string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "cluster members: " + list);
            }
            if (list != null) {
                arrayList.addAll(list);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_checkForClusterScope", new Object[]{arrayList});
        }
        return arrayList;
    }

    private void _addObjectsToList(List list, List list2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_addObjectsToList", new Object[]{list, list2});
        }
        for (int i = 0; i < list.size(); ++i) {
            if (list2.contains(list.get(i))) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Adding object " + list.get(i) + " to list");
            }
            list2.add(list.get(i));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_addObjectsToList", new Object[]{list2});
        }
    }

    private void _addObjectsToTbl(Hashtable hashtable, Hashtable hashtable2) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_addObjectsToTbl", new Object[]{hashtable, hashtable2});
        }
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            int n;
            Object k = enumeration.nextElement();
            Object v = hashtable.get(k);
            if (!hashtable2.containsKey(k)) {
                hashtable2.put(k, v);
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "Adding " + k);
                continue;
            }
            Object v2 = hashtable2.get(k);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existingObject: " + v2);
            }
            List list = new ArrayList();
            if (v2 instanceof EObject) {
                list.add(v2);
            } else if (v2 instanceof List) {
                list = (List)v2;
            }
            List list2 = new ArrayList();
            if (v instanceof EObject) {
                list2.add(v);
            } else if (v instanceof List) {
                list2 = (List)v;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "newObjectList: " + list2);
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            for (n = 0; n < list.size(); ++n) {
                arrayList.add(WorkspaceHelper.getContext(((EObject)list.get(n)).eResource()).getURI());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "existing object scope uri: " + arrayList);
            }
            for (n = 0; n < list2.size(); ++n) {
                if (list.contains(list2.get(n))) continue;
                String string = WorkspaceHelper.getContext(((EObject)list2.get(n)).eResource()).getURI();
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "new object: " + list2.get(n) + " with scope uri " + string);
                }
                boolean bl = false;
                for (int i = 0; i < arrayList.size(); ++i) {
                    if (((String)arrayList.get(i)).indexOf(string) < 0) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    list.add(list2.get(n));
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "Adding object to list");
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug(tc, "object with overriden scope is already in the EObject list");
            }
            if (list.size() > 1) {
                hashtable2.put(k, list);
            }
            if (!tc.isDebugEnabled()) continue;
            Tr.debug(tc, "final object list: " + list);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_addObjectsToTbl", new Object[]{hashtable2});
        }
    }

    private ObjectName _createConfigObjectName(EObject eObject) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_createConfigObjectName", new Object[]{eObject});
        }
        ObjectName objectName = MOFUtil.createObjectName(eObject);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_createConfigObjectName", new Object[]{objectName});
        }
        return objectName;
    }

    private Hashtable _getInAppTaskResource() throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getInAppTaskResource");
        }
        Hashtable hashtable = new Hashtable();
        hashtable = this._resMapper.getInAppTaskResource(this._controller);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getInAppTaskResource", new Object[]{hashtable});
        }
        return hashtable;
    }

    public Hashtable _getInAppRefObjects(String string) throws AppDeploymentException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "_getInAppRefObjects", new Object[]{string});
        }
        Hashtable hashtable = new Hashtable();
        if (this._controller.checkIfEnhancedEar()) {
            hashtable = this._getRefObjects(this._controller.getEnhancedEarDeploymentResource(string));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "_getInAppRefObjects", new Object[]{hashtable});
        }
        return hashtable;
    }

    public void printValueTable() throws AppDeploymentException {
        this._checkInit();
        System.out.println("---------------------- value Table -----------------------");
        Enumeration enumeration = this._valueToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("======== key: " + string);
            Hashtable hashtable = (Hashtable)this._valueToResourceTbl.get(string);
            Enumeration enumeration2 = hashtable.keys();
            System.out.println("======== value: ");
            while (enumeration2.hasMoreElements()) {
                Object k = enumeration2.nextElement();
                List list = (List)hashtable.get(k);
                System.out.println("     -------- key: " + k);
                for (int i = 0; i < list.size(); ++i) {
                    Hashtable hashtable2 = (Hashtable)list.get(i);
                    System.out.println("         ++++++ resType: " + hashtable2.get("resource.type"));
                    System.out.println("                resObject: " + hashtable2.get("resource.object"));
                }
                System.out.println("\n\n");
            }
        }
    }

    public void printScopeTable() throws AppDeploymentException {
        this._checkInit();
        System.out.println("---------------------- Scope Table -----------------------");
        Enumeration enumeration = this._scopeToResourceTbl.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            System.out.println("======== key: " + string);
            Hashtable hashtable = (Hashtable)this._scopeToResourceTbl.get(string);
            Enumeration enumeration2 = hashtable.keys();
            System.out.println("======== value: ");
            while (enumeration2.hasMoreElements()) {
                Object object;
                String string2 = (String)enumeration2.nextElement();
                Object v = hashtable.get(string2);
                System.out.println("     -------- key: " + string2);
                if (v instanceof Hashtable) {
                    object = (Hashtable)v;
                    Enumeration enumeration3 = ((Hashtable)object).keys();
                    while (enumeration3.hasMoreElements()) {
                        String string3 = (String)enumeration3.nextElement();
                        System.out.println("       ******** key: " + string3);
                        Hashtable hashtable2 = (Hashtable)((Hashtable)object).get(string3);
                        Enumeration enumeration4 = hashtable2.keys();
                        while (enumeration4.hasMoreElements()) {
                            String string4 = (String)enumeration4.nextElement();
                            System.out.println("          +++++++++++++ key: " + string4);
                            System.out.println("              ............. " + hashtable2.get(string4));
                        }
                    }
                } else if (v instanceof List) {
                    object = (List)v;
                    for (int i = 0; i < object.size(); ++i) {
                        System.out.println("       +++++++++++++ " + object.get(i));
                    }
                }
                System.out.println("\n\n");
            }
        }
    }

    public void printAppTable() throws AppDeploymentException {
        Object object;
        Object object2;
        Object object3;
        this._checkInit();
        System.out.println("---------------------- Scope-to-Module Table -----------------------");
        Enumeration enumeration = this._scopeToModuleTbl.keys();
        while (enumeration.hasMoreElements()) {
            object3 = (String)enumeration.nextElement();
            System.out.println("======== target: " + (String)object3);
            object2 = (Hashtable)this._scopeToModuleTbl.get(object3);
            object = ((Hashtable)object2).keys();
            while (object.hasMoreElements()) {
                String string = (String)object.nextElement();
                Hashtable hashtable = (Hashtable)((Hashtable)object2).get(string);
                System.out.println("     -------- module: " + string);
                Enumeration enumeration2 = hashtable.keys();
                while (enumeration2.hasMoreElements()) {
                }
            }
            System.out.println("\n\n");
        }
        System.out.println("---------------------- Module-to-Scope Table -----------------------");
        object3 = this._moduleToScopeTbl.keys();
        while (object3.hasMoreElements()) {
            object2 = (String)object3.nextElement();
            System.out.println("======== module: " + (String)object2);
            object = (List)this._moduleToScopeTbl.get(object2);
            for (int i = 0; i < object.size(); ++i) {
                System.out.println("    ----------- target: " + object.get(i));
            }
            System.out.println("\n\n");
        }
    }

    static {
        _mapPropertyTable.put("cells", "cell");
        _mapPropertyTable.put("nodes", "node");
        _mapPropertyTable.put("servers", "server");
        _mapPropertyTable.put("clusters", "cluster");
    }
}

