/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminClient;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.AdminCommand;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgrInitException;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandGroupMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.CommandProviderHelper;
import com.ibm.websphere.management.configservice.ConfigService;
import com.ibm.websphere.management.configservice.ConfigServiceFactory;
import com.ibm.websphere.management.configservice.ConfigServiceHelper;
import com.ibm.websphere.management.exception.ConnectorException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.ClientCommandMgr;
import com.ibm.ws.management.cmdframework.impl.CommandUtility;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Properties;
import javax.management.ObjectName;

public abstract class CommandMgr {
    private static TraceComponent tc = Tr.register(CommandMgr.class, "CommandMgr", "com.ibm.websphere.management.resources.cmdframework");
    protected static CommandMgr cmdMgr;
    protected static boolean initialized;
    private static final String SOAP_CONNECTOR_ADDRESS_NEP = "SOAP_CONNECTOR_ADDRESS";
    private static final String BOOTSTRAP_ADDRESS_NEP = "BOOTSTRAP_ADDRESS";

    public static CommandMgr getCommandMgr() {
        if (cmdMgr == null && !initialized) {
            if (AdminServiceFactory.getAdminService() != null) {
                CommandMgr.initializeServerMode();
            } else {
                CommandMgr.initializeLocalMode();
            }
            initialized = true;
        }
        return cmdMgr;
    }

    public static CommandMgr getClientCommandMgr(AdminClient adminClient) throws CommandMgrInitException {
        CommandMgr.checkForAdminClientLoopBack(adminClient);
        return CommandMgr.initializeClientMode(adminClient);
    }

    private static synchronized CommandMgr initializeClientMode(AdminClient adminClient) throws CommandMgrInitException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeClientMode");
        }
        try {
            ObjectName objectName = CommandUtility.getRemoteCmdMgrMbean(adminClient);
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ClientCommandMgr");
            ClientCommandMgr clientCommandMgr = null;
            clientCommandMgr = (ClientCommandMgr)clazz.newInstance();
            clientCommandMgr.setAdminClient(adminClient);
            initialized = true;
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeClientMode", clientCommandMgr);
            }
            return clientCommandMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "104");
            Tr.error(tc, "commandframework failed to initialize in client mode", throwable);
            throw new CommandMgrInitException(throwable, "ClientMode");
        }
    }

    private static synchronized CommandMgr initializeServerMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeServerMode");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.ServerCommandMgr");
            CommandMgr commandMgr = null;
            if (cmdMgr == null || !clazz.isInstance(cmdMgr)) {
                commandMgr = (CommandMgr)clazz.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeServerMode");
            }
            return cmdMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "126");
            Tr.error(tc, "commandframework failed to initialize in server mode", throwable);
            return null;
        }
    }

    private static CommandMgr initializeLocalMode() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeLocalMode");
        }
        try {
            Class<?> clazz = Class.forName("com.ibm.ws.management.cmdframework.impl.LocalCommandMgr");
            CommandMgr commandMgr = null;
            if (cmdMgr == null || !clazz.isInstance(cmdMgr)) {
                commandMgr = (CommandMgr)clazz.newInstance();
            }
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "initializeLocalMode");
            }
            return cmdMgr;
        }
        catch (Throwable throwable) {
            FFDCFilter.processException(throwable, "com.ibm.websphere.management.cmdframework.CommandMgr", "148");
            Tr.error(tc, "commandframework failed to initialize in local mode", throwable);
            return null;
        }
    }

    public abstract Collection listCommandGroups() throws ConnectorException, CommandException;

    public abstract Collection listCommands(String var1) throws ConnectorException, CommandException;

    public abstract Collection listCommands() throws ConnectorException, CommandException;

    public abstract Collection listAllCommands() throws ConnectorException, CommandException;

    public abstract CommandMetadata getCommandMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandMetadata() throws ConnectorException, CommandException;

    public abstract CommandGroupMetadata getCommandGroupMetadata(String var1) throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract Collection getAllCommandGroupMetadata() throws ConnectorException, CommandNotFoundException, CommandException;

    public abstract AdminCommand createCommand(String var1) throws CommandNotFoundException, CommandException, ConnectorException;

    public abstract AdminCommand loadCommand(InputStream var1) throws CommandLoadException, ConnectorException, CommandException;

    public abstract CommandProviderHelper getCommandProviderHelper();

    private static void checkForAdminClientLoopBack(AdminClient adminClient) throws CommandMgrInitException {
        block32: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "checkForAdminClientLoopBack", adminClient);
            }
            ConfigService configService = null;
            Session session = null;
            try {
                Object object;
                AdminService adminService = AdminServiceFactory.getAdminService();
                if (adminService == null || !adminService.getProcessType().equals("UnManagedProcess")) break block32;
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Loopback detection - standalone process detected");
                }
                Properties properties = adminClient.getConnectorProperties();
                String string = properties.getProperty("host");
                String string2 = properties.getProperty("port");
                String string3 = properties.getProperty("type");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "targetHost, targetPort, connType : " + string + ", " + string2 + ", " + string3);
                }
                ObjectName objectName = adminService.getLocalServer();
                String string4 = (String)adminService.getAttribute(objectName, "name");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Current Server name " + string4);
                }
                if (string3 == null) break block32;
                String string5 = null;
                if (string3.equals("SOAP")) {
                    string5 = SOAP_CONNECTOR_ADDRESS_NEP;
                } else if (string3.equals("RMI")) {
                    string5 = BOOTSTRAP_ADDRESS_NEP;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "acEndPoint is " + string5);
                }
                if (string5 == null) break block32;
                session = new Session();
                configService = ConfigServiceFactory.getConfigService();
                String string6 = "";
                ObjectName objectName2 = ConfigServiceHelper.createObjectName(null, "Node");
                ObjectName objectName3 = configService.queryConfigObjects(session, null, objectName2, null)[0];
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "baseNode Object Name " + objectName3);
                }
                ObjectName objectName4 = configService.getRelationship(session, objectName3, "ServerIndex")[0];
                String string7 = (String)configService.getAttribute(session, objectName4, "hostName");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "siHostName " + string7);
                }
                ObjectName objectName5 = ConfigServiceHelper.createObjectName(null, "ServerEntry");
                ObjectName[] objectNameArray = configService.queryConfigObjects(session, objectName4, objectName5, null);
                block10: for (int i = 0; i < objectNameArray.length; ++i) {
                    object = (String)configService.getAttribute(session, objectNameArray[i], "serverName");
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Inspecting serverEntry for server " + (String)object);
                    }
                    if (!((String)object).equals(string4)) continue;
                    ObjectName objectName6 = ConfigServiceHelper.createObjectName(null, "NamedEndPoint");
                    ObjectName[] objectNameArray2 = configService.queryConfigObjects(session, objectNameArray[i], objectName6, null);
                    for (int j = 0; j < objectNameArray2.length; ++j) {
                        String string8 = (String)configService.getAttribute(session, objectNameArray2[j], "endPointName");
                        if (tc.isDebugEnabled()) {
                            Tr.debug(tc, "Inspecting namedEndPoint " + string8);
                        }
                        if (!string8.equals(string5)) continue;
                        ObjectName objectName7 = ConfigServiceHelper.createObjectName(null, "EndPoint");
                        ObjectName objectName8 = configService.queryConfigObjects(session, objectNameArray2[j], objectName7, null)[0];
                        string6 = ((Integer)configService.getAttribute(session, objectName8, "port")).toString();
                        if (!tc.isDebugEnabled()) break block10;
                        Tr.debug(tc, "Got port Value " + string6);
                        break block10;
                    }
                    break;
                }
                InetAddress inetAddress = InetAddress.getByName(string);
                object = InetAddress.getByName(string7);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "TargetAddress, siAddress :" + inetAddress + ", " + object);
                }
                if ((inetAddress.isLoopbackAddress() || inetAddress.equals(object)) && string2.equals(string6)) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Loopback detected");
                    }
                    throw new CommandMgrInitException("ClientMode: AdminClient points to local server JVM");
                }
            }
            catch (CommandMgrInitException commandMgrInitException) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "got CommandMgrInitException during loopback checking: " + commandMgrInitException);
                }
                throw commandMgrInitException;
            }
            catch (Exception exception) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Got Exception during loopback checking: " + exception);
                }
                throw new CommandMgrInitException(exception, "ClientMode");
            }
            finally {
                try {
                    if (configService != null && session != null) {
                        configService.discard(session);
                    }
                }
                catch (Exception exception) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "Got Exception session discard: " + exception);
                    }
                    throw new CommandMgrInitException(exception, "ClientMode");
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "checkForAdminClientLoopBack");
        }
    }

    static {
        initialized = false;
    }
}

