/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.Session;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandHistory;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.InvalidParameterNameException;
import com.ibm.websphere.management.cmdframework.InvalidParameterValueException;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.GenericObjectValue;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.ParameterMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractTaskCommand;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.management.Attribute;
import javax.management.AttributeList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class AbstractCommandStep
extends AbstractAdminCommand
implements CommandStep {
    private static TraceComponent tc = Tr.register(AbstractCommandStep.class, "AbstractCommandStep", "com.ibm.websphere.management.resources.cmdframework");
    protected AbstractTaskCommand taskCmd = null;
    private boolean initialized = false;

    public AbstractCommandStep(AbstractTaskCommand abstractTaskCommand, CommandMetadata commandMetadata) {
        super(commandMetadata);
        this.taskCmd = abstractTaskCommand;
    }

    public AbstractCommandStep(AbstractTaskCommand abstractTaskCommand, CommandData commandData) throws CommandNotFoundException {
        super(commandData);
        this.taskCmd = abstractTaskCommand;
    }

    public static CommandMetadata getCommandMetadata(String string) throws CommandNotFoundException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandMetadata", string);
        }
        CommandStepMetadata commandStepMetadata = null;
        Set set = (Set)CommandMetadataMgr.getInstance().listCommands();
        if (tc.isEntryEnabled()) {
            Tr.debug(tc, "commandlist is " + set);
        }
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            CommandMetadata commandMetadata;
            String string2 = (String)iterator.next();
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "command name is " + string2);
            }
            if ((commandMetadata = CommandMetadataMgr.getInstance().getCommandMetadata(string2)) instanceof TaskCommandMetadata) {
                Iterator iterator2 = ((TaskCommandMetadata)commandMetadata).getSteps().iterator();
                while (iterator2.hasNext()) {
                    CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)iterator2.next();
                    if (!commandStepMetadata2.getName().equals(string)) continue;
                    commandStepMetadata = commandStepMetadata2;
                    break;
                }
            }
            if (commandStepMetadata == null) continue;
            break;
        }
        if (commandStepMetadata == null) {
            throw new CommandNotFoundException(string);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandMetadata", commandStepMetadata);
        }
        return commandStepMetadata;
    }

    public boolean isEnabled() {
        return this.getCommandStepData().isEnabled();
    }

    public final int hashcode() {
        return this.getName().hashCode();
    }

    public final boolean equals(Object object) {
        if (object == null || !(object instanceof CommandStep)) {
            return false;
        }
        return this.getName().equals(((CommandStep)object).getName());
    }

    protected CommandData initCommandData() {
        CommandStepData commandStepData = CommandDataFactory.eINSTANCE.createCommandStepData();
        commandStepData.setEnabled(true);
        return commandStepData;
    }

    public final CommandStepData getCommandStepData() {
        return (CommandStepData)this.getCommandData();
    }

    public final void resetCommandData(CommandData commandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandData", commandData);
        }
        int n = -1;
        EList eList = this.taskCmd.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "stepDataCollection ", eList);
        }
        CommandData commandData2 = this.getCommandData();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "currentStepData ", commandData2);
        }
        for (int i = 0; i < eList.size(); ++i) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepDataCollection name " + i + " is", ((CommandData)eList.get(i)).getName());
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "currentStepData name is  ", commandData2.getName());
            }
            if (!((CommandData)eList.get(i)).getName().equals(commandData2.getName())) continue;
            n = i;
            break;
        }
        eList.set(n, commandData);
        super.resetCommandData(commandData);
    }

    public final void execute(CommandHistory commandHistory) {
        throw new UnsupportedOperationException();
    }

    public final void execute() {
        throw new UnsupportedOperationException();
    }

    public Collection listSetParams(int n) throws IndexOutOfBoundsException {
        return super.listSetParams(n);
    }

    public Object getParameter(String string, int n) throws InvalidParameterNameException, IndexOutOfBoundsException {
        return super.getParameter(string, n);
    }

    public void setParameter(String string, Object object, int n) throws InvalidParameterValueException, InvalidParameterNameException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "setParameter", new Object[]{string, object, new Integer(n)});
        }
        super.setParameter(string, object, n);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "setParameter");
        }
    }

    public int getNumberOfRows() {
        return this.getCommandData().getCmdParams().size();
    }

    protected void initializeRow(AttributeList attributeList, int n) throws InvalidParameterValueException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "initializeAddRow", new Object[]{attributeList, new Integer(n)});
        }
        this.addRow(attributeList, n, true);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "initializeAddRow");
        }
    }

    public void addRow(AttributeList attributeList, int n) throws InvalidParameterValueException, IndexOutOfBoundsException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addRow", new Object[]{attributeList, new Integer(n)});
        }
        this.addRow(attributeList, n, false);
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRow");
        }
    }

    private void addRow(AttributeList attributeList, int n, boolean bl) throws InvalidParameterValueException, IndexOutOfBoundsException {
        block12: {
            if (tc.isEntryEnabled()) {
                Tr.entry(tc, "addRow", new Object[]{attributeList, new Integer(n), new Boolean(bl)});
            }
            if (tc.isEntryEnabled()) {
                Tr.debug(tc, "table is " + this.isTable() + " adddeleteRow is " + this.addDeleteRowAllowed());
            }
            if (!this.isTable() || !bl && !this.addDeleteRowAllowed()) {
                throw new UnsupportedOperationException();
            }
            EObject eObject = null;
            EList eList = this.getCommandData().getCmdParams();
            try {
                eObject = this.createParamEObject();
                Iterator iterator = attributeList.iterator();
                while (iterator.hasNext()) {
                    Attribute attribute = (Attribute)iterator.next();
                    String string = attribute.getName();
                    if (this.isParamReadonly(string) && !bl) {
                        throw new InvalidParameterValueException(this.getName(), string, attribute.getValue());
                    }
                    EStructuralFeature eStructuralFeature = eObject.eClass().getEStructuralFeature(string);
                    if (eStructuralFeature instanceof EAttribute) {
                        eObject.eSet(eStructuralFeature, attribute.getValue());
                        continue;
                    }
                    GenericObjectValue genericObjectValue = (GenericObjectValue)eObject.eGet(eStructuralFeature);
                    if (genericObjectValue == null) {
                        genericObjectValue = CommandDataFactory.eINSTANCE.createGenericObjectValue();
                        eObject.eSet(eStructuralFeature, (Object)genericObjectValue);
                    }
                    genericObjectValue.setValue(attribute.getValue());
                }
                eList.add(n, eObject);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                FFDCFilter.processException(commandNotFoundException, "com.ibm.websphere.management.commandframework.provider.AbstractCommandStep", "260");
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "Exception occured. " + commandNotFoundException);
                }
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                FFDCFilter.processException(invalidParameterNameException, "com.ibm.websphere.management.commandframework.provider.AbstractCommandStep", "263");
                if (!tc.isDebugEnabled()) break block12;
                Tr.debug(tc, "Exception occured. " + invalidParameterNameException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addRow");
        }
    }

    public void deleteRow(int n) throws UnsupportedOperationException {
        if (!this.isTable() || !this.addDeleteRowAllowed()) {
            throw new UnsupportedOperationException();
        }
        EList eList = this.getCommandData().getCmdParams();
        eList.remove(n);
    }

    protected final boolean isTable() {
        return ((CommandStepMetadata)this.getCommandMetadata()).isTable();
    }

    protected final EObject createParamEObject() throws CommandNotFoundException {
        return CommandMetadataMgr.getInstance().createParamDataEObject(this.taskCmd.getName(), this.getName());
    }

    public void stepModified(String string) {
    }

    public void commandParamModified() {
    }

    public void validate() throws CommandValidationException {
        if (this.isEnabled()) {
            super.validate();
        }
    }

    protected void taskCommandExecuted(boolean bl, boolean bl2) {
    }

    protected void executeStep() {
    }

    protected void initializeStep() throws CommandException {
    }

    void initStep() throws CommandException {
        if (!this.initialized) {
            this.initializeStep();
            this.initialized = true;
        }
    }

    public boolean isRequired() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequired");
        }
        boolean bl = false;
        CommandMetadata commandMetadata = this.getCommandMetadata();
        EList eList = commandMetadata.getParameters();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
            String string = parameterMetadata.getName();
            Object object = null;
            try {
                object = this.getParameter(string);
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                // empty catch block
            }
            if (!parameterMetadata.isRequired() || object != null) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequired - " + bl);
        }
        return bl;
    }

    public Session getConfigSession() {
        return this.taskCmd.getConfigSession();
    }

    public boolean isRequired(int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "isRequired - " + n);
        }
        boolean bl = false;
        CommandMetadata commandMetadata = this.getCommandMetadata();
        EList eList = commandMetadata.getParameters();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            ParameterMetadata parameterMetadata = (ParameterMetadata)iterator.next();
            String string = parameterMetadata.getName();
            Object object = null;
            try {
                object = this.getParameter(string, n);
            }
            catch (InvalidParameterNameException invalidParameterNameException) {
                // empty catch block
            }
            if (!parameterMetadata.isRequired() || object != null) continue;
            bl = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "isRequired - " + bl);
        }
        return bl;
    }

    public Object[] getChoices(String string, int n) {
        return this.getChoices(string);
    }

    private boolean addDeleteRowAllowed() {
        CommandStepMetadata commandStepMetadata = (CommandStepMetadata)this.getCommandMetadata();
        return commandStepMetadata.isEnableAddRows();
    }
}

