/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.management.cmdframework.provider;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.cmdframework.CommandException;
import com.ibm.websphere.management.cmdframework.CommandLoadException;
import com.ibm.websphere.management.cmdframework.CommandMgr;
import com.ibm.websphere.management.cmdframework.CommandNotFoundException;
import com.ibm.websphere.management.cmdframework.CommandResult;
import com.ibm.websphere.management.cmdframework.CommandStep;
import com.ibm.websphere.management.cmdframework.CommandValidationException;
import com.ibm.websphere.management.cmdframework.TaskCommand;
import com.ibm.websphere.management.cmdframework.TaskCommandResult;
import com.ibm.websphere.management.cmdframework.commanddata.CommandData;
import com.ibm.websphere.management.cmdframework.commanddata.CommandDataFactory;
import com.ibm.websphere.management.cmdframework.commanddata.CommandStepData;
import com.ibm.websphere.management.cmdframework.commanddata.TaskCommandData;
import com.ibm.websphere.management.cmdframework.commandmetadata.CommandStepMetadata;
import com.ibm.websphere.management.cmdframework.commandmetadata.TaskCommandMetadata;
import com.ibm.websphere.management.cmdframework.provider.AbstractAdminCommand;
import com.ibm.websphere.management.cmdframework.provider.AbstractCommandStep;
import com.ibm.websphere.management.cmdframework.provider.CommandProvider;
import com.ibm.websphere.management.cmdframework.provider.TaskCommandResultImpl;
import com.ibm.ws.management.cmdframework.impl.CommandMetadataMgr;
import com.ibm.ws.management.cmdframework.impl.CommandSecurityUtil;
import com.ibm.ws.management.cmdframework.impl.LocalCommandMgr;
import com.ibm.ws.security.core.ContextManagerFactory;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.security.auth.Subject;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public abstract class AbstractTaskCommand
extends AbstractAdminCommand
implements TaskCommand {
    private static TraceComponent tc = Tr.register(AbstractTaskCommand.class, "AbstractTaskCommand", "com.ibm.websphere.management.cmdframework");
    private Map steps = new HashMap();
    private int currentStepIndex = 0;
    private boolean isLocal;
    private AbstractCommandStep currentStep = null;

    public AbstractTaskCommand(TaskCommandMetadata taskCommandMetadata) throws CommandNotFoundException {
        super(taskCommandMetadata);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractTaskCommand", taskCommandMetadata);
        }
        if (CommandMgr.getCommandMgr() instanceof LocalCommandMgr) {
            this.isLocal = true;
        }
        this.contructSteps();
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractTaskCommand");
        }
    }

    protected void contructSteps() throws CommandNotFoundException {
        TaskCommandData taskCommandData = this.getTaskCommandData();
        TaskCommandMetadata taskCommandMetadata = this.getTaskCommandMetadata();
        EList eList = taskCommandMetadata.getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepMetadata commandStepMetadata = (CommandStepMetadata)iterator.next();
            if (this.isLocal && (!commandStepMetadata.isSupportLocalMode() || !this.isLocal)) continue;
            String string = commandStepMetadata.getName();
            CommandProvider commandProvider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepName", string);
            }
            AbstractCommandStep abstractCommandStep = commandProvider.createCommandStep(this, string);
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step", abstractCommandStep);
            }
            this.addStep(abstractCommandStep, commandProvider.commandStepPosition(this, string));
        }
    }

    public AbstractTaskCommand(CommandData commandData) throws CommandNotFoundException, CommandLoadException {
        super(commandData);
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "AbstractTaskCommand", commandData);
        }
        TaskCommandData taskCommandData = this.getTaskCommandData();
        EList eList = taskCommandData.getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            String string = commandStepData.getName();
            CommandProvider commandProvider = CommandMetadataMgr.getInstance().getCommandProvider(this.getName(), string);
            AbstractCommandStep abstractCommandStep = commandProvider.loadCommandStep(this, commandStepData);
            this.steps.put(string, abstractCommandStep);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "AbstractTaskCommand");
        }
    }

    protected CommandData initCommandData() {
        return CommandDataFactory.eINSTANCE.createTaskCommandData();
    }

    public CommandStep getCurrentStep(int n) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug(tc, "currentstep", this.currentStep.getName());
        }
        return this.getCurrentStep(n, "");
    }

    public CommandStep getCurrentStep(int n, String string) {
        if (tc.isDebugEnabled() && this.currentStep != null) {
            Tr.debug(tc, "currentstep", this.currentStep.getName());
        }
        return this.currentStep;
    }

    public void setCurrentStep(AbstractCommandStep abstractCommandStep) {
        this.currentStep = abstractCommandStep;
    }

    public int getCurrentStepIndex() {
        return this.currentStepIndex;
    }

    public void setCurrentStepIndex(int n) {
        this.currentStepIndex = n;
    }

    public final String[] listCommandSteps() {
        EList eList = this.getTaskCommandData().getSteps();
        String[] stringArray = new String[eList.size()];
        for (int i = 0; i < eList.size(); ++i) {
            stringArray[i] = ((CommandStepData)eList.get(i)).getName();
        }
        return stringArray;
    }

    public final CommandStep nextStep() throws NoSuchElementException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "nextStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(0);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        } else {
            this.commandParamsModified();
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "1. Step data list is " + eList);
        }
        int n = eList.size();
        AbstractCommandStep abstractCommandStep = null;
        for (int i = this.currentStepIndex; i < n; ++i) {
            object = (CommandStepData)eList.get(i);
            if (!object.isEnabled()) continue;
            abstractCommandStep = (AbstractCommandStep)this.steps.get(object.getName());
            this.currentStepIndex = i + 1;
            break;
        }
        if (abstractCommandStep == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Next step not available ");
            }
            throw new NoSuchElementException();
        }
        this.currentStep = abstractCommandStep;
        try {
            abstractCommandStep.initStep();
        }
        catch (CommandException commandException) {
            object = new NoSuchElementException(commandException.toString());
            ((Throwable)object).initCause(commandException);
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "nextStep", abstractCommandStep.getName());
        }
        return abstractCommandStep;
    }

    public final CommandStep previousStep() throws NoSuchElementException {
        Object object;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "previousStep");
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(1);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "3. Step data list is " + eList);
        }
        int n = eList.size();
        AbstractCommandStep abstractCommandStep = null;
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "current stepindex is " + this.currentStepIndex);
        }
        for (int i = this.currentStepIndex - 1; i > 0; --i) {
            if (i <= 0) {
                throw new NoSuchElementException();
            }
            object = (CommandStepData)eList.get(i - 1);
            if (!object.isEnabled()) continue;
            abstractCommandStep = (AbstractCommandStep)this.steps.get(object.getName());
            this.currentStepIndex = i;
            if (!tc.isDebugEnabled()) break;
            Tr.debug(tc, "index is  " + i);
            break;
        }
        if (abstractCommandStep == null) {
            throw new NoSuchElementException();
        }
        this.currentStep = abstractCommandStep;
        try {
            abstractCommandStep.initStep();
        }
        catch (CommandException commandException) {
            object = new NoSuchElementException();
            ((Throwable)object).initCause(commandException);
            throw object;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "previousStep", abstractCommandStep.getName());
        }
        return abstractCommandStep;
    }

    public final boolean hasNextStep() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "hasNextStep");
        }
        EList eList = this.getTaskCommandData().getSteps();
        int n = eList.size();
        boolean bl = false;
        for (int i = this.currentStepIndex; i < n; ++i) {
            CommandStepData commandStepData = (CommandStepData)eList.get(i);
            if (!commandStepData.isEnabled()) continue;
            bl = true;
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "hasNextStep," + bl);
        }
        return bl;
    }

    public final boolean hasPreviousStep() {
        EList eList = this.getTaskCommandData().getSteps();
        int n = eList.size();
        boolean bl = false;
        for (int i = this.currentStepIndex - 2; i >= 0; --i) {
            CommandStepData commandStepData;
            if (i < 0 || !(commandStepData = (CommandStepData)eList.get(i)).isEnabled()) continue;
            bl = true;
            break;
        }
        return bl;
    }

    public final CommandStep gotoStep(String string) throws NoSuchElementException {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "gotoStep", string);
        }
        this.currentStep = (AbstractCommandStep)this.getCurrentStep(2, string);
        if (this.currentStep != null) {
            this.stepModified(this.currentStep.getName());
        }
        TaskCommandData taskCommandData = this.getTaskCommandData();
        CommandStepData commandStepData = taskCommandData.getStepData(string);
        AbstractCommandStep abstractCommandStep = null;
        if (commandStepData == null || !commandStepData.isEnabled()) {
            throw new NoSuchElementException();
        }
        this.currentStepIndex = taskCommandData.getSteps().indexOf((Object)commandStepData) + 1;
        abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
        this.currentStep = abstractCommandStep;
        try {
            abstractCommandStep.initStep();
        }
        catch (CommandException commandException) {
            NoSuchElementException noSuchElementException = new NoSuchElementException();
            noSuchElementException.initCause(commandException);
            throw noSuchElementException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "gotoStep " + abstractCommandStep);
        }
        return abstractCommandStep;
    }

    public CommandStep getCommandStep(String string) throws CommandNotFoundException {
        CommandStep commandStep;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "getCommandStep", string);
        }
        if ((commandStep = (CommandStep)this.steps.get(string)) == null) {
            if (tc.isEntryEnabled()) {
                Tr.exit(tc, "getCommandStep");
            }
            throw new CommandNotFoundException("Command Step " + string + " not found");
        }
        try {
            ((AbstractCommandStep)commandStep).initStep();
        }
        catch (CommandException commandException) {
            CommandNotFoundException commandNotFoundException = new CommandNotFoundException("Command Step " + string + " not found");
            commandNotFoundException.initCause(commandException);
            throw commandNotFoundException;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "getCommandStep", commandStep.getName());
        }
        return commandStep;
    }

    public final TaskCommandData getTaskCommandData() {
        return (TaskCommandData)this.getCommandData();
    }

    public final TaskCommandMetadata getTaskCommandMetadata() {
        return (TaskCommandMetadata)this.getCommandMetadata();
    }

    private void addStep(AbstractCommandStep abstractCommandStep, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "addStep", new Object[]{abstractCommandStep, new Integer(n)});
        }
        this.steps.put(abstractCommandStep.getName(), abstractCommandStep);
        TaskCommandData taskCommandData = this.getTaskCommandData();
        EList eList = taskCommandData.getSteps();
        CommandStepData commandStepData = taskCommandData.getStepData(abstractCommandStep.getName());
        if (commandStepData != null) {
            eList.remove(commandStepData);
        }
        if (n < 0 || n > eList.size()) {
            eList.add(abstractCommandStep.getCommandData());
        } else {
            eList.add(n, abstractCommandStep.getCommandData());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "addStep");
        }
    }

    public void resetCommandData(CommandData commandData) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "resetCommandData", commandData);
        }
        super.resetCommandData(commandData);
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", eList);
        }
        for (int i = 0; i < eList.size(); ++i) {
            AbstractCommandStep abstractCommandStep;
            CommandStepData commandStepData = (CommandStepData)eList.get(i);
            String string = commandStepData.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "steps are ", this.steps);
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "step Name is ", string);
            }
            if ((abstractCommandStep = (AbstractCommandStep)this.steps.get(string)) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "reload step comanddata", commandStepData);
                }
                abstractCommandStep.resetCommandData(commandStepData);
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "create new step", commandStepData);
            }
            TaskCommandMetadata taskCommandMetadata = this.getTaskCommandMetadata();
            CommandStepMetadata commandStepMetadata = null;
            Iterator iterator = taskCommandMetadata.getSteps().iterator();
            while (iterator.hasNext()) {
                CommandStepMetadata commandStepMetadata2 = (CommandStepMetadata)iterator.next();
                if (!commandStepMetadata2.getName().equals(string)) continue;
                commandStepMetadata = commandStepMetadata2;
                break;
            }
            if (commandStepMetadata == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "unable to create step", commandStepMetadata);
                }
                return;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "stepMetadata", commandStepMetadata);
            }
            abstractCommandStep = new AbstractCommandStep(this, commandStepMetadata);
            abstractCommandStep.resetCommandData(commandStepData);
            this.addStep(abstractCommandStep, i);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "resetCommandData");
        }
    }

    public void validate() throws CommandValidationException {
        super.validate();
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.steps.get(commandStepData.getName());
            if (!abstractCommandStep.isEnabled()) continue;
            abstractCommandStep.validate();
        }
    }

    protected void beforeStepsExecuted() {
    }

    protected void afterStepsExecuted() {
    }

    protected void taskCommandExecuted(boolean bl) {
    }

    protected void stepModified(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stepModified");
        }
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string2 = ((CommandStepData)iterator.next()).getName();
            if (string2.equals(string)) continue;
            try {
                AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.getCommandStep(string2);
                abstractCommandStep.stepModified(string);
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.error(tc, commandNotFoundException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "stepModified");
        }
    }

    public void commandParamsModified() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commandParamsModified");
        }
        EList eList = this.getTaskCommandData().getSteps();
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            String string = ((CommandStepData)iterator.next()).getName();
            try {
                AbstractCommandStep abstractCommandStep = (AbstractCommandStep)this.getCommandStep(string);
                abstractCommandStep.commandParamModified();
            }
            catch (CommandNotFoundException commandNotFoundException) {
                if (!tc.isDebugEnabled()) continue;
                Tr.error(tc, commandNotFoundException.getMessage());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "commandParamsModified");
        }
    }

    public void execute() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "execute");
        }
        TaskCommandResultImpl taskCommandResultImpl = new TaskCommandResultImpl();
        this.setCommandResult(taskCommandResultImpl);
        CommandSecurityUtil commandSecurityUtil = CommandSecurityUtil.getInstance();
        boolean bl = commandSecurityUtil.checkAccess(this);
        if (!bl) {
            String string = "Access denied for this command " + this.getName();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, string);
            }
            Exception exception = new Exception(string);
            taskCommandResultImpl.setException(exception);
            return;
        }
        String string = commandSecurityUtil.getDelegationMode(this);
        if (string != null && string.equals("System")) {
            try {
                Subject subject = ContextManagerFactory.getInstance().getServerSubject();
                ContextManagerFactory.getInstance().runAsSpecified(subject, new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        AbstractTaskCommand.this.executeReal();
                        return null;
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                Exception exception = privilegedActionException.getException();
                taskCommandResultImpl.setException(exception);
            }
            catch (Exception exception) {
                taskCommandResultImpl.setException(exception);
            }
        } else {
            this.executeReal();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "execute");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReal() {
        Object object;
        Object object2;
        Object object3;
        EList eList;
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeReal");
        }
        EList eList2 = this.getTaskCommandData().getSteps();
        ArrayList<String> arrayList = new ArrayList<String>(eList2.size());
        boolean bl = true;
        TaskCommandResultImpl taskCommandResultImpl = (TaskCommandResultImpl)this.getCommandResult();
        try {
            this.validate();
            this.beforeStepsExecuted();
            if (!taskCommandResultImpl.isSuccessful()) {
                bl = false;
            } else {
                eList = eList2.iterator();
                while (eList.hasNext()) {
                    object3 = (CommandStepData)eList.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "stepData", object3);
                    }
                    object2 = (AbstractCommandStep)this.getCommandStep(object3.getName());
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "step", object2);
                    }
                    ((AbstractCommandStep)object2).executeStep();
                    object = ((AbstractAdminCommand)object2).getCommandResult();
                    taskCommandResultImpl.setStepResult(((AbstractAdminCommand)object2).getName(), (CommandResult)object);
                    arrayList.add(((AbstractAdminCommand)object2).getName());
                    if (taskCommandResultImpl.isSuccessful()) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "task command " + this.getName() + " failed on step " + ((AbstractAdminCommand)object2).getName());
                    }
                    bl = false;
                    break;
                }
                if (bl) {
                    this.afterStepsExecuted();
                }
            }
        }
        catch (Throwable throwable) {
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Exception thrown during command validation");
            }
            taskCommandResultImpl.setException(throwable);
        }
        finally {
            eList = this.getTaskCommandData().getSteps();
            object3 = eList.iterator();
            while (object3.hasNext()) {
                object2 = ((CommandStepData)object3.next()).getName();
                try {
                    object = (AbstractCommandStep)this.getCommandStep((String)object2);
                    ((AbstractCommandStep)object).taskCommandExecuted(taskCommandResultImpl.isSuccessful(), arrayList.contains(object2));
                }
                catch (CommandNotFoundException commandNotFoundException) {
                    if (!tc.isDebugEnabled()) continue;
                    Tr.error(tc, commandNotFoundException.getMessage());
                }
            }
            this.taskCommandExecuted(taskCommandResultImpl.isSuccessful());
        }
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "executeReal");
        }
    }

    public TaskCommandResult getTaskCommandResult() {
        return (TaskCommandResult)this.getCommandResult();
    }

    public void listAllStepParamsData() {
        if (tc.isEntryEnabled()) {
            Tr.entry(tc, "listAllStepParamsData", this.getTaskCommandData());
        }
        EList eList = this.getTaskCommandData().getSteps();
        if (tc.isDebugEnabled()) {
            Tr.debug(tc, "step data list is  ", eList);
        }
        Iterator iterator = eList.iterator();
        while (iterator.hasNext()) {
            CommandStepData commandStepData = (CommandStepData)iterator.next();
            String string = commandStepData.getName();
            EList eList2 = commandStepData.getCmdParams();
            if (tc.isDebugEnabled()) {
                Tr.debug(tc, "Parameters are " + eList2);
            }
            EObject eObject = null;
            for (int i = 0; i < eList2.size(); ++i) {
                eObject = (EObject)eList2.get(i);
                if (tc.isDebugEnabled()) {
                    Tr.debug(tc, "paraData name is ", eObject);
                }
                EClass eClass = eObject.eClass();
                Iterator iterator2 = eClass.getEAllAttributes().iterator();
                while (iterator2.hasNext()) {
                    EStructuralFeature eStructuralFeature = (EStructuralFeature)iterator2.next();
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "feature", eStructuralFeature);
                    }
                    if (!eObject.eIsSet(eStructuralFeature)) continue;
                    if (tc.isDebugEnabled()) {
                        Tr.debug(tc, "setted feature is " + eStructuralFeature.getName());
                    }
                    if (!tc.isDebugEnabled()) continue;
                    Tr.debug(tc, "setted feature value is " + eObject.eGet(eStructuralFeature));
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit(tc, "listAllStepParamsData");
        }
    }
}

